/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ldsa.c: version 25.1 created on 11/27/91 at 15:27:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ldsa.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
/* #include "disksect.h" */
/* #include "dsetup.h" */
#include "setjmp.h"
/* #include "a.out.h" */
/* #include "filehdr.h" */
/* #include "icbcmd.h" */
#include "sa_dir.h"
#include "sys/ioctl.h"
/* #include "sys/icb.h" */
/* #include "sys/vreg.h" */
#include "sys/fcntl.h"
#include "dev.h"

#define IOPM_BSIZE	0x400
#define LD_BOOT_SLICE	5	/* IOPM BOOT SLICE */

#define MIN(a, b)	((a) < (b) ? (a) : (b))

jmp_buf	errorbuf;

char	buf[0x40000];		/* 256k buffer */

int	maxsa;			/* available room for sa programs */

int 	srcfd, dstfd;
char 	srcname[DEV_NAMLEN],
	dstname[DEV_NAMLEN];

extern off_t	lseek();
extern void	exit();


/*VARARGS1*/
die(fmt, a1, a2, a3)
char	*fmt;
{
	printf(fmt, a1, a2, a3);
	if (srcfd > 0)
		close(srcfd);
	if (dstfd > 0)
		close(dstfd);
	exit(0);
}

/*VARARGS1*/
error(fmt, a, b, c, d)
char	*fmt;
{
	printf("ERROR, ");
	printf(fmt, a, b, c, d);
	printf("\n");
	longjmp(errorbuf,1);
}

main()
{
	init();
	transfer();
	/*NOTREACHED*/
}

init()
{
	register uint	dev_type;

	(void) setjmp(errorbuf);

	srcfd = dstfd = -1;
	do {
		printf("Enter source device (X/YmtZ, XmtY or '?') : ");
		dev_type = get_device_name(srcname);
		if (dev_type == DV_HELP_REQUEST)
			dev_help_message();
		else if (dev_type != DV_MT && dev_type != DV_DK)
			printf("Device must be tape or disk boot slice\n");
		else
			srcfd = opensa(srcname, dev_type, O_RDONLY);

	} while (srcfd < 0);


	(void) setjmp(errorbuf);

	do {
		printf("Enter target device (X/YdZ, XdYsZ or '?') : ");
		dev_type = get_device_name(dstname);
		if (dev_type == DV_HELP_REQUEST)
			dev_help_message();
		else if (dev_type != DV_MT && dev_type != DV_DK)
			printf("Device must be a tape or disk boot slice\n");
		else if (strcmp(srcname, dstname) == 0)
			printf("Source and target devices must be different\n");
		else
			dstfd = opensa(dstname, dev_type, O_RDWR);

	} while (dstfd < 0);
}

transfer()
{
	register char	*bufptr;
	register int	rc;
	register int	count;
	register int	bootsize;
	register int	size;
	register int	bytes_read;
	register int	extra;
	struct sa_dir	*sap;

	if (setjmp(errorbuf))
		die("ABORT, fatal I/O error!\n");

	if ((rc = fillbuf(srcfd, buf, BLK_SIZE)) != BLK_SIZE)
		die("Failed to read bootimage directory on source device!\n");

	sap = (struct sa_dir *)buf;
	if (sap->magic_num != MAGIC_NUM)
		die("invalid magic number in bootimage! (0x%04x)\n",
		  sap->magic_num);

	bootsize = sap->bootimage_size;

	if (bootsize > maxsa)
		die("bootimage too large (%d vs %d)!\n", bootsize, maxsa);

	printf("Copying bootimage to %s.\n",dstname);

	/* have already read one sector */
	bufptr = buf + rc;
	count = bootsize - rc;
	size = MIN(count, sizeof(buf) - rc);
	bytes_read = extra = rc;

	while (count > 0 && (rc = fillbuf(srcfd, bufptr, size)) > 0) {
		count -= rc;
		bytes_read += rc;

		rvwriteck(dstfd, buf, rc + extra);
		extra = 0;
		bufptr = buf;
		size = MIN(count, sizeof(buf));
	}

	die("0x%x bytes transferred\n", bytes_read);
	/*NOTREACHED*/
}


opensa(icbchar, dev_type, mode)
char	*icbchar;
uint	dev_type;
int	mode;
{
	register int	fd;
	int		type;

	fd = openck(icbchar, mode);
	rvlseekck(fd, 0L);
	if (dev_type == DV_DK) {	/* IOPM boot slice */
		if ((type = ioctl(fd, GET_LOG_TYPE, 0)) < 0) {
			close(fd);
			error("ioctl GET_LOG_TYPE on IOPM boot slice failed!");
		}
		if (type != LD_BOOT_SLICE) {
			close(fd);
			error("%s is not an IOPM boot slice!", icbchar);
		}
		if ((maxsa = ioctl(fd, GET_DISK_SIZE, 0)) < 0) {
			close(fd);
			error("ioctl GET_DISK_SIZE on IOPM boot slice failed!");
		}

		maxsa *= IOPM_BSIZE;

	} else if (dev_type == DV_MT || dev_type == DV_9T) {
		maxsa = 0x7fffff;  /* lots of room on the tape */
	} else {
		close(fd);
		error("%s: invalid device type 0x%x", icbchar, dev_type);
	}

	return(fd);
}

openck(path, mode)
char	*path;
int	mode;
{
	int	fd;

	if ((fd = open(path, mode)) < 0)
		error("open error on device %s", path);
	return(fd);
}

rvlseekck(fd, pos)
int	fd;
off_t	pos;
{
	int	rc;

	if ((rc = lseek(fd, pos, 0)) < 0)
		die("lseek(%d, 0x%x, 0) error\n", fd, pos);
	return(rc);
}

rvwriteck(fd, p, s)
register int	fd, s;
register char	*p;
{
	register int	rc;
	int		totalbyte = 0;

	while (s > 0) {
		if ((rc = write(fd, p, BLK_SIZE)) < 0)
			error("write(%d, 0x%x, 0x%x) error", fd, p, s);
		if (rc == 0)
			break;
		totalbyte += rc;
		p += rc;
		s -= rc;
	}
	return(totalbyte);
}


fillbuf(fd, p, size)
register int	fd;
register char	*p;
int		size;
{
	register char	*endp = p + size;
	register int	count = 0;
	int		rc;

	while (p < endp) {
		if ((rc = read(fd, p, BLK_SIZE)) < 0)
			error("read(%d, 0x%x, 0x%x) error\n", fd, p, BLK_SIZE);
		if (rc == 0)
			break;
		count += rc;
		p += rc;
	}
	return(count);
}
