/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) reassign.c: version 25.1 created on 11/27/91 at 15:27:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)reassign.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include	"iopmfmt.h"	
#include 	"sdk_cdb.h"
#include 	"macros.h"
#include	"ctype.h"

extern long	strtol();

static void
reassign_command(fd)
int	fd;
{
	int	retry;
	uint	len;
	daddr_t	blkno;
	struct	{
			struct defect_head dh;
			struct defect_desc dc;
	} d_data;

	blkno = (daddr_t)prompt_num(0L, dev.lst_blkno,
		"enter block number : ");
	len = 1024/dev.blk_ratio; /* Set up globally upon open */

	d_data.dh.reserv[0] = d_data.dh.reserv[1] = 0;
	d_data.dh.list_len_msb = 0;
	d_data.dh.list_len_lsb = 4;
	ITOC4(d_data.dc.lba_msb, d_data.dc.lba_2, d_data.dc.lba_1,
		d_data.dc.lba_0, blkno);

	if (question("Should block recovery be attempted?")) {
		retry = 4;
		while (cdb_read(fd, buf, blkno, len, 1) == -1)
			if (--retry < 0) {
				printf("Could not recover block %d (0x%x)!\n",
				  blkno, blkno);
				if (!question("Continue reassign?")) {
					printf("Reassign aborted.\n");
					return;
				}
				break;
			}
	}
	else
		retry = -1;

	if (cdb_reassign_blocks(fd, &d_data, 8) == -1)
		return;
	printf("Block reassigned.\n");

	if (retry >= 0 && cdb_write(fd, buf, blkno, len, 1) != -1)
		printf("Block rewritten.\n");
	else	printf("data in this block is lost\n");
}

reassign_blk(fd)
int	fd;
{
	do {
		reassign_command(fd);
	} while (question("Re-assign another block?"));
}
