#	START NEW ARIX SCCS HEADER
#
#	@(#) iopmfmt.mk: version 25.1 created on 11/27/91 at 15:27:00
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)iopmfmt.mk	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

# IROOT is provided by the driving makefile or script OR
# for stand alone makes, PWD provide as a command line varible or
# environment varible (ksh).

IROOT = $(PWD)/../../..
include $(IROOT)/macdefs

NAME = iopmfmt
HDR = ../../lib/standhead.o
LIBFLAG = -L../../lib -lsc
LDF = ../../lib/ld.util
VERPATT = 's/^.define[ 	]*IOPMFMT_VERSION[ 	]*\([0-9]*\)/-VS \1/p'
VERFLAG = `sed -n -e $(VERPATT) iopmfmt.h`

SINC = ../../head
SPMINC = ../spm/head
 
LOCAL_CFLAGS = -T2 -DSTANDALONE -I$(SINC) -I$(SPMINC)

OBFILES = \
	fmt_menu.o \
	format.o \
	slice.o \
	dev_info.o \
	disktest.o \
	reassign.o \
	vdr_dskcdb.o \
	ccs_dskcdb.o \
	scsi_ermsg.o

.SUFFIXES: .c .o

.c.o:
	$(CC) $(CFLAGS) -c $<

all install: $(NAME)

clean:
	-rm -f $(OBFILES)

clobber: clean
	-rm -f $(NAME) $(NAME).map

$(NAME): $(OBFILES)
	$(LD) -o $(NAME) $(LDF) $(HDR) $(OBFILES) $(LIBFLAG) $(VERFLAG) \
		-L/lib -lc
	nm -xv $(NAME) | grep -v '| file |' | sort -t'|' +1 -2 +0 > $(NAME).map
	strip $(NAME)
	mcs -d $(NAME) 	# strip off comment section
