/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) format.c: version 25.1 created on 11/27/91 at 15:26:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)format.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"iopmfmt.h"
#include	"macros.h"
#include	"sdk_cdb.h"
#include	"sdk_disk.h"

extern char	*memcpy(), *memset();

static	unchar	wren_pg38[] = { 0xb8, 0x0e, 0x10,0,0,0,0,0,0,0,0,0,0,0,0,0};

static  int init_ph_table = 0;
struct	page_hd	ph_table[10];
int	total_pages = 0;

#define INTERLEAVE		0x01
#define	DFCTS_FIELD_LEN		8
#define	BSIZE			1024

disk_fmt(fp, use_grown)
{

	struct	capacity	ca;	

	if (!set_disk_para(fp))
		return(0);
	if (!use_grown)
		printf("drive will return to manufacturers defect list\n");
	printf("Formatting in progress.....\n");
	if (cdb_format(fp, use_grown) < 0)
		return(0);
	if (cdb_read_cap(fp, &ca, 0) < 0)
		return(0);
	dev.blk_len = CAT4(ca.bl_msb,ca.bl_2,ca.bl_1,ca.bl_lsb);
	dev.blk_ratio = BSIZE/dev.blk_len; 
	dev.lst_blkno = CAT4(ca.lba_msb,ca.lba_2,ca.lba_1,ca.lba_lsb);
	dev.lst_blkno /= dev.blk_ratio;
	if (!disk_config(fp))
		return(0);
	else {
		if (!use_grown)
			printf("disktest option should now be used to identify\
 bad blocks\n");
		return(1);
	}
}

set_ph_table(fp)
{
	
	struct mode_head  *mh;
	struct page_hd	*ph, *pt;	
	int total_len, page_offset;

	if (init_ph_table != 0)
		return(1);

	/* read all pages */
	if (cdb_mode_sense(fp, buf, 200, PAGEALL | CHANGE) < 0)
		return(0);

	mh = (struct mode_head *)buf;
	total_len = mh->sd_len + 1;	
	page_offset = sizeof ( struct mode_head) + mh->dscptr_len;
	total_len -= (sizeof ( struct mode_head) + mh->dscptr_len);
	pt = ph_table;
	total_pages = 0;

	while ( total_len ) {
		ph =  (struct page_hd *)(buf + page_offset);
		pt->code = ph->code & 0x03F;
		pt->len = ph->len;
		pt++;
		page_offset += (sizeof(struct page_hd) + ph->len);
		total_len -= (sizeof(struct page_hd) + ph->len);
		total_pages++;
	}
	init_ph_table = 1;
	return(1);
}
		
set_disk_para(fp)
{
	if (!set_page_01(fp))
		return(0);
	if (!set_page_03(fp))
		return(0);
	switch (dev.id) {
#if 0 /* FIX declan : find out if needed (we no longer support them anyway) */
	case ID_WREN3 :
#endif
	case ID_WREN4 :
	case ID_WREN5 :
	case ID_WREN6 :
		if (!set_any_page(fp, 0x38, wren_pg38, sizeof(wren_pg38)))
			return(0);
	default :
		;
	}
	return(1);
}	

#define	MAXMS_P1 PGHD_LEN + DSCPTR_LEN + MODEHEAD_LEN + sizeof (struct page_01)

set_page_01(fp)
{
	int page_len, xfer_len, byte_remain;
	unchar	cbuf[MAXMS_P1];
	unchar	dbuf[MAXMS_P1];
	struct mode_head  *cptr, *dptr;
	register  struct blk_dscptr *cbdp, *dbdp;
	register  struct page_hd   *cph, *dph;
	register  struct page_01  *cp1p, *dp1p;
	register  unchar *x,*y; 

	/* check if drive supports page 01 */
	if ((page_len = check_page(1)) == 0)
		return(1);

	xfer_len = page_len + PGHD_LEN  + DSCPTR_LEN + MODEHEAD_LEN;

	if (cdb_mode_sense(fp, cbuf, xfer_len, PAGE01 | CHANGE) < 0)
		return(0);

	cptr = (struct mode_head *)cbuf;

	/* read default value */
	/* REE - need to use current value not default */

	if (cdb_mode_sense(fp, dbuf, xfer_len, PAGE01 | CURRENT) < 0)
		return(0);
	dptr = (struct mode_head *)dbuf;

	cbdp =(struct blk_dscptr *)((uint)cptr+MODEHEAD_LEN);
	dbdp =(struct blk_dscptr *)((uint)dptr+MODEHEAD_LEN);
	cph = (struct page_hd *)((uint)cbdp+cptr->dscptr_len);
	dph = (struct page_hd *)((uint)dbdp+dptr->dscptr_len);
	cp1p = (struct page_01 *)((uint)cph+PGHD_LEN);
	dp1p = (struct page_01 *)((uint)dph+PGHD_LEN);

	byte_remain = page_len;	
	
	if (dev.id == ID_RRO)
		dp1p->err_flags = (AWRE| ARRE | EEC); /* set default value */
	else
		dp1p->err_flags = cp1p->err_flags & (AWRE | EEC); /* set default value */
	if (--byte_remain == 0)
		goto setpg1;

	dp1p->retry_cnt = (10 & cp1p->retry_cnt);

	if (--byte_remain == 0)
		goto setpg1;
		

	 /* use drive default value or don't changed */	
/* REE - this screws up everything
	 for (x = (unchar *)&dp1p->correction, y = (unchar *)&cp1p->correction; 
			byte_remain != 0; byte_remain--, x++, y++)
		*x &= *y;
*/
	if (dev.id == ID_RRO) {
		dp1p->rsv2 = 0;
		dp1p->rsv3 = dp1p->rsv4 = 0xFF;	/* fix value for RRO */
	}
		
setpg1:
	dptr->sd_len = 0;	
	dptr->dscptr_len = 0;

	dph->code = PAGE01;

	memcpy(buf, dptr, MODEHEAD_LEN);
	memcpy(buf+4, dph, page_len + PGHD_LEN);
/* REE - SCSI II drives return a value that needs to be reset in 3rd byte */
	buf[2]=0x0;

       	if (dev.id == ID_RRO) {
		if(cdb_mode_select(fp, buf, page_len + PGHD_LEN + MODEHEAD_LEN, 
			M_PF ) < 0)
			return(0);
	}
	else {
		if(cdb_mode_select(fp, buf, page_len + PGHD_LEN + MODEHEAD_LEN, 
			M_PF|M_SP ) < 0)
			return(0);
	}

	return(1);

}

set_page_03(fp)
{
	struct mode_head  *cptr, *dptr;
	register  struct blk_dscptr *cbdp, *dbdp;
	register  struct page_hd   *cph, *dph;
	register  struct page_03  *cp3p, *dp3p;
	register  unchar *x,*y; 
	int	i, block_size, page_len, xfer_len, byte_remain;

	unchar	cbuf[PGHD_LEN + DSCPTR_LEN + MODEHEAD_LEN + sizeof (struct page_03)];
	/* check if drive supports page 03 */
	if (dev.id == ID_IBM)
		return(1);
	page_len = check_page(3);
	if (page_len == 0)
		return(1);
	xfer_len = page_len + PGHD_LEN  + DSCPTR_LEN + MODEHEAD_LEN;
	if (cdb_mode_sense(fp, cbuf, xfer_len, PAGE03 | CHANGE) < 0)
		return(0);

	cptr = (struct mode_head *)cbuf;

	/* read default value */
	/* REE - need to use current value not default */

	if (cdb_mode_sense(fp, buf, xfer_len, PAGE03 | CURRENT) < 0)
		return(0);
	dptr = (struct mode_head *)buf;

/*
	if (dev.id == ID_IBM) 
		block_size = 512;
	else
*/
		block_size = 1024;

	byte_remain = page_len;	
	/* setup each block pointer */
	cbdp =(struct blk_dscptr *)((uint)cptr+MODEHEAD_LEN);
	dbdp =(struct blk_dscptr *)((uint)dptr+MODEHEAD_LEN);
	cph = (struct page_hd *)((uint)cbdp+cptr->dscptr_len);
	dph = (struct page_hd *)((uint)dbdp+dptr->dscptr_len);
	cp3p = (struct page_03 *)((uint)cph+PGHD_LEN);
	dp3p = (struct page_03 *)((uint)dph+PGHD_LEN);

	dph->code = PAGE03;

	/* set default value if field is changeable */
	if (dptr->dscptr_len == 0) goto set_p3;

/* REE - these values should remain as drive returns - 0 no longer valid
	dbdp->density = dbdp->numblk_msb = dbdp->numblk =
	dbdp->numblk_lsb = 0;
*/
	
	/* try setup block size */
	if (cbdp->blk_len) {
		ITOC3(dbdp->blk_len_msb, dbdp->blk_len, dbdp->blk_len_lsb, 
			block_size);
	}
/* REE - these values should remain as drive returns - 0 no longer valid
	else {
		ITOC3(dbdp->blk_len_msb, dbdp->blk_len, dbdp->blk_len_lsb, 
			0);
	}
*/

set_p3:
	/* set default value if fields is changeable */
/* REE - these values should remain as drive returns - 0 no longer valid
	for (x = (unchar *)dp3p ,y = (unchar *)cp3p, i = 0; 
		i != DFCTS_FIELD_LEN; i++ ){
		*x++ &= *y++;
		if (--byte_remain == 0 )
			goto start_p3cmd;
	}
*/

		

	/* setup sector per track */
	if(cp3p->bps_lsb){

		ushort cur_sec_size,cur_spt, sec_ratio;

		cur_sec_size = CAT2(dp3p->bps_msb, dp3p->bps_lsb);
		cur_spt = CAT2(dp3p->spt_msb, dp3p->spt_lsb);

		if (block_size > cur_sec_size){
			sec_ratio = block_size / cur_sec_size;
			cur_spt /= sec_ratio;
			ITOC2(dp3p->spt_msb, dp3p->spt_lsb, cur_spt);
			ITOC2(dp3p->bps_msb, dp3p->bps_lsb, block_size);
			
		}
			
		else if (block_size == cur_sec_size) {
			ITOC2(dp3p->bps_msb, dp3p->bps_lsb, 0);	
			dp3p->spt_msb = dp3p->spt_lsb = 0;
		}
		else if (block_size < cur_sec_size) {
			sec_ratio = cur_sec_size / block_size;
			cur_spt *= sec_ratio;
			ITOC2(dp3p->spt_msb, dp3p->spt_lsb, cur_spt);
			ITOC2(dp3p->bps_msb, dp3p->bps_lsb, block_size);
		}
	} 
/* REE - these values should remain as drive returns - 0 no longer valid
	else {	
		ITOC2(dp3p->bps_msb, dp3p->bps_lsb, 0);
		dp3p->spt_msb = dp3p->spt_lsb = 0;
	}
*/

	if ((byte_remain -= 4) <= 0)
		goto start_p3cmd;
			

	if(cp3p->intrlv_lsb){
		ITOC2(dp3p->intrlv_msb, dp3p->intrlv_lsb, INTERLEAVE);
	}
/* REE - these values should remain as drive returns - 0 no longer valid
	else {
		ITOC2(dp3p->intrlv_msb, dp3p->intrlv_lsb, 0);
	}
*/

	if ((byte_remain -= 2) <= 0)
		goto start_p3cmd;
	 /* use drive default value or don't changed */	
/* REE - these values should remain as drive returns - 0 no longer valid
	 for (x = (unchar *)&dp3p->tksf_msb, y = (unchar *)&cp3p->tksf_msb; 
			byte_remain != 0; byte_remain--, x++, y++)
		*x &= *y;
*/
start_p3cmd:
	dptr->sd_len = dptr->wp_bm_speed = 0;

	if(cdb_mode_select(fp, buf, xfer_len , M_PF) < 0)
		return(0);
	else
		return(1);
} /* end of set_page_03 */

/*
 * set_any_page() - set any mode select page.
 *
 * This blindly sends the mode select page, without any checking of vaildity.
 * This routine should only be used for special cases, and therefore
 * the appropriate care in defining the page is assumed.
 * The data should contain the two byte page header followed by the contents.
 */
set_any_page(fp, pageno, data, len)
int	fp;
unchar	pageno;
unchar	*data;
unchar	len;
{
	uchar	buff[0xff];
	register uchar	*buf_p = buff;
	register unchar	i;
	unchar	page_len;

	for (i = 0; i != MODEHEAD_LEN; i++)
		*buf_p++ = 0;
	for ( ; i != len + MODEHEAD_LEN; i++)
		*buf_p++ = *data++;
	if ((page_len = check_page(pageno)) == 0) {
		printf("page %x not supported\n", pageno);
		return(0);
	}

	if (cdb_mode_select(fp, buff, page_len + PGHD_LEN + MODEHEAD_LEN, 
		M_PF|M_SP ) < 0)
		return(0);
	return(1);
}

check_page(n)
{
	struct page_hd *pt = ph_table;
	int m = total_pages;
	while(m--) {
		if (pt->code == n)
			return(pt->len);
		pt++;
	}
	return(0);
}

disk_config(fp)
{
	uint	i, blkno;

	struct sdk_block_0 *s0;	
	
	if (!set_ph_table(fp))
		return(0);

	if(!set_device_table(fp, buf))
		return(0);
	s0 = (struct sdk_block_0 *)buf;

	
	/* setup slice_table */
	if(!init_blk0_slice(fp,s0))
		return(0);

	if (cdb_write ( fp, s0, CONFIG_BLOCK*dev.blk_ratio, 
			1024, dev.blk_ratio*1) < 0)
		return(0);
	/* update back up block */
	if(cdb_write(fp, s0, CONFIG_BLOCK_BKUP*dev.blk_ratio,
			1024, dev.blk_ratio*1) < 0)
		return(0);
		
	/* clear defect list */
	memset(s0, 0, BSIZE);

	for (i = 0, blkno = DEF_DEFCT_LIST; i < DEF_DEFCT_SIZE; i++,blkno++){
		if (cdb_write(fp, s0, blkno*dev.blk_ratio, BSIZE, 
			dev.blk_ratio*1) < 0)
			return(0);
	}
	return(1);
} /* end of disk_config */

/* set_device_table -- setup disk drive configuration table. */

set_device_table(fp, s0)
struct sdk_block_0 *s0;	
{
	

	memset(s0, 0, BSIZE);
	memcpy(s0->misc.disk_info.vol_id,"IOPMSCSI",8);
	s0->misc.disk_info.date = VERSION_DATE;
	switch(dev.id) {
		case	ID_IBM:	/* IBM 3 1/2" disk */
			s0->misc.disk_info.cylns =IBM_CYLNS;
			s0->misc.disk_info.bps = IBM_BPS;
			s0->misc.disk_info.heads = IBM_HEADS;
			return(1);

		case 	ID_RRO:	/* RICOH removable eraseable op disk */
			s0->misc.disk_info.cylns = RRO_CYLNS;
			s0->misc.disk_info.bps = RRO_BPS;
			s0->misc.disk_info.heads = RRO_HEADS;
			return(1);

		default:
			if( !set_disk_info(fp, s0))
				return(0);
			else
				return(1);
	}
	/*NOTREACHED*/
}


static set_disk_info(fp,s0)
struct sdk_block_0 *s0;	
{

	struct	mode_head *sd; /* send data ptr */
	register struct	page_03	*p3;	/* page 03 ptr	*/
	register struct	page_04	*p4;	/* page 04 ptr	*/		
	int	xfer_len, page_len;

	if ( (page_len = check_page(3)) == 0) {
		dev_print("Device should provide page 03 info");
		return(0);
	}
	xfer_len = page_len + PGHD_LEN  + DSCPTR_LEN + MODEHEAD_LEN;
	/* REE - need to use current value not default */
	if(cdb_mode_sense(fp, altbuf, xfer_len, (PAGE03 | CURRENT)) < 0)
		return(0);

	sd = (struct mode_head *)altbuf;
	if (sd->wp_bm_speed & WP) {
		dev_print("media is write protected"); /* get write protection bit */	
		return(0);
	}

	p3 = (struct page_03 *)((uint)sd+MODEHEAD_LEN+sd->dscptr_len+PGHD_LEN);
	s0->misc.disk_info.bps = CAT2(p3->bps_msb, p3->bps_lsb); 

	if ( (page_len = check_page(4)) == 0) {
		dev_print("Device should provide page 04 info");
		return(0);
	}

	/* REE - need to use current value not default */
	if(cdb_mode_sense(fp, altbuf, xfer_len, (PAGE04 | CURRENT)) < 0)
		return(0);

	p4 = (struct page_04 *)((uint)sd+MODEHEAD_LEN+sd->dscptr_len+PGHD_LEN);
	if (dev.id == ID_RRH) { /* RICHO removable hard disk does not follow
		cylnrs concept */
		int cylns;	
		s0->misc.disk_info.heads = 1;
		cylns = CAT3(p4->cylns_msb, p4->cylns, p4->cylns_lsb);
		s0->misc.disk_info.cylns = cylns * p4->heads;
	}
	else {
		s0->misc.disk_info.cylns = CAT3(p4->cylns_msb, p4->cylns, p4->cylns_lsb);
		s0->misc.disk_info.heads = p4->heads;
	}
	return(1);

} /* end of set_disk_info  */



init_blk0_slice(fp,s0)
struct sdk_block_0	*s0;
{
	struct capacity	 cap;
	uint	last_blk, blk_len;
	union _s0_blk1 *slp = &s0->slice_table[DEF_DEFCT_SLICE];

	/* set default defect list slice */
	slp->ldrv.ld_strt = DEF_DEFCT_LIST;
	slp->ldrv.ld_size = DEF_DEFCT_SIZE;
	slp->ldrv.ld_type = LD_DEFCT_SLICE;

	if(cdb_read_cap(fp, &cap, 0)< 0)
		return(0);
	blk_len = CAT4(cap.bl_msb,cap.bl_2,cap.bl_1,cap.bl_lsb);
	last_blk = CAT4(cap.lba_msb,cap.lba_2,cap.lba_1,cap.lba_lsb);
	dev.blk_ratio = 1024 / blk_len;
	last_blk /= dev.blk_ratio;

	/* setup first slice entry */
	slp = &s0->slice_table[0];
	slp->ldrv.ld_strt = DEF_DEFCT_LIST + DEF_DEFCT_SIZE;
	slp->ldrv.ld_size = last_blk - slp->ldrv.ld_strt + 1;
	slp->ldrv.ld_type = LD_UNUSED_SLICE;

	/* First, get last block number on first cylnder */
	if(cdb_read_cap(fp, &cap, FIRST_DATA_BLOCK_NUM) < 0)
			return(0);
	last_blk = CAT4(cap.lba_msb,cap.lba_2,cap.lba_1,cap.lba_lsb);

	slp->ldrv.ld_spt = (blk_len/s0->misc.disk_info.bps) * 
		((last_blk+1)/s0->misc.disk_info.heads);

	slp->ldrv.ld_spt = slp->ldrv.ld_spt;
	return(1);

}
