/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dev_info.h: version 25.1 created on 11/27/91 at 15:26:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dev_info.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


struct vendor_id {
	char *vid;
	char *pid;
	short drv_id;
		   
};
/* drv_id definitions */
#define	ID_WREN4		0x01	/* CDC WREN 4 disk */
#define	ID_WREN3		0x02	/* CDC WREN 3 disk */
#define	ID_SWFT			0x03	/* CDC 3 1/2" disk */
#define	ID_IBM			0x04	/* IBM 3 1/2" disk */
#define ID_RRH			0x05	/* RICOH removable hard disk */
#define ID_RRO			0x06	/* RICOH removable eraseable op disk */
#define ID_MRP			0x07	/* MICROPOLIS disk */
#define ID_WREN6		0x08	/* CDC WREN 6 disk */
#define ID_MAXTR		0x09	/* maxtor 3 1/2" disk */
#define ID_OCU			0x0A	/* Ten X Optical Conversion Unit */
#define ID_WREN5		0x0B	/* CDC WREN 5 SCSI disk, 639 meg. */

struct dev_info {
	unchar 	medium;
	unchar 	id;
	ushort	blk_ratio;
	int	blk_len;
	int	lst_blkno;
	int	format;
	int	bps;
	int	heads;
};

/* medium definitions */
#define	M_RMB		0x01	/* removable medium	*/
#define	M_FIX		0x00	/* non-removable medium */

/* format type */
#define	FMT_EDT		0x01
#define FMT_OLD		0x02
#define FMT_NEW		0x03
#define FMT_NO		0x04

typedef struct s_size {
	uint	offset;		/* starting block number	*/
	uint	noblk;		/* size of partition		*/
	unchar	type;		/* the logic drive status 	*/
	unchar  spt;
} SLSIZE;

#define LD_UNUSED_SLICE	0
#define LD_UNIX_SLICE	1
#define LD_SWAP_SLICE	2
#define LD_DIAG_SLICE	3
#define LD_DEFCT_SLICE	4
#define LD_BOOT_SLICE	5


#define MAX_SLICE_NUM	32
#define	BSIZE		1024

#define	TRUE	1
#define	FALSE	-1

/* number of sectors per page */
#define NSPP (PAGESIZE/BSIZE)
/* ******************************************************
 *							*
 *	Vendor's specific drive info 			*
 *							*
 * ******************************************************/

/* IBM 3 1/2" disk	*/
#define IBM_SPT		48
#define IBM_BPS		512
#define IBM_CYLNS	949
#define IBM_HEADS	14

/* RICHO removable erasable optical disk	*/
#define RRO_BPS		1024
#define RRO_CYLNS	18553
#define RRO_HEADS	1
