/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dev_info.c: version 25.1 created on 11/27/91 at 15:26:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dev_info.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include	"iopmfmt.h"
#include	"sys/elog.h"
#include	"macros.h"
#include	"sdk_cdb.h"
#ifdef STANDALONE
#include	"spm_debug.h"
#else
#include	<sys/debug.h>
#endif /* STANDALONE */

struct vendor_id vid_table[] = {
	{"CDC     ", "94171", ID_WREN4},   
	{"CDC     ", "94161",	ID_WREN3},
	{"CDC     ", "94181", ID_WREN5},
	{"CDC     ", "94191", ID_WREN6},
	{"CDC     ", "94351", ID_SWFT},
	{"IBM     ", "0661371", ID_IBM},
	{"RICOH   ", "RH5500  ", ID_RRH},
	{"RICOH   ", "RO-5030E", ID_RRO},
	{"RICOH   ", "SPECIAL", ID_RRO},
	{"MICROP  ", "1578-15MB1", ID_MRP},
	{"MAXTOR  ", "LXT-200S", ID_MAXTR},
	{"Ten X   ", "OCU-100", ID_OCU},
	{0,0,0}
};

static void
disp_strb(s, l)
unchar	*s;
int	l;
{
	int i;

	for ( i = 0; i < l; i++, s++) {
		if (*s == 0)
			break;
		else
			printf("%c", *s);
	}
}


check_device(fp)
int fp;
{
	struct	inquiry_data *inqp;
	struct	capacity	*ca;


	if (cdb_inquiry(fp, buf, sizeof (struct inquiry_data)) < 0)
		return(0);	 

	inqp = (struct inquiry_data *)buf;
	if (inqp->dev_type != DA_DEV){
		dev_print("Device is not a Direct-Access Device");
		return(0);	 
	}

	if (inqp->dev_qual & QUAL_RMB)
		dev.medium = M_RMB;	/* setup removable media drive */	
	else
		dev.medium = M_FIX;
	
	dev.id = dev_identify(inqp);
	dev_print((char *)0);		/* print device name */
	disp_strb(inqp->vdr_id, 8);
	printf(" model ");
	disp_strb(inqp->prod_id, 16);

	printf("\n");
	if (dev.id == 0) {
		if (question(" This kind of drive is not included in ARIX's devices list; continue?") != YES)
		return(0);
	}


	if (dev.medium == M_RMB) {
		if (!lock_device (fp))
			return(0);
	}


	if (cdb_read_cap(fp, buf, 0) < 0)
		return(0);
	ca = (struct capacity *)buf;

	dev.blk_len = CAT4(ca->bl_msb, ca->bl_2, ca->bl_1, ca->bl_lsb);
	dev.blk_ratio = BSIZE/dev.blk_len; 
	dev.lst_blkno = CAT4(ca->lba_msb, ca->lba_2, ca->lba_1, ca->lba_lsb);
	dev.lst_blkno /= dev.blk_ratio;

	if (!set_ph_table(fp))
		return(0);
	return(1);
} /*  end of check device */


dev_identify(inqp)
struct inquiry_data	*inqp;
{

	struct vendor_id *id;
	
	for (id = vid_table; id->vid != 0; id++) {
		if (!token_cmp(id->vid, inqp->vdr_id))
			continue;
		if (!token_cmp(id->pid, inqp->prod_id))
			continue;
		return(id->drv_id);
	}
	return(0);
}
			
show_disk_layout(fp)
{
	(void) read_slice_table(fp, sltable);

	printf("\nThe device is "); 
	switch(dev.format) {
		case FMT_EDT:
			printf("formatted (EDT).\n");
			break;
		case FMT_OLD:
			printf("formatted (old iopm).\n");
			break;
		case FMT_NEW:
			printf("formatted.\n");
			break;
		default:
			printf("is not formatted or has an unknown format.\n");
	}
}
	
/* Note: token_cmp 
		doing two strings compare and stop while s0 hit blank or null,
		or find difference between two strings
*/
token_cmp(s0, s1)
unchar *s0, *s1;
{
	while ( *s0 != ' ' && *s0 != 0) {
		if (*s0++ != *s1++)
			return(0);
	}
	return(1);
}
	
lock_device(fp)
int fp;
{
	/* spin up drive */
	if (dev.medium == M_RMB) {
		if (cdb_start_stop(fp, SPIN_UP) < 0)
			return(0);

		if (cdb_medium_removal(fp, PREVENT) < 0)
			return(0);
	}
	return(1);
}

unlock_device(fp)
int fp;
{
	/* spin down drive */
/* tmp fixed for new WORM */
	if (dev.medium == M_RMB && dev.id != ID_OCU) {
		if (cdb_start_stop(fp, SPIN_DOWN) < 0)
			return(0);

		if (cdb_medium_removal(fp, ALLOW) < 0)
			return(0);
	}
	return(1);
}

verify_iopm_disk()
{
	if(dev.format == FMT_NEW)
		return(1);
	else {
		dev_print("disk is not iopm format");
		return(0);
	}
}

set_geometry_info(fp)
{

	struct	mode_head *sd; /* send data ptr */
	unchar	ms_buf[256];
	register struct page_03 *p3;
	register struct	page_04	*p4;	/* page 04 ptr	*/		
	int	xfer_len, page_len;


	if ( (page_len = check_page(3)) == 0) {
		dev_print("Device should provide page 04 info");
		return(0);
	}

	xfer_len = page_len + PGHD_LEN  + DSCPTR_LEN + MODEHEAD_LEN;
	
	sd = (struct mode_head *)ms_buf;

	if(cdb_mode_sense(fp, ms_buf, xfer_len, (PAGE03 | CURRENT)) < 0)
		return(0);

	p3 = (struct page_03 *)((uint)sd+MODEHEAD_LEN+sd->dscptr_len+PGHD_LEN);

	dev.bps = CAT2(p3->bps_msb, p3->bps_lsb); 

	if (dev.id == ID_RRH){  /* RICHO removable hard disk does not follow
				cylnrs concept */
		dev.heads = 1;
		return(1);
	}
	if ( (page_len = check_page(4)) == 0) {
		dev_print("Device should provide page 04 info");
		return(0);
	}
	xfer_len = page_len + PGHD_LEN  + DSCPTR_LEN + MODEHEAD_LEN;

	if(cdb_mode_sense(fp, ms_buf, xfer_len, (PAGE04 | CURRENT)) < 0)
		return(0);

	p4 = (struct page_04 *)((uint)sd+MODEHEAD_LEN+sd->dscptr_len+PGHD_LEN);
	dev.heads = p4->heads;
	return(1);

} /* end of set_geometry_info  */
