/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) boot_build.c: version 25.1 created on 11/27/91 at 15:25:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)boot_build.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * build_boot.c
 *
 *	given a list of files, output an S3000 bootimage
 *	complete with correct directory info.
 */

#define SA_BOOTS

#include <stdio.h>
#include <filehdr.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <aouthdr.h>
#include <scnhdr.h>
#include <fcntl.h>
#include "sa_dir.h"
#include "spm.h"

#define PMODE		0644	 /* RW for owner, R for group and others */ 

extern char *strrchr();

struct sa_dir	dir_buf;

char *
pathend(path)
char *path;
{
	register char *p;

	if(p = strrchr(path,'/'))
		++p;
	else
		p = path;
	return(p);
}


main(argc,argv)
int	argc;
char	*argv[];
{
	register int		boot_fd, file_fd;
	struct	stat		statbuf;
	AOUTHDR			aout_buf;
	FILHDR			flhdr_buf;
	uint			seekval, numbytes;
	uint			i,block_num;
	char			*boot_name = "bootimage";
	char			*spm = "spm";
	char			*buf, *pathend_ptr;
	uint			retval;
	uint			last_block_num;

	/* process arguments */
	if(argc < 2) {
		printf("sorry, no arguments\n");
		return;
	}
	/* create bootimage file */
	if( (boot_fd=creat(boot_name, PMODE)) == -1) {
		printf("failed to create %s\n", boot_name);
		perror("");
		exit(1);
	}

	/* read each file header and build up in core directory */
	block_num = 1;
	for(i = 1; i < argc; i++) {
		/* convert pathname */
		pathend_ptr = pathend(argv[i]);
		
		if( strlen( pathend_ptr ) > MAX_DIR_NAME) {
			printf("%s is longer than %d characters!\n",
				pathend_ptr, MAX_DIR_NAME);
			exit(2);
		}
		/* open file */
		if( (file_fd = open(argv[i], O_RDONLY)) == -1) {
			printf("failed to open %s\n", argv[i]);
			perror("");
			exit(3);
		}
		/* read file header */
		if(read(file_fd, &flhdr_buf, sizeof(FILHDR)) != sizeof(FILHDR)) {
			printf("failed to read file header for %s\n", argv[i]);
			perror("");
			exit(4);
		}
		/* read a.out header */
		if(read(file_fd, &aout_buf, sizeof(AOUTHDR)) != sizeof(AOUTHDR)) {
			printf("failed to read a.out header for %s\n", argv[i]);
			perror("");
			exit(5);
		}

		/* get file status */
		if( fstat(file_fd, &statbuf) == -1) {
			printf("stat of %s failed\n", argv[i]);
			perror("");
			exit(6);
		}

		seekval = sizeof(AOUTHDR) + sizeof(FILHDR) +
		   (sizeof(SCNHDR) * flhdr_buf.f_nscns);
		numbytes = statbuf.st_size;

		/* write directory element */
		strcpy(dir_buf.entry[i-1].name, pathend_ptr);
		dir_buf.entry[i-1].start_block_num = block_num;
		dir_buf.entry[i-1].byte_count = numbytes;

		/* major/minor version */
		dir_buf.entry[i-1].major_version = (aout_buf.vstamp & 0xff00) >> 8;
		dir_buf.entry[i-1].minor_version = aout_buf.vstamp & 0x00ff;

		/* mark if able to run in spm local memory */
		if((aout_buf.text_start >= SRAMSTART)
			&& (aout_buf.text_start <= SRAMSTART+SRAMSIZE)) 
			dir_buf.entry[i-1].spm_exec = 1;
		else
		/* if a mapped address, don't mark as spm local executable */
			dir_buf.entry[i-1].spm_exec = 0;

		/* seek to start of text */
		if( lseek(file_fd, 0, 0) == -1 ) {
			perror("lseek failed");
			exit(7);
		}

		/* allocate a buffer for reading the file */
		if((buf = (char *)malloc((uint)numbytes)) == NULL) {
			printf("malloc of 0x%x bytes failed\n", numbytes);
			perror("");
			exit(8);
		}
		if((read(file_fd, buf, numbytes)) != numbytes) {
			printf("read of %s failed\n", argv[i]);
			perror("read failed");
			exit(9);
		}

		/* seek to right block num in bootimage file */
		if( lseek(boot_fd, block_num * BLK_SIZE, 0) == -1 ) {
			perror("lseek failed");
			exit(10);
		}

		/* pad to even block boundary */
		numbytes += BLK_SIZE - (numbytes % BLK_SIZE);

		/* write the file out */
		if(write(boot_fd, buf, numbytes) != numbytes) {
			printf("failed to write %s\n", argv[i]);
			perror("");
			exit(11);
		}

		/* deallocate the buffer used for the read */
		free(buf);

		/* close file */
		if( close(file_fd) == -1) {
			printf("close of %s failed\n", argv[i]);
			perror("");
			exit(12);
		}

		/* adjust to next block boundary */
		block_num += (numbytes/BLK_SIZE);
	}

	/* fill first entry info */
	/* magic number */
	dir_buf.magic_num = 'SA';
	dir_buf.next_dir_block = 0;		/* mark this as the last dir */
	dir_buf.block_size = BLK_SIZE;
	dir_buf.bootimage_size = block_num * dir_buf.block_size; 

	if((buf = (char *)malloc((uint)BLK_SIZE)) == NULL) {
		printf("malloc of 0x%x bytes failed\n", BLK_SIZE);
		perror("");
		exit(13);
	}
	if(write(boot_fd, buf, BLK_SIZE) != BLK_SIZE) {
		printf("failed to write pad block\n");
		perror("");
		exit(14);
	}
	free(buf);

	/* pad directory to block boundary */
	/* assume directory not longer than one block */

	/* seek to directory block */
	if( lseek(boot_fd, 0, 0) == -1 ) {
		perror("lseek failed");
		exit(13);
	}

	/* write out directory */
	if(write(boot_fd, &dir_buf, BLK_SIZE) != BLK_SIZE) {
		printf("failed to write directory\n");
		perror("");
		exit(14);
	}
	if( close(boot_fd) == -1) {
		printf("close of %s failed\n", boot_name);
		perror("");
		exit(15);
	}
}
