/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sec.c: version 25.1 created on 11/27/91 at 15:13:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sec.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	sec.c  security interface driver
 *	(C)Copyright 1990 by ARIX Corporation
 *
 *	This driver has been created to facilitate the downloading of
 *	security sensitive data from user files to the kernel, primarily
 *	at system startup and transition to init 2 state. This driver
 *	will keep internal tables needed by the kernel for authorization
 *	decisions (setuid role/priv/mac mappings, uid/role mappings and
 *	locked uid/gid for suid/gid-exec prevention.
 *
 */

#ident	"@(#)io/sec.c:sec.c	1.3"

#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/signal.h"
#include "sys/errno.h"
#include "sys/dir.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/tty.h"
#include "sys/buf.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/fs/s5dir.h" 
#include "sys/fs/s5inode.h"
#include "sys/fs/s5filsys.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/acct.h"
#include "sys/sysinfo.h"
#include "sys/reg.h"
#include "sys/var.h"
#include "sys/tuneable.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/message.h"
#include "sys/conf.h"
#include "sys/open.h"
#include "sys/nami.h"
#include "sys/mount.h"
#include "sys/ipc.h"
#include "sys/msg.h"
#include "sys/stat.h"
#include "sys/mfs.h"
#include "sys/synch.h"

#ifdef SECON
#include "sys/mls.h"
#include "sys/priv.h"
#include "sys/security.h"


#define MINRMAX	4
/* sec_info flags bit defintions */
#define OPENWR   	0x01
#define OPENRD		0x02
#define OPENMASK	0x03
#define OPENSLP		0x08
/* sec_info - this structure is used to keep track of the
 *	      currently loaded information.
 */

typedef struct sec_info {
	uchar	flags;
	int	elsize;		/* element size */
	char	*head;		/* head of table ptr */
	char	*rwp;		/* read/write pointer */
	char	*tail;		/* pointer to end of table */
	char	*lvp;		/* pointer to last valid entry */
	spin_lock_t lock;	/* suspend lock for */   
	} sec_info_t;


/* allocate three databases for information. Each of these will be attached
 * to one of the three psuedo devices, thus the minor bits are used to 
 * determine which table is used. The following map defines the ordering:
 *	minor 0 - role definition map
 *	minor 1 - uid/role map
 *	minor 2 - locked gid map 
 *	minor 3 - exec label map
 */
sec_info_t secdb[MINRMAX];

extern kern_role_t kern_role[];
extern int rolemax, rolesize;
extern kern_uidmap_t kern_uidmap[];
extern int uidmax, uidsize;
extern kern_gidmap_t kern_gidmap[];
extern int gidmax, gidsize;
extern slabel_t exec_labels[];
extern int execmax, execsize;
#endif

/*
 *	secinit   initialize the security database driver 
 */	
secinit()
{
#ifdef SECON
slabel_t *sl, *dl;
int i = 0;

	/* initialize the arrary of pointers and max's for the
	 * table of databases 
 	 */
	secdb[0].head = (char *)kern_role;
	secdb[0].rwp = (char *)kern_role;
	secdb[0].lvp = (char *)kern_role;
	secdb[0].tail = secdb[0].head + (rolemax * rolesize);
	secdb[0].elsize = rolesize;

	secdb[1].head = (char *)kern_uidmap;
	secdb[1].rwp = (char *)kern_uidmap;
	secdb[1].lvp = (char *)kern_uidmap;
	secdb[1].tail = secdb[1].head + (uidmax * uidsize);
	secdb[1].elsize = uidsize;

	secdb[2].head = (char *)kern_gidmap;
	secdb[2].rwp = (char *)kern_gidmap;
	secdb[2].lvp = (char *)kern_gidmap;
	secdb[2].tail = secdb[2].head + (gidmax * gidsize);
	secdb[2].elsize = gidsize;

	secdb[3].head = (char *) exec_labels;
	secdb[3].rwp = (char *) exec_labels;
	secdb[3].lvp = (char *) exec_labels;
	secdb[3].tail = secdb[3].head + (execmax * execsize);
	secdb[3].elsize = execsize;
#endif
}

	

/* 
 *	secopen   open a channel (psuedo-device) to one of the databases
 *	          for reading and writting. The flag and type arguments
 *		  are used to determine the type of access and whether 
 *		  a reset of the internal database is necessary.
 */
secopen( dev, flag, type )
dev_t dev;
int flag, type;
{
#ifdef SECON
sec_info_t *p;
int minr = minor( dev );

	/* make sure the minor is valid */
	if ( minr > MINRMAX ) {
		u.u_error = ENXIO;
		return;
	}

	p = &secdb[minr];

	/* only one guy can have us open at a time  
         * this will make the sync problems much easier to 
 	 * deal with 
 	 */
	spin_lock( &p->lock );
	if ( p->flags & OPENMASK ) {
		spin_unlock( &p->lock );
		u.u_error = EACCES;
		return;
	}

	/* decide if the open is for a read of a write */	
	if ( flag & FREAD ) {
		p->flags |= OPENRD; 
		p->rwp = p->head;
	}
	/* start all the pointers from scratch */
	else if ( flag & FWRITE)  {
		p->flags |= OPENWR;
		p->rwp = p->head;
		p->lvp = p->head;
	} 
	else if ( flag & FAPPEND ) {
		p->flags |= OPENWR;
		p->rwp = p->lvp;
	}
	spin_unlock( &p->lock );
#endif
}


/*
 *	secclose   close the open channel to the given table. This
 *		   should allow anyone in who really wants in.
 */

secclose( dev, flag, type )
dev_t dev;
int flag, type;
{
#ifdef SECON
sec_info_t *p;
int minr = minor( dev );

	/* make sure the minor is valid */
	if ( minr > MINRMAX ) {
		u.u_error = ENXIO;
		return;
	}
	p = &secdb[minr];

	spin_lock( &p->lock );

	/* make sure we've been opened before we close */
	if ( !( p->flags & OPENMASK)) {
		spin_unlock( &p->lock );
		u.u_error = EACCES;
		return;
	}

	/* remove the open flags */
	p->flags &= (~OPENMASK );

	/* if any of the readers are waiting to read table let them
	 * in right now!!
	 */
	if ( p->flags & OPENSLP ) { 
		wakeup((caddr_t)p);
		p->flags &= ~OPENSLP;
	}
	spin_unlock( &p->lock );  
#endif
}

/*
 *	secread   write a security table in local dataspace to the users
 *		  dataspace.
 *
 */

secread( dev )
dev_t dev;
{
#ifdef SECON
sec_info_t *p;
int minr = minor( dev );

	/* make sure the minor is valid */
	if ( minr > MINRMAX ) {
		u.u_error = ENXIO;
		return;
	}
	p = &secdb[minr];

	spin_lock( &p->lock );
	/* make sure we've been opened before we close */
	if ( !( p->flags & OPENRD)) {
		u.u_error = EINVAL;
		spin_unlock( &p->lock );
		return;
	}

	/* check that data structure passwd down is aligned */
	if ( u.u_count % p->elsize ) {
		spin_unlock( &p->lock );
		u.u_error = EINVAL;
		return;
	}


	/* while user needs more bytes and we have data */
	while ( u.u_count && (p->rwp < p->lvp) ) {
		/* make sure we're not past end of table */
		if ( p->tail - p->rwp < p->elsize )
			break;
	
		/* copy the data from user mode */ 	
		iomove_read( (caddr_t)p->rwp, p->elsize );

		if ( u.u_error )
			break;

		/* update counters */
		p->rwp += p->elsize;
	}
	spin_unlock( &p->lock );
#endif
}

/*
 *	secwrite  read a security table in user space to local dataspace
 *		  dataspace.
 *
 */

secwrite( dev )
dev_t dev;
{
#ifdef SECON
sec_info_t *p;
int minr = minor( dev );

	/* make sure the minor is valid */
	if ( minr > MINRMAX ) {
		u.u_error = ENXIO;  
		return;
	}
	p = &secdb[minr];

	spin_lock( &p->lock );
	/* make sure we've been opened before we close */
	if ( !( p->flags & OPENWR)) {
		spin_unlock( &p->lock );
		u.u_error = EACCES;
		return;
	}

	/* check that data structure passwd down is aligned */
	if ( u.u_count % p->elsize ) {
		spin_unlock( &p->lock );
		u.u_error = EINVAL;
		return;
	}

	while ( u.u_count ) {
		/* make sure we're not past end of table */
		if ( p->tail - p->rwp < p->elsize )
			break;

		/* copy the data from user mode */ 	
		iomove_write((caddr_t) p->rwp, p->elsize );

		if ( u.u_error )
			break;

		/* update counters */
		p->rwp += p->elsize;
		p->lvp += p->elsize;
	}
	spin_unlock( &p->lock );
#endif
}

#ifdef SECON
/*
 *	setrole   set the role for the user based upon the uid 
 *		  passed in. This routine will return 1 if the 
 *		  proper entries were found and updated, else
 *		  it return 0 (this means either role or uid 
 *		  not authenticated)
 *	Note:   mode = 0 means setup the role in total. 
 *		mode = 1 means only setup the effective priv
 *		mode = 2 trust the uauth->a_role, and set the rest 
 */

setrole( uid, mode )
register ushort uid;
int mode;
{
register sec_info_t *p;
register kern_uidmap_t *up;
register kern_role_t *rp;
int role;
	/* if the uid is a real one */
	if ( mode != 2 ) {
		/* decide if the user exists in the database. If he 
		 * doesn't, ignore the request and return an error
		 */
		p = &secdb[1];
		spin_lock( &p->lock );

		/* if there aren't any entries, assume we haven't been
		 * downloaded and return 
		 */
		if ( p->lvp == p->head ) {
			spin_unlock( &p->lock );
			return 1;
		}
		
		/* wait for uidmap writers to back out */
		while ( p->flags & OPENWR ) {
			p->flags |= OPENSLP;
			mfs_sleep((caddr_t)p, PZERO-1, &p->lock );
		}

		/* init role with absurd value so we can see if we get a 
		 * match  
		 */	
		role = -1;  	
		for ( up = (kern_uidmap_t *)p->head; 
		      up < (kern_uidmap_t *)p->lvp; up++ ) {
			/* if the uid exists and isn't locked or retired */
			if ((up->uid == uid) && (!up->status)) {
				role = up->role;
				break;
			}
		}
		spin_unlock( &p->lock );

		/* test to see if we found anything...error out if not */
		if ( role == -1 ) 
			return 0;
		else
			uauth->a_role = role; 
	}

	/* if we aren't in priv/label mode, then we might as well 
 	 * return a sucess at this point...no need to do any extra
 	 * work
	 */
	if (!(sec_mode & (PRIVON|MACSON)))
		return 1;

	/* now let's find the associated role */
	p = &secdb[0];
	spin_lock( &p->lock );

	/* as in the uid map, check to see if this database
	 * is loaded...if not just return okay
	 */	
	if ( p->lvp == p->head ) {
		spin_unlock( &p->lock );
		return 1;
	}

	/* wait for writers of the role db to back out */
	while ( p->flags & OPENWR ) {
		p->flags |= OPENSLP;
		mfs_sleep((caddr_t)p, PZERO-1, &p->lock );
	}

	/* now find the matching role */	
	for ( rp = (kern_role_t *)p->head; rp < (kern_role_t *)p->lvp; rp++ ) {
		/* if he matched and isn't locked */
		if ((rp->role == uauth->a_role) && (!rp->status)) {
			if ( sec_mode & PRIVON ) {
				if ( mode !=1 ) {
					bcopy((caddr_t)&rp->priv, 
						(caddr_t)&uauth->a_priv,
						sizeof( priv_t ));
					uauth->a_priv.real &= sys_priv_mask;
					uauth->a_priv.eff &= sys_priv_mask;
				} else 
					uauth->a_priv.eff = rp->priv.real;
			}
			if ((sec_mode & MACSON) && (mode != 1) )
				bcopy((caddr_t)&(rp->minlabel), 
					(caddr_t)&uauth->a_minlabel, 
					sizeof( slabel_t) * 2 );
			
			/* we did it!! unlock and return */
			spin_unlock( &p->lock );
			return 1;
		}
	}

	/* we didn't do it!! unlock and return */
	spin_unlock( &p->lock );
	return 0;
}


/*
 *	getgidinfo   return the status of a gid. 1 = okay, 0 = locked
 *		     or doesn't exist
 *
 */
getgidinfo( gid )
register ushort gid;
{
register sec_info_t *p;
register kern_gidmap_t *rp;

	/* point the the gid database */
	p = &secdb[2];	
	spin_lock( &p->lock );

	/* if we haven't been loaded, assume normal operation and
	 * return valid status
	 */ 
	if ( p->lvp == p->head ) {
		spin_unlock( &p->lock );
		return 1;
	}

	/* wait for writers to back out! */
	while (p->flags & OPENWR ) {
		 p->flags |= OPENSLP;
		 mfs_sleep( (caddr_t)p, PZERO-1, &p->lock );
	}

	/* search for the proper gid */
	for ( rp = (kern_gidmap_t *)p->head; 
	      rp < (kern_gidmap_t *)p->tail; rp++ ) 
		if ( rp->gid == gid && (! rp->status )) {
			spin_unlock( &p->lock );
			return 1;
		}
	spin_unlock( &p->lock );
	return 0;
}

#endif
