/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sat.c: version 25.1 created on 11/27/91 at 15:13:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sat.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	sat.c   security audit trail. 
 *	(C)Copyright 1990 by ARIX Corporation
 *
 *	This driver is essentially nothing more than a psuedo device
 *	that stores audit trace information. The Audit daemon is a 
 *	user level process tasked with periodically opening up this 
 *	driver and coping data from it to the file system. The audit
 *	system call reaches into data structures in this driver, so
 *	it must be present whenever the audit system call is!!
 *
 */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/signal.h"
#include "sys/errno.h"
#include "sys/dir.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/tty.h"
#include "sys/buf.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/fs/s5dir.h" 
#include "sys/fs/s5inode.h"
#include "sys/fs/s5filsys.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/acct.h"
#include "sys/sysinfo.h"
#include "sys/reg.h"
#include "sys/var.h"
#include "sys/tuneable.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/message.h"
#include "sys/conf.h"
#include "sys/open.h"
#include "sys/cmn_err.h"
#include "sys/nami.h"
#include "sys/mount.h"
#include "sys/ipc.h"
#include "sys/msg.h"
#include "sys/stat.h"
#include "sys/mfs.h"
#include "sys/synch.h"


#ifdef SECON
#include "sys/audit.h"
#include "sys/security.h"


/* Priorities are set so that readers of the audit trail (TCB guys) can
 * be interrupted. This is necessary, because this is the way that the
 * auditc utility talks to the daemon...via signals. Since the daemon 
 * will usually be asleep in the satread call, and because he promises
 * to return, we will allow the wakeup. On the other hand, writters are
 * not allowed to take signals....they must sleep until we guarentee the
 * audit records get out to disk.
 */
#define PSATRD		PZERO + 2
#define PSATWR		PZERO - 2
#define	SAT_DEV_MAX	1	

/* these variables are declared externally throught the confuration
 * mechanism; They are essentially confurable parameters, although 
 * some of them (HWM etc.) can be varied at runtime for tuning.
 */

extern char 	sat_buf[];		/* externally declared sat buffer */
extern uint 	sat_size;		/* size  of the buffers */   
extern ushort 	sat_hwm;		/* default HWM */
extern ushort	sat_hz;			/* default sleep time */

/* warning message if daemon closed but audit record on */
extern satwarning();
extern sattimeout0();


/* 
 *	locally defined variables 
 */

/* the aud_info structure are set up as an array to facilitate multiple
 * internal audit buffers in the future. Currently this is unimplemented,
 * but we may need it!!
 */
aud_state_t aud_info[SAT_DEV_MAX];		
#endif

/*
 *	sat_som  show configuration status of audit trail daemon
 */
sat_som()
{
#ifdef SECON
	if ( sec_mode & SATON )
		cmn_err(CE_CONT, "Audit Trail Enabled\n" );
#endif
}

/*
 *	satinit   initialize the driver data structures. This includes
 *	          only the code necesssary for first time startup
 *
 */
satinit()
{
#ifdef SECON	

	/* initialize the audit info structure */
	aud_info[0].version = 2;
	aud_info[0].boot_time = time;
	aud_info[0].pid = 0;
	aud_info[0].hwm = sat_hwm;
	aud_info[0].callout = sat_hz;
	aud_info[0].bcnt = sat_size;
	aud_info[0].h = (char *)sat_buf;
	aud_info[0].r = (char *)sat_buf;
	aud_info[0].w = (char *)sat_buf;
	aud_info[0].e = (char *)&sat_buf[sat_size];

#endif
}


/*
 *	satopen   open the audit trail. Only on process may open the
 *		  audit trail, and this process must be the satsave
 *		  daemon (proper privileges are checked). 
 *
 */
satopen( dev, flag, type )
dev_t dev;
int flag, type;
{
#ifdef SECON
int minr = minor( dev );
aud_state_t *ap;

	/* check to see if the audit tail is installed */
	if ( !(sec_mode & SATON )) {
		u.u_error = ENXIO;
		return;
	}

	/* check for witch audit trail was opened */
	if ( minr > SAT_DEV_MAX ) {
		u.u_error = ENXIO;
		return; 
	}

	/* make sure user is authorized to open sat device */	
	if ( !auth_sat()) {
		u.u_error = EPERM;
		return;
	}

	ap = &aud_info[minr];
	spin_lock( &ap->lock );

	/* make sure the driver isn't already open.
	 * once the daemon opens us no one else can
	 */
	if ( ap->state & SAT_OPEN ) {
		spin_unlock( &ap->lock);
		u.u_error = EACCES;
		return;
	}
	/* stash the id of the opening process and mark the drive
	 * as open. This open flag is used by the kernel probes 
	 * to determine if records should be written
 	*/
	ap->pid = u.u_procp->p_pid;
	ap->state |= SAT_OPEN;
	ap->open_time = time;
	spin_unlock( &ap->lock );

#endif
}


/*
 *	satclose   close the audit trail  
 * 
 */
satclose( dev, flag, type )
dev_t dev;
int flag, type;
{
#ifdef SECON
int minr = minor( dev );
aud_state_t *ap;

	/* check to see if sat is enabled */
	if ( ! sec_mode & SATON ) {
		u.u_error = ENXIO;
		return;
	}

	/* check for witch audit trail was opened */
	if ( minr > SAT_DEV_MAX ) {
		u.u_error = ENXIO;
		return; 
	}

	ap = &aud_info[minr];
	spin_lock( &ap->lock );

	/* error to close device that's not open */
	if (!(ap->state & SAT_OPEN )) {
		spin_unlock( &ap->lock );
		u.u_error = EINVAL;
		return;
	}

	ap->pid = 0;
	ap->state &= ~SAT_OPEN;
	ap->close_time = time;
	spin_unlock( &ap->lock );

	/* issue a console message when we close the device and the audit
 	 * stuff is still enabled just so we are aware that noone is reading
	 * the record from the driver. This case should only occur if the 
 	 * audit daemon didn't do a proper shutdown. 
 	 */
	if ( ap->state & SAT_ENABLE ) 
		satwarning();
#endif
}


/*
 *	satread  read data from the audit trail  
 *
 */
satread( dev )
dev_t dev;
{
#ifdef SECON 
int minr = minor(dev);
int rsize;
aud_state_t *ap;

	/* check to see if the audit tail is installed */
	if ( !(sec_mode & SATON )) {
		u.u_error = ENXIO;
		return;
	}

	/* check for witch audit trail was opened */
	if ( minr > SAT_DEV_MAX ) {
		u.u_error = ENXIO;
		return; 
	}

	/* make sure user is authorized to open sat device */	
	if ( !auth_sat()) {
		u.u_error = EPERM;
		return;
	}

	ap = &aud_info[minr];
	spin_lock( &ap->lock );

	/* check to see if we setup a timeout...if not then doit  */
	if ( (! (ap->state & SAT_TIMER )) && ( ap->rcnt ) )  {
		ap->state |= SAT_TIMER;
		timeout( sattimeout0, 0, ap->callout );
	}
	
	/* check to see if the free count is greater than the hwm 
	 * if it's not, then sleep until it is or until we get woken
	 * up by the timeout call
 	 */
	while ( !ap->rcnt || (ap->bcnt >= ap->hwm) && (ap->state & SAT_TIMER) ) 
		mfs_sleep_with_sig_check((caddr_t)&ap->rcnt, PSATRD, &ap->lock);

	while ( u.u_count && ap->buf_recs ) {
		/* 2nd byte of header rec contains len of sat rec */
		switch( ap->e - ap->r ) {
			case 0:		/* read ptr at end, hdr starts at h */
				rsize = ap->h[1];
				break;
			case 1:		/* read ptr 1 byte from end */
				rsize = ap->h[0];
				break;
			default:
				rsize = ap->r[1];
		}
		rsize += sizeof( sat_hdr_t );
		if ( u.u_count < rsize ) {
			spin_unlock( &ap->lock );
			return;
		}
		satget( ap, rsize );
		ap->buf_recs--;
	}

	/* wakeup anybody waiting for space */
	if ( ap->state & SAT_SLEEP ) {
		ap->state &= ~SAT_SLEEP;
		wakeup((caddr_t)&ap->bcnt);
	}
	spin_unlock( &ap->lock );
#endif
}


#ifdef SECON
/*
 *	satsave  support routine that allows an audit record  to 
 *		 be written into the audit driver buffer. This routine
 *		 will hang if there is no room in the buffer.
 *
 */
satsave( event, buf, size )
int event;
char *buf;
int size;
{
sat_hdr_t hdr;
register aud_state_t *ap;
register evt_state_t *ep;

	hdr.event = event;
	hdr.cpu = u.u_procp->p_last_ran_on;
	hdr.pid = u.u_procp->p_pid;
	hdr.time = lbolt;
	hdr.size = size;

	/* ultimately this changes to proper syntax */
	ap = &aud_info[0];
	ep = &ap->evts[event];

	spin_lock( &ap->lock );

	/* if there isn't enough room in the buffer
	 * then we will sleep until there is room. We will sleep
	 * on the head of the aud_info structure, below PZERO so
	 * we can't be awaken.
	 * Note:  the two ifs can be taken out of the while loop by
	 *	  using another if with the same body as the while loop.
	 */
	while ((size + sizeof( sat_hdr_t)) > ap->bcnt) {
		if ( p_chkreal(P_SEC) ) {
			spin_unlock( &ap->lock );
			return;
		}
		ap->state |= SAT_SLEEP;
		mfs_sleep((caddr_t)&ap->bcnt, PSATWR , &ap->lock );
	}

	hdr.seq = ep->seq++;
	satput( ap, &hdr, sizeof( sat_hdr_t ));
	satput( ap, buf, size );

	/* knock down the proper buffer counter
	 * to record how much we have in there and hoow much
	 * is left. Also record the record count in the particular
	 * evt structure and the main structure 
	 */
	ap->tot_recs++;
	ap->cur_recs++;
	ap->buf_recs++;
	ep->tot_recs++;
	ep->cur_recs++;
	
	if ( ap->bcnt < ap->hwm )
		wakeup((caddr_t)&ap->rcnt );
	/* check to see if we setup a timeout...if not then doit  */
	else if ( ! (ap->state & SAT_TIMER )) {
		ap->state |= SAT_TIMER;
		timeout( sattimeout0, 0, ap->callout );
	}
	spin_unlock( &ap->lock );
}

/*
 *	satget  copy the record (marked by size) from the circular buffer
 *		to user space.
 */
satget( ap, size )
register aud_state_t *ap;
uint size;
{
register int bsize, asize, rsize;

	ASSERT(size <= ap->rcnt);
	/* figure out if we have enough room for whole thing - 
 	 * it not, then figure out how much to write before a 
	 * wrap around 
	 */
	bsize = ap->e - ap->r;
	asize = ( bsize < size ) ? bsize: size;
	rsize = size - asize;

	/* copy from current buffer pointer till end or buffer */
	if (asize) {
		spin_unlock( &ap->lock );
		iomove( ap->r, asize, B_READ );
		spin_lock( &ap->lock );
		ap->r += asize;
	}

	/* if there was a wrap, get the remaninder */
	if (rsize ) { 
		ASSERT(ap->r == ap->e);
		ap->r = ap->h;
		spin_unlock( &ap->lock);
		iomove( ap->r, rsize, B_READ );
		spin_lock( &ap->lock);
		ap->r += rsize;
	}
	ap->rcnt -= size;
	ap->bcnt += size;
	ASSERT(ap->rcnt + ap->bcnt == sat_size);
}


/*
 *	satput   put the contents of the buffer into the cirular queue
 */
satput( ap, buf, size )
register aud_state_t *ap;
char *buf;
uint size;
{
register int bsize, asize, rsize;

	ASSERT(size <= ap->bcnt);
	/* figure out if we have enough room for whole thing - 
 	 * it not, then figure out how much to write before a 
	 * wrap around 
	 */
	bsize = ap->e - ap->w;
	asize = ( bsize < size ) ? bsize: size;
	rsize = size - asize;


	/* if we have bytes we can write do so now */
	if ( asize ) {
		bcopy((caddr_t)buf, (caddr_t)ap->w, asize);
		ap->w += asize;
	}

	/* if we have bytes left to write, the figure out how
         * many are left, reset write pointer to head and write
	 * then out
	 */
	if ( rsize ) {
		ASSERT(ap->w == ap->e);
		ap->w = ap->h;
		bcopy((caddr_t)buf+asize, (caddr_t)ap->w, rsize);
		ap->w += rsize;
	}

	ap->rcnt += size;
	ap->bcnt -= size;
	ASSERT(ap->rcnt + ap->bcnt == sat_size);
}

/*
 *	syncevtstates  make sure all the vents substructure have thier
 *		       appropriate state flags enabled or disabled 
 */
syncevtstates()
{
register int i;
register aud_state_t *ap;

	ap = &aud_info[0];
	for ( i = 0; i < AUD_MAX_EVT; i++ ){
		if ( ((i<32) ? 
			(ap->mask[0]&(1<<i)) : ap->mask[1] & (1<<(i-32)))) {
			ap->evts[i].state |= SAT_ENABLE;
			ap->evts[i].edtime = time;
			ap->evts[i].cur_recs = 0;
			ap->evts[i].seq = 0;
		}
		else {
			ap->evts[i].state &= ~SAT_ENABLE;
			ap->evts[i].edtime = time;
		}
	}
} 

/*
 *	evt_active  determine if a given event is active or not 
 *		    based upon the global audit mask and the per-process
 *		    audit mask.
 */
evt_active( event )
register uint event;
{
register uint val;
register aud_state_t *ap;

	/* if sat is disabled make the audit probe points think that
	 * the event is disabled and let them chuck the record 
	 */
	if (!sec_mode & SATON) 
		return 0;

	ap = &aud_info[0];

	/* make sure we have enabled the audit trail
	 * in so many words, we chuck any events that occur when
	 * we are disabled 
	 */
	if (! (ap->state & SAT_ENABLE))
		return 0;
	
	if ( event < 0 )
		panic( "sat event number out of range" );

	/* figure out is event is first word or second */
	if ( event < 32 ) {
		val = 1 << event;
		return ( ap->mask[0] & val & uauth->a_amask[0] );
	}
	else if ( event < 64 ) {
		val = 1 << ( event - 32 );
		return ( ap->mask[1] & val & uauth->a_amask[1] );
	}
	panic( "sat event number out of range" );
}

/*
 *	sattimeout0  schedule a wakeup for any readers waiting for the
 *	            buffer to fill to the proper amount 
 *		
 *	Note: if we have more than 1 aud_info structure then we
 *	      need more sattimout routines 
 */
sattimeout0()
{
	spin_lock(&aud_info[0].lock);
	aud_info[0].state &= ~SAT_TIMER;
	spin_unlock(&aud_info[0].lock);
	wakeup((caddr_t)&aud_info[0].rcnt);
}

/* 
 *	satwarning      print a warnint every ten seconds if we are 
 *			buffering audit trail records but noone is 
 *			reading them 
 */
satwarning()
{
register int i;
register aud_state_t *ap;

	ap = &aud_info[0];
	for ( i = 0; i < SAT_DEV_MAX; i++, ap++ ) {
		if ((ap->state & SAT_ENABLE) && (ap->pid == 0)) {
			printf( "WARNING: audit tail [%d] enabled but no daemon process running\n", i );
			printf( "WARNING: %d bytes free in audit trail\n", ap->bcnt );
			/* warning every 5 minutes */
			timeout( satwarning, 0, 300 ); 
		}
	}
}

#endif
