/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) priv.c: version 25.1 created on 11/27/91 at 15:13:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)priv.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *
 *	priv.c     privilege support routine for kernel
 *
 *	9/1/89	   JTOF - initial code
 */
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/tuneable.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/clock.h"
#include "sys/conf.h"
#include "sys/spl.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/param.h"
#include "sys/fs/s5inode.h"
#include "sys/cmn_err.h"

#ifdef  SECON
#include "sys/priv.h"
#include "sys/mls.h"
#include "sys/security.h"
#endif


extern int s5readi();
#ifdef SECON    
extern kern_role_t *getroleinfo();
#endif

/*
 *	priv_som   show ipl banner indicating privilege state 
 *
 */
priv_som()
{
#ifdef SECON
	if (sec_mode & PRIVON )
		cmn_err(CE_CONT, "Privilege Mode Enabled. \n" );
#endif
}


/*
 *
 *	priv    kernel privilege system call entry point. Support for getpriv, 
 *              setpriv, getfpriv, setfpriv all vectored from here  
 *
 */

priv()
{
#ifdef SECON
int tmp;
struct inode *ip;
struct s5inode *s5ip;
kern_role_t *rp;
register struct a {
	int	func;
	priv_t	*p;
	char	*fname;
	} *uap = (struct a *) u.u_ap;

	if (!(sec_mode & PRIVON))  {
		u.u_error = ENOSYS;
		return;
	}
	switch(uap->func) {
		case GETROLE:
			if (copyout((caddr_t)(&uauth->a_role), (caddr_t)uap->p,
				 sizeof( ushort )))
				u.u_error = EFAULT;
			return;
		case SETROLE:
			/* make sure we protect this */
			if ( ! auth_priv_subj() ) {
				u.u_error = EPERM;
				return;
			}
			if (copyin((caddr_t)uap->p,(caddr_t)(&uauth->a_role),
				sizeof( ushort ))) {
				u.u_error = EFAULT;
				return;
			}
			/* 0 is a fake argument - 2 means we will set 
		         * the role based on contents of uauth->a_role 
			 */
			if (setrole( 0, 2 ))
				sat_setrole();
			else
				u.u_error = EPERM;
			return;
		case GETPRIV:
			if (copyout((caddr_t)(&uauth->a_priv), 
				(caddr_t)uap->p, sizeof(priv_t)))
				u.u_error = EFAULT;
			return;

		/* set a process privilege. This is one of the most
		 * sensitive security areas in the kernel
		 * PROTECT IT WELL OBI WAN KANOBI !!!
		 */
		case SETPRIV:
			if (!auth_priv_subj()) {
				u.u_error = EPERM;
				return; 
			}
			/* JTOF - little side effect here...setpriv will
		         *        allow the caller to set effective privleges
		         *        as well as real privileges. This can be
  		         * 	  of user if you want a utility to have
			 *        a transient effective for a while 
			 */
			if (copyin((caddr_t)uap->p,(caddr_t)(&(uauth->a_priv)),
				      sizeof(priv_t)))  {
				u.u_error = EFAULT;
				return;
			}
			sat_priv();
			return;
		/* JTOF - delpriv was added so that any user could give 
		 * away privileges not needed. It is the only form of 
		 * privilege modification non-privileged users may do. This
		 * call does create an audit record, but we check to make
		 * sure proc has privilege so we don't flood audit trail 
		 * if a malicous user tries to give away privileges in 
		 * a continous loop!
		 */
		case DELPRIV:
			/* get delete map from the user */
			if (copyin((caddr_t)uap->p,(caddr_t)&tmp, 
				sizeof(uint))) {
				u.u_error = EFAULT;
				return;
			}
			/* check to make sure at least some privileges 
			 * are present to remove. If non exist, return 
 			 * EINVAL error.
			 */
			if ( !((uauth->a_priv.real | uauth->a_priv.eff) & 
				tmp)) {
				u.u_error = EINVAL;
				return;
			}
			/* now strip out the privileges we don't want */
			uauth->a_priv.real &= ~tmp;
			uauth->a_priv.eff &= ~tmp;
			uauth->a_priv.mask &= ~tmp;
			sat_priv();
			return;
		/* get a files effective privilege */
		case GETFPRIV:
			/* don't let any normal users see the effective
 			 * privileges on files unless they have proper priv
		         */
			if (!auth_priv_obj() ) {
				u.u_error = EPERM;
				return;
			}
		
			u.u_dirp = (caddr_t)u.u_arg[2];
			if ((ip = namei(upath,0)) == NULL)
				return;

			if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
				u.u_error = EINVAL;
				iput(ip);
				return;
			}

			/* only copyout the effective privilege */
			if (copyout( (caddr_t)&ip->i_priv, (caddr_t)uap->p,
				 sizeof(uint)))
				u.u_error = EFAULT;

			iput(ip);	
			return;

		/* set file effective privileges */
		case SETFPRIV:
			if ( ! auth_priv_obj() ) {
				u.u_error = EPERM;
				return;
			}
			/* get file to set privilege on */
			u.u_dirp = (caddr_t)u.u_arg[2];
			if ((ip = namei(upath,0)) == NULL)
				return;

			if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
				u.u_error = EINVAL;
				iput(ip);
				return;
			}
			tmp = ip->i_priv;
			/* copy in the privilege */
			if (copyin( (caddr_t)uap->p, (caddr_t)&ip->i_priv, 
				sizeof(uint)))  {
				iput(ip);
				u.u_error = EFAULT;
				return;
			}
			ip->i_flag |= (IUPD|ICHG);
			sat_filepriv(ip, ip->i_priv, tmp );
			iput(ip);
			return;
		case SETSYSMASK:
			if ( !auth_sysmask() ) {
				u.u_error = EPERM;
				return;
			}
			if (copyin((caddr_t)uap->p, &sys_priv_mask, 	
				sizeof(uint)))
				u.u_error = EFAULT;
			return;
		case GETSYSMASK:
			if ( !auth_sysmask() ) {
				u.u_error = EPERM;
				return;
			}
			if (copyout((caddr_t)&sys_priv_mask, (caddr_t)uap->p,
				sizeof(uint)))
				u.u_error = EFAULT;
			return;
		default:
			u.u_error = EINVAL;
			break;
	}
#else
	u.u_error = ENOSYS;
#endif
}


