/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mls.c: version 25.1 created on 11/27/91 at 15:13:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mls.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/tuneable.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/conf.h"
#include "sys/spl.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/param.h"
#include "sys/cmn_err.h"

#ifdef SECON
#include "sys/mls.h"
#include "sys/security.h"
#include "sys/fs/s5inode.h"
#endif

extern s5iread();

/*
 *	macs
 *
 */
macs_som()
{
#ifdef SECON
	if (sec_mode & MACSON )
		cmn_err(CE_CONT, "Label Checking Enabled. \n" );
#endif
}
/*
 *      mls       multilevel security system entry point
 *		  several different operations are permitted under
 *		  this system call. They are as follows
 *		  GETMAC - to retrieve a process min and max labels
 *		  SETMAC - to set a process min and max labels
 *		  GETFMAC - to get a files label
 *		  SETFMAC - to set a files label 
 *
 *	Notes: the function code that deal with the process labels
 *	       must pass a user-area large enough to store two labels!
 */

mls()
{
#ifdef SECON
register struct inode *ip;
register struct s5inode *s5ip;
slabel_t tmp;
register struct a {
	uint	fno;
	slabel_t *label;
	char	*name;
	} *uap = (struct a *) u.u_ap;

	/* only if macs are enabled!! */
	if ( ! (sec_mode & MACSON) ) {
		u.u_error = EINVAL;
		return;
	}

	switch (uap->fno) {
		/* get a process label set. This call should return 
 		 * two labels, the min and the max attainable. C2 
 		 * will only pay attention to the min
 		 */
		case GETMAC:
			if (copyout(&uauth->a_minlabel, uap->label, 
					sizeof(slabel_t) * 2))
				u.u_error = EFAULT;
			return;

		/* set a process label set. This call should expect the
 		 * user buffer to hold two labels, a min and a max. C2
 		 * implementation only deals with min
                  */
		case SETMAC:
			/* make sure are cleared to set label */
			if ( ! auth_label_subj() ) {
				u.u_error = EPERM;
				return;
			}
			if (copyin(uap->label, &uauth->a_minlabel, 
					sizeof(slabel_t) * 2)) 
				u.u_error = EFAULT;
			sat_label();
			return;

		/* get a file label. Files will only contain one label
                 * at a time. For now, restict the user from being able
                 * to check file labels at all!!
 		 */
		case GETFMAC:
			/* make sure we are cleared to set the label */
			if ( ! auth_label_obj() ) {
				u.u_error = EPERM;
				return;
			}
			u.u_dirp = (caddr_t)u.u_arg[2];
			if ((ip = namei(upath, 0)) == NULL)
				return;

			if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
				u.u_error = EINVAL;
				iput(ip);
				return;
			}
			s5ip = (struct s5inode *)ip->i_fsptr;
			if (copyout(&s5ip->s5i_label, uap->label, 
					sizeof(slabel_t)))
				u.u_error = EFAULT;
			iput(ip);
			return;

		/* set a file label. This call is the key to overall
                 * integrity of the system. It MUST BE PROTECTED!!!
 		 */
		case SETFMAC:
			if ( ! auth_label_obj()) {
				u.u_error = EPERM;
				return;
			}
			u.u_dirp = (caddr_t)u.u_arg[2];
			if ((ip = namei(upath, 0)) == NULL)
				return;

			if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
				u.u_error = EINVAL;
				iput(ip);
				return;
			}

			s5ip = (struct s5inode *)ip->i_fsptr;
			bcopy((caddr_t)&s5ip->s5i_label, &tmp, 
				sizeof( slabel_t));
			if (copyin( uap->label, &s5ip->s5i_label, 
				sizeof(slabel_t))) {
				u.u_error = EFAULT;
				iput(ip);
				return;
			}
			sat_filelabel( ip, &tmp, &s5ip->s5i_label );
			ip->i_flag |= (IUPD|ICHG);
			iput(ip);
			return;

		/* any function calls other than expected..eat shit and
 	         * tell the process to die 
 		 */
		default:
			u.u_error = EINVAL;
			break;
	}
#else
	u.u_error = ENOSYS;
#endif
}

/*
 *	mls_exec    check file to see if user has label that allows
 * 		    him to exec file. General rules are as follows:
 *                  if user has PRIV_EXEC_ALL than return true. If 
 *		    PRIV_EXEC_ALL is absent, then then if file isn't 
 *		    marked SYS_TCB return 0.
 *
 */

mls_exec( ip ) 
struct inode *ip;
{
#ifdef SECON
register struct s5inode *s5ip;
register slabel_t *lp;
extern slabel_t exec_labels[];

	/* get the s5ip ptr */
	s5ip = (struct s5inode *)ip->i_fsptr;

	/* for each label in the ok to exec table */
	for ( lp = exec_labels; lp->level; lp++ ) {
		if (mls_equ(&s5ip->s5i_label, lp ))
			return 1; 
	}

	/* sorry but no matches found here */
	return 0;
#else
	return 1;
#endif
}




/*
 *	mls_equ   return TRUE is the subject label is equal to the 
 *		  object label. Equality is defined as equivelent 
 *		  label levels with the subject category list as a 
 *		  proper superset of the object category list
 */

mls_equ( subj, obj )
#ifdef SECON  
register slabel_t *subj, *obj;
#endif
{
#ifdef SECON  
register int i;

	/* only if macs are enabled!! */
	if ( ! (sec_mode & MACSON) ) {
		return 1;
	}
#ifdef B1
	/* JTOF - in a true B1 we must match labesl */
	if ( subj->level != obj->level )
		return 0;
#else
	/* in our hybrid C2, we either match labels or if  
 	 * the object has no label, we declare a match  (kludgy huh??)
         */
	if ( obj->level && (subj->level != obj->level) )
		return 0;
#endif

	/* note:  is a is NULL and b is NULL will also match 
	   This check will be used later when a full B1 implementation
	   is developed
	*/
#ifdef B1
	for ( i = 0; i < MAXCATLST; i++ ) {
		if ( (subj->catlst[i] & obj->catlst[i]) != (obj->catlst[i]) )
			return 0;
	}
#endif
	return 1;
#else
	return 1;
#endif
}


/*
 *	mls_dom test the subject label for dominance over the object
 *		label. Dominance means that the subject label's level
 *		is greater than or eqaul, and the subject category list
 *		contains all the categories in the object.
 */

mls_dom( subj, obj )
#ifdef SECON
register slabel_t *subj, *obj;
#endif
{
#ifdef SECON
register int i;

	/* only if macs are enabled!! */
	if ( ! (sec_mode & MACSON) ) {
		return 1;
	}

/* JTOF - this will work for B1 and C2 cause no subj should execute
 *   	  with NOLABEL....if he does then he will only match objects
 *        with nolabel
 */
	if ( subj->level < obj->level )
		return 0;
#ifdef B1
	for ( i = 0; i < MAXCATLST; i++ ) {
		if ( (subj->catlst[i] & obj->catlst[i]) != (obj->catlst[i]) )
			return 0;
	}
#endif
	return 1;
#else
	return 1;
#endif
}

/*
 *	nolabel - this is a definite C2ism....not to cool for B1
 *
 */
#ifndef B1
nolabel( a )
#ifdef SECON
register slabel_t *a;
#endif
{
#ifdef SECON
register int i;

	/* only if macs are enabled!! */
	if ( ! (sec_mode & MACSON) ) {
		return 1;
	}
	if ( a->level == 0 ) {
		for ( i=0; i < MAXCATLST; i++ ) {
			if ( a->catlst[i] )
				return 0;
		}
		return 1;
	}
	return 0;
#else
	return 0;
#endif
}
#endif
