/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) audit.c: version 25.1 created on 11/27/91 at 15:13:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)audit.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
 /*
 * 	audit    audit system call routine. This routine is the entry
 *		 point for all audit specific requests from the user.
 *		 check the file audit.h for specific functions available
 */

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/tuneable.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/clock.h"
#include "sys/conf.h"
#include "sys/spl.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/param.h"
#include "sys/signal.h"
#include "sys/fs/s5inode.h"
#include "sys/dir.h" 
#include "sys/cmn_err.h" 
#include "sys/acct.h"

#ifdef SECON
#include "sys/mls.h"
#include "sys/priv.h"
#include "sys/security.h"
#include "sys/audit.h" 
#endif

#ifdef SECON
extern aud_state_t aud_info[];
#endif

/*
 *	audit    audit system call: this routine will vector to 
 *		 the proper audit call.
 */
audit() 
{
#ifdef SECON
char buf[512];			
aud_state_t *ap;
register struct a {
	uint	func;			
	uint	val;		
	char	*p;		
	} *uap = (struct a *) u.u_ap;

	/* make sure the audit stuff is enabled */
	if ( ! sec_mode & SATON ) {
		u.u_error = ENXIO;
		return;
	}

	/* make sure the authorization stuff is enabled */
	if ( uap->func != AUDIT_WRITE ) {
		if (!auth_audcntl()) {
			u.u_error = EPERM;
			return;
		}
	}

	ap = &aud_info[0];
	switch( uap->func ) {
		case AUDIT_AUID:
				if (copyout((caddr_t)&uauth->a_auid,
				   (caddr_t) uap->p, sizeof( ushort )))
					u.u_error = EFAULT;
				return;
		case AUDIT_SUMASK:
				if (copyin((caddr_t)uap->p, 
				    (caddr_t)uauth->a_amask, sizeof(uint)*2)) 
					u.u_error = EFAULT;
				return;
		case AUDIT_GUMASK:
				if (copyout((caddr_t)uauth->a_amask, 
				    (caddr_t)uap->p, sizeof(uint)*2))
					u.u_error = EFAULT;
				return;
		case AUDIT_START:	
				audit_start();	
				break;
		case AUDIT_STOP:
				audit_stop();
				break;
		case AUDIT_MASK:
				audit_mask( uap->p );
				break;
		case AUDIT_STAT:
				if ( copyout((caddr_t)ap, (caddr_t)uap->p, 
					sizeof( aud_state_t )))
					u.u_error = EFAULT;
				break;
		case AUDIT_EVTSTAT:
				if ( copyout((caddr_t)&(ap->evts[uap->val]),
				     	uap->p, sizeof( evt_state_t )))
					u.u_error = EFAULT;
				break;
		case AUDIT_WRITE:
				if ( ! auth_audit() ) {
					u.u_error = EPERM;
					return;
				}
				if ( copyin((caddr_t)uap->p,(caddr_t) buf, 
					uap->val )) {
					u.u_error = EFAULT;	
					break;
				}
				if ( evt_active( buf[0] ))
					satsave( buf[0], &buf[1], 
					uap->val - 1 );
				break;
		case AUDIT_GET:
				audit_getcf( uap->val, uap->p );
				break;
		case AUDIT_SET:
				audit_setcf( uap->val, uap->p );
				break;
		default:
			u.u_error = EINVAL;
			return;
	}
#else
	u.u_error = ENOSYS;
	return;
#endif
}

/*
 *	audit_getcf   return the audit configuration paramenters to 
 *	              the user.
 */
audit_getcf( val, p )
int val;
char *p;
{
#ifdef SECON
aud_state_t *ap;
uint tmp, size;

	ap = &aud_info[0];
	switch( val ) {
		case AUDCONF_HWM:
			tmp = ap->hwm;
			break;
		case AUDCONF_HZ:
			tmp = ap->callout;
			break;
		case AUDCONF_MASK:
			if (copyout((caddr_t)ap->mask, (caddr_t)p, 
				sizeof(uint) * 2))
				u.u_error = EFAULT;
			return;
		case AUDCONF_VERS:
			tmp = ap->version;
			break;
		default:
			u.u_error = EINVAL;
	}
	if (copyout((caddr_t)&tmp,(caddr_t)p, sizeof(uint)))
			u.u_error = EFAULT;
#endif
}
			
/*
 *	audit_setcf  set the configuration parameters. SETMASK is
 *	             provided as an alternate form of the direct
 *		     system call, and functions identically
 */	
audit_setcf( val, p )
int val;
char *p;
{
#ifdef SECON    
aud_state_t *ap;
uint size, tmp;

	ap = &aud_info[0];
	switch( val ) {
		case AUDCONF_HWM:
			if (copyin((caddr_t)p,(caddr_t)&tmp, sizeof(uint))){
				u.u_error = EFAULT;
				return;
			}
			spin_lock(&ap->lock);
			ap->hwm = tmp;
			if ( ap->bcnt < ap->hwm )
				wakeup((caddr_t)ap );	
			spin_unlock(&ap->lock);
			break;
		case AUDCONF_HZ:
			if (copyin((caddr_t)p,(caddr_t)&tmp, sizeof(uint))){
				u.u_error = EFAULT;
				return;
			}
			spin_lock( &ap->lock);
			ap->callout = tmp;
			spin_unlock( &ap->lock);
			break;
		case AUDCONF_MASK:
			audit_mask( p );
			break;
		default:
			u.u_error = EINVAL;
	}
#endif
}

/*
 *	audit_start   start the audit trail recording.  When the sec_mode
 *		      audit bit is on, the audit trail has been set up but
 *		      this doesn't imply that it's collecting data. When the
 *	              start call is made, the audit routines are actually 
 *		      capturing data according to the rules bases on the
 *		      auditmask and the user mask.
 *
 */
audit_start()
{
#ifdef SECON
aud_state_t *ap;
sat_audit_t buf;


	/* there is only one audit trail supported for now, so
	 * this is hard coated
	 */
	ap = &aud_info[0];

	/* make the audit start record */
	buf.mode = AUDSTART;
	buf.mask[0] = ap->mask[0];
	buf.mask[1] = ap->mask[1];
	buf.version = ap->version;

	/* don't write the enabled bit until we've deposited our
	 * start record. This guarentees that the first record in 
	 * a given audit session is the start record 
 	 */
	satsave( AUD_AUDIT, &buf, sizeof( sat_audit_t ) );
	sat_sync_clk( time );

	spin_lock( &ap->lock );
	ap->start_time = time;   
	ap->state |= SAT_ENABLE;
	syncevtstates();
	spin_unlock( &ap->lock );
#endif       
}
	
/*
 *	audit_stop  disable the audit trail recording mechansim. 
 *		    Any events already in transit will be witten to 
 *                  the audit trail properly
 */	
audit_stop()
{
#ifdef SECON
aud_state_t *ap;
sat_audit_t buf;

	/* there is only one audit trail supported for now, so
	 * this is hard coated
	 */
	ap = &aud_info[0];
	buf.mode = AUDSTOP; 
	buf.version  = ap->version;
	satsave( AUD_AUDIT, &buf, sizeof( sat_audit_t ) );
	spin_lock( &ap->lock);

	ap->state &= ~SAT_ENABLE;
	ap->end_time = time;   
	spin_unlock( &ap->lock);
#endif
}	

/*
 *	audit_mask  change the audit mask in use. This can be done
 *		    anytime, including before the audit trail is 
 *		    started because the start event will record the
 *		    current mask. 
 */
audit_mask( p )
char *p;
{
#ifdef SECON
uint mask[2];
aud_state_t *ap;
sat_audit_t buf;

	/* get the argument passed down to us */
	if ( copyin((caddr_t)p, (caddr_t)mask, sizeof( uint ) * 2)) {
		u.u_error = EFAULT;
		return;
	}

	ap = &aud_info[0];
	buf.mode = AUDMASK;
	buf.mask[0] = mask[0];
	buf.mask[1] = mask[1];
	buf.version = ap->version;
	satsave( AUD_AUDIT, &buf, sizeof( sat_audit_t ));

	spin_lock( &ap->lock);
	ap->mask[0] = mask[0];
	ap->mask[1] = mask[1];
	syncevtstates();
	spin_unlock( &ap->lock);
#endif
}

/*
 *	sat_fork   record security relevant information about the fork
 *		   of a process. Little needs to be recorded at
 *		   this point because we will know the privileges that 
 *		   the parent had...the child is the same.
 */
sat_fork()
{
#ifdef SECON
sat_fork_t r;

	if (! evt_active( AUD_FORK ))
		return;
	r.ppid = u.u_procp->p_ppid;
	bcopy( (caddr_t)&uauth->a_priv, (caddr_t)&r.priv, sizeof( priv_t )); 
	satsave( AUD_FORK, &r, sizeof( sat_fork_t) );
#endif
}

/*
 *	sat_exec   record security relevant information about the exec
 *	           or a process. An entire snapshot of the user identification
 *		   parameters is taken at this point.
 *
 */
sat_exec( name )
char *name;
{
#ifdef SECON
sat_exec_t r;

	if (! evt_active( AUD_EXEC ))
		return;
	r.auid = uauth->a_auid;
	r.ruid = u.u_ruid;
	r.rgid = u.u_rgid;
	r.euid = u.u_uid;
	r.egid = u.u_gid;
	r.sessid = u.u_procp->p_session_id;
	r.pgrp = u.u_procp->p_pgrp;
	r.ctty = u.u_ttyp ? u.u_ttyd : NODEV;
	r.dev = u.u_exdata.ip->i_dev;
	r.ino = u.u_exdata.ip->i_number;
	r.role = uauth->a_role;
	bcopy((caddr_t)&uauth->a_priv, (caddr_t)&r.priv, sizeof( priv_t ));
	bcopy((caddr_t)&uauth->a_minlabel, 
		(caddr_t)&r.minlabel, sizeof(slabel_t) * 2);
	bcopy((caddr_t)uauth->a_groups, (caddr_t)r.groups, 
		sizeof(ushort) * NGROUPS_MAX);
	bcopy((caddr_t)name,(caddr_t)r.name, DIRSIZ );
	satsave( AUD_EXEC, &r, sizeof( sat_exec_t ));	
#endif
}


/*
 *	sat_exit  record the necessary information on a process exit 
 */
sat_exit(stat)
uint stat;
{
#ifdef SECON
sat_exit_t r;

	if ( !evt_active(AUD_EXIT))
		return;
	r.status = stat;		/* what was his exit status */
	r.flag = u.u_acflag;		/* did he ever invoke privileges */
	r.pused = uauth->a_pused;	/* record privs used by proc */
	satsave( AUD_EXIT, &r, sizeof( sat_exit_t));
#endif
}


/*
 *	sat_setuid  record the setuid call. This doesn't includes privileges 
 */
sat_setuid()
{
#ifdef SECON
sat_setuid_t r;

	if ( !evt_active(AUD_SETUID))
		return;	
	r.auid = uauth->a_auid;
	r.ruid = u.u_ruid;
	r.euid = u.u_uid;
	r.role = uauth->a_role;

	/* we need priv's cause we wan't to know what the effect 
 	 * of the system wide mask is 
         */
	bcopy((caddr_t)&uauth->a_priv, (caddr_t)&r.priv, sizeof(priv_t));
	satsave( AUD_SETUID, &r, sizeof( sat_setuid_t));
#endif
}

/*
 *	sat_setgid  set the group id of the process 
 */
sat_setgid()
{
#ifdef SECON
sat_setgid_t r;

	if ( !evt_active(AUD_SETGID))
		return;
	r.rgid = u.u_rgid;
	r.egid = u.u_gid;
	satsave( AUD_SETGID, &r, sizeof( sat_setgid_t ));
#endif
}


/*
 *	sat_setsid   record changes to the session id  
 */
sat_setsid( p )
register struct proc *p;
{
#ifdef SECON
sat_setsid_t r;

	if ( !evt_active(AUD_SETSID))
		return;
	r.mode = 1;
	r.old_sessid = p->p_session_id;
	r.old_pgrp = p->p_pgrp;
	r.old_ctty = u.u_ttyp ? u.u_ttyd : NODEV;
	r.new_ctty = 0;
	satsave(AUD_SETSID, &r, sizeof(sat_setsid_t));
#endif
}

/*
 *	sat_setpgrp  record the same structure as setsid. This
 *		     guy is a little different cause there are 
 *		     cases where the controlling tty changes  
 */
sat_setpgrp( p, dev )
register struct proc *p;
register dev_t dev;
{
#ifdef SECON 
sat_setsid_t r;

	if ( !evt_active(AUD_SETSID))
		return;
	
	r.old_sessid = p->p_session_id;
	r.old_pgrp = p->p_pgrp;
	r.old_ctty = dev;
	r.new_ctty = u.u_ttyp ? u.u_ttyd : NODEV;
	satsave(AUD_SETSID, &r, sizeof( sat_setsid_t )); 
#endif
}

/*
 *	sat_setsupp record attempts to change a process supplementary
 *	            groups. 
 */
sat_setsupp()
{
#ifdef SECON
sat_setsupp_t buf;

	if ( ! evt_active( AUD_SUPPL ) ) 
		return;
	bcopy((caddr_t)uauth->a_groups, (caddr_t)buf.groups, 
		sizeof( ushort ) * NGROUPS_MAX );
	satsave( AUD_SUPPL, &buf, sizeof( sat_setsupp_t ));
#endif
}

/*
 *	sat_setrole   record any attempt to alter the role of the
 *		      process. We record the privileges after the
 *		      role is set because the result may be quite
 *		      different that that for the role when the 
 *		      system and user masks are applied
 */
sat_setrole()
{
#ifdef SECON
sat_setrole_t buf;

	if (! evt_active( AUD_ROLE ))
		return;
	buf.new_role = uauth->a_role;
	bcopy((caddr_t)&uauth->a_priv, (caddr_t)&buf.priv, sizeof( priv_t ));
	satsave( AUD_ROLE, &buf, sizeof( sat_setrole_t ));
#endif
}

/*
 *	sat_priv   record any changes in a process privilege. This guy
 *		   take a snapshot of the privileges after changes so
 *		   we can track his operating level 
 */
sat_priv()
{
#ifdef SECON
sat_priv_t buf;
	
	if (! evt_active( AUD_PRIV ))
		return;
	bcopy((caddr_t)&(uauth->a_priv), (caddr_t)&buf.priv, sizeof( priv_t ));	
	satsave( AUD_PRIV, &buf, sizeof( sat_priv_t ));
#endif
}


/*
 *	sat_label   record an changes made to the labels of a process. 
 */
sat_label()
{
#ifdef SECON
sat_label_t buf;

	if (! evt_active( AUD_LABEL ))
		return;
	bcopy((caddr_t)&uauth->a_minlabel, (caddr_t)&buf.minlabel, 
		sizeof( slabel_t) * 2 );
	satsave( AUD_LABEL, &buf, sizeof( sat_label_t ));
#endif
}

/*
 *	sat_chroot  record any attempts to modify a process's notion
 *	            of a root directory
 */
sat_chroot( ip )
struct inode *ip;
{
#ifdef SECON
sat_chroot_t buf;

	if (! evt_active( AUD_CHROOT))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	satsave( AUD_CHROOT, &buf, sizeof( sat_chroot_t ));
#endif
}

/*
 *	sat_ctty  keep track of a process controlling tty. We need to 
 *	          keep track 
 */
sat_ctty()
{
#ifdef SECON
sat_ctty_t buf;

	if (! evt_active( AUD_CTTY))
		return;
	buf.sessid = u.u_procp->p_session_id;
	buf.ctty = u.u_ttyp ? u.u_ttyd : NODEV;
	satsave( AUD_CTTY, &buf, sizeof( sat_ctty_t ));
#endif
}

/*
 *	sat_kill record any signals send between processes
 */
sat_kill( pid, signo )
ushort pid;
uint signo;
{
#ifdef SECON
sat_kill_t buf;
	
	if (! evt_active( AUD_KILL))
		return;
	buf.from_pid = pid;
	buf.signal = signo;
	satsave( AUD_KILL, &buf, sizeof( sat_kill_t ) );
#endif
}

/*
 *	sat_accs     handle all sucessfull file access events
 */
sat_accs( ip, type, mode )
register struct inode *ip;
int type, mode;
{
#ifdef SECON
sat_access_t buf;
register sat_access_t *ap = &buf;

	if ( type & (IEXEC|IOBJEXEC|ICDEXEC) || ( mode == IWRITE &&
			( ip->i_mode & IFMT ) == IFDIR ))
			return ;
	ap->mode = mode;
	ap->dev = ip->i_dev;
	ap->ino = ip->i_number;
	ap->type = type;

	if ( type & IWRITE ) {
		if (! evt_active(AUD_ACCSW))
			return;
		satsave( AUD_ACCSW, ap, sizeof( sat_access_t ));
	}
	else {
		if ( ! evt_active(AUD_ACCSR))
			return;
		satsave( AUD_ACCSR, ap, sizeof( sat_access_t ));
	}
#endif
}

/*
 *	sat_accf     handle all sucessfull file access events
 */
sat_accf( ip, type, mode )
register struct inode *ip;
int type, mode;
{
#ifdef SECON
sat_access_t buf;
register sat_access_t *ap = &buf;

	ap->dev = ip->i_dev;
	ap->ino = ip->i_number;
	ap->type = type;
	ap->mode = mode;
	if ( type & IWRITE ) {
		if (! evt_active(AUD_ACCFW))
			return;
		satsave( AUD_ACCFW, ap, sizeof( sat_access_t ));
	} 
	else {
		if (! evt_active(AUD_ACCFR) )
			return;
		satsave( AUD_ACCFR, ap, sizeof( sat_access_t));
	}
#endif
}

/*
 *	sat_mknod 
 */
sat_mknd( ip, mode )
register struct inode *ip;
uint mode;
{
#ifdef SECON
sat_mknod_t buf;
register struct s5inode *s5ip;
register struct direct *dir;

	if (! evt_active(AUD_MKNOD))
		return;

	dir = (struct direct *)(u.u_base - sizeof(struct direct));
	if(strcmp(dir->d_name,"."))
	   if(strcmp(dir->d_name,"..")) {
		buf.mode = mode;
		buf.dev = ip->i_dev;
		buf.dino = ip->i_number;
		buf.ino = dir->d_ino;
		bcopy((caddr_t)dir->d_name,(caddr_t)buf.name,DIRSIZ );
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof( slabel_t)); 
		satsave( AUD_MKNOD, &buf, sizeof( sat_mknod_t ));
	}
#endif
}

/*
 *	sat_pipe   record the usage of a pipe device 
 */
sat_pipe( ip )
register struct inode *ip;
{
#ifdef SECON
sat_pipe_t buf;

	if (! evt_active(AUD_PIPE))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	satsave( AUD_PIPE, &buf, sizeof( sat_pipe_t ));
#endif
}

/*
 *
 */
sat_create( ip, mode )
register struct inode *ip;
uint mode;
{
#ifdef SECON
sat_create_t buf;
register struct s5inode *s5ip;
register struct direct *dir;

	if (! evt_active(AUD_CREAT))
		return;

	dir = (struct direct *)(u.u_base - sizeof(struct direct));
	if(strcmp(dir->d_name,"."))
	   if(strcmp(dir->d_name,"..")) {
		buf.mode = mode;
		buf.dev = ip->i_dev;
		buf.dino = ip->i_number;
		buf.ino = dir->d_ino;
		bcopy((caddr_t)dir->d_name,(caddr_t)buf.name,DIRSIZ );
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof( slabel_t)); 
		satsave( AUD_CREAT, &buf, sizeof( sat_create_t ));
	}
#endif
}

/*
 *	sat_link   record an new names given to a file. 
 */
sat_link( ip )
register struct inode *ip;
{
#ifdef SECON
sat_link_t buf;
register struct s5inode *s5ip;
register struct direct *dir;

	if (! evt_active(AUD_LINK))
		return;

	dir = (struct direct *)(u.u_base - sizeof(struct direct));
	if(strcmp(dir->d_name,"."))
	   if(strcmp(dir->d_name,"..")) {
		buf.dev = ip->i_dev;
		buf.dino = ip->i_number;
		buf.ino = dir->d_ino;
		bcopy((caddr_t)dir->d_name,(caddr_t)buf.name,DIRSIZ );
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof( slabel_t)); 
		satsave( AUD_LINK, &buf, sizeof( sat_link_t ));
	}
#endif
}

/*
 *	sat_slink
 */
sat_slink( ip, link, dir_ino, target, path_length )
register struct inode  *ip;
char                   *link;
long                   dir_ino;
char                   *target;
uint                   path_length;
{
#ifdef SECON
	sat_slink_t buf;
	register struct s5inode *s5ip;

	if (! evt_active(AUD_SLINK))
		return;

	if ( strcmp(link, ".") && strcmp(link, "..") )
	{
		buf.dev = ip->i_dev;
		buf.ino = ip->i_number;
		buf.dino = dir_ino;
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof(slabel_t));
		bcopy(link, buf.name, DIRSIZ);
		buf.path_length = path_length;
		bcopy(target, buf.target, path_length);
		satsave(AUD_SLINK, &buf,
		  (uint)&buf.target - (uint)&buf + path_length);
	}
#endif
}

/*
 *
 */
sat_rename()
{
#ifdef SECON
sat_rename_t buf;
	
	if (! evt_active(AUD_RENAME))
		return;
	satsave( AUD_RENAME, &buf, sizeof( sat_rename_t));
#endif
}

/*
 *
 */
sat_unlink( ip, dip )
register struct inode *ip; 
register struct inode *dip; 
{
#ifdef SECON
sat_unlink_t buf;
register struct direct *dir;
register struct s5inode *s5ip;

	if (! evt_active(AUD_UNLINK))
		return;
	dir = (struct direct *)(u.u_base - sizeof(struct direct));
	if(strcmp(dir->d_name,"."))
	   if(strcmp(dir->d_name,"..")) {
		buf.dev = ip->i_dev;
		buf.ino = dip->i_number;
		buf.dino = ip->i_number;
		bcopy((caddr_t)dir->d_name,(caddr_t)buf.name,DIRSIZ );
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof( slabel_t)); 
		satsave( AUD_UNLINK, &buf, sizeof( sat_link_t ));
	}
#endif 
}

/*
 *	sat_rmdir   record any attempts to remove a directory 
 */
sat_rmdir( ip, dip )
register struct inode *ip;
register struct inode *dip;
{
#ifdef SECON
sat_unlink_t buf;
register struct direct *dir;
register struct s5inode *s5ip;

	if (! evt_active(AUD_UNLINK))
		return;
	dir = (struct direct *)(u.u_base - sizeof(struct direct));
	if(strcmp(dir->d_name,"."))
	   if(strcmp(dir->d_name,"..")) {
		buf.dev = ip->i_dev;
		buf.ino = dip->i_number;
		buf.dino = ip->i_number;
		bcopy((caddr_t)dir->d_name,(caddr_t)buf.name,DIRSIZ );
		s5ip = (struct s5inode *)ip->i_fsptr;
		bcopy((caddr_t)&s5ip->s5i_label, &buf.label, sizeof( slabel_t)); 
		satsave( AUD_UNLINK, &buf, sizeof( sat_link_t ));
	}
#endif 
}

/*
 *	sat_chmod   record any changes to the modes of a file 
 */
sat_chmod(ip,old_mode, new_mode)
register struct inode *ip;
uint old_mode, new_mode;
{
#ifdef SECON
sat_chmod_t buf;

	if (! evt_active(AUD_CHMOD))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	buf.old_mode = old_mode;
	buf.new_mode = new_mode;
	satsave(AUD_CHMOD, &buf, sizeof( sat_chmod_t ));
#endif
}

/*
 *	sat_chown   record any changes to the owner of a file
 */
sat_chown(ip, old_uid, new_uid )
register struct inode *ip;
uint old_uid, new_uid;
{
#ifdef SECON
sat_chown_t buf;

	if (! evt_active(AUD_CHOWN))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	buf.old_uid = old_uid;
	buf.new_uid = new_uid;
	satsave(AUD_CHOWN, &buf, sizeof( sat_chown_t ));
#endif
}

/*
 *	sat_chgrp   record any changes to the gid of a file
 */
sat_chgrp( ip, old_gid, new_gid )
register struct inode *ip;
uint old_gid, new_gid;
{
#ifdef SECON
sat_chgrp_t buf;

	if (! evt_active(AUD_CHGRP))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	buf.old_gid = old_gid;
	buf.new_gid = new_gid;
	satsave(AUD_CHGRP, &buf, sizeof( sat_chgrp_t ));
#endif
}

/*
 *	sat_filepriv   changes the privileges of a file
 */
sat_filepriv( ip, new_priv, old_priv )
register struct inode *ip;
uint new_priv, old_priv;
{
#ifdef SECON
sat_filepriv_t buf;

	if (! evt_active(AUD_FILEPRIV))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	buf.old_priv = old_priv;
	buf.new_priv = new_priv;
	satsave(AUD_FILEPRIV, &buf, sizeof( sat_filepriv_t ));
#endif
}

/*
 *	sat_filelabel 
 */
sat_filelabel( ip, old_label, new_label )
register struct inode *ip;
#ifdef SECON
slabel_t *old_label, *new_label;
#endif
{
#ifdef SECON
sat_filelabel_t buf;

	if (! evt_active(AUD_FILELABEL))
		return;
	buf.dev = ip->i_dev;
	buf.ino = ip->i_number;
	bcopy((caddr_t)old_label, (caddr_t)&buf.old_label, sizeof( slabel_t));
	bcopy((caddr_t)new_label, (caddr_t)&buf.new_label, sizeof( slabel_t));
	satsave(AUD_FILELABEL, &buf, sizeof( sat_filelabel_t ));
#endif
}

/*
 *
 */
sat_acl()
{
}

/*
 *	sat_mount   record any attempts to mount filesystems. This is 
 *		    an extremely security sensitive event because of
 *		    macs and acls. 
 */
sat_mount( mp, bip )
register struct mount *mp;
register struct inode *bip;
{
#ifdef SECON
sat_mount_t buf;

	/* check if the mount is active */	
	if ( ! evt_active( AUD_MOUNT ))
		return;
	buf.mtptdev = (ushort)mp->m_inodp->i_dev;
	buf.mtptino = (ushort)mp->m_inodp->i_number;
	buf.fsdev = (ushort)mp->m_dev;
	buf.fsrootdev = (ushort)bip->i_dev;
	buf.fsrootino = (ushort)bip->i_number;
	satsave( AUD_MOUNT, &buf, sizeof( sat_mount_t ));
#endif
}

/*
 *
 */
sat_umount( mp )
register struct mount *mp;
{
#ifdef SECON
sat_umount_t buf;

	if ( ! evt_active( AUD_UMOUNT ))
		return;
	buf.mptdev = (ushort)mp->m_inodp->i_dev;
	buf.mptptino = (ushort)mp->m_inodp->i_number;
	buf.fsdev = (ushort)mp->m_dev;
	satsave( AUD_UMOUNT, &buf, sizeof( sat_umount_t ));
#endif
}

/*
 *	sat_syserr   record errors encounterd on system calls. This
 *		     event records all error, including permission 
 *		     errors on calls. 
 */
sat_syserr()
{
#ifdef SECON
sat_syserr_t buf;

	if ( !evt_active( AUD_SYSERR ))
		return;
	buf.sysno = u.u_syscall;
	buf.errno = u.u_error;
	satsave( AUD_SYSERR, &buf, sizeof( sat_syserr_t));
#endif
}

/*
 *
 */
sat_ipccreat()
{
}

/*
 *
 */
sat_ipcaccess()
{
}

/*
 *
 */
sat_ipcrm()
{
}

/*
 * 
 */
sat_ipclabel()
{
}

/*
 *
 */
sat_ipcchown()
{
}

/*
 *
 */
sat_ipcchgrp()
{
}

/*
 *
 */
sat_ipcmode()
{
}

/*
 *
 */
sat_login()
{
}

/*
 *
 */
sat_audit()
{
}

/*
 *
 */
sat_pwd()
{
}

/*
 *
 */
sat_lock()
{
}

/*
 *
 */
sat_ipcdac()
{
}


/*
 *	sat_clk   audit any user attempts to change the system time.
 *		  This is critical to assure the timestamps on audit
 *		  records are traceable
 */
sat_clk( time )
register time_t time;
{
#ifdef SECON
sat_clock_t buf;

	if ( ! evt_active( AUD_CLOCK ) )
		return;

	/* record the new time being set */
	buf.time = time;
	satsave( AUD_CLOCK, &buf, sizeof( sat_clock_t ));
#endif
}

/*
 *	sat_sync clk   write a record with the start
 */
sat_sync_clk( time )
time_t time;
{
#ifdef SECON
sat_clock_t buf;

	buf.time = time;
	satsave(AUD_CLOCK, &buf, sizeof( sat_clock_t));
#endif
}


