/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) utssys.c: version 25.1 created on 11/27/91 at 15:13:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)utssys.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/immu.h"
#include "sys/uadmin.h"
#include "sys/mount.h"
#include "sys/errno.h"
#include "sys/user.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/ustat.h"
#include "sys/statfs.h"
#include "sys/file.h"
#include "sys/var.h"
#include "sys/utsname.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/systm.h"
#include "sys/sysmacros.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/ints.h"

utssys()
{
	register struct mount *mp;
	register struct inode *ip;
	register struct a {
		char	*cbuf;
		int	mv;
		int	type;
	} *uap;
	register i;
	struct ustat ust;
	struct statfs stfs;
	register dev_t	dev;

	uap = (struct a *)u.u_ap;
	switch (uap->type) {
	case 0:		/* uname */
		if (copyout(&utsname, uap->cbuf, sizeof(struct utsname)))
			u.u_error = EFAULT;
		return;

	/* case 1 was umask */

	case 2:		/* ustat */
		if (uap->mv < 0) {
			duustat();
			return;
		}
		dev = (dev_t)uap->mv;
		for (i = 0; i < v.v_mount; i++) {
			mp = &mount[i];
			if ((mp->m_flags & MINUSE) && mp->m_dev == dev) {
				ASSERT(mp->m_mount != NULL);
				ip = iget(mp, mp->m_mount->i_number);
				if (ip == NULL) {
					u.u_error = ENOENT;
					return;
				}
				if (! fstypsw[mp->m_fstyp].statfs_flag)
					upkern_lock();
				(*fstypsw[mp->m_fstyp].fs_statfs)(ip, 
				  (char *)&stfs, 0);
				if (u.u_error) {
					iput(ip);
					return;
				}
				ust.f_tfree = (daddr_t)stfs.f_bfree;
				ust.f_tinode = (ino_t)stfs.f_ffree;
				bcopy(stfs.f_fpack, ust.f_fpack, 
				  sizeof(ust.f_fpack));
				bcopy(stfs.f_fname, ust.f_fname, 
				  sizeof(ust.f_fname));

				if (copyout(&ust, uap->cbuf, sizeof(ust)))
					u.u_error = EFAULT;
				iput(ip);
				return;
			}
		}
		u.u_error = EINVAL;
		return;

	default:
		u.u_error = EFAULT;
	}
}

/*
 * clean_shutdown -- shut down the system cleanly
 */

#define UADMIN_WAIT	30	/* try to delay at most this many seconds */
#define FIRST_PROC	5	/* first non-system process table slot	*/

static void
clean_shutdown()
{
	register proc_t	*p;
	register int	more;
	register time_t	start;
	struct file	*fp, *getf();

	/*
	 * first, set all the processes to ignore SIGCLD (fast exit)
	 */
	for (p = &proc[0]; p < (struct proc *)v.ve_proc; p++) {
		if (p->p_stat == NULL)
			continue;
		p->p_userp->u_signal[SIGCLD - 1] = SIG_IGN;
	}
	/*
	 * now, kill off all but init, killing traced processes too
	 */
	for (p = &proc[FIRST_PROC]; p < (struct proc *)v.ve_proc; p++) {
		if (p->p_stat == NULL)
			continue;
		if (p->p_flag & STRC)
			atom_or(&p->p_flag, SPTRX);
		psignal(p, SIGKILL);
	}
	update();
	/*
	 * wait up to UADMIN_WAIT seconds to allow procs to exit, and buffer
	 * caches to flush, etc, starting now
	 */
	start = time;

	/*
	 * close this process's files
	 */
	close_ofiles(1);

	/*
	 * wait for other procs to exit
	 */
	do {
		delay(HZ / 2);
		more = 0;
		for (p = &proc[FIRST_PROC]; p < (struct proc *)v.ve_proc; p++) {
			if (p->p_stat == NULL || p == u.u_procp)
				continue;
			more = 1;
			if (!(p->p_flag & SLOAD) || p->p_stat == SXBRK) {
				setrun(proc);	/* run swapper */
				break;
			}
		}
	} while (more && time - start < UADMIN_WAIT);

	psignal(&proc[1], SIGKILL);	/* then kill init	*/
	delay(HZ / 2);			/* allow init to exit	*/
	xumount(&mount[0]);
	update();
	if ((more = UADMIN_WAIT - (time - start)) > 0)
		bdwait_timeout(more * HZ);
	if ((more = UADMIN_WAIT - (time - start)) > 0)
		s54kbdwait_timeout(more * HZ);
	srumountfun();
}

/*
 * administrivia system call
 */

uadmin()
{
	register struct a {
		int	cmd;
		int	fcn;
		int	mdep;
	} *uap;
	uint		n;
	register int	(*pwr_ptr)();
	extern int	(*pwr_clr[])();
	static uint	ualock;

	if (!suser())
		return;
	if (ualock) {
		u.u_error = EBUSY;
		return;
	}
	ualock = 1;
	uap = (struct a *)u.u_ap;

	switch (uap->cmd) {
	case A_SHUTDOWN:
	case A_REBOOT:
		/*
		 * check fcn and mdep before doing anything drastic
		 */
		switch (uap->fcn) {
		case AD_BOOT:
			uap->mdep = MD_REBOOT;	/* AD_BOOT implies MD_REBOOT */
			break;
		case AD_HALT:
			uap->mdep = MD_POWEROFF;/* AD_HALT means MD_POWEROFF */
			break;
		case AD_IBOOT:
			break;			/* ok */
		default:
			u.u_error = EINVAL;
			ualock = 0;
			return;
		}
		switch (uap->mdep) {
		case MD_RESET:
		case MD_REBOOT:
		case MD_PROM:
		case MD_POWEROFF:
			break;			/* ok */
		default:
			u.u_error = EINVAL;
			ualock = 0;
			return;
		}
	case A_REMOUNT:
		break;
	default:
		u.u_error = EINVAL;
		ualock = 0;
		return;
	}

	switch (uap->cmd) {
	case A_SHUTDOWN:
		clean_shutdown();
		uap->mdep |= MD_CLEAN;		/* clean shutdown	*/
		/* fall through! */
	case A_REBOOT:
		for (n = 0; pwr_ptr = pwr_clr[n]; n++)
			(*pwr_ptr)();		/* do power fail routines */

		if (kern2spm_cmd(K2S_UADMIN, uap->fcn, uap->mdep))
			break;
		stop_all_processors();		/* system eats electric death */
		break;
	case A_REMOUNT:
		iflush(&mount[0]);
		/* remount root file system */
		srmountfun(0);
		break;

	default:
		u.u_error = EINVAL;
	}
	ualock = 0;
}
