/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) text.c: version 25.1 created on 11/27/91 at 15:13:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)text.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:text.c	23.1"

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/sysinfo.h"
#include "sys/pfdat.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/conf.h"
#include "sys/mfs.h"


/*	Allocate text region for a process
 */
struct inode *
xalloc(exec_data, tpregtyp)
register struct exdata *exec_data;
{
	register struct inode   *ip = exec_data->ip;
	register reg_t		*rp;
	register preg_t		*prp;
	register int		size = exec_data->ux_tsize;
	register caddr_t	org = (caddr_t)(exec_data->ux_toffset);
	register int		base = exec_data->ux_txtorg;
	register int		regva = base & ~SOFFMASK;
	extern short dufstyp;

	if (size == 0)
		return(ip);
	/* kind a KLUDGY but reduces number of DU hooks
	 * if the ip if remote overwrite magic number to 410
	 */
	if (ip->i_fstyp == dufstyp) 
		exec_data->ux_mag = 0410;

	/*	Search the region table for the text we are
	 *	looking for.
	 */

loop:
	rlstlock();

	for (rp = ractive.r_forw ; rp != &ractive ; rp = rp->r_forw) {
		if (rp->r_type == RT_STEXT  &&
		   rp->r_iptr == ip  &&
		   (rp->r_flags & RG_NOSHARE) == 0) {
			rlstunlock();
			reglock(rp);
			if (rp->r_type != RT_STEXT || rp->r_iptr != ip) {
				regrele(rp);
				goto loop;
			}
			/*	Artificially bump the reference count
			 *	to make sure the region doesn't go away
			 *	while we are waiting.
			 *	Since we have the inode locked, we should
			 *	never get into xalloc with RG_DONE not set.
			 */
			if ((rp->r_flags & RG_DONE) == 0) {
				rp->r_refcnt++;
				rp->r_waitcnt++;
				regrele(rp);
				regwait(rp);
				reglock(rp);
				rp->r_refcnt--;
			}
			prp = attachreg(rp, &u, regva, tpregtyp, SEG_RO);
			regrele(rp);
			if (prp == NULL) {
				iput(ip);
				return(NULL);
			}
			return(ip);
		}
	}
	rlstunlock();
	
	/*	Text not currently being executed.  Must allocate
	 *	a new region for it.
	 *	Inode is locked by getxfile;  it expects us to
	 *	do an iput on every failure.  Since allocreg bumps
	 *	ip->i_count, we must decrement here.  Don't set
	 *	RG_NOFREE until the end also.
	 */

	if ((rp = allocreg(ip, RT_STEXT)) == NULL) {
		iput(ip);
		return(NULL);
	}

	ASSERT ((rp->r_flags & RG_DONE) == 0);

	/*	Attach the region to our process.
	 */
	
	if ((prp = attachreg(rp, &u, regva, tpregtyp, SEG_RW)) == NULL) {
		ip->i_count--;
		freereg(rp);
		return(NULL);
	}
	
	/*	Load the region or map it for demand load.
	 */

	switch (exec_data->ux_mag) {
	case 0413:
	case 0443:
		if (mapreg(prp, base, ip, org, size) < 0) {
			ip->i_count--;
			detachreg(prp, &u);
			return(NULL);
		}
		break;


		/* fall thru case if REMOTE */
	case 0410:
		if (loadreg(prp, base, ip, org, size) < 0) {
			ip->i_count--;
			detachreg(prp, &u);
			return(NULL);
		}
		break;
	default:
		cmn_err(CE_PANIC, "xalloc - bad magic");
	}

	if (!FS_ACCESS(ip, ISVTX))
		rp->r_flags |= RG_NOFREE;

	ASSERT(prp->p_reg->r_listsz != 0);
	chgprot(prp, SEG_TEXT);
	regrele(rp);
	return(ip);
}


/*	Free the swap image of all unused shared text regions
 *	which are from device dev (used by umount system call).
 */

xumount(mp)
register struct mount *mp;
{
	register reg_t		*rp;
	register reg_t		*nrp;
	register inode_t	*ip;
	register int		count;

	count = 0;
loop:
	rlstlock();

	for (rp = ractive.r_forw ; rp != &ractive ; rp = nrp) {
		if (rp->r_type != RT_STEXT)
			nrp = rp->r_forw;
		else {
			rlstunlock();
			/*
			 * There is a race here.  At this point the region
			 * is not locked, and while we sleep waiting for
			 * the inode lock, the region may be freed and the
			 * inode count may drop to zero; when we finally
			 * get the inode we panic on the assertion in plock()
			 * which says that the count must not be zero.
			 *
			 * The correct fix is to lock the region before locking
			 * the inode, but to avoid deadlocks it has to be done
			 * in the same order throughout the system.  Next
			 * release, guys.  Workaround for the moment: put the
			 * code for plock() and prele() inline here, without
			 * the i_count assertions.  (I don't like it, either.)
			 */
			if (ip = rp->r_iptr) {
				/* Temporary: plock(ip) */
				spin_lock(&inode_sem);
				while (inode_locked(ip)) {
					inode_want(ip);
					mfs_sleep((caddr_t)ip, PINOD,
						   &inode_sem);
				}
				inode_lock(ip);
				spin_unlock(&inode_sem);
			}
			reglock(rp);
			if (rp->r_type != RT_STEXT) {
				regrele(rp);
				if (ip) {
					ASSERT(inode_locked(ip));
					spin_lock(&inode_sem);
					inode_unlock(ip);
					if (inode_wanted(ip))  {
						inode_unwant(ip);
						mfs_wakeup_all((caddr_t)ip);
					}
					spin_unlock(&inode_sem);
				}
				goto loop;
			}
			rlstlock();
			nrp = rp->r_forw;
			if (mp == ip->i_mntdev && rp->r_refcnt == 0) {
				rlstunlock();
				freereg(rp);
				count++;
				goto loop;
			} else {
				regrele(rp);
				if (ip)
					prele(ip);
			}
		}
	}
	rlstunlock();
	return(count);
}
/*	Remove a shared text region associated with inode ip from
 *	the region table, if possible.
 */
xrele(ip)
register struct inode *ip;
{
	register reg_t	*rp;
	register reg_t	*nrp;

	ASSERT(inode_locked(ip));

	if ((ip->i_flag&ITEXT) == 0)
		return;
	
loop:
	rlstlock();

	for (rp = ractive.r_forw ; rp != &ractive ; rp = nrp) {
		if (rp->r_type != RT_STEXT || ip != rp->r_iptr)
			nrp = rp->r_forw;
		else {
			rlstunlock();
			reglock(rp);
			if (rp->r_type != RT_STEXT || ip != rp->r_iptr) {
				regrele(rp);
				goto loop;
			}
			rlstlock();
			nrp = rp->r_forw;
			if (rp->r_refcnt == 0) {
				rlstunlock();
				freereg(rp);
				plock(ip);
				goto loop;
			} else {
				regrele(rp);
			}
		}
	}
	rlstunlock();
}


/*	Try to remove unused sticky regions in order to free up swap
 *	space.
 */

swapclup()
{
	register reg_t		*rp;
	register reg_t		*nrp;
	register inode_t	*ip;
	register int		rval;

	rval = 0;

loop:
	rlstlock();

	for (rp = ractive.r_forw ; rp != &ractive ; rp = nrp) {
		nrp = rp->r_forw;
		if (rp->r_type == RT_SHMEM)
			continue;
		if (ip = rp->r_iptr) {
			if (inode_locked(ip))
				continue;
			if (!try_plock(ip))
				continue;	/* get it next time around */
		}
		if (reg_islocked(rp)) {
			if (ip)
				prele(ip);
			continue;
		}
		reglock(rp);
		if (rp->r_type == RT_UNUSED) {
			regrele(rp);
			if (ip)
				prele(ip);
			continue;
		}
		if (rp->r_refcnt == 0) {
			rlstunlock();
			freereg(rp);
			rval = 1;
			goto loop;
		} else {
			regrele(rp);
			if (ip)
				prele(ip);
		}
	}
	rlstunlock();
	return(rval);
}

#define FORCE	1

/*
 * Prepare object process text region for writing.  If there is only
 * one reference to the region, and it's not sticky (RG_NOFREE is not
 * set), change the region type to private (instead of shared-text)
 * to prevent it from being found by any subsequent text searches.
 * Otherwise, make a private copy-on-write duplicate, detach the
 * original region from the object process, and attach the duplicate
 * in its place.  The pregion pointer of the new (private) text region
 * is returned.
 *
 * The original region and the associated inode (if any) must be locked
 * before entry to xdup(); on return the new region will have been
 * locked and the inode will be (still) locked.  On error, xdup()
 * returns NULL and unlocks both the region and the inode.
 */
preg_t *
xdup(p, prp)
register struct proc *p;
register preg_t *prp;
{
	register reg_t *rp = prp->p_reg, *nrp;
	register struct inode *ip;
	register preg_t *nprp;
	caddr_t va;
	register user_t *up;

	ASSERT(reg_mylock(rp));
	ASSERT(rp->r_type == RT_STEXT);
	if (rp->r_refcnt == 1 && (rp->r_flags & RG_NOFREE) == 0) {
		nprp = prp;
		rp->r_type = RT_PRIVATE;
	}
	else {
		ASSERT(rp->r_iptr == NULL || inode_locked(rp->r_iptr));
		va = prp->p_regva;
		if ((nrp = dupreg(rp, NOSLEEP, FORCE)) == NULL) {
			regrele(rp);
			return(NULL);
		}
		ip = nrp->r_iptr;
		up = p->p_userp;
		detachreg(prp, up);

		/* detachreg() unlocks ip */
		if (ip)
			plock(ip);
		if ((nprp = attachreg(nrp, up, va, PT_TEXT, SEG_RO)) == NULL)
			freereg(nrp);
	}
	if (nprp)
		nprp->p_reg->r_flags |= RG_WASTEXT;
	return(nprp);
}
