/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tdb.c: version 25.1 created on 11/27/91 at 15:13:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)uts/os/M68020:tdb.c	25.1"

#include "sys/types.h"
#include "sys/spm_mem.h"
#include "sys/state.h"
#include "sys/own.h"
#include "sys/trap.h"
#include "sys/psl.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/lio.h"
#include "sys/kmem.h"

extern	uchar	stkfmtsz[];

extern uint	fubyte(), fushort(), fuword();

tdb(debug_state)
state_t	debug_state;
{
	extern	void	TDB_vector();

    	own.o_tdb.state = &debug_state;


	if (own.o_tdb.state->s_vector == TRCTRAP)
		if (own.o_tdb.state->s_pc == (ulong) TDB_vector ||
		own.o_tdb.cmd == TDB_CMD_GO) {
			own.o_tdb.state->s_ps &= ~PS_T;
			return;
		}
	while (1) {
		own.o_tdb.done = 1;
		while (own.o_tdb.done)
			;
		if (own.o_tdb.cmd == TDB_CMD_GO) 
			return;
		if (own.o_tdb.cmd == TDB_CMD_STEP) {
			own.o_tdb.state->s_ps |= PS_T;
			return;
		}
		tdb_low_level();
	}
}

void
TDB_errvect()
{
	longjmp(own.o_tdb.jbuf, 1);
}

tdb_low_level()
{
	ulong		saved_vbr;
	extern ulong	TDBvec[];

	saved_vbr = get_vbr();
	if (setjmp(own.o_tdb.jbuf))
		own.o_tdb.error = EFAULT;
	else {
		set_vbr(TDBvec);
		own.o_tdb.error = 0;	/* no error */
		tdb_execute_low();
	}
	set_vbr(saved_vbr);
}

tdb_execute_low()
{
	switch (own.o_tdb.cmd) {
	case TDB_CMD_GET_CHAR:
		own.o_tdb.value = is_kern_addr(own.o_tdb.arg) ?
		  *(uchar *) own.o_tdb.arg : fubyte(own.o_tdb.arg);
		break;
	case TDB_CMD_PUT_CHAR:
		if (is_kern_addr(own.o_tdb.arg))
			*(uchar *) own.o_tdb.arg = own.o_tdb.value;
		else if (subyte(own.o_tdb.arg, own.o_tdb.value))
			own.o_tdb.error = EFAULT;
		break;
	case TDB_CMD_GET_SHORT:
		own.o_tdb.value = is_kern_addr(own.o_tdb.arg) ?
		  *(ushort *) own.o_tdb.arg : fushort(own.o_tdb.arg);
		break;
	case TDB_CMD_PUT_SHORT:
		if (is_kern_addr(own.o_tdb.arg))
			*(ushort *) own.o_tdb.arg = own.o_tdb.value;
		else if (sushort(own.o_tdb.arg, own.o_tdb.value))
			own.o_tdb.error = EFAULT;
		break;
	case TDB_CMD_GET_LONG:
		own.o_tdb.value = is_kern_addr(own.o_tdb.arg) ?
		  *(ulong *) own.o_tdb.arg : fuword(own.o_tdb.arg);
		break;
	case TDB_CMD_PUT_LONG:
		if (is_kern_addr(own.o_tdb.arg))
			*(ulong *) own.o_tdb.arg = own.o_tdb.value;
		else if (suword(own.o_tdb.arg, own.o_tdb.value))
			own.o_tdb.error = EFAULT;
		break;
	case TDB_CMD_GET_REG:
		tdb_getreg();
		break;
	case TDB_CMD_PUT_REG:
		tdb_putreg();
		break;

	case TDB_CMD_SHOW_TRAP:
		showtrap(own.o_tdb.state);
		break;

	case TDB_CMD_BACKTRACE:
		backtrace();
		break;

	case TDB_CMD_CHECK_TAGS:
#ifdef	M68020
		*CACHE_CTL_REG = CACHE_CTL_OFF;
		cache_tag_check(0);
		pm_cache_on();
#endif	/* M68020 */
#ifdef	M68040
		tagchk();
		if (! spm_mem.cache_off) {
		    clear_chip_cache();
		    re_enable_caches();
		} 
#endif	/* M68040 */
		break;

	default:
		own.o_tdb.error = EINVAL;
		break;
	}
}

tdb_getreg()
{
	state_t	*stp = own.o_tdb.state;

	switch (own.o_tdb.arg) {

	case TDB_REG_D0: own.o_tdb.value = stp->s_d0; break;
	case TDB_REG_D1: own.o_tdb.value = stp->s_d1; break;
	case TDB_REG_D2: own.o_tdb.value = stp->s_d2; break;
	case TDB_REG_D3: own.o_tdb.value = stp->s_d3; break;
	case TDB_REG_D4: own.o_tdb.value = stp->s_d4; break;
	case TDB_REG_D5: own.o_tdb.value = stp->s_d5; break;
	case TDB_REG_D6: own.o_tdb.value = stp->s_d6; break;
	case TDB_REG_D7: own.o_tdb.value = stp->s_d7; break;

	case TDB_REG_A0: own.o_tdb.value = stp->s_a0; break;
	case TDB_REG_A1: own.o_tdb.value = stp->s_a1; break;
	case TDB_REG_A2: own.o_tdb.value = stp->s_a2; break;
	case TDB_REG_A3: own.o_tdb.value = stp->s_a3; break;
	case TDB_REG_A4: own.o_tdb.value = stp->s_a4; break;
	case TDB_REG_A5: own.o_tdb.value = stp->s_a5; break;
	case TDB_REG_A6: own.o_tdb.value = stp->s_a6; break;
	case TDB_REG_A7:
		if (USERMODE(stp->s_ps))
			own.o_tdb.value = (ulong) stp->s_sp;
		else
			own.o_tdb.value =
			(ulong) &stp->s_proc + stkfmtsz[stp->s_format];
		break;

	case TDB_REG_PC: own.o_tdb.value = (ulong) stp->s_pc; break;
	case TDB_REG_SR: own.o_tdb.value = stp->s_ps; break;
	case TDB_REG_VECTOR: own.o_tdb.value = stp->s_vector; break;
	case TDB_REG_FORMAT: own.o_tdb.value = stp->s_format; break;

	default: own.o_tdb.error = EINVAL; break;
	}
}

tdb_putreg()
{
	state_t	*stp = own.o_tdb.state;

	switch (own.o_tdb.arg) {

	case TDB_REG_D0: stp->s_d0 = own.o_tdb.value; break;
	case TDB_REG_D1: stp->s_d1 = own.o_tdb.value; break;
	case TDB_REG_D2: stp->s_d2 = own.o_tdb.value; break;
	case TDB_REG_D3: stp->s_d3 = own.o_tdb.value; break;
	case TDB_REG_D4: stp->s_d4 = own.o_tdb.value; break;
	case TDB_REG_D5: stp->s_d5 = own.o_tdb.value; break;
	case TDB_REG_D6: stp->s_d6 = own.o_tdb.value; break;
	case TDB_REG_D7: stp->s_d7 = own.o_tdb.value; break;

	case TDB_REG_A0: stp->s_a0 = own.o_tdb.value; break;
	case TDB_REG_A1: stp->s_a1 = own.o_tdb.value; break;
	case TDB_REG_A2: stp->s_a2 = own.o_tdb.value; break;
	case TDB_REG_A3: stp->s_a3 = own.o_tdb.value; break;
	case TDB_REG_A4: stp->s_a4 = own.o_tdb.value; break;
	case TDB_REG_A5: stp->s_a5 = own.o_tdb.value; break;
	case TDB_REG_A6: stp->s_a6 = own.o_tdb.value; break;
	case TDB_REG_A7:
		if (USERMODE(stp->s_ps))
			stp->s_sp = own.o_tdb.value;
		else
			own.o_tdb.error = EINVAL;
		break;

	case TDB_REG_PC:
		if ( stp->s_format == 0xA || stp->s_format == 0xB )
			own.o_tdb.error = EINVAL;
		else
			stp->s_pc = own.o_tdb.value;
		break;

	case TDB_REG_SR: stp->s_ps = own.o_tdb.value; break;
	case TDB_REG_VECTOR: stp->s_vector = own.o_tdb.value; break;
	case TDB_REG_FORMAT: stp->s_format = own.o_tdb.value; break;

	default: own.o_tdb.error = EINVAL; break;
	}
}
