/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sysarix.c: version 25.1 created on 11/27/91 at 15:12:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sysarix.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * sysarix.c -- device dependent system calls
 */

/*	Copyright (c) 1988 by Arix Corporation		*/
/*	All Rights Reserved				*/


#include "sys/param.h"
#include "sys/types.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/sysarix.h"
#include "sys/utsname.h"
#include "sys/sysmacros.h"
#include "sys/swap.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/systm.h"
#include "sys/map.h"
#include "sys/inode.h"
#include "sys/var.h"
#include "sys/pfdat.h"
#include "sys/tuneable.h"
#include "sys/buf.h"
#include "sys/fstyp.h"
#include "sys/spm_mem.h"
#include "sys/sbus_spm.h"
#include "sys/kmem.h"
#include "sys/ints.h"

extern char	*strncpy();

extern int	hz;		/* from os/space.c or master.d/kernel	*/
extern int	availrmem, availsmem, freemem, maxmem, physmem;


extern uint	kern2spm_cmd();

sysarix()
{
	register struct	a {
		int	cmd;
		int	arg1, arg2, arg3, arg4, arg5;
	} *uap = (struct a *) u.u_ap;
	register int	s;

	switch (uap->cmd) {

	/*
	 *	Set system name
	 *		sysarix(ARIXSNAME, nameptr);
	 */
	case ARIXSNAME:
	{
		char	sname[sizeof(utsname.sysname)];

		if (!auth_utsname())
			break;

		switch (upath((caddr_t)uap->arg1, sname, sizeof(sname))) {
		case -1:	/* bad addr */
			u.u_error = EFAULT;
			break;
		case -2:	/* too long */
		case 0:		/* too short */
			u.u_error = EINVAL;
			break;
		default:
			str8cpy(utsname.nodename, sname);
			break;
		}
		break;
	}

	/*
	 *	General interface for adding, deleting, or
	 *	finding out about swap files.  See swap.h
	 *	for a description of the argument.
	 *		sysarix(ARIXSWPI, arg_ptr);
	 */

	case ARIXSWPI:
	{
		swpi_t	swpbuf;

		if (copyin(uap->arg1, &swpbuf, sizeof(swpi_t)) < 0) {
			u.u_error = EFAULT;
			return;
		}
		swapfunc(&swpbuf);
		break;
	}

	/*
	 * Adjust power margining
	 *	sysarix(POWERMARG, power_supply, flag)
	 */

	case POWERMARG:
		if (auth_power())
			u.u_rval1 =
			  kern2spm_cmd(K2S_SETMARGIN, uap->arg1, uap->arg2);
		break;

	/*
	 * Get power margining
	 *	sysarix(ARIXGMARG, power_supply)
	 */

	case ARIXGMARG:
		u.u_rval1 = kern2spm_cmd(K2S_GETMARGIN, uap->arg1);
		break;

	/*
 	**	Copy a string from a given kernel address to a user buffer.
	**	Uses copyout() for each byte to trap bad kernel addresses
	**	while watching for the null terminator.
	**		sysarix(ARIXKSTR, src, dst, length);
	*/
	case ARIXKSTR:
	{
		register char	*src;
		register char	*dst;
		register char	*dstlim;

		if (!auth_kstr()) {
			u.u_error = EACCES;
			break;
		}

		src = (char *) uap->arg1;
		if ( ! is_kern_addr(src) || (uint)src >= KIO_START) {
			u.u_error = ENXIO;			/* bad addr */
			break;
		}
		dstlim = (dst = (char *) uap->arg2) + (unsigned int) uap->arg3;
		if ( ! is_kern_addr(dstlim) || (uint)dstlim >= KIO_START) {
			u.u_error = ENXIO;			/* bad addr */
			break;
		}

		do {
			if (dst == dstlim || copyout(src, dst++, 1) < 0) {
				u.u_error = EINVAL;
				break;
			}
		} while (*src++);
		break;
	}

	/*
	**	Return the value of HZ as defined in param.h and set to hz
	**	in os/space.c or master.d/kernel
	**		sysarix(ARIXGETHZ)
	*/
	case ARIXGETHZ:
		u.u_rval1 = hz;
		break;

	/* Returns the selected memory value, or fills array if XMEM_ALL:
	 *	sysarix(ARIXMEMSIZE, mem_sel, int_array)
	 */
	case ARIXMEMSIZE:
		switch (uap->arg1) {
		case XMEM_AVAILRMEM:	/* available lockable pages */
			u.u_rval1 = availrmem - tune.t_minarmem;
			break;
		case XMEM_AVAILSMEM:	/* available virtual pages */
			u.u_rval1 = availsmem - tune.t_minasmem;
			break;
		case XMEM_FREEMEM:	/* currently free physical pages */
			u.u_rval1 = freemem;
			break;
		case XMEM_MAXMEM:	/* maximum available physical pages */
			u.u_rval1 = maxmem;
			break;
		case XMEM_PHYSMEM:	/* total physical pages */
			u.u_rval1 = physmem;
			break;
		case XMEM_ALL: {	/* all memory values in XMEM_ order */
			register uint	*up = (uint *)uap->arg2;

			if (suword(up++, availrmem - tune.t_minarmem) ||
			    suword(up++, availsmem - tune.t_minasmem) ||
			    suword(up++, freemem) ||
			    suword(up++, maxmem) ||
			    suword(up,   physmem))
				u.u_error = EFAULT;
			break;
		}
		default:
			u.u_error = EINVAL;
		}
		break;

	/*
	**	Return the load average table.
	**		sysarix(ARIXGETLA,avgtabptr)
	*/
	case ARIXGETLA:
	{
		long		LocalAvenrun[5]; /* local for copyout */
		extern long	Avenrun[5];	 /* defined in os/schedcpu.c */

		s = splhi();
		LocalAvenrun[0] = Avenrun[0];
		LocalAvenrun[1] = Avenrun[1];
		LocalAvenrun[2] = Avenrun[2];
		LocalAvenrun[3] = Avenrun[3];
		LocalAvenrun[4] = Avenrun[4];
		splx(s);
		if (copyout(LocalAvenrun, uap->arg1, sizeof(Avenrun)) < 0)
			u.u_error = EFAULT;
		break;
	}
	/*
	**	Get system clock chip's calibration (scaled in 100ths of a sec)
	**		sysarix(ARIXGETCLKCAL)
	*/
	case ARIXGETCLKCAL:
		u.u_rval1 = kern2spm_cmd(K2S_GET_CLK_CAL);
		break;

	/*
	**	Set and return clock chip's calibration (in 100ths of a sec)
	**		sysarix(ARIXGETCLKCAL, cal_value)
	*/
	case ARIXSETCLKCAL:
		if (auth_clkcal())
			u.u_rval1 = kern2spm_cmd(K2S_SET_CLK_CAL, uap->arg1);
		break;

	/*
	** Return the kernel symbol with the value <= arg1
	**	sysarix(ARIXGETVALSYM, value, ksym_p)
	** Returns 0 on success, ENXIO if no symbols or symbol not found
	**/
	case ARIXGETVALSYM:
	{
		kern_sym_t	*kp, *findsym();
		ksym_t		sym;

		if (kp = findsym((uint)uap->arg1)) {
			sym.value = kp->value;
			strncpy(sym.name, kp->name, sizeof(sym.name) - 1);
			sym.name[sizeof(sym.name) - 1] = '\0';
			if (copyout((caddr_t)&sym, (caddr_t)uap->arg2,
			  sizeof(sym)))
				u.u_error = EFAULT;
		}
		else
			/* I wish there were a better errno that wasn't already
			 * being used by sysarix. (EINVAL is already used)
			 */
			u.u_error = ENXIO;
		break;
	}

	/*
	** Return the kernel symbol value that matches arg1
	**	sysarix(ARIXGETSTRSYM, sym_string);
	** Returns ENXIO on error, else an uint not equal to (uint)-1.
	**/
	case ARIXGETSTRSYM:
	{
		kern_sym_t	*kp, *strsym();
		char		str[KSYM_NAME_LEN];

		switch (upath((caddr_t)uap->arg1, str, sizeof(str))) {
		case -1:	/* bad addr */
			u.u_error = EFAULT;
			break;
		case -2:	/* too long */
		case 0:		/* too short */
			u.u_error = EINVAL;
			break;
		default:
			if (kp = strsym(str))
				u.u_rval1 = kp->value;
			else
				/* see ARIXGETVALSYM for errno complaint */
				u.u_error = ENXIO;
			break;
		}
		break;
	}

	/*
	**	Modify the control character which gets
	**	into or out of debug mode.
	**		sysarix(ARIXCCDEBUG,flag,value)
	*/
	case ARIXCCDEBUG:
		if (!auth_cdebug()) {
			u.u_error = EACCES;
			break;
		}
		u.u_rval1 = kern2spm_cmd(K2S_CCDEBUG, uap->arg1, uap->arg2);
		break;

#ifdef	_POSIX_SOURCE
	/*
	**	Perform a special command for a POSIX binary control.
	**	CALL:
	**		sysarix(ARIXPOSIX,cmd,pid,&flags)
	**			cmd	is uap->arg1
	**			pid	is uap->arg2
	**				if 0, do it to current process
	**			&flags	is uap->arg3 (user virtual address)
	**	RETURN:
	**		0	- on success
	**		-1	- on failure and set errno to:
	**			EINVAL	- if invalid POSIX sub-command
	**			EFAULT	- if copying of flags fails
	**			EACCES	- if not superuser and tries to change
	**				  someone else's flags
	**			ESRCH	- if 'pid' is not in proc table
	*/
	case ARIXPOSIX:
	{
		register uint	*up = (uint *)uap->arg3;
		register int	pflags;

		switch (uap->arg1) {
		case ARIXGETPOSFLAGS:
			pflags = getposflags(uap->arg2);
			if (u.u_error == 0)
				if (suword(up,pflags))
					u.u_error = EFAULT;
			break;

		case ARIXSETPOSFLAGS:
			if ((pflags = fuword(up)) == -1)
				u.u_error = EFAULT;
			else
				setposflags(uap->arg2,pflags);
			break;

		default:
			u.u_error = EINVAL;
			break;
		}
		break;
	}
#endif	/* _POSIX_SOURCE */

	/*
	** System 90 specific
	** ARIXGETKERNNAME returns the pathname of the booted kernel in arg1
	**	arg1 = string (at least KERN_NAME_LEN bytes [see sys/spm_mem.h])
	** Returns EFAULT on address error.
	**/
	case ARIXGETKERNNAME:
		if (copyout(spm_mem.kern_name, (caddr_t)uap->arg1,
			    sizeof(spm_mem.kern_name)))
			u.u_error = EFAULT;
		break;

	/*
	** System 90 specific
	** ARIXGETSPM_MEM returns the spm_mem structure in arg1
	**	arg1 = pointer to spm_mem_t (see sys/spm_mem.h)
	** Returns EFAULT on address error.
	**/
	case ARIXGETSPM_MEM:
		if (copyout((caddr_t)&spm_mem, (caddr_t)uap->arg1,
			    sizeof(spm_mem)))
			u.u_error = EFAULT;
		break;

	default:
		u.u_error = EINVAL;
		break;
	}
}

#ifdef	_POSIX_SOURCE
getposflags(pid)
{
register proc_t	*pp;

	if ((pid < 1) || (u.u_procp->p_pid == pid))
		return (u.u_procp->p_posix_flags);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_posix_flags);
	}
	u.u_error = ESRCH;
	return (0);
}

setposflags(pid,pflags)
{
register proc_t	*pp;

	if ((pid < 1) || (u.u_procp->p_pid == pid)) {
		pflags &= POSIX_FLAGS_MASK;
		u.u_procp->p_posix_flags &= ~POSIX_FLAGS_MASK;
		return (u.u_procp->p_posix_flags |= pflags);
	}
	if (!auth_posix()) {
		u.u_error = EACCES;
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			pflags &= POSIX_FLAGS_MASK;
			pp->p_posix_flags &= ~POSIX_FLAGS_MASK;
			return (pp->p_posix_flags |= pflags);
		}
	}
	u.u_error = ESRCH;
	return (0);
}
#endif	/* _POSIX_SOURCE */

/*
 *	swapfunc - manipulate swap files.
 */
swapfunc(si)
register swpi_t	*si;
{
	register inode_t	*ip;
	extern swpt_t		swaptab[MSFILES];

	switch (si->si_cmd) {
		case SI_LIST:
			if (copyout((caddr_t)swaptab, (caddr_t)si->si_buf,
				    sizeof(swaptab)) < 0)
				u.u_error = EFAULT;
			break;

		case SI_ADD:
		case SI_DEL:
			if (!auth_swap())
				break;
			u.u_dirp = si->si_buf;
			if ((ip = namei(upath, 0)) == NULL)
				break;
			if (ip->i_ftype != IFBLK) {
				iput(ip);
				u.u_error = ENOTBLK;
				break;
			}

			u.u_rval1 = (si->si_cmd == SI_DEL) ?
			  swapdel(ip->i_rdev, si->si_swplo) :
			  swapadd(ip->i_rdev, si->si_swplo, si->si_nblks);

			iput(ip);
			break;
		default:
			u.u_error = EINVAL;
	}
}
