/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sys4.c: version 25.5 created on 7/24/92 at 19:34:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sys4.c	25.5	7/24/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:sys4.c	2.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/tuneable.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/clock.h"
#include "sys/conf.h"
#include "sys/spl.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/param.h"
#include "sys/ints.h"
#include "sys/time.h"
#include "sys/resource.h"

/*
 * Everything in this file is a routine implementing a system call.
 */

struct proc *check_pid();

gtime()
{
	u.u_rtime = time;
}

stime()
{
	register struct a {
		time_t	time;
	} *uap;

	uap = (struct a *)u.u_ap;
	if (auth_stime()) {
		time = uap->time;
		kern2spm_cmd(K2S_SETTIME, uap->time);
		sat_clk( uap->time );

#ifdef RFS
		rem_date();
#endif
	}
}


/* 
 * 	setuid  since this is a relatively security conscious operation
 *	        pass it off to the security stuff 
 */
setuid()
{
	register unsigned uid;
	register struct a {
		int	uid;
	} *uap;
	int rval = 0;

	uap = (struct a *)u.u_ap;
	uid = uap->uid;
	if (uid >= MAXUID) {
		u.u_error = EINVAL;
		return;
	}

	/* if we indeed did set the uid information then record 
 	 * the proper actions in the audit trail. We may not have 
         * because we're not privileged to do so, or because we
         * are a normal user trying to setuid to some unauthed value 
 	 */
	if ( auth_setuid( uid ) )
		sat_setuid();
}

/* 
 * 	setgid  since this is a relatively security conscious operation
 *	        pass it off to the security stuff 
 */
setgid()
{
	register unsigned gid;
	register struct a {
		int	gid;
	} *uap;

	uap = (struct a *)u.u_ap;
	gid = uap->gid;
	if (gid >= MAXUID) {
		u.u_error = EINVAL;
		return;
	}

	/* as in setuid, only do the audit if something really
 	 * changed 
 	 */
	if ( auth_setgid(gid) )
		sat_setgid();
}


setsid()
{
	register struct proc *p;
	register struct proc *p1;
	
	p = u.u_procp;
	/* if he is already a group leader, return error */
	if( p->p_pid == p->p_pgrp )  {
		u.u_error = EPERM;
		return;
	}
	for (p1 = &proc[1]; p1 < (struct proc *)v.ve_proc; p1++)
		if (p1->p_pgrp == p->p_pid)  {
			u.u_error = EPERM;
			return;
		}
	/* make the audit call now - we still have old values
 	 * so pass in the new value 
         */
	sat_setsid( p );
	/* this process becomes a process group leader */
	p->p_pgrp = p->p_pid;
	/* this process is also the session leader */
	p->p_session_id = p->p_pid;
	/* but unfortunately, he loses his controlling terminal */
	u.u_ttyp = NULL;
	u.u_ttyip = NULL;
	p->p_my_tty = 0;
	/* turn on job control */
	if (IS_POSIX_PROC(p))
		p->p_posix_flags |= JOB_CONTROL_PROC | JOB_SESSION_PROC;
	u.u_rval1 = p->p_pgrp;
}

getuid()
{

	u.u_rval1 = u.u_ruid;
	u.u_rval2 = u.u_uid;
}


getgid()
{

	u.u_rval1 = u.u_rgid;
	u.u_rval2 = u.u_gid;
}

getpid()
{
	u.u_rval1 = u.u_procp->p_pid;
	u.u_rval2 = u.u_procp->p_ppid;
}

/* If the flag is set then we are calling setpgrp otherwise we want getpgrp*/
setpgrp()
{
	register short *save_ttyp;
	register struct proc *p = u.u_procp;
	register struct a {
		int	flag;
	} *uap;

	uap = (struct a *)u.u_ap;
	if (uap->flag) {
		save_ttyp = u.u_ttyp;
		if (p->p_pgrp != p->p_pid) {
			u.u_ttyp = NULL;
			u.u_ttyip = NULL;
			p->p_my_tty = 0;
		}
		sat_setpgrp( p, save_ttyp );
		/*
		 *	This process becomes both the process group leader
		 *	and the session leader.
		 *	Specifically turn off job control (Should we?).
		 */
		p->p_pgrp = p->p_pid;
		p->p_session_id = p->p_pid;
		p->p_posix_flags &= ~(JOB_CONTROL_PROC | JOB_SESSION_PROC);
	}
	u.u_rval1 = p->p_pgrp;
}

sync()
{

	update();
}

	
nice()
{
	register struct proc *p = u.u_procp;
	register n;
	register struct a {
		int	niceness;
	} *uap;
	extern int chgnice();


	uap = (struct a *)u.u_ap;
	n = uap->niceness;
	p->p_nice = chgnice(p->p_nice, n);
	u.u_rval1 = p->p_nice - NZERO;
}

/*
 * Unlink system call.
 */
unlink()
{
	struct argnamei nmarg;

	nmarg.cmd = NI_DEL;
	(void)namei(upath, &nmarg);
}

chdir()
{
	chdirec(&u.u_cdir);
}

chroot()
{
	if (auth_chroot())
		chdirec(&u.u_rdir);
}

chdirec(ipp)
register struct inode **ipp;
{
	register struct inode *ip;

	if ((ip = namei(upath, 0)) == NULL)
		return;
	if (ip->i_ftype != IFDIR) {
		u.u_error = ENOTDIR;
		goto bad;
	}
	if (FS_ACCESS(ip, ICDEXEC))
		goto bad;
#ifdef SECON
	sat_chroot(ip);
#endif
	prele(ip);
	if (*ipp) {
		plock(*ipp);
		iput(*ipp);
	}
	*ipp = ip;
	return;

bad:
	iput(ip);
}

chmod()
{
	register struct inode *ip;
	struct a {
		char	*fname;
		int	fmode;
	} *uap;
	struct argnamei nmarg;

	if ((ip = namei(upath, 0)) == NULL)
		return;

	nmarg.cmd = NI_CHMOD;
	uap = (struct a *)u.u_ap;
	nmarg.mode = uap->fmode;
	if(FS_SETATTR(ip, &nmarg))
		ip->i_flag |= ICHG;
	iput(ip);
}

#ifdef FIPS
fchmod()
{
	register struct inode *ip;
	register struct file *fp;
	struct a {
		int	fdes;
		int	fmode;
	} *uap;
	struct argnamei nmarg;
	uap = (struct a *)u.u_ap;

	/* check if valid file descriptor */
	if ((fp=getf(uap->fdes)) == NULL)
		return;				/* returns EBADF */

	plock(ip = fp->f_inode);
	nmarg.cmd = NI_CHMOD;
	nmarg.mode = uap->fmode;
	if(FS_SETATTR(ip, &nmarg))
		ip->i_flag |= ICHG;
	prele(ip);
}
#endif /* FIPS */

lchown()
{
	chown_common(0);
}

chown()
{
	chown_common(1);
}

chown_common(symlink_follow)
uint symlink_follow;
{
	register struct inode *ip;
	register struct a {
		char	*fname;
		int	uid;
		int	gid;
	} *uap;
	struct argnamei nmarg;

	if (symlink_follow)
		ip = namei(upath, 0);
	else
		ip = lnamei(upath);

	if (ip == NULL)
		return;

	nmarg.cmd = NI_CHOWN;
	uap = (struct a *)u.u_ap;
	nmarg.uid = (ushort)uap->uid;
	nmarg.gid = (ushort)uap->gid;
	if(FS_SETATTR(ip, &nmarg))
		ip->i_flag |= ICHG;
	iput(ip);
}

#ifdef FIPS
fchown()
{
	register struct inode *ip;
	register struct file *fp;
	register struct a {
		int	fdes;
		int	uid;
		int	gid;
	} *uap;
	struct argnamei nmarg;
	uap = (struct a *)u.u_ap;

	/* check if valid file descriptor */
	if ((fp=getf(uap->fdes)) == NULL)
		return;				/* returns EBADF */

	plock(ip = fp->f_inode);
	nmarg.cmd = NI_CHOWN;
	nmarg.uid = (ushort)uap->uid;
	nmarg.gid = (ushort)uap->gid;
	if(FS_SETATTR(ip, &nmarg))
		ip->i_flag |= ICHG;
	prele(ip);
}
#endif /* FIPS */

/* 
 * Ssig() is the common entry for signal, sigset, sighold, sigrelse,
 * sigignore and sigpause 
 */

ssig()
{
	register struct proc *p;
	register struct a {
		int	signo;
		void	(*fun)();
	} *uap;
	register int	signal;
	register int	mask;


	uap = (struct a *)u.u_ap;
	signal = uap->signo & SIGNO_MASK;
	if (signal <= 0 || signal >= NSIG || signal == SIGKILL) {
		u.u_error = EINVAL;
		return;
	}
	if (IS_SVID_PROC(u.u_procp) && (sigbit(signal) & POSIXSIGNALS))  {
		u.u_error = EINVAL;
		return;
	}

	p = u.u_procp;
	mask = (1L<<(signal-1));
	switch (uap->signo & ~SIGNO_MASK) {

	case SIGHOLD:	/* sighold */
		p->p_hold |= mask;
		u.u_rval1 = 0;
		return;

	case SIGRELSE:	/* sigrelse */
		p->p_hold &= ~mask;
		u.u_rval1 = 0;
		return;

	case SIGIGNORE:	/* signore */
		u.u_signal[signal-1] = SIG_IGN;
		p->p_sig &= ~mask;
		p->p_hold &= ~mask;
		u.u_rval1 = 0;
		return;

	case SIGPAUSE:	/* sigpause */
		p->p_hold &= ~mask;
		u.u_rval1 = 0;
		pause();
		/* not reached */

	case SIGDEFER:		/* sigset */
		if (uap->fun != SIG_DFL && uap->fun != SIG_IGN
			&& uap->fun != SIG_HOLD)
			p->p_chold |= mask;
		if (p->p_hold & mask)
			u.u_rval1 = (int) SIG_HOLD;
		else
			u.u_rval1 = (int) u.u_signal[signal-1];
		if (uap->fun == SIG_HOLD) {
			p->p_hold |= mask;
		} else {
			u.u_signal[signal-1] = uap->fun;
			p->p_hold &= ~mask;
		}
 		p->p_posix_sig &= ~mask; 
		u.u_sigmask[signal-1] = 0;
		break;

	case 0:	/* signal */
		p->p_chold &= ~mask;
		u.u_rval1 = (int) u.u_signal[signal-1];
		u.u_signal[signal-1] = uap->fun;
		/* p_sig only cleared in signal, not in sigset */
		p->p_sig &= ~mask;
		p->p_posix_sig &= ~mask; 
		u.u_sigmask[signal-1] = 0;
		break;

	default:
		u.u_error = EINVAL;
		return;
	}
	
	if (signal == SIGCLD) {
		for (p = p->p_child ; p ; p = p->p_sibling) {
			if (p->p_stat == SZOMB)
				psignal(u.u_procp, SIGCLD);
		}
	}
}

kill()
{
	register struct proc *p, *q;
	register struct a {
		int	pid;
		int	signo;
	} *uap;
	register arg;
	register f;

	uap = (struct a *)u.u_ap;
	if (uap->signo < 0 || uap->signo >= NSIG) {
		u.u_error = EINVAL;
		return;
	}
	f = 0;
	arg = uap->pid;
	if (arg > 0)
		p = &proc[1];
	else
		p = &proc[2];
	q = u.u_procp;
	if (arg == 0 && q->p_pgrp == 0) {
		u.u_error = ESRCH;
		return;
	}
	for (; p < (struct proc *)v.ve_proc; p++) {
		if (p->p_stat == NULL)
			continue;
		if (arg > 0 && p->p_pid != arg) 
		        continue;
		if (arg == 0 && p->p_pgrp != q->p_pgrp)
			continue;
		if (arg < -1 && p->p_pgrp != -arg)
			continue;

		if(!((p->p_session_id == q->p_session_id) && (uap->signo == SIGCONT)) &&
		        (!(auth_kill(q,p) || 
			u.u_uid == p->p_uid ||
			u.u_ruid == p->p_uid ||
			u.u_uid == p->p_saved_set_uid ||
			u.u_ruid == p->p_saved_set_uid)) ||
			((p == &proc[1]) && (uap->signo == SIGKILL)))
			if (arg > 0) {
				u.u_error = EPERM;
				return;
			} else
				continue;
		f++;
		if (uap->signo)  {
#ifdef SECON
			sat_kill( p->p_pid, uap->signo );
#endif
			psignal(p, uap->signo);
			if(arg == -1)
				p->p_pgrp = 0;
		}

		if (arg > 0)
			break;
	}
	if (f == 0)
		u.u_error = ESRCH;
}

times()
{
	register struct a {
		time_t	(*times)[4];
	} *uap;

	uap = (struct a *)u.u_ap;
	if(copyout((caddr_t)&u.u_utime,(caddr_t)uap->times,sizeof(*uap->times)))
		u.u_error = EFAULT;
	fspl7();
	u.u_rtime = spm_mem.lbolt;
	fspl0();
}

/*
 * Profiling
 */

profil()
{
	register struct a {
		short	*bufbase;
		unsigned bufsize;
		unsigned pcoffset;
		unsigned pcscale;
	} *uap;

	uap = (struct a *)u.u_ap;
	u.u_prof.pr_base = uap->bufbase;
	u.u_prof.pr_size = uap->bufsize;
	u.u_prof.pr_off = uap->pcoffset;
	if (uap->pcscale == 1) uap->pcscale = 0;
	u.u_prof.pr_scale = uap->pcscale;
}

/*
 * alarm clock signal
 */
alarm()
{
	register struct proc *p;
	register c;
	register struct a {
		int	deltat;
	} *uap;

	uap = (struct a *)u.u_ap;
	p = u.u_procp;
	c = p->p_clktim;
	p->p_clktim = uap->deltat;
	u.u_rval1 = c;
}

/*
 * indefinite wait.
 * no one should wakeup(&u)
 */
pause()
{
	for (;;)
		sleep((caddr_t)&u, PSLEP);
}

/*
 * mode mask for creation of files
 */
umask()
{
	register struct a {
		int	mask;
	} *uap;
	register t;

	uap = (struct a *)u.u_ap;
	t = u.u_cmask;
	u.u_cmask = uap->mask & PERMMSK;
	u.u_rval1 = t;
}

/*
 * Set IUPD and IACC times on file.
 */
utime()
{
	register struct a {
		char	*fname;
		time_t	*tptr;
	} *uap;
	register struct inode *ip;
	time_t tv[2];

	uap = (struct a *)u.u_ap;
	if (uap->tptr != NULL) {
		if (server())	/* server already copied time in */
			bcopy((caddr_t)uap->tptr, (caddr_t)tv, sizeof(tv));
		else
			if (copyin((caddr_t)uap->tptr,(caddr_t)tv,sizeof(tv))) {
				u.u_error = EFAULT;
				return;
			}
	} else {
		tv[0] = time;
		tv[1] = time;
	}
	if ((ip = namei(upath, 0)) == NULL)
		return;

#ifdef SECON
	if ( FS_ACCESS(ip, ILABELW) ) {
		iput(ip);
		return;
	}
#endif

	if (u.u_uid != ip->i_uid && ! auth_utime()) {
		u.u_error = 0; /* FIX THIS, HH - auth_utime sets u_error */
		if (uap->tptr != NULL)
			u.u_error = EPERM;
		else
			FS_ACCESS(ip, IWRITE);
	}
	if (u.u_error == 0) {
		if (rdonlyfs(ip->i_mntdev))
			u.u_error = EROFS;
		else  {
			ip->i_flag |= IACC|IUPD|ICHG;
			FS_IUPDAT(ip, &tv[0], &tv[1]);
		}
	}
	iput(ip);
}

ulimit()
{
	register struct a {
		int	cmd;
		long	arg;
	} *uap;

	uap = (struct a *)u.u_ap;
	switch (uap->cmd) {

	case 2:	/* Set new file size limit. */
		if (uap->arg > u.u_limit && !auth_ulimit())
			return;
		if (uap->arg < 0) {
			u.u_error = EINVAL;
			return;
		}
		u.u_limit = uap->arg;
		u.u_limit_adj = (u.u_limit & ~1) << (SCTRSHFT-1);

	case 1:	/* Return current file size limit. */
		u.u_roff = u.u_limit;
		break;

	case 3:	/* Return maximum possible break value. */
	{
		register off_t	addr;
		preg_t		*dprp;

		/*	Find the data region */
		if ((dprp = findpreg(u.u_procp, PT_DATA)) == NULL)  {
			u.u_roff = 0;
			break;
		}

		/* 
		 * The absolute maximum break value is the current end of the
		 * data segement plus ctob(MAXUMEM - current_proc_size).
		 */
		addr = (off_t)dprp->p_regva +
		 ctob(dprp->p_reg->r_pgsz + tune.t_maxumem - u.u_procp->p_size);

		/* Now clip addr against the region with a virtual address
		 * greater than the data region but lower than any other
		 * region.  This is easy because the pregions are sorted.
		 */
		++dprp;
		ASSERT(dprp->p_reg);
		if (dprp->p_type == PT_STACK)
			addr = min(addr,
			  (off_t)dprp->p_regva - ctob(dprp->p_reg->r_pgsz));
		else
			addr = min(addr, (off_t)dprp->p_regva);
		u.u_roff = addr;
		break;
	}
	case 4:	/* Return current soft limit value of RLIMIT_NOFILE. */
		u.u_roff = u.u_rlimit[RLIMIT_NOFILE].rlim_cur;
		break;

	default:
		u.u_error = EINVAL;
	}
}

getgroups()
{
	register struct	a {
		uint	gidsize;
		gid_t	*gidset;
	} *uap = (struct a *)u.u_ap;
	register int size;

	/* make sure this is a posix process */
	if (!IS_POSIX_ENV(u.u_procp))  {
		u.u_error = EACCES;
		return;
	}
	/* count the valid supplementary groups in the proc */
	for (size = 0; size < NGROUPS_MAX && 
		(uauth->a_groups[size] != (gid_t) -1); size++ ); 

	/* if size of array is 0 then user asking for real size */
	if (  uap->gidsize == 0 )  {
		u.u_rval1 = size;
		return;
	}

	/* if array size doesn't hold entire set of groups 
	 * or user passed a big size error
	 */
	if (size > uap->gidsize ) {
		u.u_error = EINVAL;
		return;
	}

	/* okay...now give the groups to him */
	uap->gidsize = size;
	u.u_rval1 = size;
	if (copyout((caddr_t)uauth->a_groups, (caddr_t) uap->gidset,
		sizeof(gid_t) * size )) 
		u.u_error = EFAULT;
}

setgroups()
{
	register struct	a {
		uint	gidsize;
		gid_t	*gidset;
	} *uap = (struct a *)u.u_ap;

	if (!auth_setgrps())
		return;

	if ( uap->gidsize > NGROUPS_MAX ) {
		u.u_error = EINVAL;
		return;
	}

	/* copy it into the supplemanrty group array for the proc */
	if ( copyin( (caddr_t)uap->gidset, (caddr_t)uauth->a_groups,
			sizeof( gid_t ) * uap->gidsize )) {
		u.u_error = EFAULT;
		return;
	}
	
	if ( uap->gidsize < NGROUPS_MAX )
		uauth->a_groups[uap->gidsize] = (gid_t) -1;

#ifdef SECON
	sat_setsupp();
#endif
}

/* Returns the process group id of the calling process */

getpgrp()
{
	register struct proc *p;

	u.u_rval1 = u.u_procp->p_pgrp;
}

/* Set the process group id to pgrp
   This function is used to either join an existing process group or
   create a new process group within the session of the calling process
*/

setpgid()
{
	register struct proc *p;
	register struct a {
		int	pid;
		int	pgrp;
	} *uap = (struct a *)u.u_ap;

	if((uap->pid < 0) || (uap->pid > MAXPID) || (uap->pgrp < 0))  {
		u.u_error = EINVAL;
		return;
	}
	p = u.u_procp;
	if (uap->pid == 0)
		uap->pid = p->p_pid;

	/* If it is a session leader, we cannot change its group */
	if(uap->pid == p->p_session_id){
		u.u_error = EPERM;
		return;
	}
	if(uap->pgrp == 0)
		uap->pgrp = uap->pid;

	/* Check to see if any of the children of this process match the
	   requested ID
	*/

	p = check_pid(uap->pid,uap->pgrp);

	/* No match, send back an error */
	if (p == (struct proc *)0) 
		return;

	/* If we have a match and the pgrp parameter is 0, then the process
	   ID of the requesting process is used
	*/

	p->p_pgrp = uap->pgrp;
}

/* Check to see if the requested pid either matches the calling process'
   pid or one of its children's pid
*/

struct proc *
check_pid(pid,pgrp)
register pid_t pid,pgrp;
{
	register struct proc *p,*p1;

	if(pid == u.u_procp->p_pid){
		p = u.u_procp;
	}
	else{
		p = u.u_procp;
	
		/* Check to see if any of the children of this process match the
	   	 * requested ID and that they are in this session.
		 */
	    	for (p = p->p_child; p;p = p->p_sibling) {
			if (p->p_pid == pid) {
			    if(!IS_POSIX_PROC(p))  {
				u.u_error = EACCES;
				return((struct proc *)0);
			    }
			    if (u.u_procp->p_session_id != p->p_session_id) {
				u.u_error = EPERM;
				return((struct proc *)0);
			    }
			    if (p->p_posix_flags & WAS_EXECED) {
				u.u_error = EACCES;
				return((struct proc *)0);
			    }
			    else
			        break;
			}
	    	}
	}
	if(!p){
		u.u_error = ESRCH;
		return((struct proc *)0);
	}

	/* If not then check to see if the given group id matches any other
	   group in the same session
	*/
	if(pgrp != pid){
	    for (p1 = &proc[1]; p1 < (struct proc *)v.ve_proc; p1++){
		if ((p1->p_pgrp == pgrp) && 
		    (u.u_procp->p_session_id == p1->p_session_id))
			return (p);
	    }
	}
	else
	    return(p);

	u.u_error = EPERM;
	return((struct proc *)0);
}


sysconf()
{
register struct a {
	int	name;
} *uap = (struct a *)u.u_ap;

	switch(uap->name){

		case _SC_ARG_MAX:
			u.u_rval1 = NCARGS;
			return;

		case _SC_CHILD_MAX:
			u.u_rval1 = v.v_maxup;
			return;

		case _SC_NGROUPS_MAX:
			u.u_rval1 = v.v_ngroups;
			return;

		case _SC_OPEN_MAX:
			u.u_rval1 = u.u_rlimit[RLIMIT_NOFILE].rlim_cur;
			return;

		default:
			/* JTOF - pass default case to the
 			 * security stuff so we can set the 
 			 * report on the security parameters 
 			 */
			if (!auth_conf(uap->name))
				u.u_error = EINVAL;
			return;
	}
}

/*
 * Get/Set value of an interval timer.  The process virtual and
 * profiling virtual time timers are kept in the u. area.
 * The real time interval timer is kept in the process table slot
 * for the process.
 * Virtual time timers are processed in the clock().
 * The real time timer is processed by a timeout routine,
 * called from the timein() routine.
 * NOTE:
 *	The real time timer is not like BSD where it is kept as an
 *	absolute time, but rather is the same as the other two timers,
 *	which are number of ticks before expiration.
 *	Also, user specifies and expects it_value and it_interval to
 *	be in seconds and micro-seconds but we use the fields as ticks
 *	internally so we do necessary conversions.
 */

extern	int	realitexpire();

getitimer()
{
	register struct a {
		uint		which;
		itimerval_t	*itv;
	} *uap;
	register struct	proc	*p;
	register int		s;
	itimerval_t		uitv;
	ktimerval_t		kitv;

	uap = (struct a *)u.u_ap;
	if (uap->which > 2) {
		u.u_error = EINVAL;
		return;
	}
	p = u.u_procp;
	s = splhi();
	if (uap->which == ITIMER_REAL) {
		kitv = p->p_realtimer;
		if (p->p_realtimer_ticks > 0) {
			kitv.it_value -= (lbolt - p->p_realtimer_ticks);
			if (kitv.it_value < 0)
				kitv.it_value = 0;
		}
	} else
		kitv = u.u_timer[uap->which];

	splx(s);
	if ( p->p_realtimer_ticks && kitv.it_value == 0 ) {
		/* return that the timer is about to expire so applications */
		/* can reload the timer */
		uitv.it_value.tv_sec	 = 0;
		uitv.it_value.tv_usec	 = 1;
	} else {
		uitv.it_value.tv_sec	 = tickstosecs(kitv.it_value);
		kitv.it_value		-= secstoticks(uitv.it_value.tv_sec);
		uitv.it_value.tv_usec	 = tickstousecs(kitv.it_value);
	}
	uitv.it_interval.tv_sec	 = tickstosecs(kitv.it_interval);
	kitv.it_interval	-= secstoticks(uitv.it_interval.tv_sec);
	uitv.it_interval.tv_usec = tickstousecs(kitv.it_interval);
	if (copyout((char *)&uitv,(char *)uap->itv,sizeof(itimerval_t)))
		u.u_error = EFAULT;
	return;
}

setitimer()
{
	register struct a {
		uint		which;
		itimerval_t	*itv, *oitv;
	} *uap;
	register itimerval_t	*uitvp;
	register struct	proc	*p;
	register int		s;
	itimerval_t		uitv;
	ktimerval_t		kitv;

	uap = (struct a *)u.u_ap;
	if (uap->which > 2) {
		u.u_error = EINVAL;
		return;
	}
	p = u.u_procp;

	if ((uitvp = uap->itv) &&
	    copyin((char *)uitvp, (char *)&uitv, sizeof(itimerval_t)))
		u.u_error = EFAULT;

	if (uap->oitv) {
		uap->itv = uap->oitv;
		getitimer();
	}

	if ( uitvp == 0 || u.u_error)
		return;

	if (itimerfix(&uitv.it_value) || itimerfix(&uitv.it_interval)) {
		u.u_error = EINVAL;
		return;
	}

	kitv.it_value    = secsusecstoticks(uitv.it_value.tv_sec,
					uitv.it_value.tv_usec);
	kitv.it_interval = secsusecstoticks(uitv.it_interval.tv_sec,
					uitv.it_interval.tv_usec);
	s = splhi();
	if (uap->which == ITIMER_REAL) {
		if (p->p_realtimer_id)
			untimeout(p->p_realtimer_id);
		p->p_realtimer = kitv;
		if (kitv.it_value) {
			p->p_realtimer_ticks = lbolt;
			p->p_realtimer_id =
				timeout(realitexpire,p,kitv.it_value);
		} else	{
			p->p_realtimer_ticks = 0;
			p->p_realtimer_id = 0;
		}
	} else
		u.u_timer[uap->which] = kitv;
	splx(s);
	return;
}

/*
 * Real interval timer expired:
 * send process whose timer expired an alarm signal.
 * If time is not set up to reload, then just return.
 */
realitexpire(p)
register struct	proc	*p;
{
register int		s;

	psignal(p, SIGALRM);
	s = splhi();
	if (p->p_realtimer.it_interval == 0) {
		p->p_realtimer.it_value = 0;
		p->p_realtimer_id = 0;
		p->p_realtimer_ticks = 0;
		splx(s);
		return;
	}
	p->p_realtimer.it_value = p->p_realtimer.it_interval;
	p->p_realtimer_ticks = lbolt;
	p->p_realtimer_id = timeout(realitexpire,p,p->p_realtimer.it_value);
	splx(s);
}

/*
 * Check that a proposed value to load into the .it_value or
 * .it_interval part of an interval timer is acceptable, and
 * fix it to have at least minimal value (i.e., if it is less
 * than the resolution of the clock, round it up).
 */
itimerfix(tv)
register timeval_t	*tv;
{
	if ((tv->tv_sec < 0) || (tv->tv_sec > 100000000) ||
			(tv->tv_usec < 0) || (tv->tv_usec >= secstousecs(1)))
		return (EINVAL);
	if ((tv->tv_sec == 0) && (tv->tv_usec != 0) &&
			(tv->tv_usec < tickstousecs(1)))
		tv->tv_usec = tickstousecs(1);
	return (0);
}

/*
 * Decrement an interval timer by a specified number
 * of microseconds, which must be less than a second,
 * i.e. < 1000000.  If the timer expires, then reload
 * it.  In this case, carry over (usec - old value) to
 * reduce the value reloaded into the timer so that
 * the timer does not drift.  This routine assumes
 * that it is called in a context where the timers
 * on which it is operating cannot change in value.
 */
itimerdecr(itp,usec)
register itimerval_t	*itp;
int			usec;
{
	if (itp->it_value.tv_usec < usec) {
		if (itp->it_value.tv_sec == 0) {
			/* expired, and already in next interval */
			usec -= itp->it_value.tv_usec;
			goto expire;
		}
		itp->it_value.tv_usec += secstousecs(1);
		itp->it_value.tv_sec--;
	}
	itp->it_value.tv_usec -= usec;
	usec = 0;
	if (timerisset(&itp->it_value))
		return (1);
	/* expired, exactly at end of interval */
expire:
	if (timerisset(&itp->it_interval)) {
		itp->it_value = itp->it_interval;
		itp->it_value.tv_usec -= usec;
		if (itp->it_value.tv_usec < 0) {
			itp->it_value.tv_usec += secstousecs(1);
			itp->it_value.tv_sec--;
		}
	} else
		itp->it_value.tv_usec = 0;		/* sec is already 0 */
	return (0);
}

/*
 * Add and subtract routines for timevals.
 * N.B.: subtract routine doesn't deal with
 * results which are before the beginning,
 * it just gets very confused in this case.
 * Caveat emptor.
 */
timevaladd(t1,t2)
timeval_t	*t1, *t2;
{
	t1->tv_sec  += t2->tv_sec;
	t1->tv_usec += t2->tv_usec;
	timevalfix(t1);
	return;
}

timevalsub(t1,t2)
timeval_t	*t1, *t2;
{
	t1->tv_sec  -= t2->tv_sec;
	t1->tv_usec -= t2->tv_usec;
	timevalfix(t1);
	return;
}

timevalfix(t1)
timeval_t	*t1;
{
	if (t1->tv_usec < 0) {
		t1->tv_sec--;
		t1->tv_usec += secstousecs(1);
	}
	if (t1->tv_usec >= secstousecs(1)) {
		t1->tv_sec++;
		t1->tv_usec -= secstousecs(1);
	}
	return;
}


getrlimit()
{
	struct a {
		int		resource;
		struct rlimit	*rlim_p;
	} *uap;

	uap = (struct a *)u.u_ap;

	if (uap->resource != RLIMIT_NOFILE) { 
		u.u_error = EINVAL;
		return;
	}

	if (copyout((caddr_t)&u.u_rlimit[uap->resource], (caddr_t)uap->rlim_p,
			sizeof(struct rlimit))) {
		u.u_error = EFAULT;
		return;
	}

	return;
}

setrlimit()
{
	struct a {
		int		resource;
		struct rlimit	*rlim_p;
	} *uap;

	struct rlimit rlim;

	uap = (struct a *)u.u_ap;

	if (uap->resource != RLIMIT_NOFILE) {
		u.u_error = EINVAL;
		return;
	}

	if (copyin((caddr_t)uap->rlim_p, (caddr_t)&rlim, sizeof(rlim))) {
		u.u_error = EFAULT;
		return;
	}

	if (rlim.rlim_cur > rlim.rlim_max) {
		u.u_error = EINVAL;
		return;
	}

	if (rlim.rlim_max > u.u_rlimit[uap->resource].rlim_max &&
			!auth_ulimit()) {
		u.u_error = EPERM;
		return;
	}

	u.u_rlimit[uap->resource].rlim_cur = rlim.rlim_cur;
	u.u_rlimit[uap->resource].rlim_max = rlim.rlim_max;
}
