/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sys3.c: version 23.2 created on 2/26/91 at 16:45:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sys3.c	23.2	2/26/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/mount.h"
#include "sys/ino.h"
#include "sys/iobuf.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/cmn_err.h"
#include "sys/user.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#include "sys/conf.h"
#include "sys/stat.h"
#include "sys/statfs.h"
#include "sys/ioctl.h"
#include "sys/var.h"
#include "sys/ttold.h"
#include "sys/open.h"
#include "sys/debug.h"
#include "sys/utsname.h"
#include "sys/message.h"
#include "sys/param.h"
#include "sys/synch.h"
#include "sys/proc.h"
#include "sys/nami.h"
#include "sys/acl.h"
#include "sys/resource.h"

/*
 * If security is off, then we must copy the define from sys/mls.h.
 * This define should probably be in sys/param.h anyway.
 */
#ifndef	SECON
#define SECURE_INODE	128
#endif	/* !SECON */

/*
 * the fstat system call.
 */
fstat()
{
	register struct file *fp;
	register struct inode *ip;
	register struct a {
		int	fdes;
		struct stat *sb;
	} *uap;
	struct file *getf();

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	plock(ip = fp->f_inode);
	stat1(ip, uap->sb);
	prele(ip);
}

/*
 * the stat and lstat system calls.
 */

lstat()
{
	stat_common(0);
}

stat()
{
	stat_common(1);
}

stat_common(symlink_follow)
uint	symlink_follow;
{
	register struct inode *ip;
	register struct a {
		char	*fname;
		struct stat *sb;
	} *uap;

	uap = (struct a *)u.u_ap;

	if (symlink_follow)
		ip = namei(upath, 0);
	else
		ip = lnamei(upath);

	if (ip == NULL)
		return;
	stat1(ip, uap->sb);
	iput(ip);
}

/*
 * The basic routine for fstat and stat:
 * get the inode and pass appropriate parts back.
 */
stat1(ip, ub)
register struct inode *ip;
struct stat *ub;
{
	struct stat ds;

#ifdef SECON
	if ( FS_ACCESS(ip, ILABELR) )
		return;
#endif

	auth_stat1(ip, ub);
	if (ip->i_flag & (IACC|IUPD|ICHG))
		FS_IUPDAT(ip, &time, &time);
	/*
	 * first copy from inode table
	 */
	ds.st_dev = ip->i_dev;
	ds.st_ino = (ushort)ip->i_number;
	ds.st_nlink = ip->i_nlink;
	ds.st_uid = ip->i_uid;
	ds.st_gid = ip->i_gid;
	ds.st_rdev = (dev_t)ip->i_rdev;
	ds.st_size = ip->i_size;
	/*
	 * Call fs dependent portion to 
	 * read the disk inode to obtain
	 * file modes and dates
	 */
	FS_STATF(ip, &ds);
	if (copyout((caddr_t)&ds, (caddr_t)ub, sizeof(ds)) < 0)
		u.u_error = EFAULT;
}

/*
 * the acl system call.
 */

acl()
{
	register struct inode *ip;
	struct argnamei nmarg;
	register struct a {
		char	*fname;
		int	func;		
		char	*buf;
		int	size;
	} *uap;

	uap = (struct a *)u.u_ap;
	if (uap->func == SETNACL) {
		if(uap->size == 0) {
			nmarg.cmd = NI_DEL;
			namei(upath, &nmarg);
			return;
		}
		nmarg.cmd = NI_MKNOD;		/* create named acl */
		nmarg.ftype = IFACL;
		nmarg.mode = 0;
		ip = namei(upath, &nmarg);
	}
	else
		ip = namei(upath, 0);

	if (ip == NULL)
		return;

	if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
		u.u_error = EINVAL;
		iput(ip);
		return;
	}

	if (ip->i_ftype == IFACL) {
		if ((uap->func == SETACL) && (uap->size == 0)) {
			iput(ip);
			nmarg.cmd = NI_DEL;
			namei(upath, &nmarg);
			return;
		}
	}

	nmarg.cmd = NI_ACL;
	FS_SETATTR(ip, &nmarg);
	iput(ip);
}



/*
 * the facl system call.
 */
facl()
{
	register struct file *fp;
	register struct inode *ip;
	struct argnamei nmarg;
	register struct a {
		int	fdes;
		int	func;		
		char	*buf;
		int	size;
	} *uap;
	struct file *getf();

	uap = (struct a *)u.u_ap;
	if (uap->func == SETNACL) {
	  	if (uap->size == 0) {
			nmarg.cmd = NI_DEL;
			namei(upath, &nmarg);
			return;
		}
		nmarg.cmd = NI_MKNOD;		/* create named acl */
		nmarg.ftype = IFACL;
		nmarg.mode = 0;
		ip = namei(upath, &nmarg);
	}
	else if ((fp = getf(uap->fdes)) == NULL)
		return;

	plock(ip = fp->f_inode);

	if ( ip->i_mntdev->m_isize < SECURE_INODE ) {
		u.u_error = EINVAL;
		prele(ip);
		return;
	}

	if (ip->i_ftype == IFACL) {
		if ((uap->func == SETACL) && (uap->size == 0)) {
			prele(ip);
			nmarg.cmd = NI_DEL;
			namei(upath, &nmarg);
			return;
		}
	}

	nmarg.cmd = NI_ACL;
	FS_SETATTR(ip, &nmarg);

	prele(ip);
}


/*
 * the fstatfs system call.
 */
fstatfs()
{
	register struct file *fp;
	register struct inode *ip;
	register struct a {
		int	fdes;
		struct	statfs *sb;
		int	len;
		int	fstyp;
	} *uap = (struct a *)u.u_ap;
	struct file *getf();

	if ((fp = getf(uap->fdes)) == NULL)
		return;
	plock(ip = fp->f_inode);
	statfs1(ip, uap->sb, uap->len, uap->fstyp);
	prele(ip);
}

/*
 * the statfs system call.
 */
statfs()
{
	register struct inode *ip;
	register struct a {
		char	*fname;
		struct	statfs *sb;
		int	len;
		int	fstyp;
	} *uap = (struct a *)u.u_ap;

	if ((ip = namei(upath, 0)) == NULL)
		return;
	statfs1(ip, uap->sb, uap->len, uap->fstyp);
	iput(ip);
}

/*
 * Common routine for fstatfs and statfs.
 */
statfs1(ip, ub, len, fstyp)
register struct inode	*ip;
struct statfs		*ub;
int			len;
register		fstyp;
{
	struct statfs	ds;
	uint		index;

	if (len < 0 || len > sizeof(ds) || fstyp < 0 || fstyp >= nfstyp) {
		u.u_error = EINVAL;
		return;
	}
	if (fstyp && ip->i_ftype != IFCHR && ip->i_ftype != IFBLK) {
		u.u_error = EINVAL;
		return;
	}
	/*
	 * Get generic superblock from fs-dependent code.
	 */
	index = fstyp ? fstyp : ip->i_fstyp;
	if (! fstypsw[index].statfs_flag)
		upkern_lock();
	(*fstypsw[index].fs_statfs)(ip, &ds, fstyp);
	if (u.u_error == 0 &&
	    copyout((caddr_t)&ds, (caddr_t)ub, len) < 0)
		u.u_error = EFAULT;
}

/*
 * the dup system call.
 */
dup()
{
	register struct file *fp;
	register struct a {
		int	fdes;
	} *uap;
	register i;
	struct file *getf();

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	if ((i = ufalloc(0)) < 0)
		return;
	SET_OFILE(i, fp);
	spin_lock(&file_freelist_lock);
	fp->f_count++;
	spin_unlock(&file_freelist_lock);
}

/*
 * the file control system call.
 */
fcntl()
{
	register struct file *fp;
	register struct a {
		int	fdes;
		int	cmd;
		int	arg;
	} *uap;
	register i;
	struct 	 file   *getf();
	struct   inode  *ip;
	
	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;

	switch (uap->cmd) {
	case F_DUPFD:
		i = uap->arg;
		if (i < 0 || i >= u.u_rlimit[RLIMIT_NOFILE].rlim_cur) {
			u.u_error = EINVAL;
			break;
		}
		if ((i = ufalloc(i)) < 0)
			break;
		SET_OFILE(i, fp);
		spin_lock(&file_freelist_lock);
		fp->f_count++;
		spin_unlock(&file_freelist_lock);
		break;

	case F_GETFD:
		u.u_rval1 = GET_OFLAG(uap->fdes);
		break;

	case F_SETFD:
		SET_OFLAG(uap->fdes, uap->arg);
		break;

	case F_GETFL:
		u.u_rval1 = fp->f_flag+FOPEN;
		break;

	case F_SETFL:
		upkern_lock();
		FS_FCNTL(
		   fp->f_inode, F_CHKFL, uap->arg, fp->f_flag, fp->f_offset);
		if (! u.u_error)  {
			fp->f_flag &= (FREAD|FWRITE);
			uap->arg &= FMASK;
			fp->f_flag |= (uap->arg-FOPEN) & ~(FREAD|FWRITE);
		}
		upkern_unlock();
		break;

	case F_FREESP:
		upkern_lock();
		if ((fp->f_flag & FWRITE) == 0)
			u.u_error = EBADF;
		else if ((ip = fp->f_inode)->i_ftype != IFREG)
			u.u_error = EINVAL;
		else {
			plock(ip);
			FREESP(ip, uap->arg, fp->f_flag, fp->f_offset);
			prele(ip);
		}
		upkern_unlock();
		break;

	default:
		FS_FCNTL(
		   fp->f_inode, uap->cmd, uap->arg, fp->f_flag, fp->f_offset);
		break;
	}
}

/*
 * character special i/o control
 */
ioctl()
{
	register struct file *fp;
	register struct a {
		int	fdes;
		int	cmd;
		int	arg;
	} *uap;
	struct file *getf();

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	FS_IOCTL(fp->f_inode, uap->cmd, uap->arg, fp->f_flag);
}

/*
 * old stty and gtty
 */
stty()
{
	register struct a {
		int	fdes;
		int	arg;
		int	narg;
	} *uap;

	uap = (struct a *)u.u_ap;
	uap->narg = uap->arg;
	uap->arg = TIOCSETP;
	u.u_syscall = DUIOCTL;
	ioctl();
}

gtty()
{
	register struct a {
		int	fdes;
		int	arg;
		int	narg;
	} *uap;

	uap = (struct a *)u.u_ap;
	uap->narg = uap->arg;
	uap->arg = TIOCGETP;
	u.u_syscall = DUIOCTL;
	ioctl();
}

/*
 * the mount system call.
 */
smount()
{
	register struct inode *bip, *ip = NULL;
	register struct mount *mp, *tmp;
	register short fstyp;
	char *dataptr;
	int datalen;
	register struct a {
		char	*fspec;
		char	*freg;
		int	flags;
		int	fstyp;
		char	*dataptr;
		int	datalen;
	} *uap;
	register dev_t dev;
	int special;

	if ( !auth_mount() )
		return;

	uap = (struct a *)u.u_ap;
	if ((bip = namei(upath, 0)) == NULL)  {
		return;
	}
	dev = bip->i_rdev;
	special = (bip->i_ftype == IFBLK || bip->i_ftype == IFCHR);
	tmp = NULL;
	for (mp = mount; mp < (struct mount *)v.ve_mount; mp++) {
		if (mp->m_flags == MFREE) {
			if (tmp == NULL) {	/* first empty slot */
				tmp = mp;
				tmp->m_flags = MINTER;
			}
		} else if (special && dev == mp->m_dev) {
			/* already busy */
			mp = NULL;
			goto out;
		}
	}
	if ((mp = tmp) == NULL)	 {
		/* no free slots */
		goto out;
	}

	mp->m_dev = dev;
	mp->m_bcount = 0;
	u.u_dirp = (caddr_t)uap->freg;
	prele(bip);	/* unlock in case ip == bip */
	if ((ip = namei(upath, 0)) == NULL) {
		plock(bip);
		goto out;
	} else if (ip == bip) {
		ip->i_count--;
		if (special) {
			u.u_error = ENOTDIR;
			goto out;
		}
	} else
		plock(bip);
	if (ip->i_ftype != IFDIR) {
		u.u_error = ENOTDIR;
		goto out;
	}
	if (ip->i_count != 1 || (ip->i_flag & IISROOT))
		goto out;
	/*
	 * Backward compatibility: require the user program to
	 * supply a flag indicating a new-style mount, otherwise
	 * assume the fstyp of the root file system and zero values
	 * for dataptr and datalen.  MS_FSS indicates a 3.0 4-argument
	 * mount; MS_DATA is the preferred way and indicates a
	 * 6-argument mount.
	 */
	fstyp = (uap->flags & (MS_DATA|MS_FSS))
	  ? uap->fstyp : mount[0].m_fstyp;
	if (fstyp <= 0 || fstyp >= nfstyp) {
		u.u_error =  EINVAL;
		goto out;
	}
	dataptr = (uap->flags & MS_DATA) ? uap->dataptr : NULL;
	datalen = (uap->flags & MS_DATA) ? uap->datalen : 0;
	if (! fstypsw[fstyp].mount_flag)
		upkern_lock();
	(*fstypsw[fstyp].fs_mount)(bip, mp, uap->flags, dataptr, datalen);
	if (u.u_error)
		goto out;
	mp->m_rflags = 0;
	ip->i_flag |= IMOUNT;
	ip->i_mnton = mp;
	mp->m_inodp = ip;
#ifdef	SECON
	sat_mount( mp, bip );
#endif
	if (ip != bip)
		iput(bip);
	prele(ip);
	mp->m_flags &= ~MINTER;
	mp->m_flags |= MINUSE;
	return;

out:	/* cleanup on error */
	if (ip != bip)
		iput(bip);
	if (ip != NULL) 
		iput(ip);
	if (mp != NULL)
		mp->m_flags = MFREE;
	if (u.u_error == 0)
		u.u_error = EBUSY;
}

/*
 * the umount system call.
 */
sumount()
{
	register struct inode *bip, *ip;
	register struct mount *mp;
	register dev_t dev;
	register special = 0;

	if ( ! auth_umount() )
		return;
	if ((bip = namei(upath, 0)) == NULL)
		return;
	if (bip->i_ftype != IFDIR) {
		if ((bip->i_ftype != IFCHR) &&
		    (bip->i_ftype != IFBLK))  {
			u.u_error = ENOTBLK;
			iput(bip);
			return;
		}
		special = 1;
		dev = bip->i_rdev;
	}
	for (mp = mount; mp < (struct mount *)v.ve_mount; mp++)
		if ((mp->m_flags & MINUSE) && (special ?
	    	  dev == mp->m_dev : bip == mp->m_mount))
			goto found;

	u.u_error = EINVAL;
	iput(bip);
	return;

found:
	iput(bip);
	mp->m_flags &= ~MINUSE;
	mp->m_flags |= MINTER;
	if (! fstypsw[mp->m_fstyp].umount_flag)
		upkern_lock();
	(*fstypsw[mp->m_fstyp].fs_umount)(mp);
	if (u.u_error)
		goto out;
#ifdef SECON
	sat_umount( mp );
#endif 
	ip = mp->m_inodp;
	ip->i_flag &= ~IMOUNT;
	ip->i_mnton = NULL;
	plock(ip);
	iput(ip);
	mp->m_inodp = NULL;

out:
	if (u.u_error) {
		mp->m_flags &= ~MINTER;
		mp->m_flags |= MINUSE;
	} else
		mp->m_flags = MFREE;
}

/*
 * mount root file system
 * iflg is 1 if called from iinit, 0 if from uadmin/remount
 */
srmountfun(iflg)
{
	s5rmount(iflg);
}

/*
 * Unmount root file system
 * (called from uadmin sys call)
 */
srumountfun()
{
	s5rumount();
}

/*
 *
 *	pathconf
 *
 */

pathconf()
{
	register struct inode *ip;
	register struct a {
		char	*path;
		int 	name;
	} *uap;

	uap = (struct a *)u.u_ap;
	if ((ip = namei(upath, 0)) == NULL)
		return;
	iput(ip);
	conf_common( uap->name );
}

/*
 *
 *	fpathconf
 *
 */

fpathconf()
{
	register struct inode *ip;
	register struct file *fp;
	register struct a {
		int	fdes;
		int 	name;
	} *uap;

	uap = (struct a *)u.u_ap;

	if (!(fp = getf(uap->fdes))){
		u.u_error = EBADF;
		return;
	}
	conf_common( uap->name );
}

/*
 *
 *	conf_common     common code for pathconf and fpathconf
 * 
 */

conf_common( name )
int name;
{
	switch(name){

		case _PC_LINK_MAX:
			u.u_rval1 = LINK_MAX;
			break;
		case _PC_MAX_CANON:
			u.u_rval1 = MAX_CANON;
			break;
		case _PC_MAX_INPUT:
			u.u_rval1 = MAX_INPUT;
			break;
		case _PC_NAME_MAX:
			u.u_rval1 = NAME_MAX;
			break;
		case _PC_PATH_MAX:
			u.u_rval1 = PATH_MAX;
			break;
		case _PC_PIPE_BUF:
			u.u_rval1 = PIPE_BUF;
			break;
		case _PC_CHOWN_RESTRICTED:
			u.u_rval1 = _POSIX_CHOWN_RESTRICTED;
			break;
		case _PC_CHOWN_SUP_GRP:	
			u.u_rval1 =  _POSIX_CHOWN_SUP_GRP;
			break;
		case _PC_DIR_DOTS:
			u.u_rval1 = _POSIX_DIR_DOTS;
			break;
		case _PC_GROUP_PARENT:
			u.u_rval1 = _POSIX_GROUP_PARENT;
			break;
		case _PC_NO_TRUNC:
			u.u_rval1 = _POSIX_NO_TRUNC;
			break;
		case _PC_UTIME_OWNER:
			u.u_rval1 = _POSIX_UTIME_OWNER;
			break;
		case _PC_VDISABLE:
			u.u_rval1 = _POSIX_VDISABLE;
			break;
		default:
			u.u_error = EINVAL;
			break;
	}

}

#ifdef FIPS
ftruncate()
{
	register struct file *fp;
	register struct inode *ip;
	register struct s5inode *s5ip;
	struct argnamei nmarg;
	register struct a {
		int fdes;
		off_t length;
	}*uap;			

	uap = (struct a*)u.u_ap;

	/* check if valid file descriptor */
	if ((fp=getf(uap->fdes)) == NULL)
		return;				/* returns EBADF */

	if ((fp->f_flag & FWRITE) == NULL) {
		u.u_error = EINVAL;
		return;
	}

	plock(ip = fp->f_inode);
	if (ip->i_size <= uap->length) {
		u.u_error = EINVAL;
		prele(ip);
		return;
	}

	nmarg.cmd = NI_FTRUNC;
	FS_SETATTR(ip, &nmarg);
	prele(ip);
}
#endif /* FIPS */

#ifdef FIPS
fsync()
{
	register struct file *fp;
	register struct inode *ip;
	struct argnamei nmarg;
	register struct a {
		int fdes;
	}*uap;			

	uap = (struct a*)u.u_ap;

	/* check if valid file descriptor */
	if ((fp=getf(uap->fdes)) == NULL)
		return;				/* returns EBADF */

	plock(ip = fp->f_inode);
	nmarg.cmd = NI_FSYNC;
	FS_SETATTR(ip, &nmarg);
	prele(ip);
}
#endif /* FIPS */
