/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sys2.c: version 25.1 created on 11/27/91 at 15:12:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sys2.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-port:os/sys2.c	10.20"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/fs/s5inode.h"
#include "sys/fstyp.h"
#include "sys/nami.h"
#include "sys/sysinfo.h"
#include "sys/fcntl.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/var.h"
#include "sys/stropts.h"
#include "sys/stream.h"
#include "sys/poll.h"
#include "sys/cmn_err.h"
#include "sys/conf.h"
#include "sys/mfs.h"
#include "sys/flock.h"
#include "sys/own.h"

extern	s5readi(), s5writei();

/*
 * read system call
 */
read()
{
	register struct file *fp;
	register struct inode *ip;
	register struct a {
		int	fdes;
		char	*cbuf;
		unsigned count;
	} *uap;
	register	uint type;
	int 		i;
	int		bcount;
	struct flock 	bf;

	atom_inc(&sysinfo.sysread);
	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	if ((fp->f_flag & FREAD) == 0) {
		u.u_error = EBADF;
		return;
	}
	ip = fp->f_inode;

	if (*(ip)->i_fstypp->fs_readi != s5readi) {
		nons5_rdwr(FREAD);
		return;
	}
	bcount = u.u_ior;

	/* enter inode critical region */
	spin_lock(&inode_sem);
	type = ip->i_ftype;
	u.u_offset = fp->f_offset;
	if ((type != IFCHR) && (type != IFBLK)) {
		while (inode_locked(ip)) {
			inode_want(ip);
			mfs_sleep(ip, PINOD, &inode_sem);
		}
		inode_lock(ip);
	}
	spin_unlock(&inode_sem);

	if (u.u_offset < 0) {
		u.u_error = EINVAL;
		goto exit;
	}
	if ((u.u_count = uap->count) == 0)
		goto exit;
	u.u_base = (caddr_t)uap->cbuf;
	u.u_segflg = 0;
	u.u_fmode = fp->f_flag;

	if (type == IFCHR)  {
		if (setjmp(u.u_qsav)) {
			if(u.u_count == uap->count) {
				if (!u.u_error)
					u.u_error = EINTR;
			}
			else{
				u.u_rval1 = uap->count-u.u_count;
				u.u_ioch += (unsigned)u.u_rval1;
				atom_add(&sysinfo.readch, (unsigned)u.u_rval1);
			}
			goto exit;
		}
		fio_read_raw(ip);
	}
	else {
		if (type == IFREG || type == IFDIR) {
			if (ip->i_locklist != NULL &&
			    locked(1,fp,ip,u.u_offset, u.u_offset + u.u_count))
				goto exit;
			
			if((type == IFREG) && 
			   (((struct s5inode *)(ip->i_fsptr))->s5i_mode &
			    (ISGID|(IEXEC>>3))) == ISGID){
				/* enforce record locking protocol */
				bf.l_type = F_RDLCK;
				bf.l_whence = 0;
				bf.l_start = u.u_offset;
				bf.l_len = u.u_count;
				i = (u.u_fmode & FNDELAY) ? 
					INOFLCK : SLPFLCK|INOFLCK;
				if ((i = reclock(ip, &bf, i, 0, u.u_offset)) ||
				     (bf.l_type != F_UNLCK)) {
					u.u_error = (i == 0) ? EAGAIN : i;
					goto exit;
				}
			}
			fio_read_buffered(ip);
		} else if (type == IFIFO) {
			fp->f_offset = 0;
			u.u_offset = 0;
			fio_read_pipe(ip);
		}
		else if (type == IFBLK)
			fio_read_blocked(ip);
		else
			u.u_error = ENODEV;
	}
	u.u_rval1 = uap->count-u.u_count;
	u.u_ioch += (unsigned)u.u_rval1;
	atom_add(&sysinfo.readch, (unsigned)u.u_rval1);

exit:
	/* unlock inode */
	spin_lock(&inode_sem);
	ip->i_mntdev->m_bcount += u.u_ior - bcount;
	fp->f_offset += u.u_rval1;
	if ((type != IFCHR) && (type != IFBLK)) {
		if (inode_wanted(ip)) {
			inode_unwant(ip);
			mfs_wakeup_all(ip);
		}
		inode_unlock(ip);
	}
	spin_unlock(&inode_sem);
}


/*
 * write system call
 */
write()
{
	register struct file *fp;
	register struct inode *ip;
	register struct a {
		int	fdes;
		char	*cbuf;
		unsigned count;
	} *uap;
	register	uint  type;
	int		bcount;
	int i;
	struct flock bf;

	atom_inc(&sysinfo.syswrite);
	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	if ((fp->f_flag & FWRITE) == 0) {
		u.u_error = EBADF;
		return;
	}
	ip = fp->f_inode;

	if (*(ip)->i_fstypp->fs_writei != s5writei) {
		nons5_rdwr(FWRITE);
		return;
	}
	bcount = u.u_iow;
	u.u_base = (caddr_t)uap->cbuf;
	u.u_count = uap->count;
	u.u_segflg = 0;
	u.u_fmode = fp->f_flag;

	/* enter inode critical region */
	spin_lock(&inode_sem);
	type = ip->i_ftype;
	u.u_offset = fp->f_offset;
	if ((type != IFCHR) && (type != IFBLK)) {
		while (inode_locked(ip)) {
			inode_want(ip);
			mfs_sleep(ip, PINOD, &inode_sem);
		}
		inode_lock(ip);
	}
	spin_unlock(&inode_sem);

	if (fp->f_offset < 0) {
		u.u_error = EINVAL;
		goto exit;
	}

	if (type == IFCHR)  {
		if (setjmp(u.u_qsav)) {
			if(u.u_count == uap->count) {
				if (!u.u_error)
					u.u_error = EINTR;
			}
			else{
				u.u_rval1 = uap->count-u.u_count;
				u.u_ioch += (unsigned)u.u_rval1;
				atom_add(&sysinfo.writech, (unsigned)u.u_rval1);
			}
			goto exit;
		}

		fio_write_raw(ip); 
	}
	else {
		if (type == IFREG || type == IFDIR) {
			/* file locking hook */
			if (ip->i_locklist != NULL  &&
			    locked(1,fp,ip,u.u_offset,u.u_offset + u.u_count))
				goto exit;
			if((type == IFREG) &&
			   (((struct s5inode *)(ip->i_fsptr))->s5i_mode &
			    (ISGID|(IEXEC>>3))) == ISGID){
				/* enforce record locking protocol */

				bf.l_type = F_WRLCK;
				bf.l_whence = 0;
				bf.l_start = u.u_offset;
				bf.l_len = u.u_count;
				i = (u.u_fmode & FNDELAY) ?
					 INOFLCK : SLPFLCK|INOFLCK;
				if ((i = reclock(ip, &bf, i, 0, u.u_offset)) ||
				    (bf.l_type != F_UNLCK)) {
					u.u_error = (i == 0) ? EAGAIN : i;
					goto exit;
				}
			}
	
			if (u.u_fmode & FAPPEND) {
				fp->f_offset = ip->i_size;
				u.u_offset = ip->i_size;
			}
			fio_write_buffered(ip);
			if (u.u_fmode & FSYNC) {
				ip->i_flag |= ISYN;
				FS_IUPDAT(ip, &time, &time);
			}

		} else if (type == IFIFO) {
			fp->f_offset = 0;
			u.u_offset = 0;
			fio_write_pipe(ip);
		}
		else if (type == IFBLK)
			fio_write_blocked(ip);
		else
			u.u_error = ENODEV;
	}

	u.u_rval1 = uap->count-u.u_count;
	u.u_ioch += (unsigned)u.u_rval1;
	atom_add(&sysinfo.writech, (unsigned)u.u_rval1);

exit:
	/* unlock inode */
	spin_lock(&inode_sem);
	ip->i_mntdev->m_bcount += u.u_iow - bcount;
	fp->f_offset += u.u_rval1;
	if ((type != IFCHR) && (type != IFBLK)) {
		if (inode_wanted(ip)) {
			inode_unwant(ip);
			mfs_wakeup_all(ip);
		}
		inode_unlock(ip);
	}
	spin_unlock(&inode_sem);
}



/*
 * getmsg system call
 */
getmsg()
{
	msgio(FREAD);
}


/*
 * putmsg system call
 */
putmsg()
{
	msgio(FWRITE);
}

/*
 * common code for recv and send calls:
 * check permissions, copy in args, preliminary setup,
 * and switch to appropriate stream routine
 */
msgio(mode)
register mode;
{
	register struct file *fp;
	register struct inode *ip;
	register struct a {
		int		fdes;
		struct strbuf	*ctl;
		struct strbuf	*data;
		int		flags;
	} *uap;
	struct strbuf msgctl, msgdata;

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	if (!(fp->f_flag&mode)) {
		u.u_error = EBADF;
		return;
	}
	u.u_segflg = 0;
	u.u_fmode = fp->f_flag;
	ip = fp->f_inode;
	if ((ip->i_ftype != IFCHR) || (ip->i_sptr == NULL)) {
		u.u_error = ENOSTR;
		return;
	}
	if (uap->ctl) {
		if (copyin((caddr_t)uap->ctl, (caddr_t)&msgctl, 
		    sizeof(struct strbuf))) {
			u.u_error = EFAULT;
			return;
		}
	}
	if (uap->data) {
		if (copyin((caddr_t)uap->data, (caddr_t)&msgdata,
		   sizeof(struct strbuf))) {
			u.u_error = EFAULT;
			return;
		}
	}
	if (mode == FREAD) {
		if (!uap->ctl)
			msgctl.maxlen = -1;
		if (!uap->data)
			msgdata.maxlen = -1;
		u.u_rval1 = strgetmsg(ip, &msgctl, &msgdata, uap->flags);
		if (u.u_error)
			return;
		if ((uap->ctl && copyout((caddr_t)&msgctl, (caddr_t)uap->ctl,
				 sizeof(struct strbuf))) ||
		    (uap->data && copyout((caddr_t)&msgdata, (caddr_t)uap->data,
				 sizeof(struct strbuf)))) {
			u.u_error = EFAULT;
			return;
		}
		return;
	}
	/*
	 * FWRITE case 
	 */
	if (!uap->ctl)
		msgctl.len = -1;
	if (!uap->data)
		msgdata.len = -1;
	strputmsg(ip, &msgctl, &msgdata, uap->flags);
}

/*
 * Poll system call
 */

int pollwait;

poll()
{
	register struct uap {
		struct	pollfd *fdp;
		unsigned long nfds;
		long	timo;
	} *uap = (struct uap *)u.u_ap;
	register fdcnt = 0;
	register int i, j, s;

	struct pollfd pollfd[NPOLLFILE];
	caddr_t fdp;
	time_t t;
	int rem;
	struct file *fp;
	int polltime();
	struct strevent *timeproc;
	int id, size;
	int mark;

	if (uap->nfds < 0 || uap->nfds > u.u_rlimit[RLIMIT_NOFILE].rlim_cur) {
		u.u_error = EINVAL;
		return;
	}
	t = lbolt;

	/*
	 * retry scan of fds until an event is found or until the
	 * timeout is reached.
	 */
retry:		

	/*
	 * Polling the fds is a relatively long process.  Set up the SPOLL
	 * flag so that we can see if something happened
	 * to an fd after we checked it but before we go to sleep.
	 */
	atom_or(&u.u_procp->p_flag, SPOLL);

	/*
	 * Check fd's for specified events.   Read in pollfd records in
	 * blocks of NPOLLFILE.  Test each fd in the block
	 * and store the result of the test in the event field of the in-core
	 * record.  After a block of fds is finished, write the result out
	 * to the user.  Note that if no event is found, the whole procedure
	 * will be repeated after awakenening from the sleep
	 * (subject to timeout).
	 */

	mark = uap->nfds;
	size = 0;
	fdp = (caddr_t)uap->fdp;
	for (i = 0; i < uap->nfds; i++) {
		j = i % NPOLLFILE;
		/*
		 * If we have looped back around to the base of pollfd,
		 * write out the results of the strpoll calls kept in pollfd
		 * to the user fdp.  Read in the next batch of fds to check.
		 */
		if (!j) {
			if (i > 0) {
				ASSERT(size == NPOLLFILE*sizeof(struct pollfd));
				if (copyout(pollfd, fdp, size)) {
					u.u_error = EFAULT;
					return;
				}
				fdp += size;
			}
			size = min(uap->nfds - i,
					 NPOLLFILE) * sizeof(struct pollfd);
			if (copyin((caddr_t)fdp, (caddr_t)pollfd, size)) {
				u.u_error = EFAULT;
				return;
			}
		}

		if (pollfd[j].fd < 0) 
			pollfd[j].revents = 0;
		else if ( !(fp = GET_OFILE(pollfd[j].fd)) || 
			  (fp->f_inode->i_ftype != IFCHR) ||
			  !fp->f_inode->i_sptr) 
			pollfd[j].revents = POLLNVAL;
		else {
			pollfd[j].revents = strpoll(fp->f_inode->i_sptr, 
						     pollfd[j].events, fdcnt);
			if (u.u_error) {
				if (!fdcnt) mark = i;
				goto pollout;
			}
		}
		if (pollfd[j].revents && !fdcnt++) mark = i;
	}

	/*
	 * Poll of fds completed.  
	 * Copy out the last batch of events.  If the poll was successful, 
	 * return fdcnt to user.
	 */
	u.u_rval1 = fdcnt;
	if (copyout((caddr_t)pollfd, fdp, size)) {
		u.u_error = EFAULT; 
		return;
	}
	if (fdcnt) 
		goto pollout;

	/*
	 * If you get here, the poll of fds was unsuccessful.
	 * First make sure your timeout hasn't been reached.
	 * If not then sleep and wait until some fd becomes
	 * readable, writeable, or gets an exception.
	 */
	rem = ( (uap->timo < 0) ? 1 : (uap->timo - ((lbolt - t)*1000)/HZ) );
	if (rem <= 0)
		goto pollout;

	s = spl6();
	/*
	 * If anything has happened on an fd since it was checked, it will
	 * have turned off SPOLL.  Check this and rescan if so.
	 */
	if (!(u.u_procp->p_flag & SPOLL)) {
		splx(s);
		goto retry;
	}
	atom_and(&u.u_procp->p_flag, ~SPOLL);

	if (!(timeproc = sealloc(SE_SLEEP))) {
		splx(s);
		u.u_error = EAGAIN;
		goto pollout;
	}
	timeproc->se_procp = u.u_procp;
	if (uap->timo > 0) 
		id = timeout(polltime, timeproc, (rem*HZ+999)/1000);

	/*
	 * The sleep will usually be awakened either by this poll's timeout 
	 * (which will have nulled timeproc), or by the strwakepoll function 
	 * called from a stream head.
	 */
	if (sleep((caddr_t)&pollwait, (PZERO+1)|PCATCH)) {
		if (uap->timo > 0)
			untimeout(id);
		splx(s);
		u.u_error = EINTR;
		sefree(timeproc);
		goto pollout;
	}
	splx(s);
	if (uap->timo > 0)
		untimeout(id);

	/*
	 * If timeproc is not NULL, you were probably awakened because a
	 * write queue emptied, a read queue got data, or an exception
	 * condition occurred.  If so go back up and poll fds again.
	 * Otherwise, you've timed out so you will fall thru and return.
	 */
	if (timeproc->se_procp) {
		sefree(timeproc);
		goto retry;
	}
	sefree(timeproc);

pollout:

	/*
	 * Poll general cleanup code. Go back to all of the streams 
	 * before the mark and reset the wakeup mechanisms that were 
	 * set up during the poll.  
	 */
	atom_and(&u.u_procp->p_flag, ~SPOLL);
	fdp = (caddr_t)uap->fdp;
	for (i = 0; i < mark; i++) {
		j = i % NPOLLFILE;
		/*
		 * Read in next block of pollfds. If the total number of pollfds
		 * is less than NPOLLFILE, don't bother because the pollfds of 
		 * interest are still in the pollfd[] array.
		 */
		if (!j && (uap->nfds > NPOLLFILE)) {
			size = min(uap->nfds - i,
					 NPOLLFILE) * sizeof(struct pollfd);
			if (copyin((caddr_t)fdp, (caddr_t)pollfd, size)) {
				u.u_error = EFAULT;
				return;
			}
			fdp += size;
		}

		if ((pollfd[j].fd < 0)  ||
		    !(fp = GET_OFILE(pollfd[j].fd)) || 
		    (fp->f_inode->i_ftype != IFCHR) || !fp->f_inode->i_sptr)
			continue;
		pollreset(fp->f_inode->i_sptr);
	}
}

/*
 * Removes all event cells that refer to the current process in the
 * given stream's poll list.
 */
pollreset(stp)
register struct stdata *stp;
{
	register struct strevent *psep, *sep, *tmp;
	
	sep = stp->sd_pollist;
	psep = NULL;
	while (sep) {
		tmp = sep->se_next;
		if (sep->se_procp == u.u_procp) {
			if (psep)
				psep->se_next = tmp;
			else
				stp->sd_pollist = tmp;
			sefree(sep);
		}
		sep = tmp;
	}
	/*
	 * Recalculate pollflags
	 */
	stp->sd_pollflags = 0;
	for (sep = stp->sd_pollist; sep; sep = sep->se_next)
		stp->sd_pollflags |= sep->se_events;
}

/*
 * This function is placed in the callout table to time out a process
 * waiting on poll.  If the poll completes, this function is removed
 * from the table.  Its argument is a pointer to a variable which holds
 * the process table pointer for the process to be awakened.  This
 * variable is nulled to indicate that polltime ran.
 */
polltime(timeproc)
struct strevent *timeproc;
{
	register struct proc *p = timeproc->se_procp;

	if (p->p_wchan == (caddr_t)&pollwait) {
		setrun(p);
		timeproc->se_procp = NULL;
	}
}

/*
 * open system call
 */
open()
{
	register struct a {
		char	*fname;
		int	mode;
		int	crtmode;
	} *uap;

	uap = (struct a *)u.u_ap;
	copen(uap->mode-FOPEN, uap->crtmode);
}

/*
 * creat system call
 */
creat()
{
	struct a {
		char	*fname;
		int	fmode;
	} *uap;

	uap = (struct a *)u.u_ap;
	copen(FWRITE|FCREAT|FTRUNC, uap->fmode);
}

/*
 * common code for open and creat.
 * Check permissions, allocate an open file structure,
 * and call the device open routine if any.
 */
copen(mode, arg)
register mode;
{
	register struct inode *ip;
	struct argnamei nmarg;

	if ((mode&(FREAD|FWRITE)) == 0) {
		u.u_error = EINVAL;
		return;
	}
	/* REMOTE - don't do anything if no room */
	if (ufalloc(0) < 0) {
		return;
	}

	if (mode&FCREAT) {
		nmarg.cmd = (mode&FEXCL) ? NI_XCREAT : NI_CREAT;
		nmarg.mode = arg & MODEMSK;
		nmarg.ftype = 0;
		nmarg.idev = -1;
		if ((ip = namei(upath, &nmarg)) == NULL) 
			return;
		if (nmarg.rcode == FSN_FOUND) {
			if ((ip->i_locklist != NULL)  &&
			    (ip->i_ftype == IFREG)   &&
			    locked(2, 0, ip, 0, 1<<30)) {
				iput(ip);
				return;
			}	
			mode &= ~FCREAT;
		}
		else
			mode &= ~FTRUNC;
	} 
	else {
		if ((ip = namei(upath, 0)) == NULL) {
			return; 
		}
	}
	copen1(ip, mode);
}

copen1(ip, mode)
register struct inode *ip;
register mode;
{
	register struct file *fp;
	int i;
	int  savrval2;

	if (!(mode&FCREAT)) {
		if (mode&FREAD)
			FS_ACCESS(ip, IREAD);
		if (mode&(FWRITE|FTRUNC)) {
			FS_ACCESS(ip, IWRITE);
			if (ip->i_ftype == IFDIR)
				u.u_error = EISDIR;
			else if ((mode&FTRUNC)
				 && !FS_ACCESS(ip, IMNDLCK)
				 && (ip->i_filocks != NULL))
				u.u_error = EAGAIN;
		}
	}
	if (u.u_error || (fp = falloc(ip, mode&FMASK)) == NULL) {
		iput(ip);
		return;
	}

	if( mode & FTRUNC ) {
		if ( IS_POSIX() ) { 
			if ( ip->i_ftype != IFIFO )
				ITRUNC(ip);
		}
		else 
			ITRUNC(ip);
	}
	prele(ip);
	i = u.u_rval1;
	savrval2 = u.u_rval2;	/* rval2 is used by syopen */
	u.u_rval2 = 0;
	if (setjmp(u.u_qsav)) {	/* catch half-opens */
		u.u_rval2 = savrval2;
		if( IS_POSIX() ) 
			u.u_error = EINTR;
		else {
			if (u.u_error == 0) 
				u.u_error = EINTR;
		}
		SET_OFILE(i, NULL);
		closef(fp);
	} else {
		OPENI(ip, mode);
		/* rval2 is only set by syopen. */
		/* Normal open restores rval2 and returns */
		if (u.u_rval2 == 0 && u.u_error == 0)
		{
			u.u_rval2 = savrval2;
			return;
		}
		/* if rval2 is set by syopen then ditch this open of /dev/tty */
		/* syopen will have already opened the real tty */
		SET_OFILE(i, NULL);
		unfalloc(fp);
		plock(ip);
		iput(ip);
		u.u_rval2 = savrval2;
	}
}

/*
 * close system call
 */
close()
{
	register struct file *fp;
	register struct a {
		int	fdes;
	}  *uap;
	extern struct   file *getf();

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;
	SET_OFILE(uap->fdes, NULL);
	closef(fp);
}

/*
 * seek system call
 */
seek()
{
	register uint		file_refcnt;
	register struct file	*fp;
	register struct inode	*ip;
	register struct	a {
		int	fdes;
		off_t	off;
		int	sbase;
	}			*uap;
	off_t			offset;
	struct argnotify	noarg;

	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fdes)) == NULL)
		return;

	ip = fp->f_inode;
	if (ip->i_ftype == IFIFO) {
		u.u_error = ESPIPE;
		return;
	}

/* FIX, THIS:
 * resolve how file and inode attributes can be efficiently synchronized
 */

	/* synchronize f_offset */
	if ((file_refcnt = fp->f_count) != 1)
		spin_lock(&inode_sem);

	if (uap->sbase == 1)
		uap->off += fp->f_offset;
	else if (uap->sbase == 2) {
		if (file_refcnt == 1)
			plock(ip);
		else {
			while (inode_locked(ip)) {
				inode_want(ip);
				mfs_sleep(ip, PINOD, &inode_sem);
			}
			inode_lock(ip);
		}
		uap->off += ip->i_size;
		if (file_refcnt == 1)
			prele(ip);
		else {
			if (inode_wanted(ip)) {
				inode_unwant(ip);
				mfs_wakeup_all(ip);
			}
			inode_unlock(ip);
		}
	}
	else if (uap->sbase != 0) {
		if (file_refcnt != 1)
			spin_unlock(&inode_sem);
		u.u_error = EINVAL;
		psignal(u.u_procp, SIGSYS);
		return;
	}
	if (fsinfo[ip->i_fstyp].fs_notify & NO_SEEK) {
		if (file_refcnt != 1)
			spin_unlock(&inode_sem);
		noarg.cmd = NO_SEEK;
		noarg.data1 = uap->off;
		noarg.data2 = uap->sbase;
		offset = FS_NOTIFY(ip, &noarg);
		if (u.u_error)
			return;
		if (file_refcnt != 1)
			spin_lock(&inode_sem);
	}
	else
		offset = uap->off;
	fp->f_offset = offset;
	if (file_refcnt != 1)
		spin_unlock(&inode_sem);
	u.u_roff = offset;
}

/*
 * link system call
 */
link()
{
	register struct inode *ip;
	register struct a {
		char	*target;
		char	*linkname;
	} *uap;
	struct argnamei nmarg;

	u.u_pdir = NULL;
	uap = (struct a *)u.u_ap;
	if ((ip = IS_POSIX() ? namei(upath, 0) : lnamei(upath)) == NULL)
		return;

#ifdef SECON
	if ( FS_ACCESS(ip, ILABELW) )
		goto out;
#endif

	u.u_pdir = ip;
	if (ip->i_ftype == IFDIR && !auth_link())
		goto out;

	if (server())
		return;

	/* if the targe is being used by rename system call
	 * return error.
	 */
	if (ip->i_flag & IRENAME || ip->i_flag & IRENDEL)  {
		u.u_error = EBUSY;
		goto out;
	}

	prele(ip);
	u.u_dirp = (caddr_t)uap->linkname;
	nmarg.cmd = NI_LINK;
	nmarg.idev =  ip->i_dev;
	nmarg.ino =  ip->i_number;
	(void)namei(upath, &nmarg);
	plock(ip);
out:
	iput(ip);
}


/*
 * mknod system call
 */
mknod()
{
	register struct inode *ip;
	register struct a {
		char	*fname;
		int	fmode;
		int	dev;
	} *uap;
	struct argnamei nmarg;

	uap = (struct a *)u.u_ap;
	if ((uap->fmode&IFMT) != IFIFO && !auth_mknod())
		return;
	nmarg.cmd = NI_MKNOD;
	nmarg.mode = uap->fmode&MODEMSK;
	nmarg.ftype = uap->fmode&IFMT;
	nmarg.idev = (dev_t)uap->dev;
	if ((ip = namei(upath, &nmarg)) != NULL)
		iput(ip);
}

/*
 * access system call
 */
saccess()
{
	register svuid, svgid;
	register struct inode *ip;
	register struct a {
		char	*fname;
		int	fmode;
	} *uap;

	uap = (struct a *)u.u_ap;

	/* JTOF - fix ala NIST */
	if ( uap->fmode & ~MODEMSK ) {
		u.u_error = EINVAL;
		return;
	}	

	svuid = u.u_uid;
	svgid = u.u_gid;
	u.u_uid = u.u_ruid;
	u.u_gid = u.u_rgid;
	u.u_ruid = svuid;
	u.u_rgid = svgid;

	if ((ip = namei(upath, 0)) != NULL) {
		if (uap->fmode&(IREAD>>6))
			FS_ACCESS(ip, IREAD);
		if (uap->fmode&(IWRITE>>6))
			FS_ACCESS(ip, IWRITE);
		if (uap->fmode&(IEXEC>>6))
			FS_ACCESS(ip, IEXEC);
		iput(ip);
	}
	svuid = u.u_uid;
	svgid = u.u_gid;
	u.u_uid = u.u_ruid;
	u.u_gid = u.u_rgid;
	u.u_ruid = svuid;
	u.u_rgid = svgid;
}

/*
 * mkdir system call
 */
mkdir()
{
	register struct a {
		char *fname;
		int fmode;
	} *uap;
	struct argnamei nmarg;

	uap = (struct a *)u.u_ap;
	nmarg.cmd = NI_MKDIR;
	nmarg.mode = (uap->fmode & PERMMSK);
	(void) namei(upath, &nmarg);
}

/*
 * rmdir system call
 */
rmdir()
{	struct a {
		char *fname;
	};
	struct argnamei nmarg;

	nmarg.cmd = NI_RMDIR;
	(void) namei(upath, &nmarg);
}

/*
 * getdents system call
 */
getdents()
{
	register struct file *fp;
	register struct a {
		int fd;
		char *buf;
		int nbytes;
	} *uap;
	extern struct file	*getf();


	uap = (struct a *)u.u_ap;
	if ((fp = getf(uap->fd)) == NULL)
		return;
	
	if (fp->f_inode->i_ftype != IFDIR) {
		u.u_error = ENOTDIR;
		return;
	}
	u.u_offset = fp->f_offset;
	u.u_segflg = 0;
	if ( (u.u_rval1 = FS_GETDENTS(fp->f_inode, uap->buf, uap->nbytes)) > 0)
		fp->f_offset = u.u_offset;
	
}



rename()
{
	register struct inode *ip,*newip;
	register struct a {
		char	*oldname;
		char	*newname;
	} *uap;
	struct argnamei nmarg, nmarg1;
	int	i;
	int	idev, ino;

	uap = (struct a *)u.u_ap;
	u.u_pdir = NULL;

	nmarg.cmd = NI_RNM_OLD_CHK;
	nmarg.idev =  0;
	nmarg.ino =  0;

	u.u_dirp = (caddr_t)uap->oldname;
	if ((ip = namei(upath, &nmarg)) == NULL) 
		return;

	ASSERT (ip->i_flag & IRENAME);
	ASSERT (inode_locked(ip));
	ASSERT (ip->i_nlink > 0);

	/* fill up the nmarg structure before calling with namei
	 * with new name.
	 */
	nmarg.idev =  ip->i_dev;
	nmarg.ino =  ip->i_number;

	prele(ip);

	u.u_dirp = (caddr_t)uap->newname;
	nmarg.cmd = NI_RNM_NEW_CHK;
	if ((newip = namei(upath, &nmarg)) != NULL)  {
		/* 0 indicates that new name and old name are the same */
		if (nmarg.ino == 0)  {
			ASSERT(ip == newip);
			newip->i_flag &= ~IRENAME;
			/* decrement the count since we got the inode twice */
			ASSERT (newip->i_count > 1);
			newip->i_count--;
			iput(newip);
			return;
		}
		ASSERT (ip->i_flag & IRENAME);
		ASSERT (newip->i_nlink > 0);
		if (rename_check(ip, newip)) 
			return;

		/* well...all checks are done. delete the newname */
		ASSERT (newip->i_count > 0);
		if (ip->i_ftype == IFDIR)
			nmarg1.cmd = NI_RMDIR;
		else
			nmarg1.cmd = NI_DEL;

		ASSERT (newip->i_flag & IRENAME);

		newip->i_flag &= ~IRENAME;
		newip->i_flag |= IRENDEL;
		iput(newip);

		namei(upath, &nmarg1);
		if (u.u_error)  {
			plock(ip);
			ASSERT (ip->i_flag & IRENAME);
			ip->i_flag &= ~IRENAME;
			iput(ip);
			return;
		}
	}
	else  {
		if (u.u_error == ENOENT)
			u.u_error = 0;
		else  {
			plock(ip);
			ASSERT (ip->i_flag & IRENAME);
			ASSERT (!(ip->i_flag & IRENDEL));
			ASSERT (!(ip->i_flag & IRENLNK));
			ip->i_flag &= ~IRENAME;
			iput(ip);
			return;
		}
	}
	/*
	 * at this stage the new name doesn't exist.  
	 * so link oldname to newname.
	 */
	plock(ip);
	ip->i_flag |= IRENLNK;
	prele(ip);
	nmarg.cmd = NI_LINK;
	(void)namei(upath, &nmarg);
	if (u.u_error)  {
		plock(ip);
		ASSERT (ip->i_flag & IRENAME);
		ip->i_flag &= ~IRENAME;
		ip->i_flag &= ~IRENLNK;
		iput(ip);
		return;
	}

	/* mark the oldname to be deleted */
	plock(ip);
	ASSERT (ip->i_flag & IRENAME);
	ASSERT (ip->i_nlink > 1);
	ip->i_flag &= ~IRENAME;
	ip->i_flag |= IRENDEL;
	ip->i_flag &= ~IRENLNK;
	iput(ip);

	/* well...now delete the oldname */
	u.u_dirp = (caddr_t)uap->oldname;
	nmarg.cmd = NI_DEL;
	nmarg.idev =  0;
	nmarg.ino =  0;
	namei(upath, &nmarg);
}


rename_check(ip, newip)
inode_t *ip;
inode_t *newip;
{
	ASSERT(ip->i_count > 0);
	ASSERT(ip != newip);
	ASSERT(ip->i_flag & IRENAME);

	/* only similar kinds of files can be renamed */
	if (ip->i_ftype != newip->i_ftype)  { 
		if (ip->i_ftype == IFDIR)
			u.u_error = ENOTDIR;
		else if (newip->i_ftype == IFDIR)
			u.u_error = EISDIR;
		else
			u.u_error = EINVAL;
		rename_err (ip,newip);
		return (1);
	}
	/* we should not cross the mount
	 * point.
	 */
	if (ip->i_dev != newip->i_dev) {
		rename_err(ip, newip);
		u.u_error = EXDEV;
		return(1);
	}
	/* pwd cannot be deleted */
	if (ip == u.u_cdir || newip == u.u_cdir) {
		rename_err(ip, newip);
		u.u_error = EINVAL;
		return(1);
	}

	return (0);

}

rename_err(ip, newip)
register inode_t *ip;
register inode_t *newip;
{
	ASSERT (newip->i_flag & IRENAME);
	newip->i_flag &= ~IRENAME;
	iput(newip);
	plock(ip);
	ASSERT (ip->i_flag & IRENAME);
	ip->i_flag &= ~IRENAME;
	ASSERT (ip->i_nlink > 0);
	iput(ip);
}
/*
 * mkfifo system call
 */
mkfifo()
{
	register struct inode *ip;
	register struct a {
		char	*path;
		int	fmode;
	} *uap;
	struct argnamei nmarg;

	uap = (struct a *)u.u_ap;
	nmarg.cmd = NI_MKNOD;
	nmarg.mode = uap->fmode&MODEMSK;
	nmarg.ftype = IFIFO;
	nmarg.idev = (dev_t)0;
	if ((ip = namei(upath, &nmarg)) != NULL)
		iput(ip);
}

symlink()
{
	register struct a {
		char    *target;
		char    *linkname;
	} *uap = (struct a *)u.u_ap;
	struct argnamei nmarg;
	char 		target_buf[PATH_MAX + 1];

	switch (upath(uap->target, target_buf, PATH_MAX + 1)) {
	case -2:
		u.u_error = IS_POSIX() ? ENAMETOOLONG : ENOENT;
		return;
	case -1:
		u.u_error = EFAULT;
		return;
	}

	u.u_dirp = uap->linkname;

	nmarg.cmd = NI_SYMLINK;
	nmarg.mode = (long)target_buf;	/* ARRRGGHHH */

	(void)namei(upath, &nmarg);
}

readlink()
{
	struct a {
		char    *path;
		char    *buf;
		int     bufsize;
	} *uap;
	struct inode 	*ip;

	uap = (struct a *)u.u_ap;

	if (uap->bufsize == 0)
		return;

	if ((ip = lnamei(upath)) == NULL)
		return; 

	if (ip->i_ftype != IFLNK) {
		u.u_error = EINVAL;
		iput(ip);
		return;
	}

	u.u_count = uap->bufsize;
	u.u_base = uap->buf;
	u.u_offset = 0;
	u.u_segflg = 0;

	FS_READI(ip);

	iput(ip);

	u.u_rval1 = uap->bufsize - u.u_count;
}

