/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) symbol.c: version 25.1 created on 11/27/91 at 15:12:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)symbol.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * symbol.c -- handle kernel symbol table
 */

#include "sys/types.h"
#include "sys/spm_mem.h"
#include "sys/sysarix.h"

#define SYM_BIND_LIMIT	0x7ffff		/* symbol binding range limit	*/
#define SYM_LOW_LOCKOUT	0x7ffffffc	/* don't expand addrs less than this */

extern char	*strncpy();


/*
 * symstr -- return a pointer to an exact match to string str, else NULL
 */

kern_sym_t *
strsym(str)
register char	*str;
{
	register kern_sym_t	*kp;
	register int		n;

	for (n = spm_mem.num_syms, kp = spm_mem.symbols; --n >= 0; kp++) {
		if (strncmp(kp->name, str, KSYM_NAME_LEN) == 0)
			return (kp);
	}
	return (NULL);
}

/*
 * findsym -- returns a pointer to the symbol with the given value, or the
 *	one with the next lower value, or NULL.
 */

kern_sym_t *
findsym(value)
uint	value;
{
	register kern_sym_t	*lowp, *highp, *midp;
	register uint		val;
	register int		diff;

	if (spm_mem.num_syms <= 0)
		return (NULL);

	lowp = spm_mem.symbols;
	highp = &spm_mem.symbols[spm_mem.num_syms - 1];
	val = value >> 1;

	do {
		midp = lowp + (((highp - lowp) + 1) >> 1);
							/* avoid wraparound */
		if ((diff = (midp->value >> 1) - val) == 0)
			diff = midp->value - value;	/* same to LSB */

		if (diff > 0)
			highp = midp - 1;
		else if (diff < 0)
			lowp = midp;
		else
			return (midp);			/* exact match */
	} while (lowp < highp);

	if (highp <= spm_mem.symbols)
		return (NULL);				/* too small */

	return (lowp);					/* next lower match */
}

/*
 * symstr -- converts value to string (symbol name)
 *	returns a string with the best symbolic representation of the address
 *
 *	The symbol can have three representations:
 *		exact match:	symbol_name
 *		close match:	symbol_name+offset
 *		no/bad match:	0xVALUE
 *
 *	A bad match occurs when the offset is greater than SYM_BIND_LIMIT,
 *	or when not an exact match and the address is less than SYM_LOW_LOCKOUT.
 */
#ifdef GOT_SPRINTF
char *
symstr(x)
register uint	x;
{
	register kern_sym_t	*sp;
	register uint		delta;
	static char		str[KSYM_NAME_LEN + 12];

	sp = findsym(x);
	if (sp == NULL || (delta = x - sp->value) > SYM_BIND_LIMIT ||
	    (x < SYM_LOW_LOCKOUT && delta))
		sprintf(str, "%08x", x);		/* no/bad match */
	else if (delta == 0) {
		strncpy(str, sp->name, KSYM_NAME_LEN - 1); /* exact match */
		str[KSYM_NAME_LEN - 1] = '\0';
	}
	else
		sprintf(str, "%s+%x", sp->name, delta);

	return (str);
}
#else /* GOT_SPRINTF */
symstr(x)
register uint	x;
{
	register kern_sym_t	*sp;
	register uint		delta;

	sp = findsym(x);
	if (sp == NULL || *sp->name == 0 || (delta = x - sp->value) > SYM_BIND_LIMIT ||
	    (x < SYM_LOW_LOCKOUT && delta))
		printf("%0x", x);		/* no/bad match */
	else if (delta == 0) {
		printf("%s", sp->name);		/* exact match */
	}
	else
		printf("%s+%x", sp->name, delta);
}
#endif /* GOT_SPRINTF */

/*
 * display_sym -- print out a space separated list of symbol translations
 */

void
display_sym(uptr, num)
register uint	*uptr;
register int	num;
{
	while (--num >= 0) {
#ifdef GOT_SPRINTF
	printf("%s%s", symstr(*uptr++), (num > 0 ? " " : ""));
#else /* GOT_SPRINTF */
		symstr(*uptr++);
		if (num > 0)
			printf(" ");
#endif /* GOT_SPRINTF */
	}
}
