/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) swtch.c: version 25.1 created on 11/27/91 at 15:12:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)swtch.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/immu.h"
#include "sys/sysmacros.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/var.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/spl.h"
#include "sys/own.h"
#include "sys/kmem.h"
#include "sys/lio.h"
#include "sys/cmn_err.h"
#include "sys/upkern.h"
#include "sys/sbus.h"
#ifdef	PERF
#include "sys/perf.h"
#include "sys/perfext.h"
#endif	/* PERF */

/*
 * put the current process on
 * the Q of running processes and
 * call the scheduler. (called by trap.c)
 */
qswtch()
{
	ASSERT(u.u_procp->p_stat == SONPROC);
	/*
	 * Swtch will take it from here, changing the p_stat to SRUN
	 * and putting the processs on the runq
	 */
	swtch();
}


/*
 * This routine is called to reschedule the CPU.
 * if the calling process is not in RUN or ONPROC state,
 * arrangements for it to restart must have
 * been made elsewhere, usually by calling via sleep.
 */

extern		runqueues();
extern  char	qrunflag;

void	swtch_continue();
extern char	own_stk_end[];
extern uint	sys_stk_end[];

swtch()
{
	register struct proc	*p;
	uint			dummy;

	p = u.u_procp;

	own.o_switching = 1;
	atom_inc(&sysinfo.pswitch);

	atom_inc(&p->p_nswtch);
	if (p->p_nswtch == 0)
		atom_inc(&p->p_ovfswtch);

	if (p->p_stat == SONPROC) {
		ASSERT(p->p_wchan == 0);
		ASSERT(p->p_running != NO_PM_ID);
		setrq(p);
	}

	if (own.o_fpu_loaded)
		fpu_save();

	if (save(u.u_rsav)) {
		return;
	}
	ASSERT(own.o_spin_lock_cnt == 0);
	/* are we within the u-page's system stack? */
	if ((uint)(&dummy - 4) < ADDR_U || (&dummy + 4) >= sys_stk_end)
		cmn_err(CE_PANIC,
		  "switch: proc=0x%x [%s] stack=0x%x not in (%x to %x)\n",
		  p, u.u_comm, &dummy + 1, ADDR_U, sys_stk_end);

	set_pc_sp(swtch_continue, own_stk_end);
	/*NOTREACHED*/
}

void
swtch_continue()
{
	register struct proc	*p;
	struct proc		*disp();
	extern upkern_t		upkern;
	extern uint		idle_pm_bits;
	
	spl7();

	if (own.o_upkern_proc) {
		ASSERT(is_upkern_lock());
		ASSERT(u.u_procp->p_upkern_cnt);
		own.o_upkern_proc = 0;
		upkern_dec();
	}

#if	USIZE > 1
	{ /* local */
		/* Copy the multiple pages of user area page table info */
		register int	i;

		for (i = USIZE; --i >= 0; ) {
			own_ptbl[pnum(ADDR_U - ADDR_OWN_SEGS) + i] =
			  own_ptbl[pnum(ADDR_OWN_U - ADDR_OWN_SEGS) + i];
			flush_sys_tlb_entry(ADDR_U + btoc(i));
		}
	} /* local */
#else
	own_ptbl[pnum(ADDR_U - ADDR_OWN_SEGS)] =
	  own_ptbl[pnum(ADDR_OWN_U - ADDR_OWN_SEGS)];
	flush_sys_tlb_entry(ADDR_U);
#endif	/* USIZE > 1 */

	spl0();

	if (! (p = disp())) {
		ASSERT(own.o_spin_lock_cnt == 0);

		own.o_is_idle = 1;
		idle_led_off();

		/*
		 * once we go idle the only way we will end up
		 * with a new process is if setrq() explicitly
		 * gives us a new process by changing own.o_curproc
		 */

		while (own.o_curproc == &own.o_proc) {
			/*
			 * currently all streams processing happens within
			 * the upkern.  prevent pms from calling runqueues()
			 * when they don't have a chance of succeeding.
			 */
			if (qrunflag &&
			  ((! upkern.up_cnt) || 
					upkern.up_pm_id == own.o_pm_id)) {
				idle_led_on();
				runqueues();
				idle_led_off();
			}
		}
		ASSERT(! (idle_pm_bits & own.o_id_bit));
		idle_led_on();
		own.o_is_idle = 0;
		own.o_runrun = 0;
		p = own.o_curproc;
	}
	p->p_last_ran_on = own.o_id_bit;
	ASSERT(p->p_running == own.o_pm_id);
	ASSERT(p != &own.o_proc);
	ASSERT(p->p_stat == SONPROC);
	ASSERT(! (p->p_upkern_cnt && ! own.o_upkern_proc));
	ASSERT(! (p->p_upkern_cnt && ! is_upkern_lock()));
	/* process' private user time slice */
#ifdef	PERF
	if (glob_quantum_size > 0)
		p->p_lticks = glob_quantum_size;
	else
#endif	/* PERF */
		p->p_lticks = p->p_quantum;
#ifdef	PERF
	PERF_SLICE_CLAMP(p,p->p_lticks);
#endif	/* PERF */
	own.o_curpri = p->p_pri;
	own.o_switching = 0;
	resume(p->p_ubptbl[0], u.u_rsav, p->p_urde);
}
