/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) subr.c: version 25.1 created on 11/27/91 at 15:12:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)subr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:subr.c	23.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/buf.h"
#include "sys/mount.h"
#include "sys/var.h"
#include "sys/conf.h"
#include "sys/mfs.h"
#include "sys/debug.h"

/*
 * update is the internal name of 'sync'. It goes through the disk
 * queues to initiate sandbagged IO; goes through the I nodes to write
 * modified nodes; and it goes through the mount table to initiate modified
 * super blocks.
 */
update()
{
	register struct inode *ip;
	register struct mount *mp;
	static   struct inode uinode;

	if (uinode.i_flag)
		return;
	uinode.i_flag++;
	uinode.i_ftype = IFBLK;
	for (mp = mount; mp < (struct mount *)v.ve_mount; mp++) {
		if (mp->m_flags & MINUSE) {
			if (! fstypsw[mp->m_fstyp].update_flag)
				upkern_lock();
			(*fstypsw[mp->m_fstyp].fs_update)(mp);
		}
	}
	spin_lock(&inode_sem);
	for (ip = &inode[0]; ip < (struct inode *)v.ve_inode; ip++)  {
		if (inode_locked(ip) == 0 && ip->i_count != 0
		&& (ip->i_flag & (IACC|IUPD|ICHG))) {
			inode_lock(ip);
			ip->i_count++;
			spin_unlock(&inode_sem);
			FS_IUPDAT(ip, &time, &time);
			iput(ip);
			spin_lock(&inode_sem);
		}
	}
	spin_unlock(&inode_sem);
	bflush(NODEV);
	uinode.i_flag = 0;
}

/*
 * Routine which sets a user error; placed in
 * illegal entries in the bdevsw and cdevsw tables.
 */
nodev()
{
	u.u_error = ENODEV;
}

/*
 * Null routine; placed in insignificant entries
 * in the bdevsw and cdevsw tables.
 */
nulldev()
{
}

/*
 * nostrat -- nodev's strategy equivalent
 */
nostrat(bp)
buf_t	*bp;
{
	bp->b_error = ENODEV;
	bp->b_driver_flags |= B_ERROR;
	bp->b_resid = bp->b_bcount;
	iodone(bp);
}

#ifdef notdef
/*
 * Generate an unused major device number.
 */
#define NDEV 128
int
getudev()
{
/*	extern char MAJOR[];*/
	static int next = 0;
	int   maxdevcnt = max(bdevcnt, cdevcnt);


	for ( ; next < NDEV; next++)
		if (MAJOR[next] >= maxdevcnt)
			return(next++);
	return(-1);
}
#endif /* notdef */


/*
 * Find a proc table pointer given a process id.  The code attempts
 * to optimize the case in which repeated calls return successive
 * proc table slots (as with ps(1)) by remembering where the search
 * left off the last time.  Interspersed calls can defeat the
 * optimization but ordinarily this won't happen.
 */

struct proc *
prfind(pid)
register int pid;
{
	register struct proc *p;
	register struct proc *prend = (struct proc *) v.ve_proc;
	static   struct proc *lastp = NULL;

	if (lastp == NULL || lastp >= prend)
		lastp = prend - 1;
	p = lastp;
	do {
		if (++p >= prend)
			p = &proc[0];
		if (p->p_stat != 0 && p->p_pid == pid) {
			lastp = p;
			return(p);
		}
	} while (p != lastp);
	return(NULL);
}
