/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) streamio.c: version 25.1 created on 11/27/91 at 15:12:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)streamio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:streamio.c	2.1"

#include "sys/types.h"
#include "sys/file.h"
#include "sys/sysmacros.h"
#include "sys/param.h"
#include "sys/fs/s5dir.h"
#include "sys/buf.h"
#include "sys/errno.h"
#include "sys/signal.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/conf.h"
#include "sys/debug.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/strstat.h"
#include "sys/inode.h"
#include "sys/var.h"
#include "sys/poll.h"
#include "sys/termio.h"
#include "sys/ttold.h"
#include "sys/own.h"
#include "sys/systm.h"
#include "sys/cmn_err.h"
#include "sys/iopmdebug.h"
#include "sys/iopmstream.h"

/*
 * id value used to distinguish between different ioctl messages
 */
static long ioc_id;

/*
 *  Qinit structure and Module_info structures
 *        for stream head read and write queues
 */
int	strrput(), strwsrv();
struct 	module_info strm_info = { 0, "strrhead", 0, INFPSZ, STRHIGH, STRLOW };
struct  module_info stwm_info = { 0, "strwhead", 0, 0, 0, 0 };
struct	qinit strdata = { strrput, NULL, NULL, NULL, NULL, &strm_info, NULL };
struct	qinit stwdata = { NULL, strwsrv, NULL, NULL, NULL, &stwm_info, NULL };

#define ncopyin(A, B, C, D)	copyin(A, B, C)		/* temporary */
#define ncopyout(A, B, C, D)	copyout(A, B, C)	/* temporary */

/*
 * open a stream device
 */

stropen(ip, flag)
struct inode *ip;
{
	_stropen(ip, flag, 1);
}

_stropen(ip, flag, closeok)
struct inode *ip;
{
	register struct stdata *stp;
	register queue_t *qp;
	register ok;
	register int s;
	register proc_t *p;
	struct stdata *savestp = NULL;
	struct stdata *foundstp = NULL;
	int sav_rval1;
	int icntflg = 0;

	upkern_lock();
	p = u.u_procp;
	PRINT1(OPEN,"stropen: ip %x\n",ip);

retry:
	if (!(ip->i_sptr)) {
		/*
		 * This inode isn't streaming, but another inode
		 * may refer to same device, so look for it in stream
		 * table to avoid building 2 streams to 1 device.
		 */
		s = v.v_nstream - 1;
		for (stp = &streams[s]; s >= 0; stp--, s--) {
			if (!(stp->sd_wrq)) {
				savestp = stp;
				continue;
			}
			if (stp->sd_rdev == ip->i_rdev)
				break;
		}
		if (s >= 0) {	/* found inode already streaming */
			icntflg = 1;
			foundstp = &streams[s];
			if (savestp)
				savestp->sd_wrq = (queue_t *)RESERVED;
		} else {	/* reserve stream */
			if (!savestp) {
				strst.stream.fail++;
				cmn_err(CE_CONT, "stropen: out of streams\n");
				u.u_error = ENOSR;
				return;
			}
			savestp->sd_wrq = (queue_t *)RESERVED;
		}
	}

	/*
	 * If the stream already exists, wait for any open in progress
	 * to complete then call the open function of each module and
	 * driver in the stream.  Otherwise create the stream.
	 */
	if ( (stp = ip->i_sptr) || (stp = foundstp) ) {

		/*
		 * Waiting for stream to be created to device
		 * due to another open
		 */
		if (stp->sd_flag&(STWOPEN|STRCLOSE)) {
			if (sleep((caddr_t)stp, STOPRI|PCATCH)) {
				u.u_error = EINTR;
				goto ckreturn;
			}
			/*
			** This could be the second of 2 inodes, both of which
			** are clones to the same dev. In that case we don't
			** want to reopen the first clone stream, we want to
			** start completely over and clone our own stream.
			*/
			icntflg = 0;
			foundstp = NULL;
			goto retry;  /* could be clone! */
		}
		if ( foundstp )
			ip->i_sptr = foundstp;
		if ( icntflg )
			stp->sd_icnt++;

		if (stp->sd_flag&(STRHUP|STRERR)) {
			u.u_error = EIO;
			goto ckreturn;
		}

		s = splstr();
		stp->sd_flag |= STWOPEN;

		/*
		 * Set up to test if opens create a controlling tty.
		 */
		if (!u.u_ttyp)  {
			if( p->p_session_id != p->p_pid || (flag & FNOCTTY) )
				u.u_ttyp = (short *)-1;
			stp->sd_flag |= CTTYFLG;
		}
		splx(s);

		/*
		 * Open all modules and devices down stream to notify
		 * that another user is streaming.
		 * For modules, set the last argument to MODOPEN and
		 * do not pass any open flags.
		 */
		qp = stp->sd_wrq;
		while (qp = qp->q_next) { 
			if (qp->q_flag & QREADR) break;
			if ((*RD(qp)->q_qinfo->qi_qopen)( RD(qp),
			      notminored(ip->i_rdev), (qp->q_next ? 0 : flag),
			      (qp->q_next ? MODOPEN : 0) ) == OPENFAIL) {
				if (!u.u_error)	u.u_error = ENXIO;
				break;
			}
		}
		if( u.u_ttyp == (short *)-1 )
			u.u_ttyp = 0;
		else if (u.u_ttyp  &&  (stp->sd_flag&CTTYFLG)  &&  !u.u_error) {
			stp->sd_pgrp = *u.u_ttyp;
			u.u_ttyip = ip;
			u.u_procp->p_my_tty = (uint)stp;
		}
		s = splstr();
		stp->sd_flag &= ~(CTTYFLG | STWOPEN);
		splx(s);
ckreturn:
		if (closeok && u.u_error &&
		    stp->sd_icnt == 1 && ip->i_sptr && ip->i_count == 1)
			strclose(ip, flag);
		if (savestp)
			savestp->sd_wrq = NULL;
		wakeup((caddr_t)stp);
		return;
	} 

	/* 
	 * Not already streaming so create a stream to driver
	 */

	if (!(qp = allocq())) {
		if (savestp)
			savestp->sd_wrq = NULL;
		cmn_err(CE_CONT, "stropen: out of queues\n");
		u.u_error = ENOSR;
		return;
	}

	if (savestp) {
		stp = savestp;
		stp->sd_wrq = WR(qp);
	} else {				/* could be clone */
		for (stp = streams; stp < &streams[v.v_nstream]; stp++)
			if (!(stp->sd_wrq)) {
				stp->sd_wrq = WR(qp); /* alloc stream head */
				break;
			}

		PRINT3(OPEN,"hd at %x, hd rqp %x, hd wqp %x\n",stp,qp,WR(qp));

		if (stp >= &streams[v.v_nstream]) {
			strst.stream.fail++;
			cmn_err(CE_CONT, "stropen: out of streams\n");
			freeq(qp);
			u.u_error = ENOSR;
			return;
		}
	}

	/* 
	 * Initialize stream head
	 */
	BUMPUP(strst.stream);
	s = splstr();
	stp->sd_flag = STWOPEN;
	stp->sd_siglist = NULL;
	stp->sd_pollist = NULL;
	stp->sd_pollflags = 0;
	stp->sd_sigflags = 0;
	splx(s);
	stp->sd_icnt = 1;
	stp->sd_rdev = ip->i_rdev;
	stp->sd_pgrp = 0;
	stp->sd_error = 0;
	stp->sd_wroff = 0;
	stp->sd_iocwait = 0;
	stp->sd_iocblk = NULL;
	stp->sd_pushcnt = 0;
	setq(qp, &strdata, &stwdata);
	qp->q_ptr = WR(qp)->q_ptr = (caddr_t)stp;
	stp->sd_strtab = cdevsw[major(ip->i_rdev)].d_str;
	ip->i_sptr = stp;

	/*
	 * Used to find controlling tty
	 */

	if (!u.u_ttyp)  {
		if( p->p_session_id != p->p_pid || (flag & FNOCTTY) )
			u.u_ttyp = (short *)-1;
		stp->sd_flag |= CTTYFLG;
	}

	/*
	 * Open driver and create stream to it (via qattach).  Device opens
	 * may sleep, but must set PCATCH if they do so that signals will
	 * not cause a longjump.  Failure to do this may result in the queues
	 * and stream head not being freed.
	 */
	ok = qattach(stp->sd_strtab, qp, ip->i_rdev, flag);

	/* AUTOPUSH - Ask each driver if it would like the module ldterm
	 * pushed on top of it. Only the tty driver should respond 
	 * affirmatively. Save the u.u_rval1 value before doing the push. It
	 * contains the fd value for the open, but strpush will clear it.
	 */
	if (ok && reason_to_push(ip)) {
		sav_rval1 = u.u_rval1;
		strpush(ip, "ldterm");
		u.u_rval1 = sav_rval1;
		if (u.u_error) {
			ok = 0;
			strclose(ip, flag);
		}
	}

	if( u.u_ttyp ==(short *)-1 )
		u.u_ttyp = 0;
	/*
	 * Wake up others that are waiting for stream to be created.
	 */
	s = splstr();
	stp->sd_flag &= ~STWOPEN;
	splx(s);
	wakeup((caddr_t)stp);

	if (!ok) {
		s = splstr();
		stp->sd_flag |= STRHUP;
		splx(s);
		stp->sd_wrq = NULL; 		/* free stream */
		stp->sd_icnt = 0;
		stp->sd_rdev = -1;
		strst.stream.use--;
		freeq(qp);

		ip->i_sptr = NULL;
		if (!u.u_error)
			u.u_error = ENXIO;
		return;
	}

	/*
	 * Assign process group if controlling tty
	 */
	if (u.u_ttyp && (stp->sd_flag&CTTYFLG)) {
		stp->sd_pgrp = *u.u_ttyp;
		u.u_ttyip = ip;
		u.u_procp->p_my_tty = (uint)stp;
	}
	s = splstr();
	stp->sd_flag &= ~CTTYFLG;
	splx(s);
}




/*
 * Close a stream.  
 * This is called from closef() on the last close of an open stream.
 * Strclean() will already have removed the siglist and pollist
 * information, so all that remains is to remove all multiplexor links
 * for the stream, pop all the modules (and the driver), and free the
 * stream structure.
 */

strclose(ip, flag)
struct inode *ip;
{
	register s;
	register struct stdata *stp;
	register queue_t *qp;
	mblk_t *mp, *tmp;
	int strtime();
	int id;

	upkern_lock();

	ASSERT(ip->i_sptr);

	PRINT(CLOSE,"strclose: ");

	stp = ip->i_sptr;

	s = splstr();
	stp->sd_flag |= STRCLOSE;
	splx(s);

	munlinkall(stp, 1);

	qp = stp->sd_wrq;
	while (qp->q_next) {
		if (!(flag&FNDELAY)) {
			s = splstr();
			stp->sd_flag |= (STRTIME | WSLEEP);
			id = timeout(strtime,stp,STRTIMOUT*HZ);
			/*
			 * sleep until awakened by strwsrv() or strtime() 
			 */
			while ((stp->sd_flag & STRTIME) && qp->q_next->q_count){
				stp->sd_flag |= WSLEEP;
				/* ensure strwsrv gets enabled */
				qp->q_next->q_flag |= QWANTW;
				if (sleep((caddr_t)qp, STIPRI|PCATCH))
					break;
			}
			untimeout(id);
			stp->sd_flag &= ~(STRTIME | WSLEEP);
			splx(s);
		}
		qdetach(RD(qp->q_next), 1, flag);
	}
	flushq(qp, FLUSHALL);
	qp = RD(qp);
	s = splstr();
	mp = qp->q_first;
	qp->q_first = qp->q_last = NULL;
	qp->q_count = 0;

	if (stp->sd_iocblk) {
		freemsg(stp->sd_iocblk);
		stp->sd_iocblk = NULL;
	}
	stp->sd_wrq = NULL;
	stp->sd_rdev = -1;
	stp->sd_icnt = 0;
	stp->sd_pgrp = 0; /* NBB */
	strst.stream.use--;

	chk_runqueue(qp);	/* remove q's from queuerun list */
	chk_bufcall(qp);	/* remove q's from bufcall list */

	freeq(qp);		/* free stream head queue pair */
	splx(s);

	while (mp) {
		tmp = mp->b_next;
		if (mp->b_datap->db_type == M_PASSFP) 
			closef(((struct strrecvfd *)mp->b_rptr)->f.fp);
		freemsg(mp);
		mp = tmp;
	}

	s = splstr();
	ip->i_sptr = NULL;
	stp->sd_flag &= ~STRCLOSE;
	splx(s);
	wakeup((caddr_t)stp);
}


/*
 * Clean up after a process when it closes a stream.  This is called
 * from closef for all closes, whereas strclose is called only for the 
 * last close on a stream.  The pollist and siglist are scanned for entries
 * for the current process, and these are removed.
 */

strclean(ip, count)
struct inode *ip;
int count;
{
	register struct strevent *sep, *psep, *tsep;
	register int s;
	struct stdata *stp;

	upkern_lock();
	stp = ip->i_sptr;
	psep = NULL;
	s = splstr();
	sep = stp->sd_siglist;
	while (sep) {
		if (sep->se_procp == u.u_procp) {
			tsep = sep->se_next;
			if (psep)
				psep->se_next = tsep;
			else
				stp->sd_siglist = tsep;
			sefree(sep);
			sep = tsep;
		}
		else {
			psep = sep;
			sep = sep->se_next;
		}
	}

	psep = NULL;
	sep = stp->sd_pollist;
	while (sep) {
		if (sep->se_procp == u.u_procp) {
			tsep = sep->se_next;
			if (psep)
				psep->se_next = tsep;
			else
				stp->sd_pollist = tsep;
			sefree(sep);
			sep = tsep;
		}
		else {
			psep = sep;
			sep = sep->se_next;
		}
	}
	splx(s);
	if ((ip->i_count == 1) && (count == 1))
		stp->sd_icnt--;
	upkern_unlock();
}


/*
 * Read a stream according to the mode flags in sd_flag:
 *
 * (default mode)              - Byte stream, msg boundries are ignored
 * RMSGDIS (msg discard)       - Read on msg boundries and throw away 
 *                               any data remaining in msg
 * RMSGNODIS (msg non-discard) - Read on msg boundries and put back
 *		                 any remaining data on head of read queue
 *
 * Consume readable messages on the front of the queue until u.u_count
 * is satisfied, the readable messages are exhausted, or a message
 * boundary is reached in a message mode.  If no data was read and
 * the stream was not opened with the NDELAY flag, block until data arrives.
 * Otherwise return the data read and update the count.
 *
 * In default mode a 0 length message signifies end-of-file and terminates
 * a read in progress.  The 0 length message is removed from the queue
 * only if it is the only message read (no data is read).
 *
 * Attempts to read an M_PROTO or M_PCPROTO message results in an 
 * EBADMSG error return.
 */

strread(ip)
struct inode *ip;
{
	register s;
	register struct stdata *stp;
	register mblk_t *bp, *nbp;
	int n;
	char rflg;
	
	upkern_lock();
	PRINT1(READ,"strread: hd rqp %x\n",RD(stp->sd_wrq) );

	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	if (stp->sd_flag&(STRERR|STPLEX)) {
		u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
		return;
	}

	/* loop terminates when u.u_count == 0 */
	rflg = 0;
	for (;;) {
		/*
		 * Job control checks.
		 */
		if (strreadjobchk(u.u_procp,stp,SIGTTIN))
			return;
		s = splstr();
		while (!(bp = getq(RD(stp->sd_wrq)))) {
			if (rflg || (stp->sd_flag&STRHUP)) {
				splx(s);
				return;
			}
			if (strwaitq(stp, READWAIT, u.u_fmode)) {
				if ((stp->sd_flag & OLDNDELAY) && 
						(u.u_error == EAGAIN))  {
					if ( IS_POSIX())  {
						splx(s);
						return;
					}
					if ((u.u_fmode & FNDELAY) )
						u.u_error = 0;
				}
				splx(s);
				return;
			}
			/*
			 * Job control checks.
			 */
			if (strreadjobchk(u.u_procp,stp,SIGTTIN)) {
				splx(s);
				return;
			}
		}
		splx(s);

		if (qready())
			runqueues();

		switch (bp->b_datap->db_type) {

		case M_DATA:

			if ((bp->b_wptr - bp->b_rptr) == 0) {
				/*
				 * if already read data put zero
				 * length message back on queue else
				 * free msg and return 0.
				 */
				if (rflg) 
					putbq(RD(stp->sd_wrq), bp);
				else
					freemsg(bp);
				return;
			}

			rflg = 1;
			while (bp && u.u_count) {
				if (n = min(u.u_count, bp->b_wptr - bp->b_rptr))
					iomove(bp->b_rptr, n, B_READ);
			
				if (u.u_error) {
					freemsg(bp);
					return;
				}

				bp->b_rptr += n;
				while (bp && (bp->b_rptr >= bp->b_wptr)) {
					nbp = bp;
					bp = bp->b_cont;
					freeb(nbp);
				} 
			}
	
	
			/*
			 * The data may have been the leftover of a PCPROTO,
			 * so if none is left reset the STRPRI flag just in case.
			 */
			if (bp) {
				/* 
				 * Have remaining data in message.
				 * Free msg if in discard mode.
				 */
				if (stp->sd_flag & RMSGDIS) {
					freemsg(bp);
					s = splstr();
					stp->sd_flag &= ~STRPRI;
					splx(s);
				} else 
					putbq(RD(stp->sd_wrq),bp);

			} else {
				s = splstr();
				stp->sd_flag &= ~STRPRI;
				splx(s);
			}
	
			/*
			 * Check for signal messages at the front of the read
			 * queue and generate the signal(s) if appropriate.
			 * The only signal that can be on queue is M_SIG at
			 * this point.
			 */
			while (((bp = RD(stp->sd_wrq)->q_first)) &&
				(bp->b_datap->db_type == M_SIG)) {
				bp = getq(RD(stp->sd_wrq));
				switch (*bp->b_rptr) {
				case SIGPOLL:				
					s = splstr();
					if (stp->sd_sigflags & S_MSG) 
						strsendsig(stp->sd_siglist, S_MSG);
					splx(s);
					break;

				default:
					if (stp->sd_pgrp)
						signal(stp->sd_pgrp, *bp->b_rptr);
					break;
				}
				freemsg(bp);
				if (qready())
					runqueues();
			}

			if ((u.u_count == 0) || (stp->sd_flag&(RMSGDIS|RMSGNODIS)))
				return;
			continue;
		
		case M_PROTO:
		case M_PCPROTO:
		case M_PASSFP:
			/*
			 * Only data messages are readable.  
			 * Any others generate an error.
			 */
			u.u_error= EBADMSG;
			putbq(RD(stp->sd_wrq), bp);
			return;

		default:
			/*
			 * Garbage on stream head read queue
			 */
			ASSERT(0);
			freemsg(bp);
			break;
		}
	}
}



/*
 * Stream read put procedure.  Called from downstream driver/module
 * with messages for the stream head.  Data, protocol, and in-stream
 * signal messages are placed on the queue, others are handled directly.
 */

strrput(q, bp)
register queue_t *q;
register mblk_t *bp;
{
	register struct stdata *stp;
	register struct iocblk *iocbp;
	register int s;
	struct stroptions *sop;
	struct copyreq *reqp;
	struct copyresp *resp;

	PRINT2(ROUT,"strrput: rq = %x, mp = %x ",q,bp);
	SPRINT_TYPE(ROUT,bp);
	PRINT(ROUT,"\n");

	stp = (struct stdata *)q->q_ptr;

	ASSERT(!(stp->sd_flag & STPLEX));

	switch (bp->b_datap->db_type) {

	case M_DATA:
	case M_PROTO:
	case M_PCPROTO:
	case M_PASSFP:
		s = splstr();
		if (bp->b_datap->db_type == M_PCPROTO) {
			/*
			 * Only one priority protocol message is allowed at the
			 * stream head at a time.
			 */
			if (stp->sd_flag & STRPRI) {
				freemsg(bp);
				splx(s);
				return;
			}
			stp->sd_flag |= STRPRI;
			if (stp->sd_sigflags & S_HIPRI)
				strsendsig(stp->sd_siglist, S_HIPRI);
			if (stp->sd_pollflags & POLLPRI) 
				strwakepoll(stp, POLLPRI);
		} else if (!q->q_first) {
			if (stp->sd_sigflags & S_INPUT)
				strsendsig(stp->sd_siglist, S_INPUT);
			if (stp->sd_pollflags & POLLIN) 
				strwakepoll(stp, POLLIN);
		}

		/* 
		 * Wake sleeping read/getmsg
		 */
		if (stp->sd_flag & RSLEEP) {
			char oldpri;

			stp->sd_flag &= ~RSLEEP;
			oldpri = own.o_curpri;
			own.o_curpri = STIPRI; /* no preemption */
			wakeup((caddr_t)q);
			own.o_curpri = oldpri;
		}
		splx(s);

		putq(q, bp);
		return;


	case M_ERROR:
		/* 
		 * An error has occured downstream, the errno is in the first
		 * byte of the message.
		 */
		if (*bp->b_rptr != 0) {
			s = splstr();
			stp->sd_flag |= STRERR;
			stp->sd_error = *bp->b_rptr;
			splx(s);
			wakeup((caddr_t)q);	/* the readers */
			wakeup((caddr_t)WR(q));	/* the writers */
			wakeup((caddr_t)stp);	/* the ioctllers */

			s = splstr();
			strwakepoll(stp, POLLERR);
			splx(s);
			
			bp->b_datap->db_type = M_FLUSH;
			*bp->b_rptr = FLUSHRW;
			qreply(q, bp);
			return;
		}
		freemsg(bp);
		return;

	case M_HANGUP:
		freemsg(bp);
		s = splstr();
		stp->sd_error = ENXIO;
		stp->sd_flag |= STRHUP;
		splx(s);

		/*
		 * send signal if controlling tty
		 */
		if (stp->sd_pgrp)
			signal(stp->sd_pgrp, SIGHUP);

		wakeup((caddr_t)q);	/* the readers */
		wakeup((caddr_t)WR(q));	/* the writers */
		wakeup((caddr_t)stp);	/* the ioctllers */

		/*
		 * wake up read, write, and exception pollers and
		 * reset wakeup mechanism.
		 */
		s = splstr();
		strwakepoll(stp, POLLHUP);
		splx(s);
		return;


	case M_SIG:
		/*
		 * Someone downstream wants to post a signal.  The
		 * signal to post is contained in the first byte of the
		 * message.  If the message would go on the front of
		 * the queue, send a signal to the process group
		 * (if not SIGPOLL) or to the siglist processes
		 * (SIGPOLL).  If something is already on the queue,
		 * just enqueue the message.
		 */
		if (q->q_first) {
			putq(q, bp);
			return;
		}
		/* flow through */

	case M_PCSIG:
		/*
		 * Don't enqueue, just post the signal.
		 */
		switch (*bp->b_rptr) {
		case SIGPOLL:
			s = splstr();
			if (stp->sd_sigflags & S_MSG) 
				strsendsig(stp->sd_siglist, S_MSG);
			splx(s);
			break;

		default:
			if (stp->sd_pgrp)
				signal(stp->sd_pgrp, *bp->b_rptr);
			break;
		}
		freemsg(bp);
		return;

	case M_FLUSH:
		/*
		 * Flush queues.  The indication of which queues to flush
		 * is in the first byte of the message.  If the read queue 
		 * is specified, then flush it.
		 */
		if (*bp->b_rptr & FLUSHR) {
			mblk_t *mp, *tmp;
			register s;
			int  wantw;

			s = splstr();
			mp = q->q_first;
			q->q_first = q->q_last = NULL;
			q->q_count = 0;
			wantw = q->q_flag & QWANTW;
			q->q_flag &= ~(QFULL | QWANTW);
			splx(s);
			while (mp) {
				tmp = mp->b_next;
				if (mp->b_datap->db_type == M_PASSFP) 
					closef(((struct strrecvfd *)mp->b_rptr)->f.fp);
				freemsg(mp);
				mp = tmp;
			}

			if (wantw) {
				s = splstr();
				/* find nearest back queue with service proc */
				for (q = backq(q); q && !q->q_qinfo->qi_srvp;
				     q = backq(q))
					;
				if (q)
					qenable(q);
				splx(s);
			}
		}
		if (*bp->b_rptr & FLUSHW) {
			*bp->b_rptr &= ~FLUSHR;
			qreply(q, bp);
			return;
		}
		freemsg(bp);
		return;

	case M_IOCACK:
	case M_IOCNAK:
		iocbp = (struct iocblk *)bp->b_rptr;
		/*
		 * if not waiting for ACK or NAK then just free msg
		 * if already have ACK or NAK for user then just free msg
		 * if incorrect id sequence number then just free msg
		 */
		s = splstr();
		if ((stp->sd_flag&IOCWAIT)==0 || stp->sd_iocblk || (stp->sd_iocid != iocbp->ioc_id)) {
			freemsg(bp);
			splx(s);
			return;
		}

		/*
		 * assign ACK or NAK to user and wake up
		 */
		stp->sd_iocblk = bp;
		splx(s);
		wakeup((caddr_t)stp);
		return;

	case M_COPYIN:
	case M_COPYOUT:
		reqp = (struct copyreq *)bp->b_rptr;

		/*
		 * if not waiting for ACK or NAK then just fail request
		 * if already have ACK, NAK, or copy request, then just fail request
		 * if incorrect id sequence number then just fail request
		 */

		s = splstr();
		if ((stp->sd_flag&IOCWAIT)==0 || stp->sd_iocblk || (stp->sd_iocid != reqp->cq_id)) {
			if (bp->b_cont) {
				freemsg(bp->b_cont);
				bp->b_cont = NULL;
			}
			bp->b_datap->db_type = M_IOCDATA;
			resp = (struct copyresp *)bp->b_rptr;
			resp->cp_rval = (caddr_t)1;	/* failure */
			splx(s);
			(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
			if (qready())
				runqueues();
			return;
		}

		/*
		 * assign copy request to user and wake up
		 */
		stp->sd_iocblk = bp;
		splx(s);
		wakeup((caddr_t)stp);
		return;

	case M_SETOPTS:
		/*
		 * Set stream head options (read option, write offset,
		 * min/max packet size, and/or high/low water marks for 
		 * the read side only).
		 */

		ASSERT((bp->b_wptr - bp->b_rptr) == sizeof(struct stroptions));
		sop = (struct stroptions *)bp->b_rptr;
		s = splstr();
		if (sop->so_flags & SO_READOPT) {
			switch (sop->so_readopt) {
			case RNORM: 
				stp->sd_flag &= ~(RMSGDIS | RMSGNODIS);
				break;
			case RMSGD:
				stp->sd_flag = (stp->sd_flag & ~RMSGNODIS) | RMSGDIS;
				break;
			case RMSGN:
				stp->sd_flag = (stp->sd_flag & ~RMSGDIS) | RMSGNODIS;
				break;
			}
		}
				
		if (sop->so_flags & SO_WROFF)
			stp->sd_wroff = sop->so_wroff;
		if (sop->so_flags & SO_MINPSZ)
			q->q_minpsz = sop->so_minpsz;
		if (sop->so_flags & SO_MAXPSZ)
			q->q_maxpsz = sop->so_maxpsz;
		if (sop->so_flags & SO_HIWAT)
			q->q_hiwat = sop->so_hiwat;
		if (sop->so_flags & SO_LOWAT)
			q->q_lowat = sop->so_lowat;
		if (sop->so_flags & SO_MREADON)
			stp->sd_flag |= SNDMREAD;
		if (sop->so_flags & SO_MREADOFF)
			stp->sd_flag &= ~SNDMREAD;
		if (sop->so_flags & SO_NDELON)
			stp->sd_flag |= OLDNDELAY;
		if (sop->so_flags & SO_NDELOFF)
			stp->sd_flag &= ~OLDNDELAY;
		if (sop->so_flags & SO_TOSTOPON)
			stp->sd_flag |= STRTOSTOP;
		if (sop->so_flags & SO_TOSTOPOFF)
			stp->sd_flag &= ~STRTOSTOP;

		freemsg(bp);

		if ((q->q_count <= q->q_lowat) && (q->q_flag & QWANTW)) {
			q->q_flag &= ~QWANTW;
			for (q = backq(q); q && !q->q_qinfo->qi_srvp; q = backq(q))
				;
			if (q)
				qenable(q);
		}
		splx(s);

		return;

	/*
	 * The following set of cases deal with situations where two stream
	 * heads are connected to each other (twisted streams).  These messages
	 * should never originate at a driver or module.
	 */
	case M_BREAK:
	case M_CTL:
	case M_DELAY:
	case M_START:
	case M_STOP:
	case M_IOCDATA:
		freemsg(bp);
		return;

	case M_IOCTL:
		/*
		 * Always NAK this condition
		 * (makes no sense)
		 */
		bp->b_datap->db_type = M_IOCNAK;
		qreply(q, bp);
		return;

	default:
		ASSERT(0);
		freemsg(bp);
		return;
	}
}


/*
 * Send SIGPOLL signal to all processes registered on the given signal
 * list that want a signal for the specified event.  Always called at
 * splstr().
 */

strsendsig(siglist, event)
register struct strevent *siglist;
register event;
{
	struct strevent *sep;

	for (sep = siglist; sep; sep = sep->se_next) {
		if (sep->se_events & event)
			psignal(sep->se_procp, SIGPOLL);
	}
}


/*
 * Wake up all processes sleeping on a poll for the given events
 * on this stream.  POLLERR and POLLHUP cause a wakeup of all processes
 * regardless of the events they were looking for.  Remove all of
 * the event cells matching the given events from the pollist.
 * Always called at splstr().
 */

strwakepoll(stp, events)
struct stdata *stp;
{
	register struct strevent *sep, *psep;

	stp->sd_pollflags &= ~events;
	sep = stp->sd_pollist;
	psep = NULL;
	while (sep) {
		if ((sep->se_events & events) || (events & (POLLHUP|POLLERR|POLLNVAL))) {
			if (sep->se_procp->p_wchan == (caddr_t)&pollwait)
				setrun(sep->se_procp);
			else
				atom_and(&sep->se_procp->p_flag, ~SPOLL);
			if (psep){
				psep->se_next = sep->se_next;
				sefree(sep);
				sep = psep->se_next;
			} else  {
				stp->sd_pollist = sep->se_next;
				sefree(sep);
				sep = stp->sd_pollist;
			}
		} else {
			psep = sep;
			sep = sep->se_next;
		}
	}
}



/*
 * Write attempts to break the read request into messages conforming
 * with the minimum and maximum packet sizes set downstream.  
 *
 * Write will always attempt to get the largest buffer it can to satisfy the
 * message size. If it can not, then it will try up to 2 classes down to try
 * to satisfy the write. Write will not block if downstream queue is full and
 * O_NDELAY is set, otherwise it will block waiting for the queue to get room.
 * 
 * A write of zero bytes gets packaged into a zero length message and sent
 * downstream like any other message.
 *
 * If buffers of the requested sizes are not available, the write will
 * sleep until the buffers become available.
 *
 * Write (if specified) will supply a write offset in a message if it
 * makes sense. This can be specified by downstream modules as part of
 * a M_SETOPTS message. Write will not supply the write offset if it
 * cannot supply any data in a buffer. In other words, write will never
 * send down a empty packet due to a write offset.
 */

strwrite(ip)
struct inode *ip;
{
	register s;
	register struct stdata *stp;
	mblk_t *mp;
	struct strbuf mctl, mdata;
	short rmin, rmax;
	char waitflag;
	mblk_t *strmakemsg();
	int tempmode;

	upkern_lock();

	PRINT1(WRITE,"strwrite: ip = %x\n",ip);

	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	if (stp->sd_flag & STRHUP) {	/* for POSIX complience */
		u.u_error = EIO;
		return;
	}
	if (stp->sd_flag & (STRERR|STPLEX)) {
		u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
		return;
	}

	mctl.len = -1;

	/*
	 * Check the min/max packet size constraints.  If min packet size
	 * is non-zero, the write cannot be split into multiple messages
	 * and still guarantee the size constraints. 
	 */
	rmin = stp->sd_wrq->q_next->q_minpsz;
	rmax = stp->sd_wrq->q_next->q_maxpsz;
	ASSERT(rmax);
	if (rmax == 0)
		return;
	if (rmax == INFPSZ) 
		rmax = strmsgsz;
	else
		rmax = min(strmsgsz, rmax);

	if ((rmin > 0) && ((u.u_count < rmin) || (u.u_count > rmax))) {
		u.u_error = ERANGE;
		return;
	}

	/*
	 * do until count satisfied or error
	 */
	waitflag = WRITEWAIT;
	if (stp->sd_flag & OLDNDELAY)
		tempmode = u.u_fmode & ~FNDELAY;
	else
		tempmode = u.u_fmode;

	do {
		/*
		 * Job control checks.
		 */
		if (strwritejobchk(u.u_procp,stp,SIGTTOU))
			return;
		s = splstr();
		while (!canput(stp->sd_wrq->q_next)) {
			if (strwaitq(stp, waitflag, tempmode)) {
				splx(s);
				return;
			}
			/*
			 * Job control checks.
			 */
			if (strwritejobchk(u.u_procp,stp,SIGTTOU)) {
				splx(s);
				return;
			}
		}
		splx(s);

		/*
		 * Determine the size of the next message to be
		 * packaged.  May have to break write into several
		 * messages based on max packet size.
		 */
		mdata.len = min(u.u_count, rmax);
		mdata.buf = u.u_base;

		if (!(mp = strmakemsg(&mctl, &mdata, stp->sd_wroff, 0)))
			return;

		u.u_base += mdata.len;
		u.u_count -= mdata.len;

		/*
		 * Put block downstream
		 */
		PRINT3(WRITE, "strwrite: call \"%s\" wput (%x) for mp %x\n",
		  stp->sd_wrq->q_next->q_qinfo->qi_minfo->mi_idname,
		  stp->sd_wrq->q_next->q_qinfo->qi_putp, mp);

		(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, mp);
		waitflag |= NOINTR;
		if (qready())
			runqueues();

	} while (u.u_count);
}



/*
 * Stream head write service routine.
 * Its job is to wake up any sleeping writers when a queue
 * downstream needs data (part of the flow control in putq and getq).
 * It also must wake anyone sleeping on a poll().
 * For stream head right below mux module, it must also invoke put procedure
 * of next downstream module
 */

strwsrv(q)
register queue_t *q;
{
	register struct stdata *stp;
	register int s;

	PRINT1(ROUT,"strwsrv: q = %x\n",q);

	stp = (struct stdata *)q->q_ptr;

	ASSERT(!(stp->sd_flag & STPLEX));

	s = splstr();
	if (stp->sd_flag & WSLEEP) {
		char oldpri;

		stp->sd_flag &= ~WSLEEP;
		oldpri = own.o_curpri;
		own.o_curpri = STOPRI;
		wakeup((caddr_t)q);
		own.o_curpri = oldpri;
	}
	if (stp->sd_sigflags & S_OUTPUT)
		strsendsig(stp->sd_siglist, S_OUTPUT);
	if (stp->sd_pollflags & POLLOUT)
		strwakepoll(stp, POLLOUT);
	splx(s);
}


/*
 * ioctl for streams
 */

strioctl(ip, cmd, arg, flag)
struct inode *ip;
int arg;
int flag;
{
	register struct stdata *stp;
	register int s;
	ushort temp_group;
	struct strioctl strioc;
	char *fmt = NULL;
	void init_iopmscb();

	upkern_lock();

	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	PRINT4(IOCTL,"strioctl: ip = %x, cmd = %x, arg = %x, flag = %x\n",ip,cmd,arg,flag);

	if (stp->sd_flag & (STRERR|STPLEX)) {
		u.u_error = ((stp->sd_flag & STPLEX) ? EINVAL : stp->sd_error);
		return;
	}

	switch (cmd) {

	default:
		if (((cmd&IOCTYPE) == LDIOC) || 
		    ((cmd&IOCTYPE) == tIOC) ||
		    ((cmd&IOCTYPE) == TIOC) ) {

			/*
			 * The ioctl is a tty ioctl - set up strioc buffer 
			 * and call strdoioctl() to do the work.
			 */
			if (stp->sd_flag & STRHUP) {
				u.u_error = ENXIO;
				return;
			}
			strioc.ic_cmd = cmd;
			strioc.ic_timout = INFTIM;

			switch (cmd) {
				case TCXONC:
				case TCSBRK:
				case TCFLSH:
					/*
					 * Job control checks.
					 */
					if (strioctljobchk(u.u_procp,stp,
								SIGTTOU))
						return (0);
					/* fall thru */
				case TCDSET:
					strioc.ic_len = sizeof(int);
					strioc.ic_dp = (char *)&arg;
					strdoioctl(stp,&strioc,K_TO_K,STRINT);
					return;

				case TCSETA:
				case TCSETAW:
				case TCSETAF:
					/*
					 * Job control checks.
					 */
					if (strioctljobchk(u.u_procp,stp,
								SIGTTOU))
						return (0);
					strioc.ic_len = sizeof(struct termio);
					strioc.ic_dp = (char *)arg;
					strdoioctl(stp,&strioc,U_TO_K,STRTERMIO);
					return;

				case LDSETT:
					strioc.ic_len = sizeof(struct termcb);
					strioc.ic_dp = (char *)arg;
					strdoioctl(stp, &strioc, U_TO_K, STRTERMCB);
					return;

				case TIOCSETP:
					/*
					 * Job control checks.
					 */
					if (strioctljobchk(u.u_procp,stp,
								SIGTTOU))
						return (0);
					strioc.ic_len = sizeof(struct sgttyb);
					strioc.ic_dp = (char *) arg;
					strdoioctl(stp,&strioc,U_TO_K,STRSGTTYB);
					return;

				case TCGETA:
					fmt = STRTERMIO;
				case LDGETT:
					if (!fmt) fmt = STRTERMCB;
				case TIOCGETP:
					if (!fmt) fmt = STRSGTTYB;
					strioc.ic_len = 0;
					strioc.ic_dp = (char *)arg;
					strdoioctl(stp, &strioc, U_TO_K, fmt);
					return;

				case TCSETPGRP:
				{
					register struct proc *p;

					if (copyin(arg, &temp_group, 
							sizeof temp_group))
					{
						u.u_error = EINVAL;
						return;
					}
					if ((temp_group < 0) || 
						(temp_group > MAXPID) ) {
						u.u_error = EINVAL;
						return;
					}
					if((u.u_ttyp == NULL) || 
					    (u.u_procp->p_my_tty!=(uint)stp)) {
						u.u_error = ENOTTY;
						return;
					}
					for (p = &proc[1];  
					p < (struct proc *)v.ve_proc; p++) {
		   				 if( (temp_group == p->p_pgrp) 
						 || (temp_group == p->p_pid))
						  if(u.u_procp->p_session_id != 
						        p->p_session_id){
							u.u_error = EPERM;
							return;
						   }
					}
					stp->sd_pgrp = temp_group;
					*u.u_ttyp = temp_group;
					return;
				}

				case TCGETPGRP:
					if(u.u_ttyp == NULL){
						u.u_error = ENOTTY;
						return;
					}
					if (stp != (struct stdata *)
					  u.u_procp->p_my_tty) {
						u.u_error = ENOTTY;
						return;
					}
					if (copyout(&stp->sd_pgrp, arg, 
							sizeof stp->sd_pgrp))
						u.u_error = EFAULT;
					return;
			}
		}

		/*
		 * unknown cmd - send down request to support 
		 * transparent ioctls
		 */

		strioc.ic_cmd = cmd;
		strioc.ic_timout = INFTIM;
		strioc.ic_len = TRANSPARENT;
		strioc.ic_dp = (char *)&arg;
		strdoioctl(stp, &strioc, K_TO_K, NULL);
		return;

	case I_STR:
		/*
		 * Stream ioctl.  Read in an strioctl buffer from the user
		 * along with any data specified and send it downstream.
		 * Strdoioctl will wait allow only one ioctl message at
		 * a time, and waits for the acknowledgement.
		 */

		if (stp->sd_flag & STRHUP) {
			u.u_error = ENXIO;
			return;
		}
		if (ncopyin((caddr_t)arg, (caddr_t)&strioc, sizeof(struct strioctl), STRIOCTL)) {
			u.u_error = EFAULT;
			return;
		}
		if (strioc.ic_len < 0 || strioc.ic_timout < -1) {
			u.u_error = EINVAL;
			return;
		}

		strdoioctl(stp, &strioc, U_TO_K, NULL);

		if (ncopyout((caddr_t)&strioc, arg, sizeof(struct strioctl), STRIOCTL))
			u.u_error = EFAULT;
		return;


	case I_NREAD:
		/*
		 * return number of bytes of data in first message
		 * in queue in "arg" and return the number of messages
		 * in queue in return value
		 */
		{
			int size = 0;
			mblk_t *bp;

			if (bp = RD(stp->sd_wrq)->q_first)
				size = msgdsize(bp);
			if (ncopyout(&size, (int *)arg, sizeof(size), STRINT))
				u.u_error = EFAULT;
			u.u_rval1 = qsize(RD(stp->sd_wrq));
			return;
		}

	case I_FIND:
		/*
		 * get module name
		 */
		{
			char mname[FMNAMESZ+1];
			queue_t *q;
			int i;

			if (ncopyin((caddr_t)arg, mname, FMNAMESZ+1, STRNAME)) {
				u.u_error = EFAULT;
				return;
			}
	
			/*
			 * find module in fmodsw
			 */
			/* send command to IOPM. check there first */
			if ( stp->sd_flag & REMOTE )
			{
				strioc.ic_cmd = cmd;
				strioc.ic_dp = mname;
				strioc.ic_len = FMNAMESZ+1;
				strioc.ic_timout = 0;
				strdoioctl( stp, &strioc, K_TO_K, STRNAME );
				/* strdoioctl will set u.u_rval1 and */
				/* u.u_error (if strioc.ic_error set) */
				/* if mod pushed on IOPM or error set return */
				if ( u.u_rval1 == 1 || u.u_error )
					return;
			}

			/* mod may exist on IOPM but is not pushed */
			if ((i = findmod(mname)) < 0) {
				if ( u.u_rval1 == -1 )
				{
					/* mod doesn't exist either place */
					u.u_rval1 = 0;
					u.u_error = EINVAL;
				}
				else
					/* mod exists (not pushed) on IOPM */
					u.u_rval1 = 0;
				return;
			}
	
			u.u_rval1 = 0;
	
			/* look downstream to see if module is there */
			for (q = stp->sd_wrq->q_next; q &&
			     (fmodsw[i].f_str->st_wrinit != q->q_qinfo); q = q->q_next)
				;

			u.u_rval1 = ( q ? 1 : 0);
			return;
		}

	case I_PUSH:
		/*
		 * Push a module
		 */

		{
			char mname[FMNAMESZ+1];

			if (stp->sd_flag & STRHUP) {
				u.u_error = ENXIO;
				return;
			}
			/* stp->sd_pushcnt applies to the complete stream, */
			/* the kernel part and the IOPM part */
			if (stp->sd_pushcnt >= nstrpush) {
				u.u_error = EINVAL;
				return;
			}
			
			/*
			 * get module name and look up in fmodsw
			 */
			if (ncopyin((caddr_t)arg, mname, FMNAMESZ+1, STRNAME)) {
				u.u_error = EFAULT;
				return;
			}
	
			while (stp->sd_flag & STWOPEN) {
				if (sleep((caddr_t)stp, STOPRI|PCATCH)) {
					u.u_error = EINTR;
					return;
				}
				if (stp->sd_flag & (STRERR|STRHUP|STPLEX)) {
					u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
					return;
				}
			}
			s = splstr();
			stp->sd_flag |= STWOPEN;

			/*
			 * Set up to test if the push creates a controlling tty.
			 */
			if (!u.u_ttyp) {
				if( u.u_procp->p_session_id != u.u_procp->p_pid)
					u.u_ttyp = (short *)-1;
				stp->sd_flag |= CTTYFLG;
			}
			splx(s);

			/*
			 * push new module and call its open routine via qattach
			 */
			strpush(ip, mname);

			/*
			 * if controlling tty established mark the 
			 * process group and tty inode pointer.
			 */
			if(u.u_ttyp == (short *)-1)
				u.u_ttyp =  (short *)0;
			else if (u.u_ttyp && (stp->sd_flag&CTTYFLG) &&
			  !u.u_error) {
				stp->sd_pgrp = *u.u_ttyp;
				u.u_ttyip = ip;
				u.u_procp->p_my_tty = (uint)stp;
			}

			s = splstr();
			stp->sd_flag &= ~(CTTYFLG | STWOPEN);
			splx(s);
			wakeup((caddr_t)stp);
			return;
		}


	case I_POP:
		/*
		 * Pop module ( if module exists )
		 */
	{
		struct iopmscb  iopmscb;

		if (stp->sd_flag&STRHUP) {
			u.u_error = ENXIO;
			return;
		}
		if (stp->sd_wrq->q_next->q_next && 
		    !(stp->sd_wrq->q_next->q_next->q_flag & QREADR)) {
			qdetach(RD(stp->sd_wrq->q_next), 1, 0);
			stp->sd_pushcnt--;
			return;
		}

		/* if the first module is the IOPM driver */
		if ( stp->sd_flag & REMOTE &&
		     !stp->sd_wrq->q_next->q_next )
		{
			/* send the command down to detach the first module */
			/* under the IOPM psuedo head */
			init_iopmscb(&iopmscb);

			strioc.ic_cmd = cmd;
			strioc.ic_dp = (char *)&iopmscb;
			strioc.ic_len = sizeof iopmscb;
			strioc.ic_timout = -1;
			strdoioctl( stp, &strioc, K_TO_K, NULL );
			/* strdoioctl will set u.u_error (if strioc.ic_error set) */
			if ( !u.u_error )
				stp->sd_pushcnt--;
			return;
		}

		u.u_error = EINVAL;
		return;
	}


	case I_LOOK:
		/*
		 * Get name of first module downstream
		 * If no module (return error)
		 */
		{
			int i;

			for (i=0; i<fmodcnt; i++)
				if(fmodsw[i].f_str->st_wrinit==stp->sd_wrq->q_next->q_qinfo) {
					if (ncopyout(fmodsw[i].f_name,(char *)arg,FMNAMESZ+1, STRNAME))
						u.u_error = EFAULT;
					return;
				}

			/* not found in kernel, try IOPM */
			strioc.ic_cmd = cmd;
			/* this will cause a copyin from arg which isn't needed */
			/* but this works nicely for the return */
			strioc.ic_dp = (char *)arg;
			strioc.ic_len = FMNAMESZ + 1;
			strioc.ic_timout = 0;
			strdoioctl( stp, &strioc, U_TO_K, STRNAME );
			/* strdoioctl will copyout mod name if no error */
			/* strdoioctl will set u.u_error (if strioc.ic_error set) */
			return;
		}


	case I_LINK:
		/* 
		 * link a multiplexer 
		 */
		{
			struct file *fpdown;
			struct linkblk *linkblkp, *alloclink();
			struct stdata *stpdown;
			queue_t *rq;

			/*
			 * Test for invalid upper stream
			 */
			if (stp->sd_flag & STRHUP) {
				u.u_error = ENXIO;
				return;
			}

			/* if not IOPM stream then head must have mux init */
			/* (IOPM cdevsw has mux init for IOPM mux driver) */
			if ( !(stp->sd_flag & REMOTE) )
				if (!stp->sd_strtab->st_muxwinit) {
					u.u_error = EINVAL;
					return;
				}

			fpdown = getf(arg);
			if (u.u_error)
				return;
	
			/*
			 * Test for invalid lower stream 
			 */
			/* if to-be-linked file descriptor is not a stream OR */
			/* try to link stream to self OR */
			/* to-be-linked stream is ineligable */
			/*    (already under a mux driver - STPLEX) */
			/*    (hung up - STRHUP) */
			/*    (has a fatal error - STRERR) */
			/*    (waiting on a ioctl - IOCWAIT) OR */
			/* this link would cause a stream loop OR */
			/* the controling stream is an IOPM stream AND */
			/* the to-be-linked stream is not an IOPM stream with no modules on the kernel side */
			/* ie only simple IOPM streams (no kernel mods) can link under IOPM */
			if (!(stpdown = fpdown->f_inode->i_sptr) ||	
			    (stpdown == stp) ||
			    (stpdown->sd_flag & (STPLEX|STRHUP|STRERR|IOCWAIT)) ||
			    linkcycle(getendq(stp->sd_wrq), stpdown->sd_wrq) ||
			     stp->sd_flag & REMOTE &&
			     stpdown->sd_wrq->q_next->q_next )
			{
				u.u_error = EINVAL;
				return;
			}

			/* for IOPM streams getendq returns the kernel IOPM */
			/* driver queue. This will be over written by the IOPM */
			if (!(linkblkp = alloclink(getendq(stp->sd_wrq), 
					     stpdown->sd_wrq, fpdown - &file[0]))) {
				u.u_error = EAGAIN;
				return;
			}
			strioc.ic_cmd = I_LINK;
			strioc.ic_timout = 0;
			strioc.ic_len = sizeof(struct linkblk);
			strioc.ic_dp = (char *) linkblkp;
			/* Set up queues for link */
			/* Note that since the q_ptr's are cleared and setq is
			/* called here for kernel muxes only, the kernel side
			/* head and IOPM driver will remain, ready to be
			/* reconnected by UNLINK. */
			if ( !(stp->sd_flag & REMOTE) )
			{
				/* not IOPM mux. link on kernel side */	
				rq = RD(stpdown->sd_wrq);
				setq(rq, stp->sd_strtab->st_muxrinit,
				     stp->sd_strtab->st_muxwinit);
				rq->q_ptr = WR(rq)->q_ptr = NULL;
				rq->q_flag |= QWANTR;
				WR(rq)->q_flag |= QWANTR;
			}
			else
			{
				/* for IOPM mux, send address of linkblk entry to IOPM "head". */
				/* IOPM will copy contents to msg and send to IOPM mux driver */
			}

			strdoioctl(stp, &strioc, K_TO_K, STRLINK);

			if (u.u_error) {
				linkblkp->l_qtop = NULL;
				if ( !(stp->sd_flag & REMOTE) )	/* not IOPM mux */
				{				/* restore kernel stream structure */
					setq(rq, &strdata, &stwdata);
					rq->q_ptr = WR(rq)->q_ptr = (caddr_t)stpdown;
				}
				return;
			}
			s = splstr();
			stpdown->sd_flag |= STPLEX;
			fpdown->f_count++;
			splx(s);
			/*
			 * Wake up any other processes that may have been waiting
			 * on the lower stream.  These will all error out.
			 */
			wakeup((caddr_t)rq);
			wakeup((caddr_t)WR(rq));
			wakeup((caddr_t)stpdown);
			u.u_rval1 = fpdown - &file[0];
			return;
		}
	
	
	case I_UNLINK:
		/*
		 * Unlink a multiplexer.
		 * If arg is -1, unlink all links for which this is the
		 * controlling stream.  Otherwise, arg is a index number
		 * for a link to be removed.
		 */
		{
			struct file *fpdown;
			struct linkblk *linkblkp;
			struct stdata *stpdown;

			if (stp->sd_flag & STRHUP) {
				u.u_error = ENXIO;
				return;
			}
			if (arg == -1) {
				munlinkall(stp, 0);
			} else {
				fpdown = &file[arg];
				if ((fpdown < file) || 
				    (fpdown >= (struct file *)v.ve_file) ||
				    !fpdown->f_inode || 
				    !(stpdown = fpdown->f_inode->i_sptr) ||
				    !(stpdown->sd_flag & STPLEX) ||
				    !(linkblkp = findlinks(getendq(stp->sd_wrq),
					     	stpdown->sd_wrq, arg))) {
					/* invalid user supplied index number */
					u.u_error = EINVAL;
					return;
				}
				(void) munlink(stp, fpdown, linkblkp, 0);
			}
			return;
		}

	case I_FLUSH:
		/*
		 * send a flush message downstream
		 * flush message can indicate 
		 * FLUSHR - flush read queue
		 * FLUSHW - flush write queue
		 * FLUSHRW - flush read/write queue
		 */
		if (stp->sd_flag & STRHUP) {
			u.u_error = EINVAL;
			return;
		}
		if (arg & ~FLUSHRW) {
			u.u_error = EINVAL;
			return;
		}
		while (!putctl1(stp->sd_wrq->q_next, M_FLUSH, arg))
			if (strwaitbuf(1, BPRI_HI, 1))
				return;

		if (qready())
			runqueues();
		return;

	case I_SRDOPT:
		/*
		 * Set read options
		 *
		 * RNORM - default stream mode
		 * RMSGN - message no discard
		 * RMSGD - message discard
		 */
		s = splstr();
		switch (arg) {
		case RNORM: 
			stp->sd_flag &= ~(RMSGDIS | RMSGNODIS);
			break;
		case RMSGD:
			stp->sd_flag = (stp->sd_flag & ~RMSGNODIS) | RMSGDIS;
			break;
		case RMSGN:
			stp->sd_flag = (stp->sd_flag & ~RMSGDIS) | RMSGNODIS;
			break;
		default:
			u.u_error = EINVAL;
			break;
		}
		splx(s);
		return;


	case I_GRDOPT:
		/*
		 * Get read option and return the value
		 * to spot pointed to by arg
		 */
		{
			int rdopt;

			rdopt = ( (stp->sd_flag & RMSGDIS ? RMSGD :
				  (stp->sd_flag & RMSGNODIS ? RMSGN : RNORM)) );

			if (ncopyout(&rdopt, (int *)arg, sizeof(rdopt), STRINT))
				u.u_error = EFAULT;
			return;
		}

	case I_SETSIG:
		/*
		 * Register the calling proc to receive the SIGPOLL
		 * signal based on the events given in arg.  If
		 * arg is zero, remove the proc from register list.
		 */
		{
			struct strevent *sep, *psep;

			psep = NULL;
			s = splstr();
			for (sep = stp->sd_siglist; sep &&
			    (sep->se_procp != u.u_procp); psep = sep, sep = sep->se_next)
				;

			if (arg) {
				if (arg & ~(S_INPUT|S_HIPRI|S_OUTPUT|S_MSG)) {
					splx(s);
					u.u_error = EINVAL;
					return;
				}

				/*
				 * If proc not already registered, add it to list
				 */
				if (!sep) {
					if (!(sep = sealloc(SE_SLEEP))) {
						splx(s);
						u.u_error = EAGAIN;
						return;
					}
					if (psep)
						psep->se_next = sep;
					else
						stp->sd_siglist = sep;
					sep->se_procp = u.u_procp;
				}
				/*
				 * set events 
				 */
				sep->se_events = arg;
				stp->sd_sigflags |= arg;
				splx(s);
				return;
			} 
			/*
			 * Remove proc from register list
			 */
			if (sep) {
				if (psep)
					psep->se_next = sep->se_next;
				else
					stp->sd_siglist = sep->se_next;
				sefree(sep);
				/*
				 * recalculate OR of sig events
				 */
				stp->sd_sigflags = 0;
				for (sep = stp->sd_siglist; sep; sep = sep->se_next)
					stp->sd_sigflags |= sep->se_events;
				splx(s);
				return;
			}
			splx(s);
			u.u_error = EINVAL;
			return;
		}

	case I_GETSIG:
		/*
		 * Return (in arg) the current registration of events
		 * for which the calling proc is to be signaled.
		 */
		{
			struct strevent *sep;

			s = splstr();
			for (sep = stp->sd_siglist; sep; sep = sep->se_next)
				if (sep->se_procp == u.u_procp) {
					if (ncopyout((caddr_t)&sep->se_events, 
						         (int *)arg, sizeof(int), STRINT))
						u.u_error = EFAULT;
					splx(s);
					return;
				};
			splx(s);
			u.u_error = EINVAL;
			return;
		}

	case I_PEEK:
		{
			mblk_t *bp;
			struct strpeek strpeek;
			int save_ucnt, n;

			if (ncopyin((caddr_t)arg, (caddr_t)&strpeek, sizeof(strpeek), STRPEEK)) {
				u.u_error = EFAULT;
				return;
			}

			if (!(bp = RD(stp->sd_wrq)->q_first) ||
			   ((strpeek.flags & RS_HIPRI) && (queclass(bp) == QNORM))){
				u.u_rval1 = 0;
				return;
			}

			if (bp->b_datap->db_type == M_PASSFP) {
				u.u_error = EBADMSG;
				return;
			}
	
			if (bp->b_datap->db_type == M_PCPROTO) 
				strpeek.flags = RS_HIPRI;
			else
				strpeek.flags = 0;


			/*
			 * First process PROTO blocks, if any
			 */
			u.u_base = strpeek.ctlbuf.buf;
			u.u_count = strpeek.ctlbuf.maxlen;
			u.u_segflg = 0;
			while (bp && bp->b_datap->db_type!=M_DATA && (int)u.u_count >= 0) {
				if (n = min(u.u_count, bp->b_wptr - bp->b_rptr))
					iomove(bp->b_rptr, n, B_READ);
				if (u.u_error)
					return;
				bp = bp->b_cont;
			}
			save_ucnt = u.u_count;
		
			/*
			 * Now process DATA blocks, if any
			 */
			u.u_base = strpeek.databuf.buf;
			u.u_count = strpeek.databuf.maxlen;
			u.u_segflg = 0;
			while (bp && u.u_count) {
				if (n = min(u.u_count, bp->b_wptr - bp->b_rptr))
					iomove(bp->b_rptr, n, B_READ);
				if (u.u_error)
					return;
				bp = bp->b_cont;
			}


			strpeek.ctlbuf.len = strpeek.ctlbuf.maxlen - save_ucnt;
			strpeek.databuf.len = strpeek.databuf.maxlen - u.u_count;
			if (ncopyout((caddr_t)&strpeek, (caddr_t)arg, sizeof(strpeek), STRPEEK)) {
				u.u_error = EFAULT;
				return;
			}
			u.u_rval1 = 1;
			return;
		}

	case I_FDINSERT:
		{
			struct strfdinsert strfdinsert;
			struct file *resftp;
			struct stdata *resstp;
			queue_t *q;
			mblk_t *mp;
			register s;
			register msgsize;
			short rmin, rmax;
			mblk_t *strmakemsg();

			if (stp->sd_flag & (STRERR|STRHUP|STPLEX)) {
				u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
				return;
			}
			if (ncopyin((caddr_t)arg, (caddr_t)&strfdinsert, 
						sizeof(strfdinsert), STRFDINSERT)) {
				u.u_error = EFAULT;
				return;
			}
			if ( strfdinsert.offset < 0 || 
			    (strfdinsert.offset % sizeof(queue_t *)) != 0 ) {
				u.u_error = EINVAL;
				return;
			}
			if (!(resftp = getf(strfdinsert.fildes)) ||
			    !(resstp = resftp->f_inode->i_sptr)) {
				u.u_error = EINVAL;
				return;
			}
	
			if (resstp->sd_flag & (STRERR|STRHUP|STPLEX)) {
				u.u_error = ((resstp->sd_flag&STPLEX) ? EINVAL : resstp->sd_error);
				return;
			}

			/* get read queue of stream terminus */
			for (q = resstp->sd_wrq->q_next; q->q_next; q = q->q_next)
				;
			q = RD(q);
	
			if (strfdinsert.ctlbuf.len < 
					(strfdinsert.offset + sizeof(queue_t *))) {
				u.u_error = EINVAL;
				return;
			}

			/*
			 * Check for legal flag value
			 */
			if (strfdinsert.flags & ~RS_HIPRI) {
				u.u_error = EINVAL;
				return;
			}

			/*
			 * make sure ctl and data sizes together fall within 
			 * the limits of the max and min receive packet sizes 
			 * and do not exceed system limit.  A negative data length
			 * means that no data part is to be sent.
			 */
			rmin = stp->sd_wrq->q_next->q_minpsz;
			rmax = stp->sd_wrq->q_next->q_maxpsz;
			if (rmax == INFPSZ)
				rmax = strmsgsz;
			else
				rmax = min(rmax, strmsgsz);
			msgsize = strfdinsert.databuf.len;
			if (msgsize < 0)
				msgsize = 0;
			if ((msgsize<rmin) || (msgsize>rmax) ||
			    (strfdinsert.ctlbuf.len>strctlsz)) {
				u.u_error = ERANGE;
				return;
			}

			s = splstr();
			while (!(strfdinsert.flags & RS_HIPRI) && 
			       !canput(stp->sd_wrq->q_next)) 
				if (strwaitq(stp, WRITEWAIT, flag)) {
					splx(s);
					return;
				}
			splx(s);

			if (!(mp = strmakemsg(&strfdinsert.ctlbuf, 
					      &strfdinsert.databuf, stp->sd_wroff,
					      strfdinsert.flags))) 
				return;

			/*
			 * place pointer to queue 'offset' bytes from the
			 * start of the control portion of the message 
			 */

			*((queue_t **)(mp->b_rptr + strfdinsert.offset)) = q;

			if ( stp->sd_flag & REMOTE || resstp->sd_flag & REMOTE )
			{
				struct remoteinsert  remoteinsert;

				if ( !(stp->sd_flag & REMOTE) || !(resstp->sd_flag & REMOTE) )
				{
					u.u_error = EINVAL;
					return;
				}

				if ( strfdinsert.offset > 0x1000 )
				{
					u.u_error = EINVAL;
					return;
				}

				remoteinsert.insertmp = mp;
				remoteinsert.offset = strfdinsert.offset;

				strioc.ic_cmd = cmd;
				strioc.ic_timout = 0;
				strioc.ic_len = sizeof(remoteinsert);
				strioc.ic_dp = (char *)&remoteinsert;

				strdoioctl(stp, &strioc, K_TO_K, "ll" );
			}
			else
			{
				/*
				 * Put message downstream
				 */
				(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, mp);
				if (qready())
					runqueues();
			}
			return;
		}

	case I_SENDFD:
		{
			register queue_t *qp;
			register mblk_t *mp;
			register struct strrecvfd *srf;
			struct file *fp;

			if (stp->sd_flag & STRHUP) {
				u.u_error = ENXIO;
				return;
			}
			for (qp = stp->sd_wrq; qp->q_next; qp = qp->q_next)
				;
			if (qp->q_qinfo != &strdata) {
				u.u_error = EINVAL;
				return;
			}
		 	if (!(fp = getf(arg)))
				return;
			if ((qp->q_flag & QFULL) || 
			    !(mp = allocb(sizeof(struct strrecvfd), BPRI_MED))) {
				u.u_error = EAGAIN;
				return;
			}
			srf = (struct strrecvfd *)mp->b_rptr;
			mp->b_wptr += sizeof(struct strrecvfd);
			mp->b_datap->db_type = M_PASSFP;
			srf->f.fp = fp;
			srf->uid = u.u_uid;
			srf->gid = u.u_gid;
			fp->f_count++;
			strrput(qp, mp);
			return;
		}

	case I_RECVFD:
		{
			register s;
			register mblk_t *mp;
			register struct strrecvfd *srf;
			register i;

			if (stp->sd_flag & (STRERR|STPLEX)) {
				u.u_error = ((stp->sd_flag & STPLEX) ? EINVAL :stp->sd_error);
				return;
			}
			s = splstr();
			while (!(mp = getq(RD(stp->sd_wrq)))) {
				if (stp->sd_flag&STRHUP) {
					splx(s);
					u.u_error = ENXIO;
					return;
				}
				if (strwaitq(stp, GETWAIT, flag)) {
					splx(s);
					return;
				}
			}
			if (mp->b_datap->db_type != M_PASSFP) {
				putbq(RD(stp->sd_wrq), mp);
				splx(s);
				u.u_error = EBADMSG;
				return;
			}
			splx(s);
			srf = (struct strrecvfd *)mp->b_rptr;
			if ((i = ufalloc(0)) < 0) {
				putbq(RD(stp->sd_wrq), mp);
				return;
			}
			SET_OFILE(i, srf->f.fp);
			srf->f.fd = i;
			if (ncopyout((caddr_t)srf, (caddr_t)arg, sizeof(struct strrecvfd), STRRECVFD)) {
				u.u_error = EFAULT;
				srf->f.fp = GET_OFILE(i);
				putbq(RD(stp->sd_wrq), mp);
				SET_OFILE(i, NULL);
				return;
			}
			freemsg(mp);
			u.u_rval1 = 0;	/* reset value set by ufalloc() */
			return;
		}
	}
}

strpush(ip, mname)
struct inode *ip;
char *mname;
{
	register struct stdata *stp;
	int i;
	queue_t *q;

	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	/* try to push mod on IOPM first iff no kernel mods */
	if ( stp->sd_flag & REMOTE && !stp->sd_wrq->q_next->q_next ) {

		struct iopmscb  iopmscb;
		struct strioctl strioc;

		init_iopmscb(&iopmscb);

		bcopy(mname, iopmscb.iopms_mname, FMNAMESZ + 1);
		strioc.ic_cmd = I_PUSH;
		strioc.ic_dp = (char *)&iopmscb;
		strioc.ic_len = sizeof iopmscb;
		strioc.ic_timout = -1;

		strdoioctl( stp, &strioc, K_TO_K, STRNAME );
		/* strdoioctl will set u.u_rval1 (=uttyp) */
		/* and u.u_error (if strioc.ic_error set) */
		if ( !u.u_error )
		{	/* no error. module pushed in IOPM */
			u.u_ttyp = (short *)u.u_rval1;
			u.u_rval1 = 0;
			stp->sd_pushcnt++;
			return;
		}
		/* module not pushed on IOPM, try PM */
		u.u_error = 0;
		u.u_rval1 = 0;
	}

	/*
	 * push new module and call its open routine via qattach
	 */
	if ( (i = findmod(mname)) < 0 )
	{
		u.u_error = EINVAL;
		return;
	}


	if (!qattach(fmodsw[i].f_str, RD(stp->sd_wrq), ip->i_rdev, 0)) {
		if (!u.u_error)
			u.u_error =  ENXIO;
	} else
		stp->sd_pushcnt++;

	/*
	 * If flow control is on, don't break it - enable
	 * first back queue with svc procedure
	 */
	if (RD(stp->sd_wrq)->q_flag & QWANTW) {
		for (q = backq(RD(stp->sd_wrq->q_next)); q &&
		    !q->q_qinfo->qi_srvp; q = backq(q))
			;
		if (q)
			qenable(q);
	}
}

/*
 * Send an ioctl message downstream and wait for acknowledgement
 */

strdoioctl(stp, strioc, copyflg, fmtp)
struct stdata *stp;
struct strioctl *strioc;
int copyflg;
char *fmtp;
{
	register mblk_t *bp;
	register s;
	struct iocblk *iocbp;
	struct copyreq *reqp;
	struct copyresp *resp;
	mblk_t *fmtbp;
	int id;
	int transparent = 0;
	int ret;
	int len = 0;
	caddr_t taddr;
	extern str2time(), str3time();
	extern void  sigiopm();

	if (strioc->ic_len == TRANSPARENT) {	/* send arg in M_DATA block */
		transparent = 1;
		strioc->ic_len = sizeof(int);
	}
	
	if ((strioc->ic_len < 0) || (strioc->ic_len > strmsgsz)) {
		u.u_error = EINVAL;
		return;
	}

	while (!(bp = allocb(max(sizeof(struct iocblk), sizeof(struct copyreq)), BPRI_HI))) 
		if (strwaitbuf(sizeof(struct iocblk), BPRI_HI, 1))
			return;

	iocbp = (struct iocblk *)bp->b_wptr;
	iocbp->ioc_count = strioc->ic_len;
	iocbp->ioc_cmd = strioc->ic_cmd;
	iocbp->ioc_uid = u.u_uid;
	iocbp->ioc_gid = u.u_gid;
	iocbp->ioc_error = 0;
	iocbp->ioc_rval = 0;
	bp->b_datap->db_type = M_IOCTL;
	bp->b_wptr += sizeof(struct iocblk);


	/*
	 * If there is data to copy into ioctl block, do so
	 */
	if (iocbp->ioc_count && !putiocd(bp, strioc->ic_dp, copyflg, SE_NOSLP, fmtp)){
			freemsg(bp);
			return;
	}
	s = splstr();
	if (transparent)
		iocbp->ioc_count = TRANSPARENT;

	/*
	 * Block for up to STRTIMOUT sec if there is a outstanding
	 * ioctl for this stream already pending.  All processes
	 * sleeping here will be awakened as a result of an ACK
	 * or NAK being received for the outstanding ioctl, or
	 * as a result of the timer expiring on the outstanding
	 * ioctl (a failure), or as a result of any waiting
	 * process's timer expiring (also a failure).
	 */
	stp->sd_flag |= STR2TIME;
	id = timeout(str2time, stp, STRTIMOUT*HZ);

	while (stp->sd_flag & IOCWAIT) {
		stp->sd_iocwait++;
		if (sleep((caddr_t)&stp->sd_iocwait,STIPRI|PCATCH) ||
				    !(stp->sd_flag & STR2TIME)) {
			stp->sd_iocwait--;
			u.u_error = (stp->sd_flag&STR2TIME ? EINTR : ETIME);
			if (!stp->sd_iocwait)
				stp->sd_flag &= ~STR2TIME;
			splx(s);
			untimeout(id);
			freemsg(bp);
			return;
		}
		stp->sd_iocwait--;
		if (stp->sd_flag & (STRHUP|STRERR|STPLEX)) {
			u.u_error = ((stp->sd_flag & STPLEX) ? EINVAL : stp->sd_error);
			if (!stp->sd_iocwait)
				stp->sd_flag &= ~STR2TIME;
			splx(s);
			untimeout(id);
			freemsg(bp);
			return;
		}
	}
	untimeout(id);
	if (!stp->sd_iocwait)
		stp->sd_flag &= ~STR2TIME;

	/*
	 * Have control of ioctl mechanism.
	 * Send down ioctl packet and wait for
	 * response
	 */
	if (stp->sd_iocblk) {
		freemsg(stp->sd_iocblk);
		stp->sd_iocblk = NULL;
	}
	stp->sd_flag |= IOCWAIT;

	/* 
	 * assign sequence number
	 */
	iocbp->ioc_id = (stp->sd_iocid = ++ioc_id);

	splx(s);
	(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
	if (qready())
		runqueues();


	/*
	 * Timed wait for acknowledgment.  The wait time is limited by the
	 * timeout value, which must be a positive integer (number of seconds
	 * to wait, or 0 (use default value of STRTIMOUT seconds), or -1
	 * (wait forever).  This will be awakened either by an ACK/NAK
	 * message arriving, the timer expiring, or the timer expiring 
	 * on another ioctl waiting for control of the mechanism.
	 */
waitioc:
	s = splstr();
	if (!(stp->sd_flag & STR3TIME) && strioc->ic_timout >= 0)
		id = timeout(str3time, stp, (strioc->ic_timout ? strioc->ic_timout: STRTIMOUT) * HZ);

	stp->sd_flag |= STR3TIME;
	/*
	 * If the reply has already arrived, don't sleep.  If awakened from
	 * the sleep, fail only if the reply has not arrived by then.
	 * Otherwise, process the reply.
	 */
	while (!stp->sd_iocblk) {
		if (stp->sd_flag & (STRERR|STPLEX)) {
			u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			if (strioc->ic_timout >= 0)
				untimeout(id);
			splx(s);
			wakeup((caddr_t)&(stp->sd_iocwait));
			return;
		}

		if (sleep((caddr_t)stp,STIPRI|PCATCH) || 
		    !(stp->sd_flag & STR3TIME))  {
			int signal = stp->sd_flag & STR3TIME;
			u.u_error = ((stp->sd_flag&STR3TIME) ? EINTR : ETIME);
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			bp = NULL;
			/*
			 * A message could have come in after we were scheduled
			 * but before we were actually run.
			 */
			if (stp->sd_iocblk) {
				bp = stp->sd_iocblk;
				stp->sd_iocblk = NULL;
			}
			if (strioc->ic_timout >= 0)
				untimeout(id);
			splx(s);
			if (bp) {
				if ((bp->b_datap->db_type == M_COPYIN) ||
				    (bp->b_datap->db_type == M_COPYOUT)) {
					if (bp->b_cont) {
						freemsg(bp->b_cont);
						bp->b_cont = NULL;
					}
					bp->b_datap->db_type = M_IOCDATA;
					resp = (struct copyresp *)bp->b_rptr;
					resp->cp_rval = (caddr_t)1;	/* failure */
					(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
					if (qready())
						runqueues();
				} else {
					freemsg(bp);
				}
			}
			if ( signal && stp->sd_flag & REMOTE )
				sigiopm( getendq(stp->sd_wrq) );
			wakeup((caddr_t)&(stp->sd_iocwait));
			return;
		}
	}
	ASSERT(stp->sd_iocblk);
	bp = stp->sd_iocblk;
	stp->sd_iocblk = NULL;
	if (bp->b_datap->db_type == M_IOCACK || bp->b_datap->db_type == M_IOCNAK) {
		stp->sd_flag &= ~(STR3TIME|IOCWAIT);
		if (strioc->ic_timout >= 0)
			untimeout(id);
		splx(s);
		wakeup((caddr_t)&(stp->sd_iocwait));
	} else {
		splx(s);
	}


	/*
	 * Have recieved acknowlegment
	 */

	switch (bp->b_datap->db_type) {
	case M_IOCACK:
		/*
		 * Positive ack
		 */
		iocbp = (struct iocblk *)bp->b_rptr;

		/*
		 * set error if indicated
		 */
		if (iocbp->ioc_error) {
			u.u_error = iocbp->ioc_error;
			break;
		}

		/*
		 * set return value
		 */
		u.u_rval1 = iocbp->ioc_rval;

		/*
		 * Data may have been returned in ACK message (ioc_count > 0).
		 * If so, copy it out to the user's buffer.
		 */
		if (iocbp->ioc_count && !transparent) {
			if (strioc->ic_cmd == TCGETA || strioc->ic_cmd == TIOCGETP ||
			    strioc->ic_cmd == LDGETT) {
				if (!getiocd(bp, strioc->ic_dp, fmtp))
					break;
			} else {
				if (!getiocd(bp, strioc->ic_dp, NULL))
					break;
			}
		}
		if (!transparent) {
			if (len)		/* an M_COPYOUT was used with I_STR */
				strioc->ic_len = len;
			else
				strioc->ic_len = iocbp->ioc_count;
		}
		break;

	case M_IOCNAK:
		/*
		 * Negative ack
		 *
		 * The only thing to do is set error as specified
		 * in neg ack packet
		 */
		iocbp = (struct iocblk *)bp->b_rptr;

		u.u_error = (iocbp->ioc_error ? iocbp->ioc_error : EINVAL);
		break;

	case M_COPYIN:
		/*
		 * driver or module has requested user ioctl data
		 */
		reqp = (struct copyreq *)bp->b_rptr;
		fmtbp = bp->b_cont;
		bp->b_cont = NULL;
		if (reqp->cq_flag & RECOPY) {
			/* redo I_STR copyin with canonical processing */
			ASSERT(fmtbp);
			reqp->cq_size = strioc->ic_len;
			ret = putiocd(bp, strioc->ic_dp, copyflg, SE_SLEEP,
					(fmtbp?fmtbp->b_rptr:NULL));
			if (fmtbp)
				freeb(fmtbp);
		} else if (reqp->cq_flag & STRCANON) {
			/* copyin with canonical processing */
			ASSERT(fmtbp);
			ret = putiocd(bp, reqp->cq_addr, U_TO_K, SE_SLEEP,
					(fmtbp?fmtbp->b_rptr:NULL));
			if (fmtbp)
				freeb(fmtbp);
		} else {
			/* copyin raw data (i.e. no canonical processing) */
			ret = putiocd(bp, reqp->cq_addr, U_TO_K, SE_SLEEP, NULL);
		}
		if (!ret && bp->b_cont) {
			freemsg(bp->b_cont);
			bp->b_cont = NULL;
		}

		bp->b_wptr = bp->b_rptr + sizeof(struct copyresp);
		bp->b_datap->db_type = M_IOCDATA;
		resp = (struct copyresp *)bp->b_rptr;
		resp->cp_rval = (caddr_t)!ret;

		(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
		if (qready())
			runqueues();

		if (!ret) {
			u.u_error = EFAULT;
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			if (strioc->ic_timout >= 0)
				untimeout(id);
			return;
		}

		goto waitioc;

	case M_COPYOUT:
		/*
		 * driver or module has ioctl data for a user
		 */
		reqp = (struct copyreq *)bp->b_rptr;
		ASSERT(bp->b_cont);
		if (transparent)
			taddr = reqp->cq_addr;
		else {
			taddr = strioc->ic_dp;
			len = reqp->cq_size;
		}
		if (reqp->cq_flag & STRCANON) {
			/* copyout with canonical processing */
			if (fmtbp = bp->b_cont) {
				bp->b_cont = fmtbp->b_cont;
				fmtbp->b_cont = NULL;
			}
			ret = getiocd(bp, taddr, (fmtbp?fmtbp->b_rptr:NULL));
			if (fmtbp)
				freeb(fmtbp);
		} else {
			/* copyout raw data (i.e. no canonical processing) */
			ret = getiocd(bp, taddr, NULL);
		}
		freemsg(bp->b_cont);
		bp->b_cont = NULL;

		bp->b_wptr = bp->b_rptr + sizeof(struct copyresp);
		bp->b_datap->db_type = M_IOCDATA;
		resp = (struct copyresp *)bp->b_rptr;
		resp->cp_rval = (caddr_t)!ret;

		(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
		if (qready())
			runqueues();

		if (!ret) {
			u.u_error = EFAULT;
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			if (strioc->ic_timout >= 0)
				untimeout(id);
			return;
		}
		goto waitioc;

	default:
		ASSERT(0);
		break;
	}

	freemsg(bp);
}



/*
 * Get the next message from the read queue.  If the message is 
 * priority, STRPRI will have been set by strrput().  This flag
 * should be reset only when the entire message at the front of the
 * queue as been consumed.
 */
int
strgetmsg(ip, mctl, mdata, flag)
register struct inode *ip;
register struct strbuf *mctl;
register struct strbuf *mdata;
register flag;
{
	register s;
	register struct stdata *stp;
	register mblk_t *bp, *nbp;
	mblk_t *savemp = NULL;
	mblk_t *savemptail = NULL;
	int rflag;
	int flg = 0;
	int more = 0;
	int n;
	int bcnt;
	char *ubuf;


	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	if (stp->sd_flag & (STRERR|STPLEX)) {
		u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
		return(0);
	}
	if (ncopyin((int *)flag, (int *)&rflag, sizeof(int), STRINT)) {
		u.u_error = EFAULT;
		return(0);
	}
	if (rflag & (~RS_HIPRI)) {
		u.u_error = EINVAL;
		return(0);
	}

	s = splstr();
	while ( ((rflag & RS_HIPRI) && !(stp->sd_flag & STRPRI)) ||
			!(bp = getq(RD(stp->sd_wrq))) ) {
		/*
		 * If STRHUP, return 0 length control and data
		 */
		if (stp->sd_flag & STRHUP) {
			mctl->len = mdata->len = 0;
			if (ncopyout(&flg, (int *)flag, sizeof(int), STRINT))
				u.u_error = EFAULT;
			splx(s);
			return(0);
		} 
		if (strwaitq(stp, GETWAIT, u.u_fmode)) {
			splx(s);
			return(0);
		}
	}
	splx(s);
	
	if (bp->b_datap->db_type == M_PASSFP) {
		putbq(RD(stp->sd_wrq), bp);
		u.u_error = EBADMSG;
		return(0);
	}

	if (qready())
		runqueues();

	/*
	 * Set HIPRI flag if message is priority.
	 */
	if (stp->sd_flag & STRPRI)
		flg |= RS_HIPRI;

	/*
	 * First process PROTO or PCPROTO blocks, if any.
	 */
	if (mctl->maxlen >= 0 && bp && bp->b_datap->db_type != M_DATA) {
		bcnt = mctl->maxlen;
		ubuf = mctl->buf;
		while (bp && bp->b_datap->db_type != M_DATA && bcnt >= 0) {
			if ( (n = min(bcnt, bp->b_wptr - bp->b_rptr)) &&
			     copyout(bp->b_rptr, ubuf, n) ) {
				u.u_error = EFAULT;
				s = splstr();
				stp->sd_flag &= ~STRPRI;
				splx(s);
				more = 0;
				freemsg(bp);
				goto getmout;
			}
			ubuf += n;
			bp->b_rptr += n;
			if (bp->b_rptr >= bp->b_wptr) {
				nbp = bp;
				bp = bp->b_cont;
				freeb(nbp);
			}
			if ((bcnt -= n) <= 0)
				break;
		}
		mctl->len = mctl->maxlen - bcnt;
	} else
		mctl->len = -1;
	
		
	if (bp && bp->b_datap->db_type != M_DATA) {	
		/*
		 * more PROTO blocks in msg 
		 */
		more |= MORECTL;
		savemp = bp;
		while (bp && bp->b_datap->db_type!=M_DATA) {
			savemptail = bp;
			bp = bp->b_cont;
		}
		savemptail->b_cont = NULL;
	}

	/*
	 * Now process DATA blocks, if any
	 */
	if (mdata->maxlen >= 0 && bp) {
		bcnt = mdata->maxlen;
		ubuf = mdata->buf;
		while (bp && bcnt >= 0) {
			if ( (n = min(bcnt, bp->b_wptr - bp->b_rptr)) &&
			     copyout(bp->b_rptr, ubuf, n) ) {
				u.u_error = EFAULT;
				s = splstr();
				stp->sd_flag &= ~STRPRI;
				splx(s);
				more = 0;
				freemsg(bp);
				goto getmout;
			}
			ubuf += n;
			bp->b_rptr += n;
			if (bp->b_rptr >= bp->b_wptr) {
				nbp = bp;
				bp = bp->b_cont;
				freeb(nbp);
			}
			if ((bcnt -= n) <= 0)
				break;
		}
		mdata->len = mdata->maxlen - bcnt;
	} else
		mdata->len = -1;

	if (bp) {			/* more data blocks in msg */
		more |= MOREDATA;
		if (savemp)
			savemptail->b_cont = bp;
		else
			savemp = bp;
	} 

	if (savemp) 
		putbq(RD(stp->sd_wrq), savemp);
	else {
		s = splstr();
		stp->sd_flag &= ~STRPRI;
		splx(s);
	}

	if (ncopyout(&flg, (int *)flag, sizeof(int), STRINT))
		u.u_error = EFAULT;

	/*
	 * Getmsg cleanup processing - if the state of the queue has changed
	 * some signals may need to be sent and/or poll awakened.
	 */
getmout:
	while ((bp = RD(stp->sd_wrq)->q_first) && (bp->b_datap->db_type==M_SIG)) {
		bp = getq(RD(stp->sd_wrq));
		switch (*bp->b_rptr) {
		case SIGPOLL:
			s = splstr();
			if (stp->sd_sigflags & S_MSG)
				strsendsig(stp->sd_siglist, S_MSG);
			splx(s);
			break;

		default:
			if (stp->sd_pgrp)
				signal(stp->sd_pgrp, *bp->b_rptr);
			break;
		}
		freemsg(bp);
		if (qready())
			runqueues();
	}
	/*
	 * If we have just received a high priority message and a
	 * regular message is now at the front of the queue, send
	 * signals in S_INPUT processes and wake up processes polling
	 * on POLLIN.
	 */
	if (RD(stp->sd_wrq)->q_first && 
	    !(stp->sd_flag & STRPRI) && (flg & RS_HIPRI)) {
		s = splstr();
		if (stp->sd_sigflags & S_INPUT) 
			strsendsig(stp->sd_siglist, S_INPUT);
		if (stp->sd_pollflags & POLLIN)
			strwakepoll(stp, POLLIN);
		splx(s);
	}
	return(more);
}



/*
 * Put a message downstream
 */

strputmsg(ip, mctl, mdata, flag)
register struct inode *ip;
register struct strbuf *mctl;
register struct strbuf *mdata;
register flag;
{
	register struct stdata *stp;
	mblk_t *mp;
	register s;
	register msgsize;
	short rmin, rmax;
	mblk_t *strmakemsg();

	ASSERT(ip->i_sptr);
	stp = ip->i_sptr;

	if (stp->sd_flag & (STRHUP|STRERR|STPLEX)) {
		u.u_error = ((stp->sd_flag&STPLEX) ? EINVAL : stp->sd_error);
		return;
	}

	/*
	 * Check for legal flag value
	 */
	if ((flag & ~RS_HIPRI) || ((flag & RS_HIPRI) && (mctl->len < 0))) {
		u.u_error = EINVAL;
		return;
	}

	/*
	 * make sure ctl and data sizes together fall within the limits of the
	 * max and min receive packet sizes and do not exceed system limit
	 */
	rmin = stp->sd_wrq->q_next->q_minpsz;
	rmax = stp->sd_wrq->q_next->q_maxpsz;
	if (rmax == INFPSZ)
		rmax = strmsgsz;
	else
		rmax = min(rmax, strmsgsz);
	msgsize = mdata->len;
	if (msgsize < 0) {
		msgsize = 0;
		rmin = 0;	/* no range check for NULL data part */
	}
	if ((msgsize<rmin) || (msgsize>rmax) || (mctl->len>strctlsz)) {
		u.u_error = ERANGE;
		return;
	}

	s = splstr();
	while (!(flag & RS_HIPRI) && !canput(stp->sd_wrq->q_next)) {
		if (strwaitq(stp, WRITEWAIT, u.u_fmode)) {
			splx(s);
			return;
		}
	}
	splx(s);

	if (!(mp = strmakemsg(mctl, mdata, stp->sd_wroff, flag)))
		return;

	/*
	 * Put message downstream
	 */
	(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, mp);
	if (qready())
		runqueues();
}



/*
 * Determines whether the necessary conditions are set on a stream
 * for it to be readable, writeable, or have exceptions.
 */
int
strpoll(stp, events, anyyet)
register struct stdata *stp;
short events;
{
	register retevents = 0;
	register s;
	register struct strevent *sep, *psep;
	register queue_t *tq;

	if (stp->sd_flag & STPLEX)
		return(POLLNVAL);
	
	s = splstr();
	if (stp->sd_flag&STRERR) {
		splx(s);
		return(POLLERR);
	}

	if (stp->sd_flag & STRHUP)
		retevents |= POLLHUP;

	for (tq = stp->sd_wrq->q_next; 
	     tq->q_next && !tq->q_qinfo->qi_srvp;  tq = tq->q_next);
	if ((events & POLLOUT) && !(stp->sd_flag & STRHUP)) {
		if (tq->q_flag & QFULL)
			tq->q_flag |= QWANTW;	/* ensure backq svc proc runs */
		else
			retevents |= POLLOUT;
	}

	if ((events & POLLIN) && !(stp->sd_flag & STRPRI))
		if (RD(stp->sd_wrq)->q_first)
			retevents |= POLLIN;

	if ((events & POLLPRI) &&
	     (stp->sd_flag & STRPRI))
			retevents |= POLLPRI;

	ASSERT((retevents & (POLLPRI|POLLIN)) != (POLLPRI|POLLIN));

	if (retevents) {
		splx(s);
		pollreset(stp);
		return(retevents);
	}


	/*
	 * if poll() has not found any events yet, set up event cell
	 * to wake up the poll if a requested event occurs on this
	 * stream.  This will occaisionally result in adding an event
	 * cell on top of one that already there, but both will get 
	 * cleaned up in the pollout: section of poll() in sys2.c.
	 * Hence, it is not worth checking for here.
	 */
	if (!anyyet) {
		if (sep = sealloc(SE_SLEEP)) {
			sep->se_procp = u.u_procp;
			sep->se_events = events;
			sep->se_next = stp->sd_pollist;
			stp->sd_pollist = sep;
			stp->sd_pollflags |= events;
			splx(s);
			return(0);
		}
		splx(s);
		pollreset(stp);
		u.u_error = EAGAIN;
		return(0);
	}
	/*
	 * If we get here the poll has already found an event but
	 * there are no return events for this stream. Remove
	 * any event cell for this process from the pollist, and
	 * recalculate the pollflags.  
	 * A cell will exist if this stream was previously scanned
	 * in this poll().
	 */
	splx(s);
	pollreset(stp);
	return(retevents);
}


/*
 * Attach a stream device or module.
 * qp is a read queue; the new queue goes in so its next
 * read ptr is the argument, and the write queue corresponding
 * to the argument points to this queue.  Return 1 on success,
 * 0 on failure.
 */

int
qattach(qinfo, qp, dev, flag)
register struct streamtab *qinfo;
register queue_t *qp;
dev_t dev;
{
	register queue_t *rq;
	register s;
	int sflg;

	dev = notminored(dev);
	if (!(rq = allocq()))
		return(0);

	sflg = 0;
	s = splstr();
	rq->q_next = qp;
	WR(rq)->q_next = WR(qp)->q_next;
	if (WR(qp)->q_next) {
		OTHERQ(WR(qp)->q_next)->q_next = rq;
		sflg = MODOPEN;
	}
	WR(qp)->q_next = WR(rq);
	setq(rq, qinfo->st_rdinit, qinfo->st_wrinit);
	rq->q_flag |= QWANTR;
	WR(rq)->q_flag |= QWANTR;

	/*
	 * Open the attached module or driver.
	 * The open may sleep, but it must always return here.  Therefore,
	 * all sleeps must set PCATCH or ignore all signals to avoid a 
	 * longjump if a signal arrives.
	 */
	PRINT4(ROUT,"qattach: call qopen(%x) dev = %x, flag = %x sflag = %x\n",
	        *rq->q_qinfo->qi_qopen,dev,flag,sflg);
	if ((*rq->q_qinfo->qi_qopen)(rq, dev, flag, sflg) == OPENFAIL) {
		qdetach(rq, 0, 0);
		splx(s);
		return(0);
	}
	splx(s);
	return(1);
}

/*
 * Detach a stream module or device.
 * If clmode == 1 then the module or driver was opened and its
 * close routine must be called.  If clmode == 0, the module
 * or driver was never opened or the <open failed, and so its close
 * should not be called.
 */

qdetach(qp, clmode, flag)
register queue_t *qp;
{
	register s;
	register queue_t *q, *prev = NULL;

	if (clmode) {
		if (qready())
			runqueues();
		s = splstr();
		PRINT(CLOSE,"qdetach: ");
		(*qp->q_qinfo->qi_qclose)(qp, (qp->q_next ? 0 : flag));
		/*
		 * Check if queues are still enabled, and remove from 
		 * runlist if necessary.
		 */
		if ((qp->q_flag | WR(qp)->q_flag) & QENAB) {
			for (q = qhead; q; q = q->q_link)  {
				if (q == qp || q == WR(qp)) {
					if (prev)
						prev->q_link = q->q_link;
					else
						qhead = q->q_link;
					if (q == qtail)
						qtail = prev;
				}
				else
					prev = q;
			}
		}
		flushq(qp, FLUSHALL);
		flushq(WR(qp), FLUSHALL);
	} else 
		s = splstr();

	if (WR(qp)->q_next)
		backq(qp)->q_next = qp->q_next;
	if (qp->q_next)
		backq(WR(qp))->q_next = WR(qp)->q_next;
	chk_runqueue(qp);		/* remove q's from queuerun list */
	chk_bufcall(qp);		/* remove q's from bufcall list */
	chk_timeout(qp, WR(qp));	/* remove q's from timeout list */
	freeq(qp);
	splx(s);
}


/*
 * This function is placed in the callout table to wake up a process
 * waiting to close a stream that has not completely drained.
 */

strtime(stp)
struct stdata *stp;
{

	if (stp->sd_flag & STRTIME) {
		wakeup(stp->sd_wrq);
		stp->sd_flag &= ~STRTIME;
	}
}

/*
 * This function is placed in the callout table to wake up all
 * processes waiting to send an ioctl down a particular stream,
 * as well as the process whose ioctl is still outstanding.  The
 * process placing this function in the callout table will remove
 * it if he gets control of the ioctl mechanism for the stream -
 * this should only run if there is a failure.  This wakes up
 * the same processes as str3time below.
 */

str2time(stp)
struct stdata *stp;
{

	if (stp->sd_flag & STR2TIME) {
		wakeup(&stp->sd_iocwait);
		stp->sd_flag &= ~STR2TIME;
	}
}

/*
 * This function is placed on the callout table to wake up the
 * the process that has an outstanding ioctl waiting acknowledgement
 * on a stream, as well as any processes waiting to send their
 * own ioctl messages.  It should be removed from the callout table
 * when the acknowledgement arrives.  If this function runs, it
 * is the result of a failure.  This wakes up the same processes
 * as str2time above.
 */

str3time(stp)
struct stdata *stp;
{

	if (stp->sd_flag & STR3TIME) {
		wakeup(stp);
		stp->sd_flag &= ~STR3TIME;
	}
}

/*
 *  Put ioctl data from user land to ioctl buffers.  Return 0 for failure,
 *  1 for success.
 */
int
putiocd(bp, arg, copymode, flag, fmt)
register mblk_t *bp;
caddr_t arg;
int copymode;
int flag;
char *fmt;
{
	register mblk_t *tmp;
	register int count, n;

	if (bp->b_datap->db_type == M_IOCTL)
		count = ((struct iocblk *)bp->b_rptr)->ioc_count;
	else {
		ASSERT(bp->b_datap->db_type == M_COPYIN);
		count = ((struct copyreq *)bp->b_rptr)->cq_size;
	}

	/*
	 * strdoioctl validates ioc_count, so if this assert fails it
	 * cannot be due to user error.
	 */
	ASSERT(count >= 0);

	while (count) {
		n = min(MAXIOCBSZ,count);
		if (flag == SE_SLEEP) {
			while (!(tmp = allocb(n, BPRI_HI))) {
				if (strwaitbuf(n, BPRI_HI, 1))
					return(0);
			}
		} else {
			if (!(tmp = allocb(n, BPRI_HI))) {
				u.u_error = EAGAIN;
				return(0);
			}
		}
		switch (copymode) {
			case K_TO_K:
				bcopy((caddr_t)arg, tmp->b_wptr, n);
				break;

			case U_TO_K:
				if (ncopyin((char *)arg, tmp->b_wptr, n, fmt)) {
					freeb(tmp);
					u.u_error = EFAULT;
					return(0);
				}
				if (fmt && count > MAXIOCBSZ)
					adjfmtp(&fmt, tmp, n);
				break;

			default:
				ASSERT(0);
				freeb(tmp);
				return(0);
		}
		arg += n;
		tmp->b_datap->db_type = M_DATA;
		tmp->b_wptr += n;
		count -= n;
		bp = (bp->b_cont = tmp);
	}
	return(1);
}

/*
 * copy ioctl data to user land.  Return 0 for failure, 1 for success.
 */
int
getiocd(bp, arg, fmt)
register mblk_t *bp;
caddr_t arg;
char *fmt;
{
	register int count,n;

	if (bp->b_datap->db_type == M_IOCACK)
		count = ((struct iocblk *)bp->b_rptr)->ioc_count;
	else {
		ASSERT(bp->b_datap->db_type == M_COPYOUT);
		count = ((struct copyreq *)bp->b_rptr)->cq_size;
	}
	ASSERT(count >= 0);

	for(bp = bp->b_cont; bp && count; count -= n, bp = bp->b_cont ,arg += n) {
		n = min(count, bp->b_wptr - bp->b_rptr);
		if (ncopyout(bp->b_rptr, arg, n, fmt)) {
			u.u_error = EFAULT;
			return(0);
		}
		if (fmt && bp->b_cont)
			adjfmtp(&fmt, bp, n);
	}
	ASSERT(count==0);
	return(1);
}



/* 
 * allocate a linkblk table entry for the triple:
 * (write queue of bottom module of top stream, write queue of stream head of
 * bottom stream, file table index number)
 *
 * linkblk table entries are freed by nulling the l_qtop field.
 */

struct linkblk *
alloclink(qup, qdown, index)
queue_t *qup, *qdown;
int index;
{
	register struct linkblk *linkblkp;

	for (linkblkp = &linkblk[0];   linkblkp < &linkblk[nmuxlink];   linkblkp++)
		if (!linkblkp->l_qtop) {
			linkblkp->l_qtop = qup;
			linkblkp->l_qbot = qdown;
			linkblkp->l_index = index;
			return(linkblkp);
		}

	return(NULL);
}


/*
 * Check for a potential linking cycle.  
 * Qup is the upper queue in a multiplexor that is going to be linked.
 * Qdown is initially the queue to be linked below the multiplexor.
 * Linkcycle() is called to recursively scan the tree of links
 * rooted at qdown to determine if qup is contained in that tree.
 */
int
linkcycle(qup, qdown)
register queue_t *qup, *qdown;
{
	register struct linkblk *linkblkp;

	for (linkblkp = &linkblk[0]; linkblkp < &linkblk[nmuxlink]; linkblkp++) {
		if (linkblkp->l_qtop == qdown) 
			if ((linkblkp->l_qbot == qup) ||
			    linkcycle(qup, linkblkp->l_qbot))
				return(1);
	}
	return(0);
}


/* 
 * find linkblk table entry corresponding to triple.
 * A NULL parameter means any value matches that member of the triple.
 * Return pointer to linkblk entry.
 */
struct linkblk *
findlinks(qup, qdown, index)
register queue_t *qup, *qdown;
int index;
{
	register struct linkblk *linkblkp;

	ASSERT(qup || qdown || index);

	for (linkblkp = &linkblk[0];   linkblkp < &linkblk[nmuxlink];   linkblkp++) {
		if ( linkblkp->l_qtop &&
		     (!qup || (qup == linkblkp->l_qtop))   &&
		     (!qdown || (qdown == linkblkp->l_qbot)) &&
		     (!index || (index == linkblkp->l_index)) )

			return(linkblkp);
	}
	return(NULL);
}


/* 
 * given a queue ptr, follow the chain of q_next pointers until you reach the
 * last queue on the chain and return it
 */
queue_t *
getendq(q)
register queue_t *q;
{
	while (q->q_next)
		q = q->q_next;
	return(q);
}


/*
 * unlink a multiplexer link.  Stp is the controlling stream for the
 * link, fpdown is the file pointer for the lower stream, and
 * linkblkp points to the link's entry in the linkblk table.
 */
int
munlink(stp, fpdown, linkblkp, cflag)
struct stdata *stp;
struct file *fpdown;
struct linkblk *linkblkp;
int cflag;
{
	register int s;
	struct strioctl strioc;
	struct stdata *stpdown;
	queue_t *rq;

	strioc.ic_cmd = I_UNLINK;
	strioc.ic_timout = 0;
	strioc.ic_len = sizeof(struct linkblk);
	strioc.ic_dp = (char *) linkblkp;
	
	strdoioctl(stp, &strioc, K_TO_K, STRLINK);

	/*
	 * If there was an error and this is not called via strclose, 
	 * return to the user.  Otherwise, pretend there was no error 
	 * and close the link.  
	 */
	if (u.u_error) {
		if (cflag) {
			cmn_err(CE_CONT, "KERNEL: munlink: could not perform unlink ioctl, closing anyway\n");
			u.u_error = 0;	
			s = splstr();
			stp->sd_flag &= ~STRERR; /* allows strdoioctl() to work */
			splx(s);
		} else
			return(-1);
	}

	stpdown = fpdown->f_inode->i_sptr;
	s = splstr();
	stpdown->sd_flag &= ~STPLEX;
	splx(s);
	rq = RD(stpdown->sd_wrq);
	setq(rq, &strdata, &stwdata);
	rq->q_ptr = WR(rq)->q_ptr = (caddr_t)stpdown;
	linkblkp->l_qtop = NULL;
	closef(fpdown);
	return(0);
}



/*
 * unlink all multiplexer links for which stp is the controlling stream.
 */
munlinkall(stp, cflag)
struct stdata *stp;
int cflag;
{

	struct file *fpdown;
	struct linkblk *linkblkp;
	queue_t *qup;

	qup = getendq(stp->sd_wrq);
	while (linkblkp = findlinks(qup, NULL, NULL)) {
		fpdown = &file[linkblkp->l_index];
		ASSERT((fpdown >= file) && (fpdown < (struct file *)v.ve_file));
		if (munlink(stp, fpdown, linkblkp, cflag) == -1) {
			ASSERT(0);
			return;
		}
	}
	return;
}

/*
 * Set the interface values for a pair of queues (qinit structure,
 * packet sizes, water marks).
 */
setq(rq, rinit, winit)
queue_t *rq;
struct qinit *rinit, *winit;
{
	register queue_t  *wq;
	register int s;

	wq = WR(rq);
	s = splstr();
	rq->q_qinfo = rinit;
	rq->q_hiwat = rinit->qi_minfo->mi_hiwat;
	rq->q_lowat = rinit->qi_minfo->mi_lowat;
	rq->q_minpsz = rinit->qi_minfo->mi_minpsz;
	rq->q_maxpsz = rinit->qi_minfo->mi_maxpsz;
	wq->q_qinfo = winit;
	wq->q_hiwat = winit->qi_minfo->mi_hiwat;
	wq->q_lowat = winit->qi_minfo->mi_lowat;
	wq->q_minpsz = winit->qi_minfo->mi_minpsz;
	wq->q_maxpsz = winit->qi_minfo->mi_maxpsz;
	splx(s);
}




/*
 * Make a protocol message given control and data buffers
 */
mblk_t *
strmakemsg(mctl, mdata, wroff, flag)
register struct strbuf *mctl;
register struct strbuf *mdata;
int wroff;
long flag;
{
	register mblk_t *mp = NULL;
	register mblk_t *bp;
	int count;
	caddr_t base;
	int pri;
	int msgtype;
	int offlg = 0;

	if (flag & RS_HIPRI) pri = BPRI_MED;
	else pri = BPRI_LO;

	/*
	 * Create control part of message, if any
	 */
	if (mctl->len >= 0) {
		if (flag & RS_HIPRI) 
			msgtype = M_PCPROTO;
		else 
			msgtype = M_PROTO;

		count = mctl->len;
		base = mctl->buf;

		/*
		 * range checking has already been done, simply try
		 * to allocate a message block for the ctl part.
		 */
		while (!(bp = allocb(count, pri))) 
			if (strwaitbuf(count, pri, 1))
				return(NULL);

		bp->b_datap->db_type = msgtype;
		if (copyin(base, bp->b_wptr, count)) {
			u.u_error = EFAULT;
			freeb(bp);
			return(NULL);
		}
		bp->b_wptr += count;
		mp = bp;
	}

	/*
	 * Create data part of message, if any
	 */
	if (mdata->len >= 0) {

		count = mdata->len;
		base = mdata->buf;
		do {
			register size;
			register class;

			size = count + (offlg ? 0 : wroff);

getbp:
			if (size < QBSIZE) {
				if (bp = allocb(size, pri))
					goto gotbp;
				if (strwaitbuf(size, pri, 1)) {
					freemsg(mp);
					return(NULL);
				}
			} else {
				if ((class = getclass(size)) == NCLASS) {
					class = NCLASS-1;
					size = rbsize[class];
				}
				if (bp = allocb(rbsize[class], pri))
					goto gotbp;
				if (bp = allocb(rbsize[--class], pri))
					goto gotbp;
				if (bp = allocb(rbsize[--class], pri))
					goto gotbp;
				/*
				 * Have strwaitbuf() call bufcall up to 3
				 * times to mimic 3 allocb() tries above.
				 * This prevents failure if there are no
				 * buffers configured for 'size' bytes.
				 */
				if (strwaitbuf(size, pri, 3)) {
					freemsg(mp);
					return(NULL);
				}
			}
			goto getbp;

gotbp:
			if (wroff && !offlg++ &&
			    (wroff < bp->b_datap->db_lim - bp->b_wptr)) {
				bp->b_rptr += wroff;
				bp->b_wptr += wroff;
			}
			if ((size = min(count, bp->b_datap->db_lim - bp->b_wptr)) &&
			    copyin(base, bp->b_wptr, size)) {
				u.u_error = EFAULT;
				freeb(bp);
				freemsg(mp);
				return(NULL);
			}
			bp->b_wptr += size;
			base += size;
			count -= size;
			if (!mp)
				mp = bp;
			else
				linkb(mp, bp);

		} while (count);
	}
	return(mp);
}

/*
 * Wait for a buffer to become available.  Return 1 if not able to wait,
 * 0 if buffer is probably there.  'ncalls' is # of bufcall() attempts.
 */
strwaitbuf(size, pri, ncalls)
int size, pri, ncalls;
{
	register int s;
	extern setrun();

	s = splstr();
	if (!bufcall(size, pri, setrun, u.u_procp)) {
		if (ncalls > 1) {
			int i, class;

			/*
			 * assume size won't exceed largest buffer size
			 * and won't loop below lowest buffer size
			 */
			class = getclass(size);
			for (i = 1; i < ncalls; i++)
				if (bufcall((size = rbsize[--class]), pri,
				    setrun, u.u_procp))
					goto bufpass;
		}
		splx(s);
		u.u_error = ENOSR;
		return(1);
	}

bufpass:
	if (sleep((caddr_t)&(u.u_procp->p_flag), STOPRI|PCATCH)) {
		strunbcall(size, pri, u.u_procp);
		splx(s);
		u.u_error = EINTR;
		return(1);
	}
	strunbcall(size, pri, u.u_procp);
	splx(s);
	return(0);
}

/*
 * Remove a setrun for the given process from the bufcall list for
 * the given buffer size and allocation priority.
 */
strunbcall(size, pri, p)
int size, pri;
struct proc *p;
{
	register s;
	struct dbalcst *dbp;
	struct strevent *sep, **prvp;
	extern setrun();
	
	ASSERT((size >= 0) && (size <= rbsize[NCLASS-1]));
	dbp = &dballoc[getclass(size)];
	prvp = ( pri == BPRI_HI ? &dbp->dba_hip :
		(pri == BPRI_LO ? &dbp->dba_lop : &dbp->dba_medp));
	s = splstr();
	if (!(sep = *prvp)) {
		splx(s);
		return;
	}
	while (sep) {
		if ((sep->se_func == setrun) && (sep->se_arg == (long)p)) {
			*prvp = sep->se_next;
			splx(s);
			sefree(sep);
			return;
		}
		prvp = &sep->se_next;
		sep = sep->se_next;
	}
	splx(s);
}


/*
 * This function waits for a read or write event to happen on a stream.
 */

strwaitq(stp, flag, fmode)
register struct stdata *stp;
int flag;
int fmode;
{
	register int s;
	int slpflg, slppri, errs;
	caddr_t slpadr;

	if (fmode & FNDELAY) {
		if (!(flag & NOINTR))
			u.u_error = EAGAIN;
		return(1);
	}
	if ((flag & READWAIT) || (flag & GETWAIT)) {
		slpflg = RSLEEP;
		slpadr = (caddr_t)RD(stp->sd_wrq);
		slppri = STIPRI;
		errs = STRERR|STPLEX;

		/* If any module downstream has requested read notification
		 * by setting SNDMREAD flag using M_SETOPTS, send a message
		 * down stream
		 */
		if ((flag & READWAIT) && (stp->sd_flag & SNDMREAD)) {
			switch ( sendmread(stp) ) {
			    case 0: break;	/* M_READ sent OK */
			    case 1: return (0);	/* data arived while waiting */
			    case 2: return (1);	/* couldn't send M_READ */
			    default: ASSERT(0);
			}
		}
	} else {
		slpflg = WSLEEP;
		slpadr = (caddr_t)stp->sd_wrq;
		slppri = STOPRI;
		errs = STRERR|STRHUP|STPLEX;
	}
	
	s = splstr();
	stp->sd_flag |= slpflg;
	if (sleep(slpadr, slppri|PCATCH)) {
		stp->sd_flag &= ~slpflg;
		splx(s);
		wakeup(slpadr);
		if (!(flag & NOINTR))
			u.u_error = EINTR;
		return(1);
	}
	splx(s);
	if (stp->sd_flag & errs) {
		u.u_error = ((stp->sd_flag & STPLEX) ? EINVAL : stp->sd_error);
		return(1);
	}
	return(0);
}

sendmread(stp)
register struct stdata *stp;
{
	mblk_t *mp;
	int s;
	extern strqbuf();

	while ( (mp = allocb(sizeof(long), BPRI_MED)) == NULL )
	{
		s = splstr();
		if ( bufcall(sizeof(long), BPRI_MED, strqbuf, stp) == 0 )
		{
			splx(s);
			u.u_error = EAGAIN;
			return 2;
		}
		else
		{
			stp->sd_flag |= RDBUFWAIT;
			if ( sleep((caddr_t)RD(stp->sd_wrq), STIPRI| PCATCH) )
			{
				if ( stp->sd_flag & RDBUFWAIT )
				{
					/* interrupted sleep */
					stp->sd_flag &= ~RDBUFWAIT;
					splx(s);
					u.u_error = EINTR;
					return 2;
				}
			}
			splx(s);
		}
	}
	mp->b_datap->db_type = M_READ;
	*(long *)mp->b_wptr = (long)u.u_count;
	mp->b_wptr += sizeof(long);
	/* send the number of bytes requested by the
	 * read as the argument to M_READ
	 */
	putnext(stp->sd_wrq, mp);
	/* if any data arrived due to inline processing
	 * of putnext(), don't sleep.
	 */
	if ( (RD(stp->sd_wrq))->q_first != NULL )
		return 1;

	return 0;
}

str2num(str)		/* string to number, updating pointer */
register char **str;
{
	register int n;

	n = 0;
	for (; **str >= '0' && **str <= '9'; (*str)++)
		n = 10 * n + **str - '0';
	return(n);
}

adjfmtp(str, bp, bytes)    /* update canon format pointer with bytes worth of data */
register char **str;
register mblk_t *bp;
int bytes;
{
	register caddr_t addr;
	register caddr_t lim;
	long num;

	addr = (caddr_t)bp->b_rptr;
	lim = addr + bytes;
	while (addr < lim) {
		switch (*(*str)++) {
		case 's':			/* short */
			addr = SALIGN(addr);
			addr = SNEXT(addr);
			break;
		case 'i':			/* integer */
			addr = IALIGN(addr);
			addr = INEXT(addr);
			break;
		case 'l':			/* long */
			addr = LALIGN(addr);
			addr = LNEXT(addr);
			break;
		case 'b':			/* byte */
			addr++;
			break;
		case 'c':			/* character */
			num = str2num(str);
			if (num = 0) {
				while (*addr++)
					;
			} else
				addr += num;
			break;
		case 0:
			return;
		default:
			break;
		}
	}
}

strqbuf (stp)
register struct stdata *stp;

{
	register int s;
	 
	if (stp->sd_flag & RDBUFWAIT) {
		s = splstr();
		stp->sd_flag &= ~RDBUFWAIT;
		splx(s);
		wakeup ((caddr_t)RD(stp->sd_wrq));
	}
	return;
}

/*
 * This was added for POSIX job control. Any process that is running
 * in the background and tries to read from the controlling terminal,
 * must be sent a stop signal unless it is either ignoring or blocking
 * the signal or the process is orphaned.  In this case EIO is set and
 * an error is sent to the calling process.
 * If we were catching TTIN signal and we have a handler for it
 * then after we come back from the handler we want to do a longjmp
 * so that we get an EINTR from the read system call if nothing
 * was transferred.
 * RETURN VALUES:
 *	0	if processing can continue
 *	1	if job control signal is not allowed (return EIO)
 *	longjmp	if there is a signal handler assigned
 */
strreadjobchk(p,stp,sig)
register struct	proc	*p;
register struct	stdata	*stp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != stp->sd_pgrp) && (p->p_my_tty == (uint)(stp))) {
		if ((sigval == SIG_IGN) || (p->p_hold & sigbit(sig)) ||
				isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		}
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}

/*
 * This was added for POSIX job control. Any process that is running
 * in the background and tries to write to the controlling terminal,
 * must be sent a stop signal if the TOSTOP bit is set unless it is 
 * either ignoring or blocking the signal or the process is orphaned. 
 * In this case EIO is set and an error is sent to the calling process.
 * If we were catching TTOU signal and we have a handler for it
 * then after we come back from the handler we want to do a longjmp
 * so that we get an EINTR from the write system call if nothing
 * was transferred.
 * RETURN VALUES:
 *	0	if processing can continue
 *	1	if job control signal is not allowed (return EIO)
 *	longjmp	if there is a signal handler assigned
 */
strwritejobchk(p,stp,sig)
register struct	proc	*p;
register struct	stdata	*stp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != stp->sd_pgrp) && (p->p_my_tty == (uint)(stp)) &&
	    (stp->sd_flag & STRTOSTOP) && (sigval != SIG_IGN) &&
	    !(p->p_hold & sigbit(sig))) {
		if (isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		} 
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}

strioctljobchk(p,stp,sig)
register struct	proc	*p;
register struct	stdata	*stp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != stp->sd_pgrp) && (p->p_my_tty == (uint)(stp)) &&
	    (sigval != SIG_IGN) && !(p->p_hold & sigbit(sig))) {
		if (isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		} 
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}

/* AUTOPUSH - Construct an M_IOCTL message. Set the command to TCLDTERM. 
 * Attach a message which will be used by the tty driver to respond with
 * the name "ldterm". We use this instead of a simple ACK of the IOCTL to
 * determine if the module ldterm should be pushed on top of the driver.
 * Send the message and do the processing of waiting for an answer.
 * If the returned M_IOCTL message is ACK'd and the attached message 
 * contains the string "ldterm", return PUSHOK. All other responses
 * are PUSHFAIL.
 */
#define PUSHFAIL 0
#define PUSHOK 1
reason_to_push(ip)
struct inode *ip;
{
	static char ldterm_m[7] = {"ldterm"};
	register mblk_t *bp;
	register struct stdata *stp;
	register s;
	register i;
	struct strioctl strioc;
	struct iocblk *iocbp;
	int id;
	int len = sizeof(ldterm_m);
	extern str3time();
	stp = ip->i_sptr;
	if( !stp ) return(PUSHFAIL);
	while (!(bp = allocb(sizeof(struct iocblk), BPRI_HI)))
		if (strwaitbuf(sizeof(struct iocblk), BPRI_HI, 1))
			return(PUSHFAIL);

	while (!(bp->b_cont = allocb(len, BPRI_HI)))
		if (strwaitbuf(len, BPRI_HI, 1)) {
			freemsg(bp);
			return(PUSHFAIL);
		}

	iocbp = (struct iocblk *)bp->b_wptr;
	iocbp->ioc_count = len;
	iocbp->ioc_cmd = TCLDTERM;
	iocbp->ioc_uid = u.u_uid;
	iocbp->ioc_gid = u.u_gid;
	iocbp->ioc_error = 0;
	iocbp->ioc_rval = 0;
	bp->b_datap->db_type = M_IOCTL;
	bp->b_wptr += sizeof(struct iocblk);

	s = splstr();
	/*
	 * Have control of ioctl mechanism.
	 * Send down ioctl packet and wait for
	 * response
	 */
	if (stp->sd_iocblk) {
		freemsg(stp->sd_iocblk);
		stp->sd_iocblk = NULL;
	}
	stp->sd_flag |= IOCWAIT;

	/* 
	 * assign sequence number
	 */
	iocbp->ioc_id = (stp->sd_iocid = ++ioc_id);

	splx(s);
	(*stp->sd_wrq->q_next->q_qinfo->qi_putp)(stp->sd_wrq->q_next, bp);
	if (qready())
		runqueues();

	/*
	 * Timed wait for acknowledgment.  The wait time is limited by the
	 * timeout value, which must be a positive integer (number of seconds
	 * to wait, or 0 (use default value of STRTIMOUT seconds), or -1
	 * (wait forever).  This will be awakened either by an ACK/NAK
	 * message arriving, the timer expiring, or the timer expiring 
	 * on another ioctl waiting for control of the mechanism.
	 */
	s = splstr();
	id = timeout(str3time, stp, STRTIMOUT * HZ);

	stp->sd_flag |= STR3TIME;
	/*
	 * If the reply has already arrived, don't sleep.  If awakened from
	 * the sleep, fail only if the reply has not arrived by then.
	 * Otherwise, process the reply.
	 */
	while (!stp->sd_iocblk) {
		if (stp->sd_flag & (STRERR|STPLEX)) {
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			untimeout(id);
			splx(s);
			return(PUSHFAIL);
		}

		if (sleep((caddr_t)stp,STIPRI|PCATCH)) { 
		    
			stp->sd_flag &= ~(STR3TIME|IOCWAIT);
			/*
			 * A message could have come in after we were scheduled
			 * but before we were actually run.
			 */
			if (stp->sd_iocblk) {
				freemsg(stp->sd_iocblk);
				stp->sd_iocblk = NULL;
			}	
			untimeout(id);
			splx(s);
			return(PUSHFAIL);
		}
	}
	ASSERT(stp->sd_iocblk);
	bp = stp->sd_iocblk;
	stp->sd_iocblk = NULL;
	if (bp->b_datap->db_type == M_IOCACK || bp->b_datap->db_type == M_IOCNAK) {
		stp->sd_flag &= ~(STR3TIME|IOCWAIT);
		untimeout(id);
		splx(s);
	} else {
		splx(s);
	}


	/*
	 * Have received acknowlegment
	 */

	if (bp->b_datap->db_type == M_IOCACK) {
		/*
		 * Positive ack
		 */
		iocbp = (struct iocblk *)bp->b_rptr;

		/*
		 * Data may have been returned in ACK message (ioc_count > 0).
		 * If so, check if the string is "ldterm".
		 */
		if (iocbp->ioc_count == len ) {
			for(i=0;i<len;i++ ) 
				if(!(bp->b_cont->b_rptr[i] == ldterm_m[i]))
					break;
			if(i==len) {
				freemsg(bp);
				return(PUSHOK);
			}
		}
	}
	freemsg(bp);
	return(PUSHFAIL);

}
