/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) startup.c: version 25.3 created on 2/5/92 at 17:15:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)startup.c	25.3	2/5/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/pfdat.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/buf.h"
#include "sys/utsname.h"
#include "sys/tty.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/sbus.h"
#include "sys/kmem.h"
#include "sys/spm_mem.h"
#include "sys/own.h"
#include "sys/lio.h"
#include "sys/sbus_pm.h"
#include "sys/sbus_spm.h"
#include "sys/sbus_iom.h"
#include "sys/var.h"
#include "sys/conf.h"
#include "sys/sysinfo.h"
#include "sys/priv.h"
#include "sys/mls.h"
#ifdef	PERF
#include "sys/perf.h"
#include "sys/perfext.h"
#endif	/* PERF */

extern int	userstack[];
extern user_t	p0_u;
extern uint	p0_u_area;
uint		num_PM = 0;
extern char	sys_stk_end[], own_stk_end[];
static	void	call_main();
static	void	startc2();
extern struct lock_req_array  lock_req_array[];


/*****************************************************************************

				startc

  Purpose
  -------
    take over from boot and start bringing kernel up.

  Algorithm
  ---------


******************************************************************************/
startc()
{
	void	swtch_continue();

	spm_mem.pm_version = SPM_MEM_VERSION;

	while ( spm_mem.spm_version != SPM_MEM_VERSION )
		;

	pm_init();

	if (num_PM++) {
		own.o_boot_response = 1;
		set_pc_sp(swtch_continue, own_stk_end);
		/* NOTREACHED */
	}

	spm_mem.lock_req_arrayp = lock_req_array;
	/*
	 * up_slot must be initialized so that the first upkern_inc will work.
	 */
	spm_mem.upkern.up_pm_id = own.o_pm_id;
	spm_mem.upkern.up_cnt = 0;

	/* NOTE: an upkern_inc() at this point will cause the upkern to be
	 * forever stuck to the processor running this routine.
	 * (i.e. reintroduce master/slave)
	 */

	own.o_boot_response = 1;

	/* wait for the SPM to tell the kernel to continue */
	while ( spm_mem.kernel_green_light == 0 )
		;

	pm_int_req_reg_init();
	init_all_owns_for_same_masks();

	mlsetup(btoc(MAINSTORE + spm_mem.spm_mem_used));

	/* switch to proc 0. u area already set up */
#if	USIZE > 1
	{ /* local */
	    register int pgnum;
	    for(pgnum=0; pgnum < USIZE; pgnum++) {
		pg_setall(&uarea_ptbl[pgnum], 
			mkpde(PG_CB|PG_P|PG_R|PG_W,pnum(&p0_u_area)+pgnum));
	    } /* for */
	} /* local */
#else	/* USIZE > 1 */
	pg_setall(&uarea_ptbl[0], mkpde(PG_CB|PG_P|PG_R|PG_W, pnum(&p0_u)));
#endif	/* USIZE > 1 */

#ifdef THREE_LEVEL_MMU
/* hanna FIX: This was necessary on sparc -- for some reason.
 * hanna FIX: Take this out when you can confirm that it's not needed.
 */
/* hanna FIX */   if(u.u_procp) {
/* hanna FIX */       u.u_procp->p_urde = km_to_rde((uint)own.o_qtbl);
/* hanna FIX */   }
#endif	/* THREE_LEVEL_MMU */


	flush_all_own_tlb();
	set_pc_sp(call_main, sys_stk_end);
	/* NOTREACHED */
}

/*****************************************************************************

  Function
  --------
   Called by 'start' to help fire up the kernel.  Main purpose is to create
 part of process zero (just enough to enable it to run) and to initialize 
 the memory map.
*/

/* Routine called before main, to initialize various data structures.
** The arguments are:
**	physclick - The click number of the first available page
**		    of virtual memory (mapped to physical memory)
*/

mlsetup(physclick)
int	physclick;
{
	register unsigned 	nextclick;
	register unsigned	i;

	/*	No user page tables available yet.
	 */

	ptfree.pf_next = &ptfree;
	ptfree.pf_prev = &ptfree;
	
	/*	Set up memory parameters.
	*/

	i = spm_mem.num_pages;
	if (v.v_maxpmem && (v.v_maxpmem < i))
		i = v.v_maxpmem;
	physmem = spm_mem.num_pages = i;
	maxclick = btoc(MAINSTORE) + i;

	ASSERT(physclick < maxclick);

	/*	Initialize memory mapping for syseg,
	**	the segment from which the kernel
	**	dynamically allocates space for  itself.
	*/

	nextclick = sysseginit(physclick, maxclick);

	/*	Note that reginit must be called before
	**	mktables because reginit calculates the
	**	value of pregpp which is used by mktables.
	*/

	/*	Initialize the map used to allocate
	**	kernel virtual space.
	*/

	mapinit(sptmap, v.v_sptmap);
	mfree(sptmap, maxclick - nextclick, btoc(ADDR_SYS_SEGS));

	procinit();
	reginit();

	/*
	 * allocate disk buffers now.  having them dynamically
	 * allocated and thus appearing outside of bss increases
	 * the probability that kernel text and data will fit
	 * within the 2Mbytes of TLB.
	 */

	buffers = (char *)ctob(nextclick);
	nextclick += (v.v_buf + ((ctob(1)/NBPSCTR) - 1)) / (ctob(1)/NBPSCTR);
	nextclick = S54K_malloc(nextclick);

	/*	Allocate some kernel tables.
	*/

	nextclick = mktables(nextclick);

	/*
	 *	Initialize the physical memory manager.
	 */
	kpbase = ctob(nextclick);
	meminit(nextclick, maxclick);
	flush_all_own_tlb();
	/*
	 *	Initialize process 0.
	 */
	p0init();
#ifdef	PERF
	/*
	 *	Initialize perf global statistics counters.
	 */
	perfinit();
#endif	/* PERF */
}

/*
 *	procinit   link in the authorization data structure into the
 *          proctable
 */

procinit()
{
register int i;
extern auth_t ua[];

	for (i=0; i<v.v_proc;i++) 
		proc[i].p_auth = (auth_t *)&ua[i]; 
}

/*
 * Initialize hardware local to a PM board
 */
pm_init()
{
	extern user_t	own_u;
	static char	o_name[] = "Idle-0";
	static preg_t	idle_preg[2];
	extern struct lock_req_array  *own_lock_req_ptr;/* in build_addr */
	extern uchar                   own_lock_id;	/* in build_addr */

	own.o_curproc = own_u.u_procp = &own.o_proc;
	set_bit(&own.o_id_bit, own.o_pm_id);

	/* initialize grab value for upkern_try_inc cas's */
	own.o_upkern_init_val.up_pm_id = own.o_pm_id;
	own.o_upkern_init_val.up_cnt = 1;
	own.o_upkern_dec_val.up_pm_id = own.o_pm_id;
	own.o_upkern_dec_val.up_cnt = 2 | UPKERN_WAITING_BIT_SHORT;

	board_init();
	iomap_init();	/* clear and initialize */

	if (spm_mem.cache_off)
		printf("Secondary Cache NOT Enabled\n");
	else
		pm_cache_on();

	get_cpu_mask_type();		/* identify cpu mask version */
	fpu_get_type();			/* identify fpu mask version */
	clear_pm_int_req_reg();		/* clear any pending interrupts */
	own_interrupt_queue_init();

	/* make death in idle loops easier to recognize */
	strcpy(own_u.u_comm, o_name);
	own_u.u_comm[sizeof(o_name) - 2] += own.o_pm_id;
	strcpy(own_u.u_psargs, own_u.u_comm);
	own_u.u_uid = own_u.u_gid = own_u.u_ruid = own_u.u_rgid = -own.o_pm_id;
	own.o_proc.p_uid = own.o_proc.p_suid = -own.o_pm_id;
	own.o_proc.p_userp = (user_t *)ADDR_OWN_U_STR;
	ASSERT(own.o_proc.p_wchan == 0);
	own.o_proc.p_region = idle_preg;
	own.o_proc.p_urde = spm_mem.invalid_rde;	/* poison rde */
	own.o_proc.p_auth = &own.o_auth;
	own.o_proc.p_auth->a_groups[0] = -1;
	own.o_proc.p_auth->p_save_pgrp = 0;

#ifdef	PERF
	own.o_proc.p_slice_clamp= 0;		/* turn off slice clamp	      */
	own.o_proc.p_pri_clamp	= 0;		/* turn off pri clamp	      */
	own.o_proc.p_usrpri_clamp=0;		/* turn off usrpri clamp      */
	own.o_proc.p_cpu_clamp	= 0;		/* turn off cpu clamp	      */
	own.o_proc.p_slice_cnt	= 0;		/* usage count statistics     */
	own.o_proc.p_slice_ovfl	= 0;		/* overflow cnt for above     */
	own.o_proc.p_pri_cnt	= 0;		/* usage count statistics     */
	own.o_proc.p_pri_ovfl	= 0;		/* overflow cnt for above     */
	own.o_proc.p_usrpri_cnt	= 0;		/* usage count statistics     */
	own.o_proc.p_usrpri_ovfl= 0;		/* overflow cnt for above     */
	own.o_proc.p_cpu_cnt	= 0;		/* usage count statistics     */
	own.o_proc.p_cpu_ovfl	= 0;		/* overflow cnt for above     */
#endif	/* PERF */
	own.o_proc.p_perf_flags	= 0;		/* turn off performance flags */
	own.o_proc.p_usrpri	= 0;		/* usrpri from p_cpu & p_nice */
	own.o_proc.p_slptime	= 0;		/* time since last sleep      */
	own.o_proc.p_pri_slp	= 0; /* pri before going to sleep	      */
	own.o_proc.p_pri_adj	= 0; /* part of dynamic pri recalculation     */
	own.o_proc.p_lticks	= quantum_size;	/* per proc ticks remaining   */
	own.o_proc.p_quantum	= quantum_size;	/* per proc slice size	      */
	own.o_proc.p_nswtch	= 0; /* per process count of swtch's	      */
	own.o_proc.p_ovfswtch	= 0; /* per process overflow of swtch's	      */
	own_lock_req_ptr = &lock_req_array[own_lock_id];

	/* start off own process with proper security features */
	auth_p0init( &own.o_proc );

	atom_inc(&sysinfo.num_pms);
}

static	void
call_main()
{
	extern void	start_icode();
	extern int	vhand();
	extern int	bdflush(), s54kbdflush();
	extern int	sched();
	extern uint	upkern_save();
	uint		upkern_level = upkern_save();

	register int 	 x;

	ASSERT(!own.o_upkern_proc);
	own.o_curproc = &proc[0];

	spl0();
	x = main();

	upkern_restore(upkern_level);
	ASSERT(!own.o_upkern_proc);

	if (x == 0) {
		if (! own.o_fpu_loaded)
			fpu_restore();
		set_pc_sp(start_icode, sys_stk_end);
		/* NOTREACHED */
	}

	if (x == (int)bdflush || x == (int)s54kbdflush)
		set_pc_sp(x, sys_stk_end);		/* NOTREACHED */
	if (x == (int)vhand || x == (int)sched) {
		upkern_lock();
		set_pc_sp(x, sys_stk_end);		/* NOTREACHED */
		/* NOTREACHED */
	}
	ASSERT(0);
}

/*	Allocate page tables for the kernel segment sysseg and
**	and initialize the segment table for it.
*/

sysseginit(physclick, maxclick)
register int	physclick;
int		maxclick;
{
	register int		pgcnt;
	register sde_t		*sptr;
	register char		*ptptr;
	register int		pm_id;
	register int		numclicks;
	sde_t			*pm_own_sptr[SBUS_MAX_NUM_PM];

	/*	Now loop through all of the segment table
	**	entries for sysseg and initialize them
	**	to point to the correct kernel page
	**	tables.
	*/

	sptr = kvtokstbl(ADDR_SYS_SEGS);
	ptptr = (char *)ctob(physclick);

	for (pm_id = spm_mem.num_pm; --pm_id >= 0; ) {
#ifdef THREE_LEVEL_MMU
		/* assume linearly assigned qtbls from here */
		pm_own_sptr[pm_id] = 
			(sde_t*) qde_to_km(*(spm_mem.pm_own[pm_id]->o_qtbl
			+ qnum(ADDR_SYS_SEGS)));
#else /* THREE_LEVEL_MMU */
		/* assume linearly assigned stbls from here */
		pm_own_sptr[pm_id] = spm_mem.pm_own[pm_id]->o_stbl
			+ SNUM(ADDR_SYS_SEGS);
#endif /* THREE_LEVEL_MMU */
	}

	numclicks = maxclick - physclick;
	for (pgcnt = 0  ;  pgcnt < numclicks ; pgcnt += NPGPT, sptr++) {
		*sptr = km_to_sde(ptptr);
		for (pm_id = spm_mem.num_pm; --pm_id >= 0; ) {
			*pm_own_sptr[pm_id]++ = *sptr;
		}
		bset_long((ulong *)ptptr, PG_UNINIT, NPGPT);
#ifdef M68040
		/*
		 * Don't cache M68040 page tables; avoid MMU lock-up bug
		 */
		{
			register pde_t	*pde;
			extern pde_t	*kfindpde();

			if (pde = kfindpde(ptptr))
				pde->pde.nocache = 1;
		}
#endif /* M68040 */
		ptptr += sizeof(ptbl_t);
	}

	/*	Set the address of the kernel page table.
	**	We are actually using a physical address.
	**	This works since all of physical memory
	**	is mapped 1-to-1 into the kernel's virtual
	**	address space.
	*/

	spm_mem.kptbl = kptbl = (pde_t *)ctob(physclick);
	spm_mem.kv_size = (pde_t *) ptptr - kptbl;

	return(btoc(ptptr));
}

/*
 * Create system space to hold page allocation and
 * buffer mapping structures and hash tables
 */

mktables(nextfree)
int	nextfree;		/* next available page number */
{
	register int	m;
	register int	i;
	register preg_t	*prp;
	extern int	pregpp;

	/*	Allocate space for the pfdat.
	*/

	i = btoc((maxclick - nextfree) * sizeof(struct pfdat));
	pfdat = (pfd_t *)sptalloc(i,
				(PG_CB|PG_P|PG_R|PG_W|PG_S|PG_G|PG_REF|PG_M),
				nextfree, NOSLEEP);
	if (!pfdat)
		cmn_err(CE_PANIC, "Can't allocate pfdat!\n");
	nextfree += i;
	
	/*	Compute the smallest power of two larger than
	 *	the size of physical memory.
	 */

	m = physmem;
	while (m & (m - 1))
		 m = (m | (m - 1)) + 1;
	phashmask = (m>>3) - 1;

	/*	Allocate space for the page hash bucket
	 *	headers.
	 */

	i = btoc((m >> 3) * sizeof(*phash));
	phash = (pfd_t **)sptalloc(i,
				(PG_CB|PG_P|PG_R|PG_W|PG_G|PG_S|PG_REF|PG_M),
				nextfree, NOSLEEP);
	if (!phash)
		cmn_err(CE_PANIC, "Can't allocate hash!\n");
	nextfree += i;

	/*	Allocate space for the pregion tables for each process
	 *	and link them to the process table entries.
	 *	The maximum number of regions allowed for is process is
	 *	3 for text, data, and stack plus the maximum number
	 *	of shared memory regions allowed.
	 */
	
	i = btoc(pregpp * sizeof(preg_t) * v.v_proc);
	prp = (preg_t *)sptalloc(i,
				(PG_CB|PG_P|PG_R|PG_W|PG_G|PG_S|PG_REF|PG_M),
				nextfree, NOSLEEP);
	if (!prp)
		cmn_err(CE_PANIC, "Can't allocate pregions! Needed %d pages\n",
		  i);
	bzero((caddr_t)prp, ctob(i));
	nextfree += i;
	for (i = 0  ;  i < v.v_proc  ;  i++, prp += pregpp)
		proc[i].p_region = prp;
	/*
	 * return next available physical page.
	 */

	return(nextfree);
}

/*	Set up proc0
*/

p0init()
{
	register int i;

	/* initialize proc entry for process 0 */
	own_curpri = 0;
	proc[0].p_size = USIZE;
	proc[0].p_nice = NZERO;
	proc[0].p_flag = SLOAD|SSYS;
	proc[0].p_stat = SONPROC;
	proc[0].p_running = own.o_pm_id;
	proc[0].p_urde = spm_mem.invalid_rde;	/* poison rde */
	proc[0].p_auth->a_groups[0] = -1;
	proc[0].p_auth->p_save_pgrp = 0;

#ifdef	PERF
	proc[0].p_slice_clamp	= 0;		/* turn off slice clamp	      */
	proc[0].p_pri_clamp	= 0;		/* turn off pri clamp	      */
	proc[0].p_usrpri_clamp	= 0;		/* turn off usrpri clamp      */
	proc[0].p_cpu_clamp	= 0;		/* turn off cpu clamp	      */
	proc[0].p_slice_cnt	= 0;		/* usage count statistics     */
	proc[0].p_slice_ovfl	= 0;		/* overflow cnt for above     */
	proc[0].p_pri_cnt	= 0;		/* usage count statistics     */
	proc[0].p_pri_ovfl	= 0;		/* overflow cnt for above     */
	proc[0].p_usrpri_cnt	= 0;		/* usage count statistics     */
	proc[0].p_usrpri_ovfl	= 0;		/* overflow cnt for above     */
	proc[0].p_cpu_cnt	= 0;		/* usage count statistics     */
	proc[0].p_cpu_ovfl	= 0;		/* overflow cnt for above     */
#endif	/* PERF */
	proc[0].p_perf_flags	= 0;		/* turn off performance flags */
	proc[0].p_usrpri	= 0;		/* usrpri from p_cpu & p_nice */
	proc[0].p_slptime	= 0;		/* time since last sleep      */
	proc[0].p_pri_slp	= 0; /* pri before going to sleep	      */
	proc[0].p_pri_adj	= 0; /* part of dynamic pri recalculation     */
	proc[0].p_lticks	= quantum_size;	/* per proc ticks remaining   */
	proc[0].p_quantum	= quantum_size;	/* per proc slice size	      */
	proc[0].p_nswtch	= 0; /* per process count of swtch's	      */
	proc[0].p_ovfswtch	= 0; /* per process overflow of swtch's	      */

	/* start off process 0 with proper security features */
	auth_p0init( &proc[0] );

#if	USIZE > 1
	{ /* local */
	    register int pgnum;
	    for(pgnum=0; pgnum < USIZE; pgnum++) {
		pg_setall(&proc[0].p_ubptbl[pgnum], 
			mkpde(PG_CB|PG_P|PG_R|PG_W,pnum(&p0_u_area)+pgnum));
	    } /* for */
	} /* local */
#else	/* USIZE > 1 */
	pg_setall(&proc[0].p_ubptbl[0],mkpde(PG_CB|PG_P|PG_R|PG_W,pnum(&p0_u)));
#endif	/* USIZE > 1 */

	proc[0].p_userp = &p0_u;
	proc[0].p_dests = ~0;

	p0_u.u_sub	= (unsigned long) userstack;
	p0_u.u_ssize = 0;
	p0_u.u_dsize = 0;
	p0_u.u_tsize = 0;
	p0_u.u_procp = &proc[0];   /* not clear that this is needed but.... */
	p0_u.u_cmask = CMASK;
	if (v.v_ulimit < CDLIMIT) {
		cmn_err(CE_WARN,
		  "Configured CDLIMIT_CONF=%d is too small, setting it to %d\n",
		  v.v_ulimit, CDLIMIT);
		v.v_ulimit = CDLIMIT;
	}
	p0_u.u_limit = v.v_ulimit;
	p0_u.u_exdata.ux_mag = 0407;
	p0_u.u_ar0 = (int *)U_AR0;

	if (default_rlimits[RLIMIT_NOFILE].rlim_cur > SFNOLIM_MAX) {
		default_rlimits[RLIMIT_NOFILE].rlim_cur = SFNOLIM_MAX;
		printf("SFNOLIM set to %d per process.\n", SFNOLIM_MAX);
	}
	bcopy(default_rlimits, p0_u.u_rlimit, sizeof(rlimit_t) * RLIM_NLIMITS);
}


/*	Machine-dependent startup code
*/

startup()
{
	cmn_err(CE_CONT,"\nARIX-OS/S90 V.3 Release %s, Version %s\n",
	  utsname.release, utsname.version);
	cmn_err(CE_CONT,
"Copyright (C) 1988 - 1992 by Arix Corporation, All Rights Reserved\n");
	cmn_err(CE_CONT, "Node %s, System %s\n",
	  utsname.nodename, utsname.sysname);

	machinit();
	devinit();
	ksym_init(); /* initialize addresses in spm_mem for use by spm ps */
	tlb_flush_init();
	update_iomap_init();
	resched_intr_init();
}

/*
 * Adjust for appropriate boot options.
 */

machinit()
{
}

/* FIX THIS, JPC:  find a better place for spm_to_kern_dev */
/*
 * spm_to_kern_dev -- return the dev_t number for a given iunit_t or NODEV
 */
dev_t
spm_to_kern_dev(spm_dev)
iunit_t	spm_dev;
{
	dev_t	iopm_to_kern_dev();

	switch (spm_mem.sbus_slot_id[spm_dev.s.slot]) {
	case SBUS_NIOM:
	case SBUS_IOPM:
		return (iopm_to_kern_dev(spm_dev));
	default:
		return (NODEV);
	}
}

/*
 * 	Initialize the rootdev, pipedev, and swapdev
 */

devinit()
{
	register uint		sbus_slot;
	register iom_config_t	*iomp;
	extern dev_t		spm_to_kern_dev();

	iomp = spm_mem.iom_config;
	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {

		switch (spm_mem.sbus_slot_id[sbus_slot]) {
		case SBUS_NIOM:
		case SBUS_IOM:
 			if (iomp->card_cage_type == IOM_TYPE_IOA) {
				cmn_err(CE_PANIC,
				  "IOA Based I/O Subsystem Not Supported");
				/*NOTREACHED*/
			}
			iomp++;
		}
	}

	rootdev = spm_to_kern_dev(spm_mem.rootdev);
	pipedev = rootdev;
	swapdev = spm_to_kern_dev(spm_mem.swapdev);
	if (rootdev == NODEV || swapdev == NODEV)
		cmn_err(CE_PANIC,
		  "devinit: can't find device! rootdev = 0x%x, swapdev = 0x%x",
		  rootdev, swapdev);
}


ksym_init()
{
	spm_mem.ksym_proc = (uint)proc;
	spm_mem.ksym_v = (uint)&v;
}

/*
 * for each PM, build fill two bit masks:
 *	one that describes all pm's that have the same cpu mask
 *	and one that describes all pm's that have the same fpu mask
 */

init_all_owns_for_same_masks()
{
	register own_t	*outer_o, *inner_o;
	register uint	outer, inner;

	for (outer = 0; outer < spm_mem.num_pm; outer++ ) {

		if (! (outer_o = spm_mem.pm_own[outer]))
			continue;

		for (inner = 0; inner < spm_mem.num_pm; inner++ ) {
			if (! (inner_o = spm_mem.pm_own[inner]))
				continue;
			if (inner_o->o_cpu_type == outer_o->o_cpu_type)
				outer_o->o_cpu_same |= inner_o->o_id_bit;
			if (inner_o->o_fpu_type == outer_o->o_fpu_type)
				outer_o->o_fpu_same |= inner_o->o_id_bit;
		}
	}
}
