/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) slp.c: version 25.1 created on 11/27/91 at 15:11:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)slp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:slp.c	4.1"

#include "sys/types.h"
#include "sys/immu.h"
#include "sys/sysmacros.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/map.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/spl.h"
#include "sys/own.h"
#include "sys/mfs.h"
#ifdef	PERF
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#endif	/* PERF */

/*
 * sleep-wakeup hashing:  Each entry in hsque[] points
 * to a linked list of sleeping processes.   NHSQUE must
 * be a power of 2.  Sqhash(x) is used to index into
 * hsque[] based on the sleep channel.
 */

#define NHSQUE		512
#define sqhash(X)	(&hsque[((int)X >> 3) & (NHSQUE-1)])

proc_t			*hsque[NHSQUE];

/*
 * While going to sleep or after awaking from sleeping a potential
 * signal has been found.  confirm_signal returns 1 if the
 * signal is real, 0 if it was a false alarm (e.g. stop signal).
 * If the signal is real and the PCATCH flag in disp is not set,
 * confirm_signal will longjmp (typically aborting the current
 * system call). 
 */
static uint
confirm_signal(disp)
uint	disp;
{
	register proc_t *p = u.u_procp;
	uint	why;
	/*
	 * If it's not safe to stop here the caller will have set
	 * PNOSTOP in "disp"; in this case make sure that we won't
	 * stop when issig() is called.
	 */
	if (disp & PNOSTOP) {
		atom_or(&p->p_flag, SNOSTOP);
		why = JUSTLOOKING;
	} else
		why = FORREAL;

	if (!issig(why)) {
		/*
		 * Signal failed to actually show up (e.g the signal
		 * is on hold), but the condition we were waiting
		 * for may have happened, so return to caller.
		 * The caller will probably turn around and call
		 * sleep a second time but this time there will
		 * no longer be a signal.
		 */
		atom_and(&p->p_flag, ~SNOSTOP);
		return(0);
	}

	/*
	 * If priority was low (>PZERO) and there has been a signal,
	 * then if PCATCH is set return 1, otherwise do a non-local
	 * jump to the qsav location.
	 */

	atom_and(&p->p_flag, ~SNOSTOP);
	if (disp & PCATCH)
		return(1);

	longjmp(u.u_qsav);
	/* NOTREACHED */
}

/*
 * Give up the processor till a wakeup occurs
 * on chan, at which time the process
 * enters the scheduling queue at priority pri.
 * The most important effect of pri is that when
 * pri <= PZERO a signal cannot disturb the sleep;
 * if pri > PZERO signals will be processed.
 * When pri <= PZERO, SNWAKE bit in p_flag will be set
 * to indicate no disturbance during sleep.
 * This is different from the old way that compares
 * p_pri and PZERO.
 * Callers of this routine must be prepared for
 * premature return, and check that the reason for
 * sleeping has gone away.
 */

#define	TZERO	10

sleep(chan, disp)
caddr_t chan;
{
	register proc_t *p = u.u_procp;
	register proc_t **q = sqhash(chan);
	register s;
	register tmpdisp;
	uint retval = 0;

	ASSERT(p->p_stat != SSLEEP);

	s = splhi();
	if (panicstr) {
		fspl0();
		splx(s);
		return(0);
	}

	ASSERT(!own.o_in_int_service);

	/* put on sleep queue */

	ASSERT(chan != 0);

	if (p->p_time > TZERO)
		p->p_time = TZERO;
	tmpdisp = disp & PMASK;
	if (p->p_pri > tmpdisp)
		p->p_pri = tmpdisp;

	spin_lock(&proc_lock);
	if ((tmpdisp > PZERO) && (p->p_cursig || (p->p_sig & ~p->p_hold))) {
		spin_unlock(&proc_lock);
		retval = confirm_signal(disp);
	} else {
		/* We are now committed to going to sleep */

		p->p_stat = SSLEEP;
		p->p_wchan = chan;
		p->p_slptime = 0;
		p->p_link = *q;
		*q = p;
		ASSERT(p->p_link != p);

		if (tmpdisp <= PZERO)
			atom_or(&p->p_flag, SNWAKE);
		spin_unlock(&proc_lock);
		swtch();

		atom_and(&p->p_flag, ~SNWAKE);
		if ((tmpdisp > PZERO) &&
		  (p->p_cursig || (p->p_sig & ~p->p_hold)))
			retval = confirm_signal(disp);
	}
	splx(s);
	return(retval);
}

/*
 * mfs_sleep
 *
 *	- give up the processor, waiting for an event to occur.
 *	  rescheduling should be arranged by another process calling
 *	  mfs_wakeup_all, or setrun.
 *
 * Parameters:
 *
 *	chan - address to wait on
 *
 *	disp - priority associated with waiting, and scheduling
 *
 *	short_cr_sem - address of a semaphore to unlock after fully on
 *		       the mfs_sleep_que
 *
 * Assumptions:
 *
 *	the calling process(or) has already locked the short critical
 *	region controlled by short_cr_sem
 *
 *	signals are ignored within this routine
 *
 * Return Values:
 *
 *
 * Note:
 *
 *	proc_lock is responsible for protecting:
 *		the sleep queues, p->p_stat, p->p_flag, p->p_wchan
 *
 *		signal processing for the current process and premature wakeups.
 *		
 * Side Effects:
 *
 *	the sleep queue is locked/unlocked
 *
 */

mfs_sleep(chan, disp, short_cr_sem)
register caddr_t	chan;
register unsigned int	disp;
register struct	sem_lock	*short_cr_sem;
{
	register proc_t	*p = u.u_procp;
	register proc_t	**q = sqhash(chan);

	ulong	saved_psw = short_cr_sem->lock_psw;
	ulong	saved_pc = short_cr_sem->ret_pc;

	ASSERT(p->p_stat != SSLEEP);

	if (panicstr) {
		spin_unlock(short_cr_sem);
		fspl0();
		/* allow interrupts, but don't allow context switch */
		spin_lock(short_cr_sem);
		restore_spin_lock(short_cr_sem, saved_psw);
		short_cr_sem->ret_pc = saved_pc;
		return(0);
	}

	ASSERT(!own.o_in_int_service);

	/* put on sleep queue */

	ASSERT(chan != 0);

	spin_lock(&proc_lock);
	exit_short_cr_no_spl(short_cr_sem);
	p->p_stat = SSLEEP;
	p->p_wchan = chan;
	p->p_slptime = 0;
	p->p_link = *q;
	*q = p;
	ASSERT(p->p_link != p);

	if (p->p_time > TZERO)
		p->p_time = TZERO;

	if (p->p_pri > disp) 
		p->p_pri = disp;

	atom_or(&p->p_flag, SNWAKE);
	spin_unlock(&proc_lock);

	swtch();

	atom_and(&p->p_flag, ~SNWAKE);
	/* process has been restarted (e.g. a wakeup has happened)
	 * the original lock is now again needed and the original information
	 * is restored.
	 */
	spin_lock(short_cr_sem);
	restore_spin_lock(short_cr_sem, saved_psw);
	short_cr_sem->ret_pc = saved_pc;
	return(0);
}


mfs_sleep_with_sig_check(chan, disp, short_cr_sem)
register caddr_t	chan;
unsigned int	disp;
register struct	sem_lock	*short_cr_sem;
{
	register proc_t *p = u.u_procp;
	register proc_t **q = sqhash(chan);
	register tmpdisp;
	uint retval = 0;

	ulong	saved_psw = short_cr_sem->lock_psw;
	ulong	saved_pc = short_cr_sem->ret_pc;

	ASSERT(p->p_stat != SSLEEP);

	if (panicstr) {
		spin_unlock(short_cr_sem);
		fspl0();
		/* allow interrupts, but don't allow context switch */
		spin_lock(short_cr_sem);
		restore_spin_lock(short_cr_sem, saved_psw);
		short_cr_sem->ret_pc = saved_pc;
		return(0);
	}


	ASSERT(!own.o_in_int_service);
	/* put on sleep queue */

	ASSERT(chan != 0);

	if (p->p_time > TZERO)
		p->p_time = TZERO;
	tmpdisp = disp & PMASK;
	if (p->p_pri > tmpdisp)
		p->p_pri = tmpdisp;

	spin_lock(&proc_lock);
	exit_short_cr_no_spl(short_cr_sem);

	if ((tmpdisp > PZERO) && (p->p_cursig || (p->p_sig & ~p->p_hold))) {
		spin_unlock(&proc_lock);
		retval = confirm_signal(disp);
	} else {
		/* We are now committed to going to sleep */

		p->p_stat = SSLEEP;
		p->p_wchan = chan;
		p->p_slptime = 0;
		p->p_link = *q;
		*q = p;
		ASSERT(p->p_link != p);

		if (tmpdisp <= PZERO)
			atom_or(&p->p_flag, SNWAKE);
		spin_unlock(&proc_lock);
		swtch();

		atom_and(&p->p_flag, ~SNWAKE);
		if ((tmpdisp > PZERO) &&
		  (p->p_cursig || (p->p_sig & ~p->p_hold)))
			retval = confirm_signal(disp);
	}
	/* process has been restarted (e.g. a wakeup has happened)
	 * the original lock is now again needed and the original information
	 * is restored.
	 */
	spin_lock(short_cr_sem);
	restore_spin_lock(short_cr_sem, saved_psw);
	short_cr_sem->ret_pc = saved_pc;
	return(retval);
}

/*
 * suspend_sleep
 *
 *	- give up the processor, waiting for an event to occur.
 *	  rescheduling should be arranged by another process calling
 *	  suspend_wakeup, or setrun.
 *
 * Parameters:
 *
 *	chan - address to wait on
 *
 *	disp - priority associated with waiting, and scheduling
 *
 *	susp_lockp - address of a suspend_lock to unlock after fully on
 *		       the sleep queue, and to relock when awakened
 *
 * Assumptions:
 *
 *	the calling process(or) has already locked the passed suspend_lock
 *
 * Return Values:
 *
 *
 * Note:
 *
 *	proc_lock is responsible for protecting:
 *		the sleep queues, p->p_stat, p->p_flag, p->p_wchan
 *
 *		signal processing for the current process and premature wakeups.
 *		
 * Side Effects:
 *
 *	the sleep queue is locked/unlocked
 *
 */

suspend_sleep(chan, disp, susp_lockp)
register caddr_t	chan;
register unsigned int	disp;
register suspend_lock_t	*susp_lockp;
{
	register proc_t	*p = u.u_procp;
	register proc_t	**q = sqhash(chan);
	register int	s;
	register tmpdisp;
	uint retval = 0;
#ifdef SUSPEND_DEBUG
	suspend_lock_t	temp;

	for (s = SUSPEND_DEBUG; --s >= 0; )
		temp.s_func[s] = susp_lockp->s_func[s];	/* save func info */
#endif

	s = splhi();
	if (panicstr) {
		fspl0();
		splx(s);
		return(0);
	}


	ASSERT(!own.o_in_int_service);
	/* put on sleep queue */

	ASSERT(chan != 0);

	if (p->p_time > TZERO)
		p->p_time = TZERO;
	tmpdisp = disp & PMASK;
	if (p->p_pri > tmpdisp)
		p->p_pri = tmpdisp;

	spin_lock(&proc_lock);

	if ((tmpdisp > PZERO) && (p->p_cursig || (p->p_sig & ~p->p_hold))) {
		spin_unlock(&proc_lock);
		/* suspend_unlock be after spin_unlock proc_lock,
		 * because suspend_unlock may require proc_lock.
		 */
		suspend_unlock(susp_lockp);
		retval = confirm_signal(disp);
	} else {
		/* We are now committed to going to sleep */

		p->p_stat = SSLEEP;
		p->p_wchan = chan;
		p->p_slptime = 0;
		p->p_link = *q;
		*q = p;

		if (tmpdisp <= PZERO)
			atom_or(&p->p_flag, SNWAKE);
		spin_unlock(&proc_lock);

		/* suspend_unlock be after spin_unlock proc_lock,
		 * because suspend_unlock may require proc_lock.
		 */
		suspend_unlock(susp_lockp);

		swtch();

		atom_and(&p->p_flag, ~SNWAKE);
		if ((tmpdisp > PZERO) &&
		  (p->p_cursig || (p->p_sig & ~p->p_hold)))
			retval = confirm_signal(disp);
	}
	/* Process has been restarted (e.g. a wakeup has happened)
	 * the original lock is now again needed.
	 */
	suspend_lock(susp_lockp);
#ifdef SUSPEND_DEBUG
	for (tmpdisp = SUSPEND_DEBUG; --tmpdisp >= 0; )	/* restore func info */
		susp_lockp->s_func[tmpdisp] = temp.s_func[tmpdisp];
#endif
	splx(s);
	return(retval);
}

/*
 * Remove a process from its wait queue.
 */

unsleep(p)
register struct proc *p;
{
	register struct proc **q;

	if (p->p_wchan) {
		for (q = sqhash(p->p_wchan); *q != p; q = &(*q)->p_link)
			;
		*q = p->p_link;
		p->p_wchan = 0;
	}
}

/*
 * Wake up all processes sleeping on chan.  Note that a process on a
 * sleep queue may be either in state SSLEEP or in state SSTOP; if it
 * was stopped we remove it from its sleep queue but we don't set it
 * running here.
 */

wakeup(chan)
register caddr_t chan;
{
	register proc_t *p;
	register proc_t	**q;
	register int	runsched = 0;

	spin_lock(&proc_lock);
	for (q = sqhash(chan); p = *q; ) {
		ASSERT(p->p_stat == SSLEEP || p->p_stat == SSTOP);
		ASSERT(p->p_link != p);
		if (p->p_wchan == chan) {
			/* 
			 * take off sleep queue, put on run queue
			 * if not SSTOP.
			 */
			p->p_wchan = 0;
			*q = p->p_link;
			if (p->p_stat == SSLEEP) {
#ifdef	PERF
				WAKEUPPRI(p);	/* mods p_pri & own.o_curpri */
#endif	/* PERF */
				setrq(p);

				/*MONITOR('W', p, chan, 0, 0);*/

				/*
				 * Make arrangements for swapin
				 * or preemption if necessary
				 */

				if (!(p->p_flag&SLOAD)) {

					/* we must not call setrun here!*/

					p->p_time = 0;
					if (runout > 0)
						runsched = 1;
				}
			}
			p->p_slptime = 0;
		} else
			q = &p->p_link;
	}
	spin_unlock(&proc_lock);

	if (runsched) {
		runout = 0;
		setrun(&proc[0]);
	}
}

/*
 * Wake up the first process sleeping on chan.  Note that a process on a
 * sleep queue may be either in state SSLEEP or in state SSTOP; if it
 * was stopped we remove it from its sleep queue but we don't set it
 * running here.
 *
 *	return  0 if there are no other sleepers on wchan
 *	return  1 if there are other sleepers on wchan.
 *	return -1 if there were no sleepers on wchan.
 */

wakeup_one(chan)
register caddr_t chan;
{
	register proc_t *p;
	register proc_t	**q;
	register uint	num_found, woke_one;
	int		runsched = 0;

	num_found = woke_one = 0;

	spin_lock(&proc_lock);
	for (q = sqhash(chan); p = *q; ) {
		ASSERT(p->p_stat == SSLEEP || p->p_stat == SSTOP);
		if (p->p_wchan != chan) {
			q = &p->p_link;
			continue;
		}
		if (num_found++ && woke_one)
			break;
		/* 
		 * take off sleep queue, put on run queue if not SSTOP.
		 */
		p->p_wchan = 0;
		*q = p->p_link;
		if (p->p_stat == SSLEEP) {
			if (woke_one++) {
				q = &p->p_link;
				continue;
			}
#ifdef PERF
			WAKEUPPRI(p);	/* mods p_pri & own.o_curpri */
#endif
			setrq(p);
			/*
			 * Make arrangements for swapin
			 * or preemption if necessary
			 */
			if (!(p->p_flag & SLOAD)) {
				/* we must not call setrun here!*/
				p->p_time = 0;
				if (runout > 0)
					runsched = 1;
			}
		}
		p->p_slptime = 0;
	}
	spin_unlock(&proc_lock);

	if (runsched) {
		runout = 0;
		setrun(&proc[0]);
	}
	return (woke_one ? (num_found > 1) : -1);
}

/*
 * Set the process running;
 * arrange for it to be swapped in if necessary.
 */

setrun(p)
register struct proc *p;
{

	spin_lock(&proc_lock);
	switch (p->p_stat) {

	case SSLEEP:
		/* take off sleep queue */
		unsleep(p);
		break;
	case SSTOP:
		break;
	default:
		/* already on run queue, waiting for memory, etc. */
		spin_unlock(&proc_lock);
		return;
	}

	/* put on run queue */
	ASSERT(p->p_wchan == 0);
#ifdef	PERF
	SETRUNPRI(p);	/* modifies p_pri & own.o_curpri */
#endif	/* PERF */
	setrq(p);
	spin_unlock(&proc_lock);

	/*
	 * Make arrangements for swapin or preemption if necessary.
	 */

	if (!(p->p_flag&SLOAD)) {
		p->p_time = 0;
		if (runout > 0) {
			runout = 0;
			setrun(&proc[0]);
		}
	}
}
