/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sig.c: version 25.4 created on 7/24/92 at 19:34:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sig.c	25.4	7/24/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * 001	JPC	8/30/88	Move the user structure to the top of the u-page,
 *			instead of the bottom.  Modify core(), and procxmt()
 *			for backwards compatability with debuggers.  E.g. make
 *			ptrace() command 3 only able to access the user struct,
 *			and rearrange the u-page in the core file back to the
 *			historical one:  user struct at offset 0, followed by
 *			the system stack.  Note that none of the pointers from
 *			the user structure to the system stack, or the frame
 *			pointers in the system stack will be correct, except
 *			for u_ar0.  The define U_SIZE is the combined size of
 *			the user struct and the size of the u_ofile and
 *			u_pofile arrays.
 */

#ident	"@(#)uts/os:sig.c	20.1"

#include "sys/types.h"
#include "sys/psl.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/pfdat.h"
#include "sys/region.h"
#include "sys/systm.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/proc.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/nami.h"
#include "sys/file.h"
#include "sys/var.h"
#include "sys/map.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/message.h"
#include "sys/spl.h"
#include "sys/wait.h"
#include "sys/fpu.h"
#include "sys/reg.h"
#include "sys/kmem.h"
#include "sys/own.h"
#include "sys/lio.h"

#define	sigbit(n)	(1L << ((n) -1))

/*
 * Priority for tracing
 */

#define	IPCPRI	PZERO

/*
 * Tracing variables.
 * Used to pass trace command from
 * parent to child being traced.
 * This data base cannot be
 * shared and is locked
 * per user.
 */

struct
{
	int	ip_lock;
	int	ip_req;
	int	*ip_addr;
	int	ip_data;
} ipc;

/* 
 * Extra storage for ipc record to hold  floating point info 
 */

fregs ipc_fpu_fregs;

/*
 * Send the specified signal to all processes with 'pgrp' as
 * process group.  Called by tty.c for quits and interrupts.
 */

signal(pgrp, sig)
register pgrp;
{
	register proc_t *p;

	if (pgrp == 0)
		return;
	for (p = &proc[1]; p < (struct proc *)v.ve_proc; p++) 
		if (p->p_pgrp == pgrp) 
			psignal(p, sig);
}

/*
 * Send the specified signal to the specified process.
 */

psignal(p, sig)
register proc_t *p;
register int sig;
{
	if (sig <= 0 || sig >= NSIG)
		return;
	
	if( sig == SIGCONT )  {
		atom_and(&p->p_sig, ~STOPSIGMASK);
		if (IS_SVID_PROC(u.u_procp))
			return (0);
	}
	else if( sigbit(sig) & STOPSIGMASK )
		atom_and(&p->p_sig, ~sigbit(SIGCONT) );

	atom_or(&p->p_sig, sigbit(sig));

	spin_lock(&proc_lock);
	/* prevent race condition where process has checked signals
	 * and is going to sleep
	 */
	spin_unlock(&proc_lock);

	if (p->p_stat == SSLEEP && ((p->p_flag & SNWAKE) == 0)) {
		if (!(p->p_hold & sigbit(sig)))
			setrun(p);
	} else if (p->p_stat == SSTOP) {
		if(sig == SIGCONT) {
			setrun(p);
			return;
		}
		if (sig == SIGKILL
		  && ((p->p_flag & STRC) == 0 || p->p_whystop != SIGNALLED)) {
			p->p_whystop = 0;
			p->p_whatstop = 0;
			setrun(p);
			return;
		}
	}
}

/*
 * Returns true if the current process has a signal to process, and
 * the signal is not held.  The signal to process is put in p_cursig.
 * This is asked at least once each time a process enters the system
 * (though this can usually be done without actually calling issig by
 * checking the pending signal masks).  A signal does not do anything
 * directly to a process; it sets a flag that asks the process to do
 * something to itself.
 *
 * The "why" argument indicates the allowable side-effects of the call:
 *
 * FORREAL:  Extract the next pending signal from p_sig into p_cursig;
 * stop the process if a stop has been requested or if a traced signal
 * is pending.
 *
 * JUSTLOOKING:  Don't stop the process, just indicate whether or not
 * a signal is pending.
 *
 * The following side-effects always result from calling issig(),
 * regardless of the "why" argument: (1) if the process has received
 * SIGCLD and is ignoring that signal, then its zombie children are
 * laid to rest; (2) both SIGPWR and SIGCLD are cancelled unless they're
 * being explicitly caught; (3) any signal which is being ignored and
 * not traced is cleared from the pending-signal mask.
 */


int
issig(why)
register int why;
{
	register int n;
	register proc_t *p = u.u_procp, *q;

	if (p->p_cursig)
		return(p->p_cursig);
	upkern_lock();
findsig:
	/*
	 * Loop on the pending signal mask until we find a non-ignored,
	 * non-held, non-traced signal.
	 */
	while (n = fsig(p)) {
		if (n == SIGCLD) {
			if (u.u_signal[SIGCLD-1] == SIG_IGN) {
				for (q = p->p_child; q; q = q->p_sibling)
					if (q->p_stat == SZOMB)
						freeproc(q, 0);
			} else if (u.u_signal[SIGCLD-1])
				break;
		} else if (n == SIGPWR) {
			if (u.u_signal[SIGPWR-1]
			  && u.u_signal[SIGPWR-1] != SIG_IGN)
				break;
		} else if( sigbit(n) & STOPSIGMASK ) {
			if(!(IS_JOBC_PROC(p)))  {
				atom_and(&p->p_sig, ~STOPSIGMASK);
				continue;
			}
			if((why == FORREAL) && (!u.u_signal[n-1])) {
				if (isorphaned(p, 0)) {
					if (sigbit(n) & ISTOPSIGMASK) {
						atom_and(&p->p_sig,
							~ISTOPSIGMASK);
						continue;
					}
				}
				p->p_cursig = n;
				/*
				 * Do a stop() before psignal() so that
				 * parent will find his child stopped.
				 * This is true for multiprocessor machines.
				 */
				stop(p);
				if(!(p->p_parent->p_posix_flags & 
							SA_NOCLDSTOP))
				    	psignal(p->p_parent, SIGCHLD);
				swtch();
				p->p_posix_flags &= ~TRACED;
				p->p_cursig = 0;
				atom_and(&p->p_sig,~sigbit(n));
				continue;
			}
			if(u.u_signal[n-1] != SIG_IGN) 
				break;
			else {
				atom_and(&p->p_sig, ~sigbit(n));
				continue;
			}
		
		} else if(n == SIGCONT) {
			 atom_and(&p->p_sig, ~STOPSIGMASK);
			 p->p_posix_flags &= ~TRACED;
			 if((u.u_signal[n-1] != SIG_DFL) && 
					(u.u_signal[n-1] != SIG_IGN)) 
				break;
		} else if ((u.u_signal[n-1] != SIG_IGN) || (p->p_flag & STRC))
			break;
		atom_and(&p->p_sig, ~sigbit(n));
	}
	if (n && why == FORREAL) {
		atom_and(&p->p_sig, ~sigbit(n));
		p->p_cursig = n;
	}
	if (n && why == FORREAL && ((p->p_flag & STRC))) {
		/*
		 * If tracing, stop.  If tracing via ptrace(2),
		 * call procxmt() repeatedly until released by
		 * debugger.
		 */
		do {
			if ((p->p_flag & STRC) && p->p_ppid == 1) {
				/*
				 * Parent of ptraced child has died; arrange
				 * for child to die.
				 */
				atom_or(&p->p_flag, SPTRX);
				if (p->p_cursig == 0)
					p->p_cursig = SIGKILL;
				upkern_unlock();
				return(p->p_cursig);
			}
			p->p_whystop = SIGNALLED;
			p->p_whatstop = n;
			stop(p);
			swtch();
		} while ((p->p_flag & STRC) && (p->p_ppid == 1 || !procxmt()));
		/*
		 * If a ptrace "exit" request has been issued,
		 * return immediately.
		 */
		if (p->p_flag & SPTRX) {
			upkern_unlock();
			return(p->p_cursig);
		}
		/*
		 * If the debugger wants us to take a signal it will
		 * leave it in p->p_cursig.  If p_cursig has been
		 * cleared or if it's being ignored, we loop around
		 * again looking for another signal.  Otherwise we
		 * return the specified signal.
		 */
		if ((n = p->p_cursig) == 0 || u.u_signal[n-1] == SIG_IGN
		  || ((n==SIGCLD || n==SIGPWR) && u.u_signal[n-1]==SIG_DFL)
		  || (p->p_hold & sigbit(n))) {
			if (n && (p->p_hold & sigbit(n)))
				atom_or(&p->p_sig, sigbit(n));
			/* No signal, or ignored signal; go look for more. */
			p->p_cursig = 0;
			goto findsig;
		}
	}
	/*
	 * Return found signal.
	 */
	upkern_unlock();
	return(n);
}

/*
 * Put the argument process into the stopped state and notify
 * tracers via wakeup.
 */

stop(p)
register proc_t *p;
{
	spin_lock(&proc_lock);
	p->p_stat = SSTOP;
	spin_unlock(&proc_lock);
	if ((p->p_flag & STRC) && p->p_whystop == SIGNALLED)	/* ptrace */
		wakeup((caddr_t)p->p_parent);
}

/*
 * Perform the action specified by the current signal.
 * The usual sequence is:
 * 	if (issig())
 * 		psig();
 * The signal bit has already been cleared by issig,
 * and the current signal number stored in p->p_cursig.
 */
psig()
{
	register int n;
	register proc_t *p = u.u_procp;
	void (*func)();
	int returnmask;

	ASSERT(p->p_cursig);

	upkern_lock();

	n = p->p_cursig;
	p->p_cursig = 0;
	/* Exit immediately on a ptrace exit request. */
	if (p->p_flag & SPTRX) {
		atom_and(&p->p_flag, ~SPTRX);
		exit(n);
	}
	if ((func = u.u_signal[n-1]) != SIG_DFL) {
#ifdef	M68020
		/* if we are in mid coproc instruction, delay sig til done */
		if (u.u_astk->s_format == COP_MIDINSTR){
			p->p_cursig = n;
			atom_or(&p->p_flag, SSIGTRC);
			u.u_astk->s_ps |= PS_T;
			upkern_unlock();
			return;
			}
#endif	/* M68020 */
		ASSERT(func != SIG_IGN);
		u.u_error = 0;
		/* For sigset(2), turn on p_hold bit. */
		if (p->p_chold & sigbit(n))
			p->p_hold |= sigbit(n);
		else if(p->p_posix_sig & sigbit(n))  {
			if(p->p_flag & SOMASK)  {
				returnmask = u.u_oldmask;
				atom_and(&p->p_flag, ~SOMASK);
			}
			else
				returnmask = p->p_hold;
			p->p_hold |=((u.u_sigmask[n-1]| sigbit(n)) & ~CANTMASK);
			pos_sendsig(func,returnmask);
			upkern_unlock();
			return;
		}
		else if (n != SIGILL && n != SIGTRAP && n != SIGPWR)
			u.u_signal[n-1] = SIG_DFL;
		sendsig(func);
		upkern_unlock();
		return;
	}
	switch (n) {

	case SIGQUIT:
	case SIGILL:
	case SIGTRAP:
	case SIGIOT:
	case SIGEMT:
	case SIGFPE:
	case SIGBUS:
	case SIGSEGV:
	case SIGSYS:
		u.u_sysabort = n;	/* record reason for core */
		if (core())
			n += 0200;
		u.u_sysabort = 0;	/* undue caution */
	}
	exit(n);
	upkern_unlock();
}

/*
 * Find the next unheld signal in bit-position representation in p_sig.
 */

int
fsig(p)
register proc_t *p;
{
	register i;
	register n;

	if (n = (p->p_sig & ~p->p_hold)) {
		for (i = 1; i < NSIG; i++) {
			if (n & 1L)
				return(i);
			n >>= 1;
		}
	}
	return(0);
}

/*
 * Create a core image on the file "core".
 *
 * It writes USIZE block of the
 * user.h area followed by the entire
 * data+stack segments.
 */


core()
{
	register struct inode *ip;
	struct argnamei nmarg;
	extern spath();
	register preg_t	*prp;
	register proc_t *pp;
	register int	gap;
	extern int	userstack[];

	if (u.u_uid != u.u_ruid)
		return(0);
	u.u_error = 0;
	u.u_dirp = "core";
	u.u_syscall = DUCOREDUMP;
	nmarg.cmd = NI_CREAT;
	nmarg.mode = ((IREAD|IWRITE)>>6)|((IREAD|IWRITE)>>3)|(IREAD|IWRITE);
	nmarg.ftype = 0;
	ip = namei(spath, &nmarg);
	if (u.u_error)
		return(0);
	if (!FS_ACCESS(ip, IWRITE) && ip->i_ftype == IFREG) {

		/*
		 * Put the region sizes into the u-block for the dump.
		 */
		pp = u.u_procp;
		if (prp = findpreg(pp, PT_TEXT))
			u.u_tsize = prp->p_reg->r_pgsz;
		else
			u.u_tsize = 0;
		
		/*
		 * In the following, we do not want to write
		 * out the gap but just the actual data.  The
		 * caluclation mirrors that in loadreg and
		 * mapreg which allocates the gap and the
		 * actual space separately.  We have to watch
		 * out for the case where the entire data region
		 * was given away by a brk(0).
		 */

		if (prp = findpreg(pp, PT_DATA)) {
			u.u_dsize = prp->p_reg->r_pgsz;
			gap = btoct((caddr_t)u.u_exdata.ux_datorg
			  - prp->p_regva);
			if (u.u_dsize > gap)
				u.u_dsize -= gap;
			else
				u.u_dsize = 0;
		} else
			u.u_dsize = 0;

		if (prp = findpreg(pp, PT_STACK))
			u.u_ssize = prp->p_reg->r_pgsz;
		else
			u.u_ssize = 0;

		/*
		 * Check the sizes against the current ulimit and
		 * don't write a file bigger than ulimit.  If we
		 * can't write everything, we would prefer to
		 * write the stack and not the data rather than
		 * the other way around.
		*/

		if (USIZE + u.u_dsize + u.u_ssize > (uint)dtop(u.u_limit)) {
			u.u_dsize = 0;
			if (USIZE + u.u_ssize > (uint)dtop(u.u_limit))
				u.u_ssize = 0;
		}

		{ /* local */
		/* 
		 * Modify the register array to look pleasing to debuggers 
		 */
		    /* 
		     * Modify the register array to be an array of
		     * longs for the debuggers by overwriting the astk
		     * stuff. Set u_ar0 to point to this array.
		     */
		    int tmp_pc, tmp_sr;
		    tmp_pc = u.u_astk->s_pc;
		    tmp_sr = u.u_astk->s_ps;
		    ((int *)(u.u_astk))[SR] = tmp_sr & 0xff;
		    ((int *)(u.u_astk))[PC] = tmp_pc;
		} /* local */
		u.u_ar0 = (int *)((int)u.u_astk - (int)ADDR_U);

		/*
		 * Save FPU status and write the u-block to
		 * the dump file.
		 */
		if ( own.o_fpu_loaded )
			fpu_save();

		ITRUNC(ip);
		/* 001
		 * Since the user struct is above the system stack, first write
		 * out the u struct and its ofiles, with a calculated value for
		 * u_ar0 as it will appear in the core file.  Then, add the
		 * system stack (shifted up by U_SIZE).
		 */
		u.u_ar0 += U_SIZE / sizeof(*u.u_ar0);
		u.u_offset = 0;
		u.u_base = (caddr_t)&u;
		u.u_count = U_SIZE;
		u.u_segflg = 1;
		u.u_fmode = FWRITE;
		WRITEI(ip);
		/* now write out the system stack */
		u.u_base = (caddr_t)ADDR_U;
		u.u_count = ctob(USIZE) - U_SIZE;
		WRITEI(ip);					/* 001 */

		/* Write the data and stack to the dump file. */
		
		u.u_segflg = 0;
		if (u.u_dsize) {
			u.u_base = (caddr_t)u.u_exdata.ux_datorg;
			u.u_count = ctob(u.u_dsize) - poff(u.u_base);
			WRITEI(ip);
			u.u_offset = ctob(btoc(u.u_offset));
		}
		if (u.u_ssize) {
			u.u_count = ctob(u.u_ssize);
			u.u_base = (caddr_t)ctob(btoc((caddr_t)userstack))
				    - u.u_count;
			WRITEI(ip);
		}

	} else
		u.u_error = EACCES;
	iput(ip);
	return(u.u_error==0);
}

/*
 * sys-trace system call.
 */

ptrace()
{
	register int	cmd;
	register struct proc *p;
	register struct a {
		int	req;
		int	pid;
		int	*addr;
		int	data;
	} *uap;

	if ( own.o_fpu_loaded )
		fpu_save();
	uap = (struct a *)u.u_ap;
	if (uap->req <= 0) {
		atom_or(&u.u_procp->p_flag, STRC);
		return;
	}
	for (p = u.u_procp->p_child; p; p = p->p_sibling)
		if (p->p_stat == SSTOP && p->p_pid == uap->pid
		  && (p->p_flag & STRC) && p->p_whystop == SIGNALLED)
			goto found;
	u.u_error = ESRCH;
	return;

    found:
	while (ipc.ip_lock)
		sleep((caddr_t)&ipc, IPCPRI);
	ipc.ip_lock = p->p_pid;
	ipc.ip_data = uap->data;
	ipc.ip_addr = uap->addr;
	ipc.ip_req = uap->req;
	cmd = ipc.ip_req;

	if (cmd == 11) {
		/* modify fpp registers from parent's address space */
		if (copyin(ipc.ip_addr, &ipc_fpu_fregs, sizeof(ipc_fpu_fregs))){
			u.u_error = EFAULT;
			ipc.ip_lock = 0;
			wakeup((caddr_t)&ipc);
			return;
		}
	}

	atom_and(&p->p_flag, ~SWTED);
	setrun(p);
	while (ipc.ip_req > 0)
		sleep((caddr_t)&ipc, IPCPRI);
	if (ipc.ip_req < 0)
		u.u_error = EIO;
	else
		u.u_rval1 = ipc.ip_data;

	if ((cmd == 10) && (ipc.ip_req != -1)) {
		/* read fpp registers  to parent's address space */
		if (copyout(&ipc_fpu_fregs, ipc.ip_addr, sizeof(ipc_fpu_fregs)))
			u.u_error = EFAULT;
	}

	ipc.ip_lock = 0;
	wakeup((caddr_t)&ipc);
}

/*
 * Code that the child process
 * executes to implement the command
 * of the parent process in tracing.
 */
#define offsetof(structname,fieldname) (size_t)&(((structname *)0)->fieldname)
/*
 * SDB is confused about the offset of pc: it doesn't know sr (psw) is a short.
 */
#define SDB_PC_OFFSET	(offsetof(state_t, s_pc) + 2)

procxmt()
{
	register uint i;
	int s;

	if (ipc.ip_lock != u.u_procp->p_pid)	/* BSD43 */
		return (0);			/* BSD43 */
	u.u_procp->p_slptime = 0;		/* BSD43 */
	i = ipc.ip_req;
	ipc.ip_req = 0;
	/* A1000 binaries don't have a text region; the data reg has PF_A1000 */
	if (u.u_procp->p_region->p_flags & PF_A1000) {
		printf("A1000 binary ptrace not supported\n");
		goto error;
	}

	switch (i) {

	case 1: /* read user I */
	case 2: /* read user D */

		if ((int)ipc.ip_addr & (sizeof(short)-1)
		  || copyin((caddr_t)ipc.ip_addr, &ipc.ip_data, sizeof(int)))
			goto error;
		break;


	case 3: /* read u */

		i = (uint)ipc.ip_addr;

		/*
		 * read registers: if offset is between U_AR0 & U_AR0 + 
		 * a register offset into state_t, return value of register.
		 */
		if (i >= U_AR0 && i <= U_AR0 + SDB_PC_OFFSET) {

			i -= U_AR0;

			if (i < offsetof(state_t, s_ps))
				ipc.ip_data = ((int *)(u.u_astk))[i>>2];

			else if (i == offsetof(state_t, s_ps))
				ipc.ip_data = u.u_astk->s_ps;
			else 
				ipc.ip_data = u.u_astk->s_pc;
			break;
		}

		/* 
		 * normal read of u: return long word at given (byte) offset.
		 */
		if (i >= 0 && i < U_SIZE) {
			ipc.ip_data = ((physadr)&u)->r[i>>2];
			break;
		}

		goto error;

	case 4: /* write user I */
	{
		register preg_t *prp;
		register reg_t *rp;
		preg_t *vtopreg(), *xdup();

		if ((prp = vtopreg(u.u_procp, ipc.ip_addr)) == NULL)
			goto error;
		rp = prp->p_reg;
		if (rp->r_type == RT_STEXT) {
			if (rp->r_iptr)
				plock(rp->r_iptr);
			reglock(rp);
			if ((prp = xdup(u.u_procp, prp)) == NULL)
				goto error;
			rp = prp->p_reg;
			if (rp->r_iptr)
				prele(rp->r_iptr);
			regrele(rp);
		}
		reglock(rp);
		chgprot(prp, SEG_RW);
		regrele(rp);
		flush_all_own_tlb();
		i = suword((caddr_t)ipc.ip_addr, ipc.ip_data);
		reglock(rp);
		chgprot(prp, SEG_RO);
		regrele(rp);
		flush_all_own_tlb();
		if (i < 0)
			goto error;
		break;
	}

	case 5: /* write user D */

		if (suword((caddr_t)ipc.ip_addr, ipc.ip_data) < 0)
			goto error;
		break;

	case 6: /* write u */

		i = (uint)ipc.ip_addr;
		/*
		 * allow writes to regs, pc and condition codes of SR (ps) only.
		 */
		if (i < U_AR0 || i > U_AR0 + SDB_PC_OFFSET)
			goto error;

		i -= U_AR0;

		if (i < offsetof(state_t, s_ps))
			((int *)(u.u_astk))[i>>2] = ipc.ip_data;

		else if (i == offsetof(state_t, s_ps)) {
			ipc.ip_data &= NZVC;
			ipc.ip_data |= u.u_astk->s_ps & ~NZVC;
			u.u_astk->s_ps = ipc.ip_data;
		} 
		else 	
			u.u_astk->s_pc = ipc.ip_data;

		break;

	case 9:	/* set signal with trace trap and continue. */

		u.u_astk->s_ps |= PS_T;

		/* Note fall-through. */

	case 7: /* set signal and continue */

		if ((int)ipc.ip_addr != 1)
			u.u_astk->s_pc = (ulong) ipc.ip_addr;
		if ((unsigned int)ipc.ip_data >= NSIG)
			goto error;
		s = splhi();
		u.u_procp->p_cursig = ipc.ip_data;
		u.u_procp->p_whystop = 0;
		u.u_procp->p_whatstop = 0;
		splx(s);
		wakeup((caddr_t)&ipc);
		return(1);

	case 8: /* force exit */

		wakeup((caddr_t)&ipc);
		atom_or(&u.u_procp->p_flag, SPTRX);
		if (u.u_procp->p_cursig == 0)
			u.u_procp->p_cursig = SIGKILL;
		return(1);

	case 10:
		/* read fpp registers */
		if (u.u_fpu.fsave[FPU_VERSION] == FPU_VERSION_NULL)
			goto error; /* fpu not home -- or not yet used */

		bcopy(&u.u_fpu.regs, &ipc_fpu_fregs, sizeof(ipc_fpu_fregs));
		break;

	case 11:

		/* write fpp registers */
		if (u.u_fpu.fsave[FPU_VERSION] == FPU_VERSION_NULL) {
			if (! own.o_fpu_loaded)
				fpu_restore();
			ml_fpu_idle();
			if ( own.o_fpu_loaded )
				fpu_save();
		} /* if */

		if (u.u_fpu.fsave[FPU_VERSION] == FPU_VERSION_NULL)
			goto error; /* fpu not home -- or not yet used */
		bcopy(&ipc_fpu_fregs, &u.u_fpu.regs, sizeof(ipc_fpu_fregs));

		break;

	default:
	error:
		ipc.ip_req = -1;
	}


	wakeup((caddr_t)&ipc);
	return(0);
}


/*
 * New system call in posix.  It is also in 5.4.
 */
sigaction()
{
	register struct a {
		int signo;
		sigact_t *nsact;
		sigact_t *osact;
	}  *uap;
	sigact_t old_sact;
	sigact_t new_sact;
	register sigact_t *sv;
	register int sig;
	int bit;

	uap = (struct a *)u.u_ap;
	sig = uap->signo;
	if (sig <= 0 || sig >= NSIG) {
		u.u_error = EINVAL;
		return;
	}
	if (uap->osact) {
		sv = &old_sact;
		sv->sa_handler = u.u_signal[sig-1];
		sv->sa_mask = u.u_sigmask[sig-1];
		if(sig == SIGCHLD)
			sv->sa_flags = u.u_procp->p_posix_flags & SA_NOCLDSTOP;
		else
			sv->sa_flags = 0;
		if(copyout((caddr_t)sv,(caddr_t)uap->osact, sizeof(sigact_t))){
			u.u_error = EFAULT;
			return;
		}
	}
	if (uap->nsact) {  
		if(sig == SIGKILL || sig == SIGSTOP || sig == SIGSAK) {
			u.u_error = EINVAL;
			return;
		}
		if (IS_SVID_PROC(u.u_procp) && (sigbit(sig) & POSIXSIGNALS))  {
			u.u_error = EINVAL;
			return;
		}
		sv = &new_sact;
		if (copyin(uap->nsact, sv, sizeof(sigact_t)) ) {
			u.u_error = EFAULT;
			return;
		}
		setsigaction(sig, sv);
	}
}

setsigaction(sig, sv)
int sig;
register sigact_t *sv;
{
	register struct proc *p;
	register int bit;

	bit = sigbit(sig);
	p = u.u_procp;
	u.u_signal[sig-1] = sv->sa_handler;
	u.u_sigmask[sig-1] = sv->sa_mask &~ CANTMASK;

	if( sv->sa_flags & SA_NOCLDSTOP)
		p->p_posix_flags |= SA_NOCLDSTOP;
	else
		p->p_posix_flags &=  ~SA_NOCLDSTOP;

	/* we take away the signal SIGCHLD if it is set to default,
	 * because its default action is to ignore the signal.
	 */
	if (sv->sa_handler == SIG_IGN ||
			(sv->sa_handler == SIG_DFL && sig == SIGCHLD)) 
		atom_and(&p->p_sig, ~bit);
	p->p_posix_sig |= bit;
	/* p_chold set by sigset. p_chold & p_posix_bit mutually exclusive */
	p->p_chold &= ~bit;
}



sigsuspend()
{
	struct a {
		sigset_t *mask;
	} *uap = (struct a *)u.u_ap;
	register struct proc *p = u.u_procp;
	unsigned int local_mask;

	/*
	 * When returning from sigsuspend, we want
	 * the old mask to be restored after the
	 * signal handler has finished.  Thus, we
	 * save it here and mark the proc structure
	 * to indicate this.
	 */

  	if( copyin(uap->mask, &local_mask, sizeof(int)))  {
			u.u_error = EFAULT;
			return;
	}
	if (IS_SVID_PROC(u.u_procp) && (local_mask & POSIXSIGNALS))  {
		u.u_error = EINVAL;
		return;
	}

	u.u_oldmask = p->p_hold;
	atom_or(&p->p_flag, SOMASK);
	p->p_hold = local_mask & ~CANTMASK;
	for (;;)
		sleep((caddr_t)&u, PSLEP);
	/*NOTREACHED*/
}


sigpending()
{
	struct a {
		sigset_t *set;
	} *uap = (struct a *)u.u_ap;
	register struct proc *p = u.u_procp;

	if( copyout(&p->p_sig,uap->set,sizeof(sigset_t)) )  {
			u.u_error = EFAULT;
			return;
	}

}


sigprocmask()
{
	struct a {
		int how;
		sigset_t *set;
		sigset_t *oset;
	} *uap = (struct a *)u.u_ap;

	struct proc *p = u.u_procp;
	sigset_t local_set;

	/* if oset is not NULL, store the previous mask there */
	if(uap->oset){
		if( copyout(&p->p_hold,uap->oset,sizeof(sigset_t)) ) {
			u.u_error = EFAULT;
			return;
		}
	}


	/* If set is not NULL it is to be used to set up the new mask
	depending on the value of "how"
	*/

	if(uap->set){
		if( copyin(uap->set,&local_set,sizeof(sigset_t)) )  {
			u.u_error = EFAULT;
			return;
		}
		if (IS_SVID_PROC(u.u_procp) && (local_set & POSIXSIGNALS))  {
			u.u_error = EINVAL;
			return;
		}
		switch( uap->how )  {

			case SIG_BLOCK:
				p->p_hold |= (local_set & ~CANTMASK);
				break;

			case SIG_UNBLOCK:
				p->p_hold &= ~local_set;
				break;

			case SIG_SETMASK:
				p->p_hold = (local_set & ~CANTMASK);
				break;
			default:
				u.u_error = EINVAL;
				return;
		}

	}
}

/*
 * kill_proc -- send sig to a proc, returns non-zero on success
 */

kill_proc(sig, pid)
uint		sig;
register uint	pid;
{
	register proc_t	*p;

	for (p = proc; p < (struct proc *)v.ve_proc; p++)
		if (p->p_stat != NULL && p->p_pid == pid) {
			psignal(p, sig);
			return (1);
		}

	return (0);
}
