/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scheds5.c: version 25.1 created on 11/27/91 at 15:11:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scheds5.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/param.h"
#include "sys/user.h"
#include "sys/proc.h"
#include "sys/cmn_err.h"
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#include "sys/perf.h"
#include "sys/perfext.h"
#include "sys/debug.h"
#include "sys/sysinfo.h"
#include "sys/own.h"

s5_clkcpu(pp)
register struct	proc	*pp;
{
	if (!own.o_switching && (pp->p_cpu < S5_CPULIMIT))
		pp->p_cpu++;
	ASSERT((pp->p_cpu >= 0) && (pp->p_cpu <= S5_CPULIMIT));
}

s5enh_clkcpu(pp)
register struct	proc	*pp;
{
	if ((lbolt & s5enh_cpuattack) == 0) {	/* power of 2 adjustment */
		if (!own.o_switching && (pp->p_cpu < s5enh_cpulimit)) {
			pp->p_cpu++;
			PERF_CPU_CLAMP(pp,pp->p_cpu);
		}
	}
}

/*
 * Decay by one-half.
 */
s5_ukclkcpu(pp)
struct	proc	*pp;
{
	pp->p_cpu >>= 1;		/* divide by 2	*/
	ASSERT((pp->p_cpu >= 0) && (pp->p_cpu <= S5_CPULIMIT));
}

/*
 * Decay by one-over-X.
 */
s5enh_ukclkcpu(pp)
struct	proc	*pp;
{
register uint	cpu;

	cpu = (uint) pp->p_cpu;
	cpu = (cpu - (cpu / s5enh_cpudecay));
	pp->p_cpu = (uchar) cpu;
}

/*
 * Decay by logarithmic function based on BSD's load averaging
 * with user specified cpu limit (independent of clamp).
 */
s5bsd_ukclkcpu(pp)
register struct	proc	*pp;
{
register long		a, scale;

	scale	= filter(*(AvenPtr + which_loadavg));
	a	= ((scale * (pp->p_cpu & 0377)) / 1000) + pp->p_nice +
		WHICH_PRI_ADJ(pp);
	if (a < 0)
		a = 0;
	if (a > s5bsd_cpulimit)
		a = s5bsd_cpulimit;
	pp->p_cpu = (uchar) a;
	PERF_CPU_CLAMP(pp,pp->p_cpu);
}

s5_ukclkpri(pp)
register struct proc	*pp;
{
register uchar	pri;

	if (pp->p_pri < (PUSER - NZERO))
		return;
	pri = (pp->p_cpu >> 1) + pp->p_nice + (PUSER - NZERO);
	ASSERT((pri >= (PUSER - NZERO)) && (pri < NUM_PRIORITIES));
	if ((pri != pp->p_pri) && (pp->p_stat == SRUN)) {
		disp_change_pri(pp, pri);
		ASSERT((pp->p_pri >= (PUSER - NZERO)) &&
			(pp->p_pri < NUM_PRIORITIES));
	}
}

s5enh_ukclkpri(pp)
register struct proc	*pp;
{
register ushort	pri;

	if (pp->p_pri < (PUSER - NZERO))
		return;
	pri = (pp->p_cpu >> 1) + pp->p_nice + (PUSER - NZERO) +
		WHICH_PRI_ADJ(pp);
	if (pri >= NUM_PRIORITIES) {
		pri = NUM_PRIORITIES - 1;
		if ((pp->p_nice + WHICH_PRI_ADJ(pp)) < NZERO)
			pri -= (NZERO - (pp->p_nice + WHICH_PRI_ADJ(pp)));
	}
	PERF_PRI_CLAMP(pp,pri);
	if ((pri != pp->p_pri) && (pp->p_stat == SRUN))
		disp_change_pri(pp, pri);
}

s5_userpri(pp)
register struct proc	*pp;
{
	pp->p_pri = (pp->p_cpu >> 1) + pp->p_nice + (PUSER - NZERO);
	ASSERT((pp->p_pri >= (PUSER - NZERO)) && (pp->p_pri < NUM_PRIORITIES));
	own.o_curpri = pp->p_pri;
}

s5enh_userpri(pp)
register struct proc	*pp;
{
register ushort	pri;

	pri = (pp->p_cpu >> 1) + pp->p_nice + (PUSER - NZERO) +
		WHICH_PRI_ADJ(pp);
	if (pri >= NUM_PRIORITIES) {
		pri = NUM_PRIORITIES - 1;
		if ((pp->p_nice + WHICH_PRI_ADJ(pp)) < NZERO)
			pri -= (NZERO - (pp->p_nice + WHICH_PRI_ADJ(pp)));
	}
	pp->p_pri = pri;
	PERF_PRI_CLAMP(pp,pp->p_pri);
	own.o_curpri = pp->p_pri;
}

s5_exitcpu(up,pp)
register struct	proc	*up, *pp;
{
	register uchar tmp_cpu;

	/*
	 * parent gets child's cpu usage
	 *
	 * HH: the use of the temporary variable tmp_cpu is critical here,
	 * in case we take a clock interrupt after adding the child's
	 * p_cpu to the parent's but before checking against the limit.  The
	 * ASSERT in s5_clkcpu will fail.
	 */
	tmp_cpu = up->p_cpu + pp->p_cpu;
	if (tmp_cpu > S5_CPULIMIT)
		tmp_cpu = S5_CPULIMIT;

	up->p_cpu = tmp_cpu;

	ASSERT((up->p_cpu >= 0) && (up->p_cpu <= S5_CPULIMIT));
}

s5enh_exitcpu(up,pp)
register struct	proc	*up, *pp;
{
	register uchar tmp_cpu;	/* see comment in s5_exitcpu */

	tmp_cpu = up->p_cpu + pp->p_cpu;

	if (tmp_cpu > s5enh_cpulimit)
		tmp_cpu = s5enh_cpulimit;

	up->p_cpu = tmp_cpu;
	
	PERF_CPU_CLAMP(up,up->p_cpu);
}

/*
 * Compute a tenex style load average of a quantity on
 * 1, 5 and 15 minute and 5 second intervals.  The last item
 * is the instant load average over the 5 second interval.
 */
s5_loadavg()
{
register int	nrun, fact, pms, ave;
register int	i;

	pms  = sysinfo.num_pms;
	nrun = runqs.rq_cnt + upkern_runqs.rq_cnt + (pms - num_idle_pms);
	fact = pms - nrun;
	if (fact <= 0)
		fact = (pms * 1000) / (nrun + 1);
	else
		fact *= 1000;
	ave = nrun * 1000;
	for (i = 0; i < 4; i++) {
		MachAvenrun[i]	= ( (Cexp[i] * MachAvenrun[i]) +
			(fact * (1000 - Cexp[i])) ) / 1000;
		Avenrun[i]	= ( (Cexp[i] * Avenrun[i]) +
			(ave  * (1000 - Cexp[i])) ) / 1000;
	}
	MachAvenrun[4]	= nrun;	/* grab load for last 5 seconds	*/
	Avenrun[4]	= nrun;	/* grab load for last 5 seconds	*/
	/*
	 * Reschedule ourselves in 5 seconds.
	 */
	timeout(sched_loadavg,(caddr_t)0,5*HZ);
}
