/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) schedmach.c: version 25.1 created on 11/27/91 at 15:11:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)schedmach.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/user.h"
#include "sys/proc.h"
#include "sys/cmn_err.h"
#include "sys/own.h"
#include "sys/perf.h"
#include "sys/perfext.h"
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#include "sys/sysinfo.h"
#include "sys/debug.h"
#include "sys/psl.h"

mach_clkcpu(pp)
register struct	proc	*pp;
{
	if (!own.o_switching && !own.o_is_idle) {
		if (++pp->p_cpu == 0)		/* keep it at 255	*/
			pp->p_cpu--;
		PERF_CPU_CLAMP(pp,pp->p_cpu);
	}
}

mach_clkpri(pp,ps)
register struct	proc	*pp;
{
	/*
	 * We adjust the priority of the current process.
	 * The priority of a process gets worse as it accumulates
	 * CPU time.  The cpu usage estimator (p_cpu) is increased here
	 * and the formula for computing priorities (in kern_synch.c)
	 * will compute a different value each time the p_cpu increases
	 * by 4.  The cpu usage estimator ramps up quite quickly when
	 * the process is running (linearly), and decays away exponentially,
	 * at a rate which is proportionally slower when the system is
	 * busy.  The basic principal is that the system will 90% forget
	 * that a process used a lot of CPU time in 5*loadav seconds.
	 * This causes the system to favor processes which haven't run
	 * much recently, and to round-robin among other processes.
	 */
	if (!own.o_switching && !own.o_is_idle) {
		if ((pp->p_cpu & 3) == 0) {	/* every 4th adjustment */
			mach_setpri(pp);	/* modifies p_usrpri	*/
			if (pp->p_pri >= PUSER) {
				pp->p_pri = pp->p_usrpri;
				PERF_PRI_CLAMP(pp,pp->p_pri);
			}
		}
		if (USERMODE(ps)) {
			/* 
			 * If a process has accumulated more than 10 minutes
			 * of user time then reduce his priority to give others
			 * a chance to run (superuser excepted).
			 * This adjustment happens only once.
			 */
			if (pp->p_uid && (pp->p_nice == NZERO) &&
					(u.u_utime > secstoticks(600))) {
				pp->p_nice = NZERO + 4;
				mach_setpri(pp);	/* modifies p_usrpri */
				pp->p_pri = pp->p_usrpri;
				PERF_PRI_CLAMP(pp,pp->p_pri);
			}
		}
	}
}

mach_ukclkcpu(pp)
register struct	proc	*pp;
{
register long		a, scale;

	if (mach_ukclkslp(pp) > 1)
		return;
	scale	= filter(*(AvenPtr + which_loadavg));
	a	= ((scale * (pp->p_cpu & 0377)) / 1000) + pp->p_nice;
	if (a < 0)
		a = 0;
	if (a > MACH_CPULIMIT)
		a = MACH_CPULIMIT;
	pp->p_cpu = (uchar) a;
	PERF_CPU_CLAMP(pp,pp->p_cpu);
}

mach_ukclkpri(pp)
register struct proc	*pp;
{
register uchar	pri;

	if (pp->p_pri >= PUSER) {
		mach_setpri(pp);	/* modifies p_usrpri */
		PERF_USRPRI_CLAMP(pp,pri);
		if (((pp != u.u_procp) || own.o_is_idle) &&
			(pp->p_stat == SRUN) && (pp->p_pri != pri))
				disp_change_pri(pp, pri);
	}
}

mach_ukclkslp(pp)
register struct proc	*pp;
{
	/*
	 * If the process has slept the entire second,
	 * stop recalculating its priority until it wakes up.
	 */
	if ((pp->p_stat == SSLEEP) || (pp->p_stat == SSTOP))
		if (pp->p_slptime != 127)
			pp->p_slptime++;
	return (pp->p_slptime);
}

mach_wakeuppri(pp)
register struct proc	*pp;
{
	if (pp->p_slptime <= 1)
		return;
	mach_updatepri(pp);
	pp->p_pri = pp->p_usrpri;
	PERF_PRI_CLAMP(pp,pp->p_pri);
	pp->p_slptime = 0;
}

mach_setrunpri(pp)
register struct proc	*pp;
{
	if (pp->p_slptime <= 1)
		return;
	mach_updatepri(pp);
	pp->p_pri = pp->p_usrpri;
	PERF_PRI_CLAMP(pp,pp->p_pri);
	pp->p_slptime = 0;
}

mach_userpri(pp)
register struct proc	*pp;
{
	mach_setpri(pp);
	pp->p_pri = pp->p_usrpri;
	PERF_PRI_CLAMP(pp,pp->p_pri);
}

/*
 * Set user priority.
 * The rescheduling flag (runrun) is set if the priority is better
 * than the currently running process.
 */
mach_setpri(pp)
register struct	proc	*pp;
{
register uint		pri;

	pri  = (pp->p_cpu & 0377) >> 2;		/* divide by 4	*/
	pri += PUSER + (pp->p_nice << 1);	/* times 2	*/
	if (pri >= NUM_PRIORITIES)
		pri = NUM_PRIORITIES - 1;
	PERF_USRPRI_CLAMP(pp,pri);
	pp->p_usrpri = (uchar) pri;
	if ((uchar)pri < own.o_curpri)
		own.o_runrun = 1;
}

/*
 * Recalculate the priority of a process after it has slept for a while.
 */
mach_updatepri(pp)
register struct	proc	*pp;
{
register long	a, scale;

	a	= pp->p_cpu & 0377;
	scale	= filter(*(AvenPtr + which_loadavg));
	pp->p_slptime--;	/* the first time was done in schedcpu */
	while (a && --pp->p_slptime)
		a = ((scale * a) / 1000) /* + pp->p_nice */;
	if (a < 0)
		a = 0;
	if (a > MACH_CPULIMIT)
		a = MACH_CPULIMIT;
	pp->p_cpu = (uchar) a;
	PERF_CPU_CLAMP(pp,pp->p_cpu);
	mach_setpri(pp);	/* modifies p_usrpri */
}

/*
 * Compute a tenex style load average of a quantity on
 * 1 minute, 5 minute, 30 second, and 5 second intervals.
 * The last item is the instant load average over the 1 second interval.
 */
mach_loadavg()
{
register int	nrun, fact, pms, ave;
register int	i;

	pms  = sysinfo.num_pms;
	nrun = runqs.rq_cnt + upkern_runqs.rq_cnt + (pms - num_idle_pms);
	fact = pms - nrun;
	if (fact <= 0)
		fact = (pms * 1000) / (nrun + 1);
	else
		fact *= 1000;
	ave = nrun * 1000;
	for (i = 0; i < 4; i++) {
		MachAvenrun[i]	= ( (MachCexp[i] * MachAvenrun[i]) +
			(fact * (1000 - MachCexp[i])) ) / 1000;
		Avenrun[i]	= ( (MachCexp[i] * Avenrun[i]) +
			(ave  * (1000 - MachCexp[i])) ) / 1000;
	}
	MachAvenrun[4]	= nrun;	/* grab load for last 1 second	*/
	Avenrun[4]	= nrun;	/* grab load for last 1 second	*/
	/*
	 * Reschedule ourselves in 1 second.
	 */
	timeout(sched_loadavg,(caddr_t)0,1*HZ);
}
