/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) schedcpu.c: version 25.1 created on 11/27/91 at 15:11:32	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)schedcpu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/proc.h"
#include "sys/errno.h"
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#include "sys/debug.h"
#include "sys/own.h"
#include "sys/spm_mem.h"
#include "sys/ints.h"
#include "sys/sbus_spm.h"

#ifdef	PERF_NOSUCHK
#define	NO_SU_CHK	0 &&
#else	/* PERF_NOSUCHK */
#define	NO_SU_CHK
#endif	/* PERF_NOSUCHK */

long	*AvenPtr;	/* pointer to one of the follwing arrays	*/
long	MachAvenrun[5];	/* load averages				*/
long	Avenrun[5];	/* load averages				*/

/*
 * Constants for averages over 1, 5, 15 minute, and 5 second intervals
 * when sampling at 5 second intervals.
 */
long	Cexp[4] = {
	920,	/* exp(-1/12)	= 0.9200444146293232	*/
	983,	/* exp(-1/60)	= 0.9834714538216174	*/
	994,	/* exp(-1/180)	= 0.9944598480048967	*/
	368	/* exp(-1/1)	= 0.367879438400269	*/
};

/*
 * For MACH, constants for averages over 1 minute, 5 minute,
 * 30 second, and 5 second intervals when sampling at 1 second intervals.
 */
long	MachCexp[4] = {
	983,	/* (59.0/60.0)	 1 minute average	*/
	997,	/* (299.0/300.0) 5 minute average	*/
	967,	/* (29.0/30.0)	30 second average	*/
	800,	/* (4.0/5.0)	 5 second average	*/
};

schedsw_t	schedsw[] =
	{
/* 0 NONE  */	{
		noschedcpu,		/* 0  -  CLKCPU		*/
		noschedpri,		/* 1  -  CLKPRI		*/
		noschedcpu,		/* 2  -  UKCLKCPU	*/
		noschedpri,		/* 3  -  UKCLKPRI	*/
		noschedslp,		/* 4  -  UKCLKSLP	*/
		noschedpri,		/* 5  -  WAKEUPPRI	*/
		noschedpri,		/* 6  -  SETRUNPRI	*/
		noschedpri,		/* 7  -  USERPRI	*/
		noschedcpu,		/* 8  -  EXITCPU	*/
		noschedload,		/* 9  -  LOADAVG	*/
		},
/* 1 SVR32 */	{
		s5_clkcpu,		/* 0  -  CLKCPU		*/
		noschedpri,		/* 1  -  CLKPRI		*/
		s5_ukclkcpu,		/* 2  -  UKCLKCPU	*/
		s5_ukclkpri,		/* 3  -  UKCLKPRI	*/
		noschedslp,		/* 4  -  UKCLKSLP	*/
		noschedpri,		/* 5  -  WAKEUPPRI	*/
		noschedpri,		/* 6  -  SETRUNPRI	*/
		s5_userpri,		/* 7  -  USERPRI	*/
		s5_exitcpu,		/* 8  -  EXITCPU	*/
		s5_loadavg,		/* 9  -  LOADAVG	*/
		},
/* 2 SVR32ENH */{
		s5enh_clkcpu,		/* 0  -  CLKCPU		*/
		noschedpri,		/* 1  -  CLKPRI		*/
		s5enh_ukclkcpu,		/* 2  -  UKCLKCPU	*/
		s5enh_ukclkpri,		/* 3  -  UKCLKPRI	*/
		noschedslp,		/* 4  -  UKCLKSLP	*/
		noschedpri,		/* 5  -  WAKEUPPRI	*/
		noschedpri,		/* 6  -  SETRUNPRI	*/
		s5enh_userpri,		/* 7  -  USERPRI	*/
		s5enh_exitcpu,		/* 8  -  EXITCPU	*/
		s5_loadavg,		/* 9  -  LOADAVG	*/
		},
/* 3 SVR32BSD */{
		s5enh_clkcpu,		/* 0  -  CLKCPU		*/
		noschedpri,		/* 1  -  CLKPRI		*/
		s5bsd_ukclkcpu,		/* 2  -  UKCLKCPU	*/
		s5enh_ukclkpri,		/* 3  -  UKCLKPRI	*/
		noschedslp,		/* 4  -  UKCLKSLP	*/
		noschedpri,		/* 5  -  WAKEUPPRI	*/
		noschedpri,		/* 6  -  SETRUNPRI	*/
		s5enh_userpri,		/* 7  -  USERPRI	*/
		noschedcpu,		/* 8  -  EXITCPU	*/
		s5_loadavg,		/* 9  -  LOADAVG	*/
		},
/* 4 BSD43 */	{
		bsd_clkcpu,		/* 0  -  CLKCPU		*/
		bsd_clkpri,		/* 1  -  CLKPRI		*/
		bsd_ukclkcpu,		/* 2  -  UKCLKCPU	*/
		bsd_ukclkpri,		/* 3  -  UKCLKPRI	*/
		bsd_ukclkslp,		/* 4  -  UKCLKSLP	*/
		bsd_wakeuppri,		/* 5  -  WAKEUPPRI	*/
		bsd_setrunpri,		/* 6  -  SETRUNPRI	*/
		bsd_userpri,		/* 7  -  USERPRI	*/
		noschedcpu,		/* 8  -  EXITCPU	*/
		bsd_loadavg,		/* 9  -  LOADAVG	*/
		},
/* 5 MACH  */	{
		mach_clkcpu,		/* 0  -  CLKCPU		*/
		mach_clkpri,		/* 1  -  CLKPRI		*/
		mach_ukclkcpu,		/* 2  -  UKCLKCPU	*/
		mach_ukclkpri,		/* 3  -  UKCLKPRI	*/
		mach_ukclkslp,		/* 4  -  UKCLKSLP	*/
		mach_wakeuppri,		/* 5  -  WAKEUPPRI	*/
		mach_setrunpri,		/* 6  -  SETRUNPRI	*/
		mach_userpri,		/* 7  -  USERPRI	*/
		noschedcpu,		/* 8  -  EXITCPU	*/
		mach_loadavg,		/* 9  -  LOADAVG	*/
		},
	};

int	schedswcnt;
int	schedsw_lock;
int	sched_debug;
int	sched_type;
int	sched_mode;
int	which_loadavg;
int	s5enh_cpulimit;
int	s5bsd_cpulimit;
int	bsd_cpulimit;
int	mach_cpulimit;
int	s5enh_cpuattack;
int	s5enh_cpudecay;
int	bsd_cpudecay;
int	mach_cpudecay;

int	clkcpu_idx;
int	clkpri_idx;
int	ukclkcpu_idx;
int	ukclkpri_idx;
int	ukclkslp_idx;
int	wakeuppri_idx;
int	setrunpri_idx;
int	userpri_idx;
int	exitcpu_idx;
int	loadavg_idx;

int	*sched_idxarray[]	=
	{
		&clkcpu_idx,
		&clkpri_idx,
		&ukclkcpu_idx,
		&ukclkpri_idx,
		&ukclkslp_idx,
		&wakeuppri_idx,
		&setrunpri_idx,
		&userpri_idx,
		&exitcpu_idx,
		&loadavg_idx,
		0
	};

chgsched()
{
	register struct	a {
		int	cmd;		/* command to perform		*/
		int	*nval;		/* new value/array		*/
		int	*oval;		/* old value/array		*/
	} *uap;
	register int	i, j, nval, oval;
	register long	*ptr;
	int		otab[SCHED_NUMIDX+1];
	int		ntab[SCHED_NUMIDX+1];

	uap = (struct a *)u.u_ap;
	if (uap->nval && ((nval = fuword(uap->nval)) == -1)) {
		u.u_error = EFAULT;
		return;
	}
	switch (uap->cmd) {
	case SCHED_GETSCHEDTYPE:	/* get current scheduler type	*/
	case SCHED_SETSCHEDTYPE:	/* set current scheduler type	*/
		oval = sched_type;
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETSCHEDTYPE) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		switch (nval) {
		case SCHED_SVR32:	/* SVR32 standard sched	   cpu=80    */
		case SCHED_SVR32ENH:	/* SVR32 enh decay by 1/2  cpu=96    */
		case SCHED_SVR32BSD:	/* SVR32 enh BSD decay	   cpu=127   */
		case SCHED_BSD43:	/* BSD43 standard sched    cpu=255   */
		case SCHED_MACH:	/* MACH  standard sched    cpu=255   */
			break;

		case SCHED_NONE:
		case SCHED_MIXED:	/* indexes were set individually*/
		default:
			u.u_error = EINVAL;
			return;
		}
		sched_type = nval;
		j = spl7();
		other_cpus_disable_interrupts();
		for (i = 0; i < SCHED_NUMIDX; i++)
			*sched_idxarray[i] = nval;
		other_cpus_reenable_interrupts();
		splx(j);
		break;

	case SCHED_GETMODE:		/* get scheduler mode		*/
	case SCHED_SETMODE:		/* set scheduler mode		*/
		oval = sched_mode;
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETMODE) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		switch (nval) {
		default:
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		sched_mode = nval;
		other_cpus_reenable_interrupts();
		splx(j);
		break;

	case SCHED_GETLOADAVG:		/* get loadavg index for sched	*/
	case SCHED_SETLOADAVG:		/* set loadavg index for sched	*/
		oval = which_loadavg;
		if (AvenPtr == &MachAvenrun[0])
			oval += LOADAVG_MACH;
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETLOADAVG) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		switch (nval) {
		case LOADAVG_1MIN:	/* use  1 min  loadavg for p_cpu calc */
		case LOADAVG_5MIN:	/* use  5 min  loadavg for p_cpu calc */
		case LOADAVG_15MIN:	/* use 15 min  loadavg for p_cpu calc */
		case LOADAVG_5SEC:	/* use  5 sec  loadavg for p_cpu calc */
		case LOADAVG_INST:	/* use instant loadavg for p_cpu calc */
			ptr = &Avenrun[0];
			break;

		case LOADAVG_M1MIN:	/* use  1 min  loadavg for p_cpu calc */
		case LOADAVG_M5MIN:	/* use  5 min  loadavg for p_cpu calc */
		case LOADAVG_M30SEC:	/* use 30 sec  loadavg for p_cpu calc */
		case LOADAVG_M5SEC:	/* use  5 sec  loadavg for p_cpu calc */
		case LOADAVG_MINST:	/* use instant loadavg for p_cpu calc */
			ptr   = &MachAvenrun[0];
			nval -= LOADAVG_MACH;
			break;

		default:
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		AvenPtr = ptr;
		which_loadavg = nval;
		other_cpus_reenable_interrupts();
		splx(j);
		break;

	case SCHED_GETARRAY:		/* get sched index array	*/
	case SCHED_SETARRAY:		/* set sched index array	*/
		for (i = 0; i < SCHED_NUMIDX; i++) {
			otab[i] = *sched_idxarray[i];
		}
		otab[i] = 0;
		if (!uap->oval)
			u.u_error = EFAULT;
		else
			if (copyout((caddr_t)otab,(caddr_t)uap->oval,
					(sizeof(int) * SCHED_NUMIDX)))
				u.u_error = EFAULT;
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETARRAY) {
			return;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (copyin((caddr_t)uap->nval,(caddr_t)ntab,
				(sizeof(int) * SCHED_NUMIDX))) {
			u.u_error = EFAULT;
			return;
		}
		for (nval = 0, j = 0, i = 0; i < SCHED_NUMIDX; i++) {
			switch (ntab[i]) {
			case SCHED_NONE:
				continue;

		case SCHED_SVR32:	/* SVR32 standard sched	   cpu=80    */
				j |= 0x0001;
				continue;

		case SCHED_SVR32ENH:	/* SVR32 enh decay by 1/2  cpu=96    */
				j |= 0x0002;
				continue;

		case SCHED_SVR32BSD:	/* SVR32 enh BSD decay	   cpu=127   */
				j |= 0x0004;
				continue;

		case SCHED_BSD43:	/* BSD43 standard sched    cpu=255   */
				j |= 0x0008;
				continue;

		case SCHED_MACH:	/* MACH  standard sched    cpu=255   */
				j |= 0x0010;
				continue;

			case SCHED_MIXED: /* indexes were set individually */
			default:
				for (j = 0; j < SCHED_NUMIDX; j++) {
					if (i != j)
						ntab[j] = -1;
				}
				ntab[j] = 0;
				if (!uap->oval)
					u.u_error = EFAULT;
				else
					if (copyout((caddr_t)ntab,
						(caddr_t)uap->oval,
						(sizeof(int) * SCHED_NUMIDX)))
						u.u_error = EFAULT;
				u.u_error = EINVAL;
				return;
			}
		}
		if (j == 0x0001)
			sched_type = SCHED_SVR32;
		else
		if (j == 0x0002)
			sched_type = SCHED_SVR32ENH;
		else
		if (j == 0x0004)
			sched_type = SCHED_SVR32BSD;
		else
		if (j == 0x0008)
			sched_type = SCHED_BSD43;
		else
		if (j == 0x0010)
			sched_type = SCHED_MACH;
		else
		if (j & 0x001f)
			sched_type = SCHED_MIXED;
		else	{	/* if all are NONE */
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		for (i = 0; i < SCHED_NUMIDX; i++) {
			*sched_idxarray[i] = ntab[i];
		}
		/*
		 * After copying in new indexes, if the previous index
		 * for load averaging was for SCHED_NONE then we must
		 * restart load averaging here.
		 */
		if (otab[IDX_GETLOADAVG - IDX_GETBASE] == SCHED_NONE) {
			sched_loadavg();
		}
		other_cpus_reenable_interrupts();
		splx(j);
		return;

	case SCHED_GETCPULIMIT:		/* get sched cpu limit		*/
	case SCHED_SETCPULIMIT:		/* set sched cpu limit		*/
		switch (sched_type) {
		case SCHED_SVR32:
			oval = S5_CPULIMIT;
			break;

		case SCHED_SVR32ENH:
			oval = s5enh_cpulimit;
			break;

		case SCHED_SVR32BSD:
			oval = s5bsd_cpulimit;
			break;

		case SCHED_BSD43:
			oval = BSD_CPULIMIT;
			break;

		case SCHED_MACH:
			oval = MACH_CPULIMIT;
			break;

		case SCHED_NONE:
		case SCHED_MIXED:	/* indexes were set individually*/
		default:
			u.u_error = EINVAL;
			return;
		}
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETCPULIMIT) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval < (PUSER - NZERO)) || (nval > 255)) {
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		switch (sched_type) {
		case SCHED_SVR32ENH:
			s5enh_cpulimit = nval;
			break;

		case SCHED_SVR32BSD:
			s5bsd_cpulimit = nval;
			break;

		case SCHED_NONE:
		case SCHED_SVR32:	/* SVR32 standard sched	   cpu=80    */
		case SCHED_BSD43:	/* BSD43 standard sched    cpu=255   */
		case SCHED_MACH:	/* MACH  standard sched    cpu=255   */
		case SCHED_MIXED:	/* indexes were set individually*/
		default:
			u.u_error = EINVAL;
			break;
		}
		other_cpus_reenable_interrupts();
		splx(j);
		if (u.u_error)
			return;
		break;

	case SCHED_GETCPUDECAY:		/* get sched cpu decay rate	*/
	case SCHED_SETCPUDECAY:		/* set sched cpu decay rate	*/
		switch (sched_type) {
		case SCHED_SVR32:
			oval = S5_CPUDECAY;
			break;

		case SCHED_SVR32ENH:
			oval = s5enh_cpudecay;
			break;

		case SCHED_NONE:
		case SCHED_SVR32BSD:
		case SCHED_BSD43:
		case SCHED_MACH:
		case SCHED_MIXED:
		default:
			u.u_error = EINVAL;
			return;
		}
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETCPUDECAY) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 1) {
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		switch (sched_type) {
		case SCHED_SVR32ENH:
			s5enh_cpudecay = nval;
			break;

		case SCHED_NONE:
		case SCHED_SVR32:
		case SCHED_SVR32BSD:
		case SCHED_BSD43:
		case SCHED_MACH:
		case SCHED_MIXED:
		default:
			u.u_error = EINVAL;
			break;
		}
		other_cpus_reenable_interrupts();
		splx(j);
		if (u.u_error)
			return;
		break;

	case SCHED_GETCPUATTACK:	/* get sched cpu attack rate	*/
	case SCHED_SETCPUATTACK:	/* set sched cpu attack rate	*/
		switch (sched_type) {
		case SCHED_SVR32:
			oval = S5_CPUATTACK;
			break;

		case SCHED_SVR32ENH:
			oval = s5enh_cpuattack;
			break;

		case SCHED_NONE:
		case SCHED_SVR32BSD:
		case SCHED_BSD43:
		case SCHED_MACH:
		case SCHED_MIXED:
		default:
			u.u_error = EINVAL;
			return;
		}
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETCPUATTACK) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		j = spl7();
		other_cpus_disable_interrupts();
		switch (sched_type) {
		case SCHED_SVR32ENH:
			s5enh_cpuattack = nval;
			break;

		case SCHED_NONE:
		case SCHED_SVR32:
		case SCHED_SVR32BSD:
		case SCHED_BSD43:
		case SCHED_MACH:
		case SCHED_MIXED:
		default:
			u.u_error = EINVAL;
			break;
		}
		other_cpus_reenable_interrupts();
		splx(j);
		if (u.u_error)
			return;
		break;

	case IDX_GETCLKCPU:		/* to get individual indexes	*/
	case IDX_GETCLKPRI:		/* to get individual indexes	*/
	case IDX_GETUKCLKCPU:		/* to get individual indexes	*/
	case IDX_GETUKCLKPRI:		/* to get individual indexes	*/
	case IDX_GETUKCLKSLP:		/* to get individual indexes	*/
	case IDX_GETWAKEUPPRI:		/* to get individual indexes	*/
	case IDX_GETSETRUNPRI:		/* to get individual indexes	*/
	case IDX_GETUSERPRI:		/* to get individual indexes	*/
	case IDX_GETEXITCPU:		/* to get individual indexes	*/
	case IDX_GETLOADAVG:		/* to get individual indexes	*/
		oval = *sched_idxarray[uap->cmd - IDX_GETBASE];
		break;

	case IDX_SETCLKCPU:		/* to set individual indexes	*/
	case IDX_SETCLKPRI:		/* to set individual indexes	*/
	case IDX_SETUKCLKCPU:		/* to set individual indexes	*/
	case IDX_SETUKCLKPRI:		/* to set individual indexes	*/
	case IDX_SETUKCLKSLP:		/* to set individual indexes	*/
	case IDX_SETWAKEUPPRI:		/* to set individual indexes	*/
	case IDX_SETSETRUNPRI:		/* to set individual indexes	*/
	case IDX_SETUSERPRI:		/* to set individual indexes	*/
	case IDX_SETEXITCPU:		/* to set individual indexes	*/
	case IDX_SETLOADAVG:		/* to set individual indexes	*/
		if (!uap->nval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		i    = uap->cmd - IDX_SETBASE;
		oval = *sched_idxarray[i];
		switch (nval) {
		case SCHED_NONE:
		case SCHED_SVR32:
		case SCHED_SVR32ENH:
		case SCHED_SVR32BSD:
		case SCHED_BSD43:
		case SCHED_MACH:
			break;

		case SCHED_MIXED:	/* indexes were set individually*/
		default:
			u.u_error = EINVAL;
			return;
		}
		sched_type = SCHED_MIXED;
		j = spl7();
		other_cpus_disable_interrupts();
		*sched_idxarray[i] = nval;
		/*
		 * After copying in new index, if the previous index
		 * for load averaging was for SCHED_NONE then we must
		 * restart load averaging here.
		 */
		if ((uap->cmd == IDX_SETLOADAVG) && (oval == SCHED_NONE)) {
			sched_loadavg();
		}
		other_cpus_reenable_interrupts();
		splx(j);
		break;

	case SCHED_GETDEBUG:		/* get scheduler'a debug level	  */
	case SCHED_SETDEBUG:		/* set scheduler'a debug level	  */
		oval = sched_debug;
		if (!uap->nval)
			break;
		if (uap->cmd == SCHED_GETDEBUG) {
			break;
		}
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		sched_debug = nval;
		break;

	default:
		if (sched_debug)
			printf("schedcpu: unknown command: 0x%x\n",uap->cmd);
		u.u_error = EINVAL;
		return;
	}
	if (!uap->oval)
		u.u_error = EFAULT;
	else
		if (suword(uap->oval,oval))
			u.u_error = EFAULT;
	return;
}

sched_loadavg()
{
	LOADAVG();
}

schedinit()
{
	schedswcnt	= sizeof(schedsw) / sizeof(schedsw_t);
	schedsw_lock	= 0;
	sched_debug	= 0;
	sched_type	= SCHED_SVR32;
	sched_mode	= 0;
	which_loadavg	= LOADAVG_1MIN;
	AvenPtr		= &Avenrun[0];
	s5enh_cpulimit	= S5ENH_CPULIMIT;
	s5bsd_cpulimit	= S5ENH_CPULIMIT;
	bsd_cpulimit	= BSD_CPULIMIT;
	mach_cpulimit	= MACH_CPULIMIT;
	s5enh_cpudecay	= S5ENH_CPUDECAY;
	s5enh_cpuattack	= S5ENH_CPUATTACK;
	bsd_cpudecay	= BSD_CPUDECAY;
	mach_cpudecay	= MACH_CPUDECAY;
	clkcpu_idx	= SCHED_SVR32;
	clkpri_idx	= SCHED_SVR32;
	ukclkcpu_idx	= SCHED_SVR32;
	ukclkpri_idx	= SCHED_SVR32;
	ukclkslp_idx	= SCHED_SVR32;
	wakeuppri_idx	= SCHED_SVR32;
	setrunpri_idx	= SCHED_SVR32;
	userpri_idx	= SCHED_SVR32;
	exitcpu_idx	= SCHED_SVR32;
	loadavg_idx	= SCHED_SVR32;
	sched_loadavg();		/* start load averaging	*/
}

noschedcpu()
{
}

noschedpri()
{
}

noschedslp()
{
	return (0);	/* must return 0 */
}

noschedload()
{
}
