/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sched.c: version 25.1 created on 11/27/91 at 15:11:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sched.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/signal.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/var.h"
#include "sys/tuneable.h"
#include "sys/getpages.h"
#include "sys/debug.h"
#include "sys/spl.h"
#include "sys/own.h"
#include "sys/spm_mem.h"
#include "sys/mfs.h"

extern unsigned int	sxbrkcnt;

/*	The scheduler sleeps on runout when there is no one
**	to swap in.  It sleeps on runin when it could not 
**	find space to swap someone in or after swapping
**	someone in.
*/

int	runout;
int	runin;

/*
 * Memory scheduler
 */

sched()
{
	register proc_t	*rp, *p, *justloaded;
	register int	outage, inage;
	register int	maxbad, runable;
	register int	tmp;

	/*
	 * find user to swap in;
	 * of users ready, select one out longest
	 */

loop:
	/*
	 * Otherwise, find user to reactivate
	 * Of users ready, select one out longest
	 */

	fspl6();
	outage = -20000;
	runable = 0;
	for (rp = &proc[0]; rp < (struct proc *)v.ve_proc; rp++) {
		if ((rp->p_stat==SXBRK ||
		    (rp->p_stat==SRUN && !(rp->p_flag&SLOAD))) &&
		    rp->p_time > outage) {
			p = rp;
			outage = rp->p_time;
		}
		if (rp->p_stat == SRUN  &&
		   (rp->p_flag & (SLOAD|SSYS)) == SLOAD)
			runable = 1;
	}

	/*
	 * If there is no one there, wait.
	 */
	if (outage == -20000) {
		runout = 1;
		sleep(&runout, PSWP);
		goto loop;
	}
	fspl0();

	/*
	 * See if there is memory for that process;
	 * if so, let it go and then delay in order to
	 * let things settle
	 */

	if (!runable  ||  freemem > tune.t_gpgslo) {
		clr_swapout(p);
		p->p_time = 0;
		if (p->p_stat == SXBRK) {
			ASSERT(p->p_wchan == 0);
			--sxbrkcnt;
			setrq(p);
		}
		if (freemem > tune.t_gpgslo)
			goto delay;
		justloaded = p;
	} else {
		justloaded = NULL;
	}

	/*
	 * none found.
	 * look around for memory.
	 * Select the largest of those sleeping
	 * at bad priority; if none, select the oldest.
	 */

	p = NULL;
	maxbad = 0;
	inage = 0;
	fspl6();
	for (rp = &proc[0]; rp < (struct proc *)v.ve_proc; rp++) {
		if (rp->p_stat==SZOMB)
			continue;
		if ((rp->p_flag&(SSYS|SLOAD|SLOCK))!=SLOAD)
			continue;
		if (rp == justloaded)
			continue;
		if (rp->p_stat==SSLEEP || rp->p_stat==SSTOP) {
			tmp = rp->p_pri - PZERO + rp->p_time;
			if (maxbad < tmp) {
				p = rp;
				maxbad = tmp;
			}
		}
		else if (maxbad<=0 && (rp->p_stat==SRUN || rp->p_stat==SXBRK)) {
			tmp = rp->p_time + rp->p_nice - NZERO;
			if (tmp > inage) {
				p = rp;
				inage = tmp;
			}
		}
	}
	fspl0();
	/*
	 * Swap out and deactivate process if
	 * sleeping at bad priority, or if it has spent at least
	 * 2 seconds in memory and the other process has spent
	 * at least 2 seconds out.
	 * Otherwise wait a bit and try again.
	 */
	if (maxbad > 0 || (outage>=2 && inage>=2)) {
		if (maxbad > 0) {
			if (!(p->p_stat == SSLEEP || p->p_stat == SSTOP))
				goto loop;
		} 
		else  {
			if (p->p_stat != SRUN  &&  p->p_stat != SXBRK) 
				goto loop;
		}
		if (p->p_flag & SLOCK)
			goto loop;

		if (swapout(p)) {
			p->p_time = 0;
			goto loop;
		}
			
	}

	/*
	 * Delay for 1 second and look again later
	 */
delay:
	fspl6();
	runin = 1;
	sleep(&runin, PSWP);
	goto loop;
}


/*	Swap out process p
 */
extern int fclimit;
extern int sclimit;

swapout(p)
register proc_t	*p;
{
	register preg_t	*prp;
	register reg_t	*rp;
	register int	flg;
	register int	rtn, temp;


	/*	Walk through process regions
	 *	Private regions or shared regions that are being used
	 *	exclusively by this process get paged out en masse.
	 *	Other shared regions are just pruned.
	 *
	 *	return 1 - every region gets paged out 
	 *      return 0 - find region(s) locked
	 */
	rtn = 1;
	set_swapout(p);
	pglstlk();

	for (prp = p->p_region; (rp = prp->p_reg) != NULL; prp++) {
		if (reg_trylock(rp) == 0) {
			rtn = 0;
			continue;
		}

		flg = (rp->r_type == RT_PRIVATE || rp->r_refcnt == 1);

		/*	if (flg == 0) only take unreferenced pages */
		/*	if (flg == 1) take all valid pages */
		temp = getpages(rp, flg);
		if (gprglst[gprgndx].gpr_count == 0  ||
		    gprglst[gprgndx].gpr_rgptr != rp) 
			regrele(rp);
		if (temp) {
			rtn = 0;
		/*	break;	*/
		}
	/*	if ((fpglndx == fclimit)  &&
		    (spglndx == sclimit))  {
			rtn = 0;
			break;
		} */
	}

	fspl6();

	if (fpglndx)
		freechunk(0); 

	if (spglndx)
		swapchunk(0, 1);

	fspl0();

	ASSERT(spglndx == 0);
	ASSERT(fpglndx == 0);
	ASSERT(gprglst[gprgndx].gpr_count == 0);

	pglstunlk();

	if (! rtn)
		cancel_swapout(p);

	return(rtn);
}
