/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) probe.c: version 25.1 created on 11/27/91 at 15:11:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)probe.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * 001	JPC	5/24/88	Removed the page alloc from userdma.  Physio now uses
 *			a buffer on its stack.
 * 002	JPC	6/24/88	Changed useracc to hold region lock while modifing
 *			dbds.  This meant changing the way copy-on-write was
 *			broken, etc.
 */


#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/signal.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/user.h"
#include "sys/inode.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/pfdat.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/tuneable.h"
#include "sys/cmn_err.h"
#include "sys/map.h"
#include "sys/param.h"

#define DMA_DEBUG		/* debug B_PHYS useracc and undma */
#define FULL_DMA_DEBUG		/* debug B_PHYS useracc and undma */

/*
 * Calculate number of pages transfer touchs
 */
#define len(base, count)	(btoc(base + count) - btoct(base))

/*
 * Calulate starting user PTE address for transfer
 */
#ifdef M68040
#define upt(base)		findpde(base,u.u_procp)
#endif

#ifdef M68020
#define upt(base)		findpde(base)
#endif

extern pde_t			*findpde();

/*
 * Check user read/write access
 * If rw has B_PHYS set, the user PTEs will be faulted in and locked down.
 * Returns 0 on failure, 1 on success.
 *
 */

useracc(base, count, rw)
uint	base, count, rw;
{
	register uint	b;
	register int	i;
	register int	npgs;
	register int	x;
	register int	b_read, b_phys;
	register pde_t	*pt;
	register reg_t  *rp;
	register dbd_t	*dbd;
	register pfd_t	*pfd;
	pde_t		*pt_array[btoc(MAXPHYSIO)+1];

	/*
	 * Check page permissions and existence
	 */

	npgs = len(base, count);

	rp = findreg(u.u_procp, base);
	if (rp == NULL)
		return (0);
	regrele(rp);

	b_phys = rw & B_PHYS;
	b_read = rw & B_READ;

	/* 002 (moved the copy-on-write breaker here)
	**	In the following test we check for a copy-
	**	on-write page and if we find one, we break
	**	the copy-on-write even if we are not going
	**	to write to the page.  This is necessary
	**	in order to make the lock accounting
	**	work correctly.  The problem is that the
	**	lock bit is in the dbd but the count of
	**	the number of lockers is in the pfdat.
	**	Therefore, if more than one pde refers
	**	to the same pfdat, the accounting gets
	**	wrong and we could fail to unlock a
	**	page when we should.  Note that this is
	**	not very likely to happen since it means
	**	we did a fork, no exec, and then started
	**	doing raw I/O.  Still, it could happen.
	*/

	for (i = 0, b = base; i < npgs; i++, b += ctob(1)) {
		if ((x = fubyte(b)) == -1)
			return (0);

		pt = upt(b);
		ASSERT(pt);
		if (b_phys)
			pt_array[i] = pt;	/* save pt */
		if (!pg_iscw(pt) && !b_read)
			continue;		/* no need to write to page */
		if (subyte(b, x) == -1)
			return (0);
	}

	/*
	 * If doing PHYSio, lock each page into memory and fault it in.
	 */

	if (b_phys) {
		reglock(rp);
		memlock();
		for (i = 0, b = base; i < npgs; i++, b += ctob(1)) {
			pt = pt_array[i];
			ASSERT(pt);
			dbd = (dbd_t *)pt + NPGPT;
			pg_setlock(dbd);

			while (!pg_isvalid(pt)) {
				/*
				 * page was swapped out -- release the locks
				 * (vfault will need them) and try again
				 */
				memunlock();
				regrele(rp);
				x = fubyte(b);
				ASSERT(x != -1);
				reglock(rp);
				memlock();
			}
			pfd = pde_to_pfdat(*pt);
			ASSERT(pfd->pf_rawcnt >= 0);
#ifdef FULL_DMA_DEBUG
if (pfd->pf_rawcnt > 0 && rp->r_type == RT_PRIVATE)
	printf("useracc: rp=%x pfd=%x dbd=%x pf_rawcnt=%x\n",
	  rp, pfd, dbd, pfd->pf_rawcnt);
#endif
			if (pfd->pf_rawcnt++ == 0) {
				atom_dec(&availrmem);
				if (availrmem < tune.t_minarmem) {
					atom_inc(&availrmem);
					--pfd->pf_rawcnt;
					pg_clrlock(dbd);
					memunlock();
					regrele(rp);
					nomemmsg("useracc", 1, 0, 1);
					u.u_error = EAGAIN;
					goto out;
				}
			}
		}
		memunlock();
		regrele(rp);
	}

	return (1);
out:

	if (b_phys) {
		reglock(rp);
		memlock();
		for (b -= ctob(1); --i >= 0; b -= ctob(1)) {
			pt = upt(b);
			ASSERT(pt);
			dbd = (dbd_t *)pt + NPGPT;
			pfd = pde_to_pfdat(*pt);
			ASSERT(pg_islocked(dbd));
			ASSERT(pfd->pf_rawcnt > 0);
			if (--pfd->pf_rawcnt == 0) {
				pg_clrlock(dbd);
				atom_inc(&availrmem);
			}
		}
		memunlock();
		regrele(rp);
	}
	return (0);
}

/*
 * Setup user physio
 */

userdma(base, count, rw)
{
	return (useracc(base, count, rw | B_PHYS));
}

/*
 * Terminate user physio
 */

undma(base, count, rw)
register uint	base, rw;
{
	register pde_t	*pt;
	register int	npgs;
	register reg_t	*rp;
	register pfd_t	*pfd;
	register dbd_t	*dbd;


	rp = findreg(u.u_procp, base);
	ASSERT(rp != NULL);

	/*
	 * Unlock pages.  Set the reference bit.  Set the modify bit if B_READ.
	 */

	memlock();
	for (npgs = len(base, count) ; --npgs >= 0 ; base += ctob(1)) {
		pt = upt(base);
		ASSERT(pt);
		dbd = (dbd_t *)pt + NPGPT;
		pfd = pde_to_pfdat(*pt);
		ASSERT(pg_islocked(dbd));
#ifdef DMA_DEBUG
		if (pfd->pf_rawcnt == 0) {
			pfd_t	pf;

			pf = *pfd;
printf("undma(base=%x, count=%x, rw=%x) npgs=%x rp=%x pt=%x dbd=%x\n",
  base, count, rw, npgs, rp, pt, dbd);
printf("pfd=%x: pf_blkno=%x pf_flags=%x pf_use=%x pf_dev=%x pf_inum=%x\n",
  pfd, pf.pf_blkno, pf.pf_flags, pf.pf_use, pf.pf_dev, pf.pf_inumber);
printf("   pf_swpi=%x pf_rawcnt=%x pf_wait=%x next=%x prev=%x hchain=%x\n",
  pf.pf_swpi, pf.pf_rawcnt, pf.pf_waitcnt, pf.pf_next, pf.pf_prev,
  pf.pf_hchain);
		}
#endif
		ASSERT(pfd->pf_rawcnt > 0);
		if (--pfd->pf_rawcnt == 0) {
			pg_clrlock(dbd);
			atom_inc(&availrmem);
		}
		pg_setref(pt);
		if (rw & B_READ) 
			pg_setmod(pt);
	}
	memunlock();
	regrele(rp);
}

