/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) printf.c: version 25.1 created on 11/27/91 at 15:11:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)printf.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/immu.h"
#include "sys/cmn_err.h"
#include "sys/tty.h"
#include "sys/own.h"
#include "sys/spm_mem.h"
#include "sys/sbus_spm.h"
#include "sys/debug.h"
#include "sys/kmem.h"

/* general argument list for cmn_err and panic */
# define ARGS	a0,a1,a2,a3,a4,a5


/*	Save output in a buffer where we can look at it
**	with demon or crash.  If the message begins with
**	a '!', then only put it in the buffer, not out
**	to the console.
*/

extern	char	putbuf[];
extern	int	putbufsz;
int		putbufndx = 0;
short		prt_where;

char	*panicstr ;


/*
 * pr_output -- send data to the SPM using character rings
 */

static void
pr_output(c)
uint	c;
{
	uint	i;

	i = (own.o_printf_count + 1) & CharBuffMask;
	while (i == own.o_spm_printf_count)
		;
	own.o_char_buff[own.o_printf_count] = c;
	own.o_printf_count = i;
}


/*
 * Scaled down version of C Library printf.
 * Only %s %u %d (==%u) %o %x %D are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Printf should not be used for chit-chat.
 */

printf(fmt, x1)
register char *fmt;
unsigned x1;
{
	register int	c, pz;
	register uint	*adx;
	register char	*s;

	pz = 0;
	adx = &x1;

loop:
	while ((c = *fmt++) != '%') {
		if (c == '\0')
			return;
		pr_output(c);
	}
	c = *fmt++;
	if (c == '0') {
		pz = 1;
		c = *fmt++;
	}
	if (c == 'l') c = *fmt++;
	if ( c <= 'Z' && c >= 'A') c += 'a' - 'A';
	if (c == 'd' || c == 'u' || c == 'o' || c == 'x')
		printn((long)*adx, c=='o'? 8: (c=='x'? 16:10), pz);
	else if (c == 's') {
		s = (char *)*adx;
		while (c = *s++) {
			pr_output(c);
		}
	}
	adx++;
	pz = 0;
	goto loop;
}

printn(n, b, padzero)
long n;
register b;
{
	register i, nd, c;
	int	flag;
	int	plmax;
	char d[12];

	c = 1;
	flag = n < 0;
	if (flag)
		n = (-n);
	if (b==8)
		plmax = 11;
	else if (b==10)
		plmax = 10;
	else if (b==16)
		plmax = 8;
	if (flag && b==10) {
		flag = 0;
		pr_output('-');
	}
	for (i=0;i<plmax;i++) {
		nd = n%b;
		if (flag) {
			nd = (b - 1) - nd + c;
			if (nd >= b) {
				nd -= b;
				c = 1;
			} else
				c = 0;
		}
		d[i] = nd;
		n = n/b;
		if ((n==0) && (flag==0))
			break;
	}
	if (i==plmax)
		i--;
	else if (padzero) {
		for (c = plmax - i - 1; c > 0; c--)
			pr_output('0');
	}
	for (;i>=0;i--) {
		pr_output("0123456789ABCDEF"[d[i]]);
	}
}

/*
 * Panic is called on unresolvable fatal errors.
 */

int	panic_level = 0;

panic(ARGS)
int	ARGS ;
{

	prt_where = PRW_CONS | PRW_BUF;
	panic_level = 1;
	printf("\nPANIC: ");
	printf(ARGS);
	printf("\n");

	/* save panic string (needed for routines elsewhere) */
	panicstr = (char *)a0 ;

	spm_mem.panic_pm_id = own.o_pm_id;
	spm_mem.panic_slot = (uint)-1;		/* to signify panic via pm_id */
	spm_mem.panic_flag = 1;

	stop_all_processors();
}

/*
 * prdev prints a warning message.
 * dev is a block special device argument.
 */

prdev(str, dev)
char *str;
dev_t dev;
{
	register uint	maj;

	dev = notminored(dev);
	maj = bmajor(dev);
	if (maj >= bdevcnt)
		cmn_err(CE_WARN, "%s on bad dev 0x%x (illegal major #)\n",
		  str, denotminored(dev));
	else if (bdevsw[maj].d_print)
		(*bdevsw[maj].d_print)(dev, str);
	else
		cmn_err(CE_WARN, "prdev: dev = 0x%x, msg = %s\n",
		  denotminored(dev), str);
}



cmn_err(level, fmt, ARGS)
int	level ;
char	*fmt;
int	ARGS ;
{
	ushort	x;

	/*	set up to print to putbuf, console, or both
	**	as indicated by the first character of the
	**	format.
	*/

	if (*fmt == '!') {
		prt_where = PRW_BUF;
		fmt++;
	} else if (*fmt == '^') {
		prt_where = PRW_CONS;
		fmt++;
	} else {
		prt_where = PRW_BUF | PRW_CONS;
	}

	switch (level) {
		case CE_CONT :
			printf(fmt, ARGS) ;
			break ;

		case CE_NOTE :
			printf("\nNOTICE: ") ;
			printf(fmt, ARGS) ;
			printf("\n") ;
			break ;

		case CE_WARN :
			printf("\nWARNING: ") ;
			printf(fmt, ARGS) ;
			printf("\n") ;
			break ;

		case CE_PANIC : {
			switch (panic_level) {
				case 0 : {
					x = splhi() ;

					prt_where = PRW_CONS | PRW_BUF;
					panic_level = 1 ;
					printf("\nPANIC: ") ;
					printf(fmt, ARGS) ;
					printf("\n") ;
					splx(x) ;
					backtrace();
 					spm_mem.panic_pm_id = own.o_pm_id;
					/* to signify panic via pm_id */
					spm_mem.panic_slot = (uint)-1;
					spm_mem.panic_flag = 1;
					stop_all_processors();
				}

				case 1 :
					panic_level = 2 ;
					prt_where = PRW_CONS | PRW_BUF;
					printf("\nDOUBLE PANIC: ") ;
					printf(fmt, ARGS) ;
					printf("\n") ;
					break;

				default :
					panic_level = 3 ;
					break;
			}
		}

		default :
			 printf(
			   "unknown level in cmn_err (level=%d, msg=\"%s\")\n",
			   level, fmt);
			backtrace();
 			spm_mem.panic_pm_id = own.o_pm_id;
						/* to signify panic via pm_id */
			spm_mem.panic_slot = (uint)-1;
			spm_mem.panic_flag = 1;

			stop_all_processors();
	}
}


/*	Called by the ASSERT macro in debug.h when an
**	assertion fails.
*/

assfail(a, f, l)
char *a, *f;
{
	cmn_err(CE_PANIC, "assertion failed: %s, file: %s, line: %d",
		a, f, l);
}


nomemmsg(func, count, contflg, lockflg)
register char	*func;
register int	count;
register int	contflg;
register int	lockflg;
{
	cmn_err(CE_NOTE,
		"%s - Insufficient memory to%s %d%s page%s - %s",
		func, (lockflg ? " lock" : " allocate"),
		count, (contflg ? " contiguous" : ""),
		(count == 1 ? "" : "s"),
		"system call failed");
}
