/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pipe.c: version 25.1 created on 11/27/91 at 15:11:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pipe.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/fstyp.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/var.h"
#include "sys/mfs.h"


short pipefstyp;

/*
 * Generic pipe sys call. 
 * Switch to current pipe fs
 */

pipe()
{
	register struct inode *ip;
	register struct file *rf, *wf;
	struct mount *mp;
	int r;

	/* get an inode on the device associated with pipefstyp */
	ASSERT(pipefstyp > 0 && pipefstyp < nfstyp);
	mp = fsinfo[pipefstyp].fs_pipe;
	ASSERT(mp != NULL);

	if ( ! fstypsw[pipefstyp].getinode_flag )
		upkern_lock();

	if ((ip = (*fstypsw[pipefstyp].fs_getinode)(mp, FSG_PIPE, -1)) == NULL)
		return;
	if ((rf = falloc(ip, FREAD)) == NULL) {
		iput(ip);
		return;
	}
	r = u.u_rval1;
	if ((wf = falloc(ip, FWRITE)) == NULL) {
		spin_lock(&file_freelist_lock);
		rf->f_count = 0;
		rf->f_next = ffreelist;
		ffreelist = rf;
		spin_unlock(&file_freelist_lock);
		SET_OFILE(r, NULL);
		iput(ip);
		return;
	}
	u.u_rval2 = u.u_rval1;
	u.u_rval1 = r;
	wf->f_flag = FWRITE;
	wf->f_inode = ip;
	rf->f_flag = FREAD;
	rf->f_inode = ip;
	ip->i_count = 2;
#ifdef SECON
	sat_pipe( ip );
#endif
	prele(ip);
}

/*
 * Lock a pipe.
 * If it's already locked,
 * set the WANT bit and sleep.
 */
plock(ip)
register struct inode *ip;
{
	spin_lock(&inode_sem);
	while (inode_locked(ip)) {
		inode_want(ip);
		mfs_sleep((caddr_t)ip, PINOD, &inode_sem);
	}
	inode_lock(ip);
	spin_unlock(&inode_sem);
	ASSERT(ip->i_count > 0);
}

/*
 * Unlock a pipe.
 * If WANT bit is on,
 * wakeup.
 * This routine is also used
 * to unlock inodes in general.
 */
prele(ip)
register struct inode *ip;
{
	ASSERT(inode_locked(ip));

	spin_lock(&inode_sem);
	inode_unlock(ip);
	if (inode_wanted(ip))  {
		inode_unwant(ip);
		mfs_wakeup_all((caddr_t)ip);
	}
	spin_unlock(&inode_sem);
}

/*
 * Try to lock a pipe (or any inode).
 * If it's already locked, return zero, else lock it and return non-zero.
 */
try_plock(ip)
register inode_t	*ip;
{
	int	ret;

	spin_lock(&inode_sem);
	if (!inode_locked(ip)) {
		inode_lock(ip);
		ret = 1;
	}
	else
		ret = 0;
	spin_unlock(&inode_sem);
	ASSERT(ip->i_count > 0);
	return (ret);
}
