/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) physio.c: version 25.1 created on 11/27/91 at 15:11:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)physio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/map.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/var.h"
#include "sys/inode.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/swap.h"
#include "sys/getpages.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/mfs.h"
#include "sys/sbus.h"
#include "sys/own.h"
#include "sys/tuneable.h"



#define MAX_EDT			256	/* max blocks per EDT transfer */
#define ALIGN(addr, bound)	(((uint)(addr) + (bound) - 1) & ~((bound) - 1))

extern buf_t	swapfreelist;
extern uint	pde_to_km();


/*
 * swap I/O
 *
 * The pglptr must point to a list of npage pages that occupy contiguous
 * physical blocks on one swap device.
 */

swap(pglptr, npage, rw)
register pglst_t	*pglptr;
register int		npage;
{
	register buf_t	*bp;
	register dev_t	dev;
	register dbd_t	*dbd;

	ASSERT(syswait.swap >= 0);
	atom_inc(&syswait.swap);
	ASSERT(npage > 0 && npage <= MAXSPGLST);

	dbd = (dbd_t *)(pglptr->gp_ptptr + NPGPT);
	dev = swaptab[dbd->dbd_swpi].st_dev;
	dev = notminored(dev);

#ifdef FULL_SWAP_DEBUG
	printf("swap(pglptr=%x, npage=%x, rw=%x)\n", pglptr, npage, rw);
#endif

	spin_lock(&swapbuf_lock);
	while ((bp = swapfreelist.av_forw) == NULL)  {
		swapfreelist.b_want_flag = 1;
		mfs_sleep(&swapfreelist, PRIBIO, &swapbuf_lock);
	}
	swapfreelist.av_forw = bp->av_forw;
	spin_unlock(&swapbuf_lock);

	bp->b_flags = B_BUSY | B_PHYS | rw;
	bp->b_dev = dev;
	bp->b_blkno = dbd->dbd_blkno;
	bp->b_proc = (proc_t *)0;

#ifdef FULL_SWAP_DEBUG
	printf("swap: alloced bp=%x b_proc=%x b_flags=%x b_dev=%x b_blkno=%x\n",
	  bp, bp->b_proc, bp->b_flags, bp->b_dev, bp->b_blkno);
#endif /* FULL_SWAP_DEBUG */

	for ( ; --npage >= 0; pglptr++) {
		bp->b_un.b_addr = (caddr_t)pde_to_km(*pglptr->gp_ptptr);
		swapseg(bp, 1, rw);
		bp->b_blkno += ptod(1);
	}

	spin_lock(&swapbuf_lock);
	bp->av_forw = swapfreelist.av_forw;
	swapfreelist.av_forw = bp;
	if (swapfreelist.b_want_flag) {
		swapfreelist.b_want_flag = 0;
		mfs_wakeup_all(&swapfreelist);
	}
	spin_unlock(&swapbuf_lock);

	ASSERT(syswait.swap > 0);
	atom_dec(&syswait.swap);
}

/*
 * Do a swap transfer for swap
 */

swapseg(bp, pg, rw)
register buf_t	*bp;
int		pg, rw;
{
	u.u_iosw++;
	if (rw) {
		sysinfo.swapin++;
		sysinfo.bswapin += pg;
	}
	else {
		sysinfo.swapout++;
		sysinfo.bswapout += pg;
	}
	bp->b_bcount = ctob(pg);
	bp->b_flags &= ~B_DONE;
	bp->b_error = bp->b_driver_flags = 0;
#ifdef SWAPSEG_DEBUG
	printf("swapseg(bp=%x pg=%x rw=%x) dev=%x flags=%x blkno=%x count=%x\n",
	  bp, pg, rw, bp->b_dev, bp->b_flags, bp->b_blkno, bp->b_bcount);
#endif

	ASSERT(bp->b_blkno >= 0);

	(*bdevsw[bmajor(bp->b_dev)].d_strategy)(bp);

	spin_lock(&bio_lock);
	while ((bp->b_flags & B_DONE) == 0)
		mfs_sleep(bp, PRIBIO, &bio_lock);
	spin_unlock(&bio_lock);

	if ((bp->b_flags & B_ERROR) || (bp->b_driver_flags & B_ERROR)) {
		cmn_err(CE_PANIC,
		  "swapseg - i/o error in swap: dev=%x, blk=%x, cnt=%x, bp=%x",
		  bp->b_dev, bp->b_blkno, bp->b_bcount, bp);
	}
}

/*
 * initialize the linked list of swapbufs
 */

initswapbufs()
{
	register buf_t	*bp;
	register int	num;
	extern buf_t	swap_bufs[];
	extern int	numswap_bufs;

	spin_lock(&swapbuf_lock);

	ASSERT(swapfreelist.b_flags == 0);
	swapfreelist.b_flags = B_OPEN;
	for (bp = swap_bufs, num = numswap_bufs; --num >= 0; bp++) {
		bp->av_forw = swapfreelist.av_forw;
		swapfreelist.av_forw = bp;
	}
	spin_unlock(&swapbuf_lock);
}

/*
 * get_physbuf -- return a buffer from physio's pool
 */

buf_t *
get_physbuf()
{
	buf_t	*bp;

	spin_lock(&bio_lock);

	while (pfreecnt == 0)  {
		mfs_sleep(&pfreelist, PRIBIO, &bio_lock);
	}
	ASSERT(pfreecnt);
	ASSERT(pfreelist.av_forw);
	pfreecnt--;
	bp = pfreelist.av_forw;
	pfreelist.av_forw = bp->av_forw;

	spin_unlock(&bio_lock);

	return (bp);
}

/*
 * rel_physbuf -- return a buffer to physio's pool
 */

void
rel_physbuf(bp)
buf_t	*bp;
{
	ASSERT(bp >= pbuf && bp <= &pbuf[v.v_pbuf - 1]);
	spin_lock(&bio_lock);
	bp->av_forw = pfreelist.av_forw;
	pfreelist.av_forw = bp;
	pfreecnt++;
	if (pfreecnt == 1) mfs_wakeup_all(&pfreelist);
	spin_unlock(&bio_lock);
}

/*
 * Raw I/O. The arguments are
 * The strategy routine for the device
 * A buffer, which is usually NULL, or special buffer
 *   header owned exclusively by the device for this purpose
 * The device number
 * Read/write flag
 */

physio(strat, bp, dev, rw)
register struct buf *bp;
int (*strat)();
{
	register int		count;
	register caddr_t	base;
	register caddr_t	lbase;
	char			*kseg();
	register int		hpf;

	count = u.u_count;
	base = u.u_base;

	if (count == 0)
		return;
	if (count > MAXPHYSIO) {
		u.u_error = EFAULT;
		return;
	}

	if (server()) {
		if ((base = kseg(btoc(count))) == 0)
			return;
		lbase = u.u_base;
		if (rw == B_WRITE) {
			if (remio(lbase, base, count)) {
				unkseg(base, btoc(count));
				return;
			}
			u.u_segflg = 1;	/*you're now dealing with kernel space*/
		}
		u.u_base = base;
	} else {
		if (userdma(base, count, rw) == NULL) {
			if (u.u_error == 0)
				u.u_error = EFAULT;
			return;
		}
	}

	hpf = (bp == NULL);

	ASSERT(syswait.physio >= 0);
	atom_inc(&syswait.physio);
	if (rw)
		atom_inc(&sysinfo.phread);
	else
		atom_inc(&sysinfo.phwrite);

		/* Get a buffer header off of the free list, if needed. */
	if (hpf)
		bp = get_physbuf();

	bp->b_flags = B_BUSY | B_PHYS | rw;
	bp->b_error = bp->b_driver_flags = 0;
	bp->b_proc = u.u_procp;
	bp->b_dev = dev;
	bp->b_blkno = btodt(u.u_offset);
	bp->b_bcount = count;
	bp->b_un.b_addr = (caddr_t)base;

	(*strat)(bp);

	spin_lock(&bio_lock);
	while ((bp->b_flags & B_DONE) == 0)
		mfs_sleep(bp, PRIBIO, &bio_lock);
	spin_unlock(&bio_lock);

	if (server()) {
		if (rw == B_READ) {
			u.u_segflg = 0;
			if (unremio(base, lbase, count))
				printf("unremio failed: err=%d\n",u.u_error);
		}
		unkseg(base, btoc(count));
	}
	else
		undma(base, count, rw);

	if ((bp->b_flags & B_ERROR) || (bp->b_driver_flags & B_ERROR)) {
		if ((u.u_error = bp->b_error)==0)
			u.u_error = EIO;
		bp->b_driver_flags &= ~B_ERROR;
	}
	
	u.u_count = bp->b_resid;

	bp->b_flags &= ~(B_BUSY|B_PHYS);

	if (hpf)
		rel_physbuf(bp);

	ASSERT(syswait.physio > 0);
	atom_dec(&syswait.physio);
}


physck(nblocks, rw)
daddr_t nblocks;
{
	register unsigned over;
	off_t upper, limit;
	struct a {
		int	fdes;
		char	*cbuf;
		unsigned count;
	} *uap;

	/*
	 * check for raw i/o with a non long word aligned buffer 
	 */
	if ((unsigned)u.u_base & 3) {
		u.u_error = EFAULT;
		return(0);
	}
		
	limit = nblocks << BSHIFT;
	if (u.u_offset >= limit) {
		if (u.u_offset > limit || rw == B_WRITE)
			u.u_error = ENXIO;
		return(0);
	}
	upper = u.u_offset + u.u_count;
	if (upper > limit) {
		over = upper - limit;
		u.u_count -= over;
		uap = (struct a *)u.u_ap;
		uap->count -= over;
	}
	return(1);
}
