/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) perf.c: version 25.1 created on 11/27/91 at 15:10:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)perf.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/tuneable.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/mount.h"
#include "sys/param.h"
#include "sys/file.h"
#include "sys/ipc.h"
#include "sys/sem.h"
#include "sys/sysinfo.h"
#include "sys/perf.h"
#include "sys/perfext.h"

/*
 * If security is off, then we must copy the define from sys/mls.h.
 * This define should probably be in sys/param.h anyway.
 */
#ifndef	SECON
#define SECURE_INODE	128
#endif	/* !SECON */

#ifdef	PERF_NOSUCHK
#define	NO_SU_CHK	0 &&
#else	/* PERF_NOSUCHK */
#define	NO_SU_CHK
#endif	/* PERF_NOSUCHK */

long	glob_quantum_copy_flag;	/* copy value from parent dir	*/
long	glob_quantum_size;	/* global quantum size		*/

long	glob_slice_copy_flag;	/* copy value from parent dir	*/
long	glob_slice_clamp_cnt;	/* global usage count stat	*/
long	glob_slice_clamp_ovfl;	/* overflow count for above	*/
long	glob_slice_clamp;	/* global slice size clamp	*/

long	glob_pri_copy_flag;	/* copy value from parent dir	*/
long	glob_pri_clamp_cnt;	/* global usage count stat	*/
long	glob_pri_clamp_ovfl;	/* overflow count for above	*/
long	glob_pri_clamp;		/* global pri clamp		*/

long	glob_usrpri_copy_flag;	/* copy value from parent dir	*/
long	glob_usrpri_clamp_cnt;	/* global usage count stat	*/
long	glob_usrpri_clamp_ovfl;	/* overflow count for above	*/
long	glob_usrpri_clamp;	/* global usrpri clamp		*/

long	glob_cpu_copy_flag;	/* copy value from parent dir	*/
long	glob_cpu_clamp_cnt;	/* global usage count stat	*/
long	glob_cpu_clamp_ovfl;	/* overflow count for above	*/
long	glob_cpu_clamp;		/* global cpu clamp		*/

long	glob_pri_adj_copy_flag;	/* copy value from parent dir	*/
long	glob_pri_adj;		/* global pri adj value		*/

long	glob_perf_flags_copy_flag;/* copy value from parent dir	*/

uchar	pri_PPIPE = PPIPE;
uchar	pri_PSEMZ = PSEMZ;
uchar	pri_PSEMN = PSEMN;

static	int	perf_debug = 0;

/*
 *	IF INVOKED AS ...
 *
 *	chgperf(fname,cmd,pid,nval,oval)
 *		fname	is uap->arg0	(user virtual address of file name)
 *
 *	OR ...
 *
 *	fchgperf(fdes,cmd,pid,nval,oval)
 *		fdes	is uap->arg0	(user file descriptor)
 *
 *	THEN ...
 *
 *		cmd	is uap->arg1	(user virtual address of cmd value)
 *					which perf value to affect (sub-command)
 *		pid	is uap->arg2	NOT USED
 *		nval	is uap->arg3	new value to set (accepts any value)
 *					Upon fork, child inherits parent's
 *					qauntum and all clamps.
 *					For qauntum, upon exec, child will use
 *					default time slice size if inode value
 *					is zero or will keep parent's value if
 *					inode value is negative, or will accept
 *					new value from the inode if it is within
 *					a valid range.
 *					For clamps, upon exec, child will
 *					turn off clamps if inode value is
 *					zero, or will keep parent's value if
 *					inode value is negative, or will accept
 *					new value from the inode if it is within
 *					a valid range.
 *		oval	is uap->arg4	return old value here
 *
 *	ELSE ...
 *
 *		if (fname is 0) OR (fdes < 0), then affect the
 *					process identified by pid
 *		cmd	is uap->arg1	(user virtual address of cmd value)
 *					which perf value to affect (sub-command)
 *		pid	is uap->arg2	process id of process to affect
 *					if 0, do it to current process
 *		nval	is uap->arg3	new value to set
 *					if 0, then use a default for qauntum or
 *						turn off clamps
 *					if -1, then just return the old value
 *						in oval
 *		oval	is uap->arg4	return old value here
 *
 *	SPECIAL CASE ...
 *
 *		For getting or setting statistics, the following override
 *		the above description:
 *
 *		cmd	is uap->arg1	(user virtual address of cmd value)
 *					which perf stat to get/set
 *		pid	is uap->arg2	process id of process to affect
 *					if -1, get global stats, else
 *					if 0, get stats from current process
 *					else, get stats from process 'pid'
 *		nval	is uap->arg3	stat overflow field get/set
 *		oval	is uap->arg4	stat count field get/set
 *
 *	RETURN:
 *		0	- on success
 *		-1	- on failure and set errno to:
 *			EINVAL	- if cmd not supported or in conflict
 *				  or if values are way out of range
 *			EFAULT	- if copying of perf structure failes
 *			ESRCH	- if 'pid' is not in proc table
 *			EBADF	- if passed bad file descriptor
 *			ENOSYS	- if bad file system type of this operation
 *			EACCES	- if not superuser and tries to change
 *				  someone else's values
 */

chgperf()
{
	register struct	a {
		char		*fname;
		int		cmd;
		int		pid;
		int		*nval;
		int		*oval;
	} *uap;
	register struct	inode	*ip;

	uap = (struct a *)u.u_ap;
	ip  = NULL;
	if (uap->fname) {
		if ((ip = namei(upath, 0)) == NULL)
			return;
		if (ip->i_mntdev->m_isize != SECURE_INODE) {
			iput(ip);
			u.u_error = ENOSYS;
			return;
		}
	}
	perfcommon(ip,uap->cmd,uap->pid,uap->nval,uap->oval);
	if (ip)
		iput(ip);
}

#ifdef FIPS
fchgperf()
{
	register struct	a {
		int		fdes;
		int		cmd;
		int		pid;
		int		*nval;
		int		*oval;
	} *uap;
	register struct	inode	*ip;
	register struct	file	*fp;
	extern	 struct	file	*getf();

	uap = (struct a *)u.u_ap;
	ip  = NULL;
	if (uap->fdes >= 0) {
		/*
		 * Check if valid file descriptor.
		 */
		if ((fp = getf(uap->fdes)) == NULL)
			return;				/* returns EBADF */
		ip = fp->f_inode;
		plock(ip);
		if (ip->i_mntdev->m_isize != SECURE_INODE) {
			prele(ip);
			u.u_error = ENOSYS;
			return;
		}
	}
	perfcommon(ip,uap->cmd,uap->pid,uap->nval,uap->oval);
	if (ip)
		prele(ip);
}
#endif /* FIPS */

perfcommon(ip,cmd,pid,unval,uoval)
register struct	inode	*ip;
register int		cmd, *unval, *uoval;
register int		pid;
{
register int		oval, nval;
struct	 argnamei	nmarg;

	oval = nval = 0;
	if (unval && ((nval = fuword(unval)) == -1)) {
		u.u_error = EFAULT;
		return;
	}
	switch (cmd) {
	case PERF_GETDEBUG:		/* get perf debug level		*/
		oval = perf_debug;
		break;

	case PERF_SETDEBUG:		/* set perf debug level		*/
		oval = perf_debug;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		perf_debug = nval;
		break;

	case PERF_GETQUANTUM:		/* get current quantum size	*/
		if (ip) {
			nmarg.cmd   = NI_CHQUANTUM;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getquantumvar(pid);
		}
		break;

	case PERF_SETQUANTUM:		/* set current quantum size	*/
		if (ip) {
			nmarg.cmd   = NI_CHQUANTUM;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setquantumvar(pid,nval,unval);
		}
		break;

	case PERF_GETSLICE:		/* get current time slice clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHSLICE;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getslicevar(pid);
		}
		break;

	case PERF_SETSLICE:		/* set current time slice clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHSLICE;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setslicevar(pid,nval,unval);
		}
		break;

	case PERF_GETPRI:		/* get current pri clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHPRI;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getprivar(pid);
		}
		break;

	case PERF_SETPRI:		/* set current pri clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHPRI;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setprivar(pid,nval,unval);
		}
		break;

	case PERF_GETUSRPRI:		/* get current usrpri clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHUSRPRI;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getusrprivar(pid);
		}
		break;

	case PERF_SETUSRPRI:		/* set current usrpri clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHUSRPRI;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setusrprivar(pid,nval,unval);
		}
		break;

	case PERF_GETCPU:		/* get current cpu clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHCPU;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getcpuvar(pid);
		}
		break;

	case PERF_SETCPU:		/* set current cpu clamp	*/
		if (ip) {
			nmarg.cmd   = NI_CHCPU;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setcpuvar(pid,nval,unval);
		}
		break;

	case PERF_GETPRIADJ:		/* get current pri adj value	*/
		if (ip) {
			nmarg.cmd   = NI_CHPRIADJ;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getpriadjvar(pid);
		}
		break;

	case PERF_SETPRIADJ:		/* set current pri adj value	*/
		if (ip) {
			nmarg.cmd   = NI_CHPRIADJ;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setpriadjvar(pid,nval,unval);
		}
		break;

	case PERF_GETMAXQUANTUM:	/* get maximum quantum size	*/
		oval = max_quantum_size;
		break;

	case PERF_SETMAXQUANTUM:	/* set maximum quantum size	*/
		oval = max_quantum_size;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval <= 0) {
			u.u_error = EINVAL;
			return;
		}
		max_quantum_size = nval;
		break;

	case PERF_GETMAXSLICE:		/* get maximum time slice clamp	*/
		oval = max_slice_clamp;
		break;

	case PERF_SETMAXSLICE:		/* set maximum time slice clamp	*/
		oval = max_slice_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval <= 0) {
			u.u_error = EINVAL;
			return;
		}
		max_slice_clamp = nval;
		break;

	case PERF_GETMAXPRI:		/* get maximum pri clamp	*/
		oval = max_pri_clamp;
		break;

	case PERF_SETMAXPRI:		/* set maximum pri clamp	*/
		oval = max_pri_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval <= PZERO) || (nval >= NUM_PRIORITIES)) {
			u.u_error = EINVAL;
			return;
		}
		max_pri_clamp = nval;
		break;

	case PERF_GETMAXUSRPRI:		/* get maximum usrpri clamp	*/
		oval = max_usrpri_clamp;
		break;

	case PERF_SETMAXUSRPRI:		/* set maximum usrpri clamp	*/
		oval = max_usrpri_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval <= PZERO) || (nval >= NUM_PRIORITIES)) {
			u.u_error = EINVAL;
			return;
		}
		max_usrpri_clamp = nval;
		break;

	case PERF_GETMAXCPU:		/* get maximum cpu clamp	*/
		oval = max_cpu_clamp;
		break;

	case PERF_SETMAXCPU:		/* set maximum cpu clamp	*/
		oval = max_cpu_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval < (PUSER - NZERO)) || (nval > 255)) {
			u.u_error = EINVAL;
			return;
		}
		max_cpu_clamp = nval;
		break;

	case PERF_GETMAXPRIADJ:		/* get maximum pri adj value	*/
		oval = max_pri_adj;
		break;

	case PERF_SETMAXPRIADJ:		/* set maximum pri adj value	*/
		oval = max_pri_adj;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval < 0) || (nval > 255)) {
			u.u_error = EINVAL;
			return;
		}
		max_pri_adj = nval;
		break;

	case PERF_GETQUANTUMCOPY:	/* get quantum size copy flag	*/
		oval = glob_quantum_copy_flag;
		break;

	case PERF_SETQUANTUMCOPY:	/* set quantum size copy flag	*/
		oval = glob_quantum_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_quantum_copy_flag = nval;
		break;

	case PERF_GETSLICECOPY:		/* get slice clamp copy flag	*/
		oval = glob_slice_copy_flag;
		break;

	case PERF_SETSLICECOPY:		/* set slice clamp copy flag	*/
		oval = glob_slice_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_slice_copy_flag = nval;
		break;

	case PERF_GETPRICOPY:		/* get pri clamp copy flag	*/
		oval = glob_pri_copy_flag;
		break;

	case PERF_SETPRICOPY:		/* set pri clamp copy flag	*/
		oval = glob_pri_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_pri_copy_flag = nval;
		break;

	case PERF_GETUSRPRICOPY:	/* get usrpri clamp copy flag	*/
		oval = glob_usrpri_copy_flag;
		break;

	case PERF_SETUSRPRICOPY:	/* set usrpri clamp copy flag	*/
		oval = glob_usrpri_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_usrpri_copy_flag = nval;
		break;

	case PERF_GETCPUCOPY:		/* get cpu clamp copy flag	*/
		oval = glob_cpu_copy_flag;
		break;

	case PERF_SETCPUCOPY:		/* set cpu clamp copy flag	*/
		oval = glob_cpu_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_cpu_copy_flag = nval;
		break;

	case PERF_GETPRIADJCOPY:	/* get pri adj value copy flag	*/
		oval = glob_pri_adj_copy_flag;
		break;

	case PERF_SETPRIADJCOPY:	/* set pri adj value copy flag	*/
		oval = glob_pri_adj_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_pri_adj_copy_flag = nval;
		break;

	case PERF_GETQUANTUMSTAT:	/* get quantum usage stats	*/
	case PERF_SETQUANTUMSTAT:	/* set quantum usage stats	*/
		u.u_error = EINVAL;
		return;

	case PERF_GETSLICESTAT:		/* get slice usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (uoval && suword(uoval,glob_slice_clamp_cnt)) {
				u.u_error = EFAULT;
				return;
			}
			if (unval && suword(unval,glob_slice_clamp_ovfl)) {
				u.u_error = EFAULT;
				return;
			}
			return;
		}
		getslicestat(pid,unval,uoval);
		return;

	case PERF_SETSLICESTAT:		/* set slice usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (NO_SU_CHK !suser()) {
				u.u_error = EACCES;
				return;
			}
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_slice_clamp_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_slice_clamp_ovfl = nval;
			}
			return;
		}
		setslicestat(pid,unval,uoval);
		return;

	case PERF_GETPRISTAT:		/* get pri    usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (uoval && suword(uoval,glob_pri_clamp_cnt)) {
				u.u_error = EFAULT;
				return;
			}
			if (unval && suword(unval,glob_pri_clamp_ovfl)) {
				u.u_error = EFAULT;
				return;
			}
			return;
		}
		getpristat(pid,unval,uoval);
		return;

	case PERF_SETPRISTAT:		/* set pri    usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (NO_SU_CHK !suser()) {
				u.u_error = EACCES;
				return;
			}
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_pri_clamp_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_pri_clamp_ovfl = nval;
			}
			return;
		}
		setpristat(pid,unval,uoval);
		return;

	case PERF_GETUSRPRISTAT:	/* get usrpri usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (uoval && suword(uoval,glob_usrpri_clamp_cnt)) {
				u.u_error = EFAULT;
				return;
			}
			if (unval && suword(unval,glob_usrpri_clamp_ovfl)) {
				u.u_error = EFAULT;
				return;
			}
			return;
		}
		getusrpristat(pid,unval,uoval);
		return;

	case PERF_SETUSRPRISTAT:	/* set usrpri usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (NO_SU_CHK !suser()) {
				u.u_error = EACCES;
				return;
			}
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_usrpri_clamp_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_usrpri_clamp_ovfl = nval;
			}
			return;
		}
		setusrpristat(pid,unval,uoval);
		return;

	case PERF_GETCPUSTAT:		/* get cpu    usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (uoval && suword(uoval,glob_cpu_clamp_cnt)) {
				u.u_error = EFAULT;
				return;
			}
			if (unval && suword(unval,glob_cpu_clamp_ovfl)) {
				u.u_error = EFAULT;
				return;
			}
			return;
		}
		getcpustat(pid,unval,uoval);
		return;

	case PERF_SETCPUSTAT:		/* set cpu    usage stats	*/
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (NO_SU_CHK !suser()) {
				u.u_error = EACCES;
				return;
			}
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_cpu_clamp_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return;
				}
				glob_cpu_clamp_ovfl = nval;
			}
			return;
		}
		setcpustat(pid,unval,uoval);
		return;

	case PERF_GETPRIADJSTAT:	/* get pri ajd value usage stats*/
		/*
		 * Since we don't keep stats of pri_adj usage, we return
		 * the per process number of swtch's occurring or the
		 * global sysinfo pswitch count.
		 */
		if (!unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		if (pid < 0) {
			if (uoval && suword(uoval,sysinfo.pswitch)) {
				u.u_error = EFAULT;
				return;
			}
			if (unval && suword(unval,sysinfo.pswitch)) {
				u.u_error = EFAULT;
				return;
			}
			return;
		}
		getpriadjstat(pid,unval,uoval);
		return;

	case PERF_SETPRIADJSTAT:	/* set pri ajd value usage stats*/
		/*
		 * Since we don't keep stats of pri_adj usage, we set
		 * the per process number of swtch's occurring.
		 * We don't clear or change global sysinfo pswitch count.
		 */
		if ((pid < 0) || !unval && !uoval) {
			u.u_error = EFAULT;
			return;
		}
		setpriadjstat(pid,unval,uoval);
		return;

	case PERF_GETGLOBQUANTUM:	/* get global quantum size	*/
		oval = glob_quantum_size;
		break;

	case PERF_SETGLOBQUANTUM:	/* set global quantum size	*/
		oval = glob_quantum_size;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval <= 0) || (nval > max_quantum_size)) {
			u.u_error = EINVAL;
			return;
		}
		glob_quantum_size = nval;
		break;

	case PERF_GETGLOBSLICE:		/* get global time slice clamp	*/
		oval = glob_slice_clamp;
		break;

	case PERF_SETGLOBSLICE:		/* set global time slice clamp	*/
		oval = glob_slice_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval <= 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_slice_clamp = nval;
		break;

	case PERF_GETGLOBPRI:		/* get global pri clamp		*/
		oval = glob_pri_clamp;
		break;

	case PERF_SETGLOBPRI:		/* set global pri clamp		*/
		oval = glob_pri_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval <= PZERO) || (nval >= NUM_PRIORITIES)) {
			u.u_error = EINVAL;
			return;
		}
		glob_pri_clamp = nval;
		break;

	case PERF_GETGLOBUSRPRI:	/* get global usrpri clamp	*/
		oval = glob_usrpri_clamp;
		break;

	case PERF_SETGLOBUSRPRI:	/* set global usrpri clamp	*/
		oval = glob_usrpri_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval <= PZERO) || (nval >= NUM_PRIORITIES)) {
			u.u_error = EINVAL;
			return;
		}
		glob_usrpri_clamp = nval;
		break;

	case PERF_GETGLOBCPU:		/* get global cpu clamp		*/
		oval = glob_cpu_clamp;
		break;

	case PERF_SETGLOBCPU:		/* set global cpu clamp		*/
		oval = glob_cpu_clamp;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval < (PUSER - NZERO)) || (nval > 255)) {
			u.u_error = EINVAL;
			return;
		}
		glob_cpu_clamp = nval;
		break;

	case PERF_GETGLOBPRIADJ:	/* get global pri adj value	*/
		oval = glob_pri_adj;
		break;

	case PERF_SETGLOBPRIADJ:	/* set global pri adj value	*/
		oval = glob_pri_adj;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if ((nval < 0) || (nval > 255)) {
			u.u_error = EINVAL;
			return;
		}
		glob_pri_adj = nval;
		break;

	case PERF_GETPRIPPIPE:		/* get PPIPE priority value	*/
		oval = pri_PPIPE;
		break;

	case PERF_SETPRIPPIPE:		/* set PPIPE priority value	*/
		oval = pri_PPIPE;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		pri_PPIPE = (uchar) nval;
		break;

	case PERF_GETPRIPSEMZ:		/* get PSEMZ priority value	*/
		oval = pri_PSEMZ;
		break;

	case PERF_SETPRIPSEMZ:		/* set PSEMZ priority value	*/
		oval = pri_PSEMZ;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		pri_PSEMZ = (uchar) nval;
		break;

	case PERF_GETPRIPSEMN:		/* get PSEMN priority value	*/
		oval = pri_PSEMN;
		break;

	case PERF_SETPRIPSEMN:		/* set PSEMN priority value	*/
		oval = pri_PSEMN;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		pri_PSEMN = (uchar) nval;
		break;

	case PERF_GETFLAGSCOPY:		/* get performance flags copy flag */
		oval = glob_perf_flags_copy_flag;
		break;

	case PERF_SETFLAGSCOPY:		/* set performance flags copy flag */
		oval = glob_perf_flags_copy_flag;
		if (!unval)
			break;
		if (NO_SU_CHK !suser()) {
			u.u_error = EACCES;
			return;
		}
		if (nval < 0) {
			u.u_error = EINVAL;
			return;
		}
		glob_perf_flags_copy_flag = nval;
		break;

	case PERF_GETPERFFLAGS:		/* get performance flags	*/
		if (ip) {
			nmarg.cmd   = NI_CHFLAGS;
			nmarg.mode  = nval;
			nmarg.rcode = 1;	/* do a get value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = getperfflags(pid);
		}
		break;

	case PERF_SETPERFFLAGS:		/* set performance flags	*/
		if (ip) {
			nmarg.cmd   = NI_CHFLAGS;
			nmarg.mode  = nval;
			nmarg.rcode = 0;	/* do a set value	*/
			if(FS_SETATTR(ip, &nmarg))
				ip->i_flag |= ICHG;
			oval = nmarg.mode;
		} else	{
			oval = setperfflags(pid,nval,unval);
		}
		break;

	default:
		if (perf_debug)
			printf("perf: unknown command: 0x%x\n",cmd);
		u.u_error = EINVAL;
		return;
	}
	if (!u.u_error) {
		if (uoval) {
			if (suword(uoval,oval))
				u.u_error = EFAULT;
		} else	{
			if (!u.u_error)
				u.u_error = EFAULT;
		}
	}
	return;
}

getquantumvar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_quantum);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_quantum);
	}
	u.u_error = ESRCH;
	return (-1);
}

setquantumvar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_quantum_size) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_quantum;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_quantum;
		else
			if (nval == 0)
				nval = quantum_size;
		pp->p_quantum = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_quantum;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_quantum;
			else
				if (nval == 0)
					nval = quantum_size;
			pp->p_quantum = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getslicevar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_slice_clamp);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_slice_clamp);
	}
	u.u_error = ESRCH;
	return (-1);
}

setslicevar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_slice_clamp) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_slice_clamp;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_slice_clamp;
		pp->p_slice_clamp = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_slice_clamp;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_slice_clamp;
			pp->p_slice_clamp = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getprivar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_pri_clamp);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_pri_clamp);
	}
	u.u_error = ESRCH;
	return (-1);
}

setprivar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_pri_clamp) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_pri_clamp;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_pri_clamp;
		else
			if ((nval > 0) && (nval <= PZERO)) {
				u.u_error = EINVAL;
				return (-1);
			}
		pp->p_pri_clamp = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_pri_clamp;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_pri_clamp;
			else
				if ((nval > 0) && (nval <= PZERO)) {
					u.u_error = EINVAL;
					return (-1);
				}
			pp->p_pri_clamp = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getusrprivar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_usrpri_clamp);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_usrpri_clamp);
	}
	u.u_error = ESRCH;
	return (-1);
}

setusrprivar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_usrpri_clamp) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_usrpri_clamp;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_usrpri_clamp;
		else
			if ((nval > 0) && (nval <= PZERO)) {
				u.u_error = EINVAL;
				return (-1);
			}
		pp->p_usrpri_clamp = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_usrpri_clamp;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_usrpri_clamp;
			else
				if ((nval > 0) && (nval <= PZERO)) {
					u.u_error = EINVAL;
					return (-1);
				}
			pp->p_usrpri_clamp = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getcpuvar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_cpu_clamp);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_cpu_clamp);
	}
	u.u_error = ESRCH;
	return (-1);
}

setcpuvar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_cpu_clamp) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_cpu_clamp;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_cpu_clamp;
		else
			if ((nval > 0) && (nval < (PUSER - NZERO))) {
				u.u_error = EINVAL;
				return (-1);
			}
		pp->p_cpu_clamp = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_cpu_clamp;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_cpu_clamp;
			else
				if ((nval > 0) && (nval < (PUSER - NZERO))) {
					u.u_error = EINVAL;
					return (-1);
				}
			pp->p_cpu_clamp = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getpriadjvar(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_pri_adj);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_pri_adj);
	}
	u.u_error = ESRCH;
	return (-1);
}

setpriadjvar(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	if (nval > max_pri_adj) {
		u.u_error = EINVAL;
		return (-1);
	}
	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_pri_adj;
		if (!unval)
			return (oval);
		if (nval < 0)
			nval = pp->p_parent->p_pri_adj;
		else
			if (nval > 255) {
				u.u_error = EINVAL;
				return (-1);
			}
		pp->p_pri_adj = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_pri_adj;
			if (!unval)
				return (oval);
			if (nval < 0)
				nval = pp->p_parent->p_pri_adj;
			else
				if (nval > 255) {
					u.u_error = EINVAL;
					return (-1);
				}
			pp->p_pri_adj = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getslicestat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval && suword(uoval,pp->p_slice_cnt)) {
			u.u_error = EFAULT;
			return (-1);
		}
		if (unval && suword(unval,pp->p_slice_ovfl)) {
			u.u_error = EFAULT;
			return (-1);
		}
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval && suword(uoval,pp->p_slice_cnt)) {
				u.u_error = EFAULT;
				return (-1);
			}
			if (unval && suword(unval,pp->p_slice_ovfl)) {
				u.u_error = EFAULT;
				return (-1);
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

setslicestat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;
register int	oval, nval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval) {
			if ((oval = fuword(uoval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_slice_cnt = oval;
		}
		if (unval) {
			if ((nval = fuword(unval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_slice_ovfl = nval;
		}
		return (0);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_slice_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_slice_ovfl = nval;
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getpristat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval && suword(uoval,pp->p_pri_cnt)) {
			u.u_error = EFAULT;
			return (-1);
		}
		if (unval && suword(unval,pp->p_pri_ovfl)) {
			u.u_error = EFAULT;
			return (-1);
		}
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval && suword(uoval,pp->p_pri_cnt)) {
				u.u_error = EFAULT;
				return (-1);
			}
			if (unval && suword(unval,pp->p_pri_ovfl)) {
				u.u_error = EFAULT;
				return (-1);
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

setpristat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;
register int	oval, nval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval) {
			if ((oval = fuword(uoval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_pri_cnt = oval;
		}
		if (unval) {
			if ((nval = fuword(unval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_pri_ovfl = nval;
		}
		return (0);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_pri_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_pri_ovfl = nval;
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getusrpristat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval && suword(uoval,pp->p_usrpri_cnt)) {
			u.u_error = EFAULT;
			return (-1);
		}
		if (unval && suword(unval,pp->p_usrpri_ovfl)) {
			u.u_error = EFAULT;
			return (-1);
		}
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval && suword(uoval,pp->p_usrpri_cnt)) {
				u.u_error = EFAULT;
				return (-1);
			}
			if (unval && suword(unval,pp->p_usrpri_ovfl)) {
				u.u_error = EFAULT;
				return (-1);
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

setusrpristat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;
register int	oval, nval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval) {
			if ((oval = fuword(uoval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_usrpri_cnt = oval;
		}
		if (unval) {
			if ((nval = fuword(unval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_usrpri_ovfl = nval;
		}
		return (0);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_usrpri_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_usrpri_ovfl = nval;
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getcpustat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval && suword(uoval,pp->p_cpu_cnt)) {
			u.u_error = EFAULT;
			return (-1);
		}
		if (unval && suword(unval,pp->p_cpu_ovfl)) {
			u.u_error = EFAULT;
			return (-1);
		}
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval && suword(uoval,pp->p_cpu_cnt)) {
				u.u_error = EFAULT;
				return (-1);
			}
			if (unval && suword(unval,pp->p_cpu_ovfl)) {
				u.u_error = EFAULT;
				return (-1);
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

setcpustat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;
register int	oval, nval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval) {
			if ((oval = fuword(uoval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_cpu_cnt = oval;
		}
		if (unval) {
			if ((nval = fuword(unval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_cpu_ovfl = nval;
		}
		return (0);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_cpu_cnt = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_cpu_ovfl = nval;
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getpriadjstat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval && suword(uoval,pp->p_nswtch)) {
			u.u_error = EFAULT;
			return (-1);
		}
		if (unval && suword(unval,pp->p_ovfswtch)) {
			u.u_error = EFAULT;
			return (-1);
		}
		return (0);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval && suword(uoval,pp->p_nswtch)) {
				u.u_error = EFAULT;
				return (-1);
			}
			if (unval && suword(unval,pp->p_ovfswtch)) {
				u.u_error = EFAULT;
				return (-1);
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

setpriadjstat(pid,unval,uoval)
register int	pid, *unval, *uoval;
{
register proc_t	*pp;
register int	oval, nval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		if (uoval) {
			if ((oval = fuword(uoval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_nswtch = oval;
		}
		if (unval) {
			if ((nval = fuword(unval)) == -1) {
				u.u_error = EFAULT;
				return (-1);
			}
			pp->p_ovfswtch = nval;
		}
		return (0);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			if (uoval) {
				if ((oval = fuword(uoval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_nswtch = oval;
			}
			if (unval) {
				if ((nval = fuword(unval)) == -1) {
					u.u_error = EFAULT;
					return (-1);
				}
				pp->p_ovfswtch = nval;
			}
			return (0);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

getperfflags(pid)
register int	pid;
{
register proc_t	*pp;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid))
		return (pp->p_perf_flags);
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid)
			return (pp->p_perf_flags);
	}
	u.u_error = ESRCH;
	return (-1);
}

setperfflags(pid,nval,unval)
register int	pid, nval, unval;
{
register proc_t	*pp;
register int	oval;

	pp = u.u_procp;
	if ((pid < 1) || (pp->p_pid == pid)) {
		oval = pp->p_perf_flags;
		if (!unval)
			return (oval);
		pp->p_perf_flags = nval;
		return (oval);
	}
	if (NO_SU_CHK !suser()) {
		u.u_error = EACCES;
		return (-1);
	}
	for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
		if (pp->p_stat == NULL)
			continue;
		if (pp->p_pid == pid) {
			oval = pp->p_perf_flags;
			if (!unval)
				return (oval);
			pp->p_perf_flags = nval;
			return (oval);
		}
	}
	u.u_error = ESRCH;
	return (-1);
}

perfinit()
{
	/*
	 *	Initialize perf global statistics counters.
	 */
	glob_quantum_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_quantum_size	= 0;	/* global quantum size		*/

	glob_slice_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_slice_clamp_cnt	= 0;	/* global usage count stat	*/
	glob_slice_clamp_ovfl	= 0;	/* overflow count for above	*/
	glob_slice_clamp	= 0;	/* global slice size clamp	*/

	glob_pri_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_pri_clamp_cnt	= 0;	/* global usage count stat	*/
	glob_pri_clamp_ovfl	= 0;	/* overflow count for above	*/
	glob_pri_clamp		= 0;	/* global pri clamp		*/

	glob_usrpri_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_usrpri_clamp_cnt	= 0;	/* global usage count stat	*/
	glob_usrpri_clamp_ovfl	= 0;	/* overflow count for above	*/
	glob_usrpri_clamp	= 0;	/* global usrpri clamp		*/

	glob_cpu_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_cpu_clamp_cnt	= 0;	/* global usage count stat	*/
	glob_cpu_clamp_ovfl	= 0;	/* overflow count for above	*/
	glob_cpu_clamp		= 0;	/* global cpu clamp		*/

	glob_pri_adj_copy_flag	= 0;	/* copy value from parent dir	*/
	glob_pri_adj		= 0;	/* global pri adj value		*/

	glob_perf_flags_copy_flag = 0;	/* copy value from parent dir	*/
}

perf_slice_clamp(pp)
register struct proc	*pp;
{
	if ((glob_slice_clamp > 0) && (glob_slice_clamp < pp->p_slice_clamp)) {
		if (pp->p_lticks > glob_slice_clamp) {
			glob_slice_clamp_cnt++;
			if (glob_slice_clamp_cnt == 0)
				glob_slice_clamp_ovfl++;
			pp->p_slice_cnt++;
			if (pp->p_slice_cnt == 0)
				pp->p_slice_ovfl++;
			pp->p_lticks = (int) glob_slice_clamp;
		}
	} else	{
		if ((pp->p_slice_clamp > 0) &&
				(pp->p_lticks > pp->p_slice_clamp)) {
			glob_slice_clamp_cnt++;
			if (glob_slice_clamp_cnt == 0)
				glob_slice_clamp_ovfl++;
			pp->p_slice_cnt++;
			if (pp->p_slice_cnt == 0)
				pp->p_slice_ovfl++;
			pp->p_lticks = (int) pp->p_slice_clamp;
		}
	}
}

perf_pri_clamp(pp)
register struct proc	*pp;
{
	if ((glob_pri_clamp > 0) && (glob_pri_clamp < pp->p_pri_clamp)) {
		if (pp->p_pri > glob_pri_clamp) {
			glob_pri_clamp_cnt++;
			if (glob_pri_clamp_cnt == 0)
				glob_pri_clamp_ovfl++;
			pp->p_pri_cnt++;
			if (pp->p_pri_cnt == 0)
				pp->p_pri_ovfl++;
			pp->p_pri = (uchar) glob_pri_clamp;
		}
	} else	{
		if ((pp->p_pri_clamp > 0) && (pp->p_pri > pp->p_pri_clamp)) {
			glob_pri_clamp_cnt++;
			if (glob_pri_clamp_cnt == 0)
				glob_pri_clamp_ovfl++;
			pp->p_pri_cnt++;
			if (pp->p_pri_cnt == 0)
				pp->p_pri_ovfl++;
			pp->p_pri = (uchar) pp->p_pri_clamp;
		}
	}
}

uchar
perf_priarg_clamp(pp,pri)
register struct proc	*pp;
uchar			pri;
{
	if ((glob_pri_clamp > 0) && (glob_pri_clamp < pp->p_pri_clamp)) {
		if (pri > glob_pri_clamp) {
			glob_pri_clamp_cnt++;
			if (glob_pri_clamp_cnt == 0)
				glob_pri_clamp_ovfl++;
			pp->p_pri_cnt++;
			if (pp->p_pri_cnt == 0)
				pp->p_pri_ovfl++;
			return ((uchar) glob_pri_clamp);
		}
	} else	{
		if ((pp->p_pri_clamp > 0) && (pri > pp->p_pri_clamp)) {
			glob_pri_clamp_cnt++;
			if (glob_pri_clamp_cnt == 0)
				glob_pri_clamp_ovfl++;
			pp->p_pri_cnt++;
			if (pp->p_pri_cnt == 0)
				pp->p_pri_ovfl++;
			return ((uchar) pp->p_pri_clamp);
		}
	}
}

perf_usrpri_clamp(pp)
register struct proc	*pp;
{
	if ((glob_usrpri_clamp > 0) &&
			(glob_usrpri_clamp < pp->p_usrpri_clamp)) {
		if (pp->p_usrpri > glob_usrpri_clamp) {
			glob_usrpri_clamp_cnt++;
			if (glob_usrpri_clamp_cnt == 0)
				glob_usrpri_clamp_ovfl++;
			pp->p_usrpri_cnt++;
			if (pp->p_usrpri_cnt == 0)
				pp->p_usrpri_ovfl++;
			pp->p_usrpri = (uchar) glob_usrpri_clamp;
		}
	} else	{
		if ((pp->p_usrpri_clamp > 0) &&
				(pp->p_usrpri > pp->p_usrpri_clamp)) {
			glob_usrpri_clamp_cnt++;
			if (glob_usrpri_clamp_cnt == 0)
				glob_usrpri_clamp_ovfl++;
			pp->p_usrpri_cnt++;
			if (pp->p_usrpri_cnt == 0)
				pp->p_usrpri_ovfl++;
			pp->p_usrpri = (uchar) pp->p_usrpri_clamp;
		}
	}
}

perf_cpu_clamp(pp)
register struct	proc	*pp;
{
	if ((glob_cpu_clamp > 0) && (glob_cpu_clamp < pp->p_cpu_clamp)) {
		if (pp->p_cpu > glob_cpu_clamp) {
			glob_cpu_clamp_cnt++;
			if (glob_cpu_clamp_cnt == 0)
				glob_cpu_clamp_ovfl++;
			pp->p_cpu_cnt++;
			if (pp->p_cpu_cnt == 0)
				pp->p_cpu_ovfl++;
			pp->p_cpu = (uchar) glob_cpu_clamp;
		}
	} else	{
		if ((pp->p_cpu_clamp > 0) && (pp->p_cpu > pp->p_cpu_clamp)) {
			glob_cpu_clamp_cnt++;
			if (glob_cpu_clamp_cnt == 0)
				glob_cpu_clamp_ovfl++;
			pp->p_cpu_cnt++;
			if (pp->p_cpu_cnt == 0)
				pp->p_cpu_ovfl++;
			pp->p_cpu = (uchar) pp->p_cpu_clamp;
		}
	}
}
