/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ofile.c: version 25.2 created on 1/20/92 at 15:03:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ofile.c	25.2	1/20/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/param.h"
#include "sys/debug.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/var.h"
#include "sys/errno.h"
#include "sys/synch.h"
#include "sys/systm.h"
#include "sys/sysmacros.h"
#include "sys/ofile.h"

static int 		check_fd();
static ofile_chain_t	*alloc_chain();
static void		bump_ref_counts();
static void		free_ofile_chain();

static ulong		chains_in_use;
extern ofile_chain_t	*end;

struct file *
get_chained_ofile(fd)
int	fd;
{
	ofile_chain_t 		*chain_p = u.u_ofile_chain;

	ASSERT(fd >= NOFILES_IN_U);

	if (fd >= u.u_nofiles || fd < 0)
		return(NULL);

	fd -= NOFILES_IN_U;

	for (; fd >= NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		ASSERT(chain_p);
		chain_p = chain_p->link;
	}
	return(chain_p->fp[fd]);
}

struct file *
set_chained_ofile(fd, fp)
int		fd;
struct file	*fp;
{
	ofile_chain_t 		*chain_p = u.u_ofile_chain;

	ASSERT(fd >= NOFILES_IN_U);	/* only called from macro */
	ASSERT(fd < u.u_nofiles);	/* better be allocated */

	fd -= NOFILES_IN_U;

	for (; fd >= NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		ASSERT(chain_p);
		chain_p = chain_p->link;
	}
	return(chain_p->fp[fd] = fp);
}

uchar
get_chained_oflag(fd)
int	fd;
{
	ofile_chain_t 		*chain_p = u.u_ofile_chain;

	ASSERT(fd >= NOFILES_IN_U);

	if (fd >= u.u_nofiles || fd < 0)
		return(NULL);

	fd -= NOFILES_IN_U;

	for (; fd >= NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		ASSERT(chain_p);
		chain_p = chain_p->link;
	}
	return(chain_p->oflag[fd]);
}

uchar
set_chained_oflag(fd, val)
int	fd;
uchar	val;
{
	ofile_chain_t 		*chain_p = u.u_ofile_chain;

	ASSERT(fd >= NOFILES_IN_U);	/* only called from macro */
	ASSERT(fd < u.u_nofiles);	/* better be allocated */

	fd -= NOFILES_IN_U;

	for (; fd >= NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		ASSERT(chain_p);
		chain_p = chain_p->link;
	}
	return(chain_p->oflag[fd] = val);
}

int 
allocate_ofile(start_fd)
int	start_fd;
{
	int 		fd;
	int		chain_i;
	ofile_chain_t	**link_p;
			
	ASSERT(fd >= 0);

	for (fd = start_fd; fd < NOFILES_IN_U; fd++)
		if (u.u_fp[fd] == NULL)
			return(check_fd(fd));

	if (check_fd(start_fd) < 0)
		return(-1);

	link_p = &u.u_ofile_chain;

	for (fd = NOFILES_IN_U; check_fd(fd) == fd; fd += NOFILES_PER_CHAIN) {

		if (!*link_p && !(*link_p = alloc_chain()))
			return(-1);

		chain_i = start_fd > fd ? start_fd - fd : 0;

		for (; chain_i < NOFILES_PER_CHAIN; chain_i++)
			if ((*link_p)->fp[chain_i] == NULL)
				return(check_fd(fd + chain_i)); 

		link_p = &(*link_p)->link;
	}
	return(-1);
}

static int
check_fd(fd)
int fd;
{
	if (fd >= u.u_rlimit[RLIMIT_NOFILE].rlim_cur) {
		u.u_error = EMFILE;
		return(-1);
	}
	return(fd);
}

dup_ofiles(u_p)
user_t *u_p;
{
	ofile_chain_t	**link_p = &u_p->u_ofile_chain,
			*parent_chain_p,
			*chain_p;

	while (parent_chain_p = *link_p) {
		if (!(*link_p = alloc_chain())) {
			free_ofile_chain(u_p->u_ofile_chain);
			return(0);
		}
		bcopy(parent_chain_p, *link_p, CHAIN_SIZE);

		link_p = &(*link_p)->link;
	}

	bump_ref_counts(u_p->u_fp, NOFILES_IN_U);

	chain_p = u_p->u_ofile_chain;
	while (chain_p) {
		bump_ref_counts(chain_p->fp, NOFILES_PER_CHAIN);
		chain_p = chain_p->link;
	}
	return(1);
}

static void
bump_ref_counts(file_pp, num)
struct file	**file_pp;
int		num;
{
	spin_lock(&file_freelist_lock);

	while (num--) {
		if (*file_pp)
			(*file_pp)->f_count++;
		file_pp++;
	}

	spin_unlock(&file_freelist_lock);
}

static ofile_chain_t *
alloc_chain()
{
	ofile_chain_t	*chain_p;

	if (!(chain_p = (ofile_chain_t *)ptalloc(1, 0, NULL, 0))) {
		u.u_error = ENOMEM;
		return(NULL);
	}
	atom_inc(&chains_in_use);

	return(chain_p);
}

void
close_ofiles(free_chain_flag)
uint	free_chain_flag;
{
	ofile_chain_t	*chain_p;
	int		chain_i;
	int		fd;
	int		limit = min(NOFILES_IN_U, u.u_nofiles);

	for (fd = 0; fd < limit; fd++)
		if (u.u_fp[fd]) {
			closef(u.u_fp[fd]);
			u.u_fp[fd] = NULL;
			u.u_oflag[fd] = 0;
		}

	if (fd == u.u_nofiles)
		return;

	chain_p = u.u_ofile_chain;

	for (; fd < u.u_nofiles; fd += NOFILES_PER_CHAIN) {

		ASSERT(chain_p);

		limit = min(NOFILES_PER_CHAIN, u.u_nofiles - fd);

		for (chain_i = 0; chain_i < limit; chain_i++)
			if (chain_p->fp[chain_i])
				closef(chain_p->fp[chain_i]);
				
		chain_p = chain_p->link;
	}

	if (free_chain_flag)
		free_ofile_chain(u.u_ofile_chain);
}

static void
free_ofile_chain(chain_p)
ofile_chain_t *chain_p;
{
	ofile_chain_t *free_p;

	ASSERT(good_ofile_chain(chain_p));

	while (free_p = chain_p) {
		ASSERT(free_p >= end); 
		chain_p = chain_p->link;
		uptfree(free_p, 1);
		atom_dec(&chains_in_use);
	}
}

static
good_ofile_chain(chain_p)
ofile_chain_t *chain_p;
{
	while (chain_p) {
		if (chain_p < end) /* FIX THIS, HH - need better test */
			return(0);
		chain_p = chain_p->link;
	}
	return(1);
}
