/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) nosys2.c: version 25.1 created on 11/27/91 at 15:10:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)nosys2.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:nosys2.c	25.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/nami.h"
#include "sys/sysinfo.h"
#include "sys/fcntl.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/mount.h"
#include "sys/debug.h"
#include "sys/var.h"
#include "sys/conf.h"


/*
 * common code for read and write calls:
 * check permissions, set base, count, and offset,
 * and switch out to readi or writei code.
 */
nons5_rdwr(mode)
register mode;
{
	register struct file	*fp;
	register struct inode	*ip;
	register struct a {
		int	fdes;
		char	*cbuf;
		unsigned count;
	}			*uap;
	int			type;
	int			bcount;
	register uint		ulimit;

	uap = (struct a *)u.u_ap;
	fp = (struct file *)getf(uap->fdes);
	u.u_base = (caddr_t)uap->cbuf;
	ip = fp->f_inode;
	type = ip->i_ftype;

	u.u_count = uap->count;
	u.u_segflg = 0;
	u.u_fmode = fp->f_flag;
	if (type == IFREG || type == IFDIR) {
		plock(ip);
		if ((u.u_fmode&FAPPEND) && (mode == FWRITE))
			fp->f_offset = ip->i_size;

		/*	Make sure that the user can read all the way up
		**	to the ulimit value.
		*/

		ulimit = (uint)(u.u_limit << (SCTRSHFT-1)) - fp->f_offset;
		if (type == IFREG  &&  mode == FWRITE
		   && ulimit < uap->count  &&  ulimit > 0)
			uap->count = u.u_count = ulimit;

	} else if (type == IFIFO) {
		plock(ip);
		fp->f_offset = 0;
	}
	u.u_offset = fp->f_offset;
	if (mode == FREAD) {
		bcount = u.u_ior;
		FS_READI(ip);
	} else {
		bcount = u.u_iow;
		WRITEI(ip);
	}
	if (u.u_error) {
		if (type == IFREG || type == IFDIR || type == IFIFO)
			prele(ip);
		return;
	}
	if (type == IFREG) {
		/* If synchronous write, update inode now. */
		if ((u.u_fmode & FSYNC) && (mode == FWRITE)) {
			ip->i_flag |= ISYN;
			FS_IUPDAT(ip, &time, &time);
		}
		prele(ip);
	} else if (type == IFDIR || type == IFIFO)
		prele(ip);


	fp->f_offset += uap->count - u.u_count;
	u.u_rval1 = uap->count-u.u_count;
	u.u_ioch += (unsigned)u.u_rval1;
	if (mode == FREAD) {
		atom_add(&sysinfo.readch ,(unsigned)u.u_rval1);
		fp->f_inode->i_mntdev->m_bcount += u.u_ior - bcount;
	} else {
		atom_add(&sysinfo.writech, (unsigned)u.u_rval1);
		fp->f_inode->i_mntdev->m_bcount += u.u_iow - bcount;
	}
}
