/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) nfsiowait.c: version 25.1 created on 11/27/91 at 15:10:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)nfsiowait.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	System V NFS - Release 3.2/V3
 *
 *	Copyright 1986, 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 */

#ident	"@(#)uts/os:nfsiowait.c	25.1"

#ifndef lint
static char SysVr3NFSID[] = "@(#)nfsiowait.c	4.2 LAI System V NFS Release 3.2/V3	source";
#endif


/*
  001	08/18/88	slee
	Put all the standard kernel bio dependent codes here to support later
	standard kernel release, 
	incore(), biowait(), binvalfree(), notavail().
*/

/*
 * Interface code for the NFS device.
 */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/mount.h"
#ifdef u3b2
#include "sys/psw.h"
#include "sys/pcb.h"
#endif
#include "sys/signal.h"
#include "sys/fs/s5dir.h"
#include "sys/user.h"
#include "sys/nami.h"
#include "sys/conf.h"
#include "sys/fstyp.h"
#include "sys/errno.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/buf.h"
#if defined(u3b2) || defined(i386)
#include "sys/inline.h"
#include "sys/immu.h"
#endif
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/fs/s5macros.h"
#include "sys/mfs.h"

#include "sys/mfs.h"
#include "sys/utsname.h"		/* 001 */
#include "sys/fs/s5inode.h"
#include "sys/sysinfo.h"


extern struct buf bufhdrs[1];


/*
 * The following is a routine that should probably live bio.c.
 *
 * Its purpose is to wait on all the i/o hooked to a particular
 * dev_t to finish.  It is used in nfsiput() to make sure that
 * all the potentials users of an rnode have finished before
 * proceeding and from nfs_flush() to wait on all writes to
 * finish on this rnode before proceeding.  The 'wait' flag is
 * used to indicate whether or not to wait on all buffers or
 * just the buffers that are being written.
 */
biowait(dev, wait)
	dev_t dev;
	int wait;
{
	register struct buf *bp;
	register int i;

	dev = notminored(dev);
	for (i = v.v_buf, bp = bufhdrs; i; i--, bp++) {
		if (bp->b_dev == dev &&
		    (wait || (bp->b_flags & B_READ) == B_WRITE)) {
			atom_inc(&syswait.iowait);
			spin_lock(&bio_lock);
			while ((bp->b_flags & B_DONE) == 0) {
				bp->b_want_flag = B_WANTED;
				mfs_sleep(bp,PRIBIO+1,&bio_lock);
			}
			spin_unlock(&bio_lock);
			atom_dec(&syswait.iowait);
		}
	}
}
