/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) nfsifind.c: version 25.1 created on 11/27/91 at 15:10:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)nfsifind.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	System V NFS - Release 3.2/V3
 *
 *	Copyright 1986, 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 */

#ident	"@(#)uts/os:nfsifind.c	23.1"

#ifndef lint
static char SysVr3NFSID[] = "@(#)nfsifind.c	4.2 LAI System V NFS Release 3.2/V3	source";
#endif


/*
  001	08/18/88	slee
	Put all the standard kernel bio dependent codes here to support later
	standard kernel release, 
	incore(), biowait(), binvalfree(), notavail().
*/

/*
 * Interface code for the NFS device.
 */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/mount.h"
#ifdef u3b2
#include "sys/psw.h"
#include "sys/pcb.h"
#endif
#include "sys/signal.h"
#include "sys/fs/s5dir.h"
#include "sys/user.h"
#include "sys/nami.h"
#include "sys/conf.h"
#include "sys/fstyp.h"
#include "sys/errno.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/buf.h"
#if defined(u3b2) || defined(i386)
#include "sys/inline.h"
#include "sys/immu.h"
#endif
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/fs/s5macros.h"
#include "sys/mfs.h"

#include "sys/sysinfo.h"
#include "sys/mfs.h"
#include "sys/utsname.h"		/* 001 */
#include "sys/fs/s5inode.h"


extern struct buf bufhdrs[1];



/*
 * The code following is a copy of iget() that does not cross mount points.
 */

extern struct ifreelist ifreelist;

/*
 * Look up an inode by mount point (device) and inumber.
 * If it is in core (in the inode structure), honor the locking
 * protocol.
 * If it is not in core, read it in from the specified device.
 * In all cases, a pointer to a locked inode structure is returned.
 *
 * printf warning: inode table overflow -- if the inode structure is
 *					   full.
#ifdef i386
 * panic: no imt -- if the mounted filesystem is not in the mount table.
 *	"cannot happen"
#endif
 */

#ifndef DEBUG
struct inode *
ifind(mp, ino)
	register struct mount *mp;
	register ino;
#else
struct inode *
ifind(mp, ino, caller)
	register struct mount *mp;
	register ino;
	int *caller;
#endif
{
	register struct inode *ip;
	register struct hinode *hip;
	register short fstyp;
	register struct inode *tip;

	atom_inc(&sysinfo.iget);
	fstyp = mp->m_fstyp;
	hip = ihash(ino);
loop:
	spin_lock(&inode_sem);
	for (ip = hip->i_forw; ip != (struct inode *)hip; ip = ip->i_forw)
		if (ino == ip->i_number && mp == ip->i_mntdev) {
			goto found;
		}

	ip = ifreelist.av_forw;
	while ((ip != (struct inode *)&ifreelist)) {
		/*
		 * If inode locked, assume it has been found in the cache
		 * by another process, so march on, march on...
		 */
		if (!inode_locked(ip)) {
			break;
		}
		ip = ip->av_forw;
	}
	if (ip == (struct inode *)&ifreelist) {
		spin_unlock(&inode_sem);
		cmn_err(CE_WARN, "ifind - inode table overflow");
		if (fsinfo[fstyp].fs_notify & NO_IGET) {
			struct argnotify noarg;

			noarg.cmd = NO_IGET;
			noarg.data1 = (long)mp;
			noarg.data2 = (long)ino;
			(void)(*fstypsw[fstyp].fs_notify)((struct inode *)0,
							  &noarg);
		}
		atom_inc(&syserr.inodeovf);
		u.u_error = ENFILE;
		return(NULL);
	}

	ASSERT(ip == ip->av_back->av_forw);
	ASSERT(ip == ip->av_forw->av_back);
	ip->av_back->av_forw = ip->av_forw;	/* remove from free list */
	ip->av_forw->av_back = ip->av_back;

	/* Remove from old hash list. */

	ip->i_back->i_forw = ip->i_forw;
	ip->i_forw->i_back = ip->i_back;
	ip->i_inode_lock = INODE_LOCK_VAL;
/*
	ASSERT(addilock(ip) == 0);
*/
	ASSERT(ip->i_count == 0);

	/*
	 * If a block number list was allocated for this file
	 * (because it is a 413), then free the space now since
	 * we are going to reuse this table slot for a different
	 * inode.  See the code in mmgt/region.c/mapreg.
	 * Also, dispose of the left-over data structures associated with
	 * an old inode whose slot we are about to re-use.  If FS_NOICACHE
	 * is set for this fstyp then old inodes don't remain in
	 * the cache and this disposal is taken care of at the time of
	 * last reference to the inode in iput().  We also assume that
	 * this disposal need not be done at all unless a new fstyp
	 * is being assigned to the inode.
	 */

	if (ip->i_fstyp) {
		long flags;

		spin_unlock(&inode_sem);
		FS_FREEMAP(ip);
		spin_lock(&inode_sem);
		flags = fsinfo[ip->i_fstyp].fs_flags;
		if ((flags & FS_NOICACHE) == 0
		  && (ip->i_fstyp != fstyp || (flags & FS_RECYCLE))) {
			spin_unlock(&inode_sem);
			IPUT(ip);
			spin_lock(&inode_sem);
		}
	}

	hip->i_forw->i_back = ip;	/* insert into new hash list */
	ip->i_forw = hip->i_forw;
	hip->i_forw = ip;
	ip->i_back = (struct inode *)hip;

	ip->i_mntdev = mp;
	ip->i_mnton = NULL;
	ip->i_dev = mp->m_dev;
	ip->i_fstyp = fstyp;
	ip->i_rcvd = NULL;
	ip->i_vcode = ++rfs_vcode;
	ip->i_wcnt = 0;
	ip->i_number = ino;
	ip->i_count = 1;
	spin_unlock(&inode_sem);
#ifdef FSPTR
	ip->i_fstypp = &fstypsw[fstyp];
#endif
#ifdef DEBUG
	ilog(ip, 0, caller);
#endif
	tip = FS_IREAD(ip);
	/*
	 * fs_iread returns NULL to indicate an error.
	 * If NULL is returned, no fs dependent inode has been
	 * assigned to the fs independent inode.
	 * In this case the newly allocated fs independent
	 * inode should be deallocated, that is, returned to the
	 * free list and taken off the hash list. If it stayed
	 * on the hash list it could be "found" and its use would
	 * cause a panic because it has no fs specific portion.
	 */
	if (tip == NULL) {
		spin_lock(&inode_sem);
		ip->i_back->i_forw = ip->i_forw; /* remove from hash list */
		ip->i_forw->i_back = ip->i_back;
		ip->i_forw = ip->i_back = ip;
		ifreelist.av_back->av_forw = ip;
		ip->av_forw = (struct inode *)&ifreelist;
		ip->av_back = ifreelist.av_back;
		ifreelist.av_back = ip;
		ip->i_fsptr = NULL;
		ip->i_count = 0;
		ip->i_fstyp = 0;
		inode_unlock(ip);
		spin_unlock(&inode_sem);
#ifdef DEBUG
		/*
		 * Use inline code (temporarily) here instead of a call to
		 * prele() to allow use of an otherwise-bogus assertion in
		 * prele().
		 */
		inode_unlock(ip);
		if (ip->i_flag & IWANT) { /* IWANT isn't in i_flag anymore!!! */
			ip->i_flag &= ~IWANT;
			wakeup((caddr_t)ip);
		}
		ASSERT(rmilock(ip) == 0);
#else
		prele(ip);
#endif
	}
	return(tip);
found:
	if (inode_locked(ip)) {
		inode_want(ip);
		mfs_sleep(ip, PINOD, &inode_sem);
		spin_unlock(&inode_sem);
		goto loop;
	}

	if (ip->i_count == 0) {
		/* remove from freelist */
		ASSERT(ip->av_back->av_forw == ip);
		ASSERT(ip->av_forw->av_back == ip);

		ip->av_back->av_forw = ip->av_forw;
		ip->av_forw->av_back = ip->av_back;
	}
	ip->i_count++;
	inode_lock(ip);
	spin_unlock(&inode_sem);
/*
	ASSERT(addilock(ip) == 0);
*/
#ifdef DEBUG
	ilog(ip, 1, caller);
#endif
	return(ip);
}
