/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) nami.c: version 25.1 created on 11/27/91 at 15:10:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)nami.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-port:os/nami.c	10.10.2.2"

#include "sys/types.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/sysmacros.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/mount.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/conf.h"
#include "sys/own.h"

#define PATHSIZE	255
#define MAXRESTARTS	32	/* the maximum number of times that we will */
				/* restart a parse due to a symbolic link */
#define	NAME_MAX	14	/* posix. Max length of a pathname component */

#define SYMLINK_RELATIVE	0
#define SYMLINK_ABSOLUTE	1

long nmfail;	/* total number of times that namei encountered excessively */
		/* long pathnames (exceeded PATHSIZE) */

/*
 * Convert a pathname into a pointer to
 * a locked inode.
 *
 * func = function called to get the pathname
 *	&upath if name is in user space
 *	&spath if name is in system space
 * flagp
 *	0 for ordinary searches, following all symbolic links
 *	else ->flag structure with more parameters
 */
struct inode *namei_common();

/*
 * namei - follow terminal symbolic links
 */
struct inode *
namei(func, flagp)
int (*func)();
register struct argnamei *flagp;
{
	return(namei_common(func, flagp, 1));
}

/*
 * lnamei - lookup only (hence no flagp) - do not follow terminal symbolic links
 */
struct inode *
lnamei(func)
int (*func)();
{
	return(namei_common(func, 0, 0));
}

static struct inode *
namei_common(func, flagp, symlink_follow)
int (*func)();
register struct argnamei *flagp;
uint symlink_follow;
{
	register struct inode *dp = NULL;
	register caddr_t bufp; /* pointer to beginning of buffer */
	register caddr_t comp; /* pointer to the beginning of component */
	register caddr_t cp; /* stepping pointer */
	register i;
	struct nx p;
	struct argnamei *tmpflagp;
	struct inode *rem_dp;
	struct mount *mp;
	char stkbuf[PATHSIZE+1];
	extern short dufstyp;
	int 		symlink_count = 0;
	long 		parent_ino;
	struct mount	*parent_mp;

	atom_inc(&sysinfo.namei);

	cp = stkbuf;

	bufp = cp;

	/* Read in entire pathname.  The functions will return */
	/* the length of the pathname if it was read correctly. */
	/* Otherwise, the following values will be returned:
	/* 	-1	if the user supplied address was not valid */
	/*	-2	if the pathname length was > PATHSIZE
	/*	0	if a null pathname was supplied. This is */
	/*		  normally an error since null pathnames */
	/*		  are not supported (however, they turn up */
	/*		  in Distributed Unix pathname searches: see */
	/*		  comment below) */
	switch (i = (*func)(u.u_dirp, bufp, PATHSIZE+1)) {
	case -2:	/* pathname too long */
		nmfail++;
		if ( IS_POSIX() )
			u.u_error = ENAMETOOLONG;
		else
			u.u_error = ENOENT;
		goto out;
	case 0:		/* null pathname */
		if (!server()) {
			u.u_error = ENOENT;
			goto out;
		}
		break;
	case -1:	/* bad user address */
		u.u_error = EFAULT;
		goto out;
	default:
		if (server())
			rnamei0();
	}

restart:

	if (*bufp == '\0' && !server()) {
		u.u_error = ENOENT;
		goto out;
	}

	cp = u.u_nextcp = bufp;

	if (*cp == '/') {
		if (u.u_rdir && (u.u_rdir->i_fstyp == dufstyp)) {
			rem_dp = dp;	/* so can use address of (&) on it */
			switch (rnamei1(u.u_rdir, &rem_dp)) {
			case 1:  /* done */
				dp = rem_dp;
				goto pout;
			case 0:  /* more */
				dp = rem_dp;
				cp = u.u_nextcp;
				goto dirloop;
			case -1: /* real error */
			default:
				dp = NULL;
				goto out;
			}
		} else {
			while (*cp == '/')
				cp++;
			if (*cp == '\0' && flagp) {
				switch (flagp->cmd) {
				case NI_CREAT:
					u.u_error = EISDIR;
					break;
				case NI_RMDIR:
				case NI_DEL:
					u.u_error = EBUSY;
					break;
				default: /* LINK, MKNOD, RNM_?? */
					u.u_error = EEXIST;
					break;
				}
				goto out;
			}
			if ((dp = u.u_rdir) == NULL)
				dp = rootdir;
		}
	} else {
		if (u.u_cdir && (u.u_cdir->i_fstyp == dufstyp)) {
			rem_dp = dp;
			switch (rnamei1(u.u_cdir, &rem_dp)) {
			case 1:
				dp = rem_dp;
				goto pout;
			case 0:
				dp = rem_dp;
				cp = u.u_nextcp;
				goto dirloop;
			case -1: 
			default:
				dp = NULL;
				goto out;
			}
		} else
			dp = u.u_cdir;
	}

	/* lock the node and bump the count. */
	plock(dp);
	dp->i_count++;

dirloop:
	ASSERT(inode_locked(dp));
	if (dp->i_ftype != IFDIR || dp->i_nlink == 0) {
		iput(dp);
		u.u_error = ENOTDIR;
		goto out;
	}
	if (FS_ACCESS(dp, ICDEXEC)) {
		iput(dp);
		goto out;
	}
	/* check for rename system call */
	if ( flagp && flagp->cmd == NI_RNM_NEW_CHK) 
		if (flagp->idev == dp->i_dev && 
				flagp->ino == dp->i_number)  {
			iput(dp);
			u.u_error = EINVAL;
			goto out;
		}

	/*
	 * Handle the pathname "/" as well as null pathnames.
	 * The latter can occur in Distributed Unix pathname
	 * searches which go remote and end up back on the local
	 * machine having processed all the components of the name;
	 * they can also occur in server processes which have been
	 * handed the (null) tail end of a pathname which started
	 * on a client machine.  A null component should be interpreted
	 * as a synonym for the directory which is "current" at this
	 * point in the processing.  Note that the non-remote case of a
	 * null pathname is handled at the beginning of namei, and
	 * rejected.
	 */

	if (*cp == '\0' && flagp == 0)	/* Works for "/" as well as for DU */
		goto out;
	comp = cp;
	u.u_comp = cp;

	/* skip over component to next '/' or '\0' */
	if(IS_POSIX())  {
		for (i=0; *cp != '/' && *cp != '\0'; i++) 
			cp++;
		if( i > NAME_MAX) {
			iput(dp);
			u.u_error = ENAMETOOLONG;
			return(NULL);
		}
	}
	else  {
		while (*cp != '/' && *cp != '\0') 
			cp++;
	}

	/* If we are still in the middle of a pathname, terminate */
	/* the component name with '\0' and specify that a lookup */
	/* request be sent to the fs dependent namei. */
	/* If the end of the pathname has been encountered, pass the */
	/* requested action (flagp) to the fs dependent namei and set */
	/* a flag indicating that the last component has been */
	/* encountered */
	if (*cp == '/') {
		*cp++ = '\0';
		while (*cp == '/')
			cp++;
	} 
	if (*cp == '\0')  {
		tmpflagp = flagp;
		/*
		 * FIX THIS, HH - this next line is to ensure that
		 * u.u_nextcp[0] is NULL if we are at the end of the pathname.
		 */
		cp[1] = '\0';
	} else {
		ASSERT(*cp != '/');
		tmpflagp = (struct argnamei *)0;
	}
	u.u_nextcp = cp;
	/* If the component is . and if the operation is a lookup */
	/* we already have the info that we need, namely a pointer */
	/* to a locked inode for the current directory in the */
	/* pathname. There is no need to call the file system */
	/* dependent code. */
	if (*comp == '.' && *(comp+1) == '\0' && flagp == 0)
		goto dirloop;
nmount:
	/* 
	 * If tmpflag is not NULL, save mount point and ino of current dir
	 * in case FS_NAMEI hits a symbolic link, and it's a relative one.
	 */
	if (tmpflagp) {
		parent_mp = dp->i_mntdev;
		parent_ino = dp->i_number;
	}

	/* set values that are to be passed to the fs specific namei */
	p.comp = comp;
	p.bufp = bufp;
	p.dp = dp;
	p.flags = 0;

	mp = dp->i_mntdev;

	/*
	 * Check if server is doing a '..' at a REMOTEly mounted point
	 */
	if (server() && (dp->i_flag & IDOTDOT) &&
			(comp[0] == '.' && comp[1] == '.' && comp[2] == '\0')){
		if (u.u_rdir == dp) {
			if (*u.u_nextcp == '\0')
				goto out;
			else	
				goto dirloop;
		}
		else 
		if ( rnamei2(comp, dp, stkbuf) == 0){
			dp = NULL;
			goto out;
		}
	}
	ASSERT(dp->i_fstyp != 0 && dp->i_fstyp < nfstyp);
	switch (FS_NAMEI(dp, &p, tmpflagp)) {

	case NI_FAIL:	/* fs specific namei failed */
			/* All iputs should have been done */
			/* in the fs dependent namei */
		goto out;

	case NI_NULL:	/* Operation is complete and calling */
			/* function does not expect an ip returned. */
			/* All iputs should have been done */
			/* fs dependent namei */
		dp = NULL;
		goto out;

	case NI_DONE:	/* The fs dependent action specified by */
			/* flagp->cmd has successfully completed. */
			/* NI_PASS can not be returned since */
			/* the dependent routine may have unlocked */
			/* the inode pointed to by dp */
				
		dp = p.dp;
		goto out;

	case NI_PASS:	/* fs specific namei passed */
		/*
		 * Special handling for ".."
		 */
		if (*comp == '.' && *(comp+1) == '.' && *(comp+2) == '\0') {
			if (dp == u.u_rdir)
				p.ino = dp->i_number;
			else if ((p.flags&NX_ISROOT) && (dp->i_flag&IISROOT)
			  && mp != &mount[0]) {
				iput(dp);
				comp = u.u_comp; /* May have changed */
				dp = mp->m_inodp;
				plock(dp);
				dp->i_count++;
				goto nmount;
			}
		}
		ASSERT(*cp != '/');

		if (flagp && (flagp->cmd != NI_RNM_NEW_CHK) &&
		   (flagp->cmd != NI_RNM_OLD_CHK) && *u.u_nextcp == '\0') {
			dp = p.dp;
			goto out;
		}

		parent_mp = dp->i_mntdev;
		parent_ino = dp->i_number;

		iput(dp);
		if ((dp = iget(mp, p.ino)) == NULL)
			goto out;

		/* 
		 * FS_NAMEI() encountered a symbolic link while doing an
		 * iget during an NI_CREAT.  We are still in NI_PASS.
		 */

		p.dp = dp;
	case NI_SYMFOUND:
		dp = p.dp;
			
		/* 
		 * For symbolic links, do pathname replacement if 
		 * a) there is more path to process, OR
		 * b) we care about the target, not the link itself (usually).
		 */

		if (dp->i_ftype == IFLNK && (*u.u_nextcp || symlink_follow)) {
			if (symlink_count++ == MAXSYMLINKS) {
				iput(dp);
				u.u_error = ELOOP;
				goto out;
			}
			switch (get_symlink(&p)) {
			case SYMLINK_ABSOLUTE:
				goto restart;
			case SYMLINK_RELATIVE:
				if ((dp = iget(parent_mp, parent_ino)) == NULL)
					goto out;
				cp = p.comp;
				goto dirloop;
			}
		}

		/* if this is the last component - leave */
		/* after putting the name into u.u_dent.d_name */
		/* so that ps can work.. */
pout:		if (*u.u_nextcp == '\0') {
			cp = u.u_dent.d_name;
			comp = u.u_comp;		/*may have changed*/
			i = 0;
			while (*comp && i++ < PSCOMSIZ)
				*cp++ = *comp++;
			if (i <= PSCOMSIZ - 1)
				*cp ='\0';
			goto out;
		}
		cp = u.u_nextcp;
		goto dirloop;

	default:
		cmn_err(CE_CONT, "namei: Invalid fs dependent namei return");
		u.u_error = ENOENT;
	}
out:
	if (u.u_error)
		return(NULL);
	return(dp);
}

get_symlink(nxp)
struct nx *nxp;
{
	char	target_path[PATH_MAX + 1];
	int	target_path_length;

	u.u_count = PATH_MAX;
	u.u_base = target_path;
	u.u_offset = 0;
	u.u_segflg = 1;

	FS_READI(nxp->dp);

	iput(nxp->dp);

	target_path[PATH_MAX - u.u_count] = '\0';

	return(replace_comp(target_path, nxp));
}

replace_comp(linkpath, nxp)
char 		*linkpath;
struct nx 	*nxp;
{
	char	tmp_path[PATH_MAX];
	int	retval;
	char 	*path = nxp->comp;

	ASSERT(u.u_nextcp > nxp->bufp);

	/*
	 * set path to beginning of next component, add slash if more path
	 */
	path = u.u_nextcp;

	if (*path != '\0')
		*--path = '/';

	if (linkpath[0] == '/') {
		nxp->comp = nxp->bufp;
		retval = SYMLINK_ABSOLUTE;
	}
	else
		retval = SYMLINK_RELATIVE;

	if (nxp->comp - nxp->bufp + strlen(linkpath) + strlen(path) + 1 > 
			PATH_MAX) {
		u.u_error = IS_POSIX() ? ENAMETOOLONG : ENOENT;
		return(-1);
	}

	strcpy(tmp_path, path);
	strcpy(nxp->comp, linkpath);
	strcpy(&(nxp->comp[strlen(nxp->comp)]), tmp_path);

	return(retval);
}
