/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) move.c: version 25.1 created on 11/27/91 at 15:10:15	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)move.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:move.c	25.1"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/inode.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/file.h"
#include "sys/systm.h"
#include "sys/debug.h"

iomove(src, count, flag)
{
	if (flag == B_READ)
		iomove_read(src, count);
	else
		iomove_write(src, count);
}

iomove_read(src, count)
caddr_t src;
register count;
{
	if ( count == 0 )
		return;

	if ( u.u_segflg != 1 )  {

		if ( copyout(src, u.u_base, count) ) {
			u.u_error = EFAULT;
			return;
		}
	}
	else
		bcopy(src, u.u_base, count);

	u.u_base += count;
	u.u_offset += count;
	u.u_count -= count;
}



iomove_write(src, count)
caddr_t src;
register count;
{
	if ( count == 0 )
		return;

	if ( u.u_segflg != 1 )  {

		if ( copyin(u.u_base, src, count) ) {
			u.u_error = EFAULT;
			return;
		}
	}
	else
		bcopy(u.u_base, src, count);

	u.u_base += count;
	u.u_offset += count;
	u.u_count -= count;
}

/*
 * Pass back  c  to the user at his location u_base;
 * update u_base, u_count, and u_offset.  Return -1
 * on the last character of the user's read.
 * u_base is in the user data space.
 */
passc(c)
int c;
{
	if (subyte(u.u_base, c) < 0) {
		u.u_error = EFAULT;
		return(-1);
	}
	u.u_count--;
	u.u_offset++;
	u.u_base++;
	return(u.u_count == 0? -1: 0);
}

/*
 * Pick up and return the next character from the user's
 * write call at location u_base;
 * update u_base, u_count, and u_offset.  Return -1
 * when u_count is exhausted.
 * u_base is in the user data space.
 */
cpass()
{
	int c;

	if (u.u_count == 0)
		return(-1);
	if ((c = fubyte(u.u_base)) < 0) {
		u.u_error = EFAULT;
		return(-1);
	}
	u.u_count--;
	u.u_offset++;
	u.u_base++;
	return(c);
}

/*	copy 8 or fewer characters from string *b to string *a	*/
/*	terminated by null character	*/
/*	string *a must be at least 9 characters long	*/
/*	used by main.c	*/
str8cpy(a, b)
register char	*a, *b;
{
	register int	i = 0;

	while (*a++ = *b++)
		if (++i >= 8)
			break;
	*a = '\0';
}

/*
 * Copy s2 to s1, truncating or null-padding to always copy n bytes
 * return s1
 */

char *
strncpy(s1, s2, n)
register char *s1, *s2;
register n;
{
	register char *os1 = s1;

	n++;				
	while ((--n > 0) &&  ((*s1++ = *s2++) != '\0'))
		;
	if (n > 0)
		while (--n > 0)
			*s1++ = '\0';
	return (os1);
}


strcmp(s1, s2)
register char *s1, *s2;
{

	if (s1 == s2)
		return(0);
	while (*s1 == *s2++)
		if (*s1++ == '\0')
			return(0);
	return(*s1 - *--s2);
}

/*
# Compare strings (at most n bytes): return *s1-*s2 for the last
# characters in s1 and s2 which were compared.
*/

strncmp(s1, s2, n)
register char *s1, *s2;
register n;
{
	if (s1 == s2)
		return(0);
	while (--n >= 0 && *s1 == *s2++)
		if (*s1++ == '\0')
			return(0);
	return((n < 0)? 0: *s1 - *--s2);
}

/*
# Given string s, return length (not including the terminating null).
*/

strlen(s)
register char *s;
{
	register n;

	n = 0;
	while (*s++)
		n++;
	return(n);
}

/*
# Copy string s2 to s1.  s1 must be large enough. Return s1.
*/

char *
strcpy(s1, s2)
register char *s1, *s2;
{
	register char *os1;

	os1 = s1;
	while (*s1++ = *s2++)
		;
	return(os1);
}
