/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) main.c: version 25.1 created on 11/27/91 at 15:10:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/mount.h"
#include "sys/inode.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/cmn_err.h"
#include "sys/tty.h"

int	maxmem;		/* Maximum available memory in clicks.	*/
int	freemem;	/* Current available memory in clicks.	*/


extern int	icode[];
extern int	szicode;

/*
 *	Initialization code.
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *
 *	loop at low address in user mode -- /etc/init
 *	cannot be executed.
 */

main()
{
	register int	(**initptr)();
	extern int	(*io_init[])();
	extern int	(*init_tbl[])();
	extern int	(*io_start[])();
	extern int	sched();
	extern int	vhand();
	extern int	bdflush();
	extern int	s54kbdflush();
	preg_t		*do_init_reg();

	upkern_lock();
	startup();
	clkstart();
	schedinit();	/* start scheduler load averaging */


	/*	Call all system initialization functions.
	*/

 	for (initptr= &io_init[0]; *initptr; initptr++) (**initptr)();
	for (initptr= &init_tbl[0]; *initptr; initptr++) (**initptr)();
	for (initptr= &io_start[0]; *initptr; initptr++) (**initptr)();

	cmn_err(CE_CONT, "\nTotal real memory  = %d\n", ctob(physmem));
	cmn_err(CE_CONT,
		"Available memory   = %d\n\n", ctob(freemem));
	/* print the security signon messages */
  	macs_som();
	priv_som();
	sat_som();
	if (v.v_s5inode < v.v_inode)  {
		v.v_inode = v.v_s5inode;
		printf(
		"WARNING! number of s5inodes should be equal to the number\n");
		printf("of inodes. number of inodes set to %d\n",v.v_s5inode);
	}


	prt_where = PRW_CONS;

	u.u_start = time;

	/*	This call of swapadd must come after devinit in case
	 *	swap is moved by devinit.  It must also come after
	 *	dskinit so that the disk is don'ed.  This call should
	 *	return 0 since the first slot of swaptab should be used.
	 */

	if (swapdev != NODEV && swapadd(swapdev, 0, 0) != 0)
		cmn_err(CE_PANIC, "main - swapadd(0x%x, 0, 0) failed", swapdev);


	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if (newproc(0)) {
		register preg_t	*prp;

		u.u_cstime = u.u_stime = u.u_cutime = u.u_utime = 0;
		/*	Set up the text region to do an exec
		**	of /etc/init.  The "icode" is in misc.s.
		*/

		prp = do_init_reg((caddr_t)0, PT_TEXT, btoc(szicode));

		if (copyout((caddr_t)icode, (caddr_t)(0), szicode))
			cmn_err(CE_PANIC, "main - copyout of icode failed");

		chgprot(prp, SEG_TEXT);

		/*	Allocate a stack region and grow it to
		 *	SSIZE pages.
		 */

		prp = do_init_reg(USERSTACK_END, PT_STACK, SSIZE);
		u.u_sub = (int)((uint)userstack - ctob(SSIZE));
		return(0);
	}

	if (newproc(0)) {
		u.u_procp->p_flag |= SLOAD|SSYS;
		u.u_cstime = u.u_stime = u.u_cutime = u.u_utime = 0;
		strcpy(u.u_psargs, "vhand");
		strcpy(u.u_comm, u.u_psargs);
		return((int)vhand);
	}

	if (newproc(0)) {
		u.u_procp->p_flag |= SLOAD|SSYS;
		u.u_cstime = u.u_stime = u.u_cutime = u.u_utime = 0;
		strcpy(u.u_psargs, "bdflush");
		strcpy(u.u_comm, u.u_psargs);
		return((int)bdflush);
	}

	if (newproc(0)) {
		u.u_procp->p_flag |= SLOAD|SSYS;
		u.u_cstime = u.u_stime = u.u_cutime = u.u_utime = 0;
		strcpy(u.u_psargs, "s54kbdflush");
		strcpy(u.u_comm, u.u_psargs);
		return((int)s54kbdflush);
	}
	strcpy(u.u_psargs, "swapper");
	strcpy(u.u_comm, u.u_psargs);
	return((int)sched);
}

/*
 * allocates, attaches, and grows a region for proto-init
 */

preg_t *
do_init_reg(vaddr, preg_type, npgs)
caddr_t	vaddr;
int	preg_type, npgs;
{
	register reg_t	*rp;
	register preg_t	*prp;
	int		ret;

	rp = allocreg(NULL, RT_PRIVATE);
	ASSERT(rp);
	prp = attachreg(rp, &u, vaddr, preg_type, SEG_RW);
	ASSERT(prp);
	ret = growreg(prp, npgs, DBD_DFILL);
	ASSERT(ret > 0);
	regrele(rp);

	return (prp);
}

/*
 * Initialize clist by freeing all character blocks.
 */
struct chead cfreelist;
cinit()
{
	register n;
	register struct cblock *cp;

	for(n = 0, cp = &cfree[0]; n < v.v_clist; n++, cp++) {
		cp->c_next = cfreelist.c_next;
		cfreelist.c_next = cp;
	}
	cfreelist.c_size = CLSIZE;
}
