/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) locking.c: version 25.1 created on 11/27/91 at 15:10:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)locking.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)uts/os:locking.c	23.1"

#include "sys/types.h"
#include "sys/errno.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/var.h"
#include "sys/locking.h"
#include "sys/mfs.h"

#define MAXSIZE (long)(1L<<30)	/* number larger than any request */
/*
 * locking -- handles syscall requests
 */

locking() {
	register struct file *fp;
	/*
	 * define order and type of syscall args
	 */
	register struct a {
		int	fdes;
		int	flag;
		off_t	size;
		} *uap = (struct a *)u.u_ap;
	register struct locklist *cl, *nl;
	struct inode *ip;
	int foo;
	register	LB, UB;

	/*
	 * check for valid open file
	 */

	fp = (struct file *)getf(uap->fdes);
	if(fp == NULL) return;

	spin_lock(&inode_sem);
	ip = fp->f_inode;
	while (inode_locked(ip)) {
		inode_want(ip);
		mfs_sleep(ip, PINOD, &inode_sem);
	}
	inode_lock(ip);
	spin_unlock(&inode_sem);

	if ((ip->i_flag&IFMT) == IFDIR) {
		u.u_error = EACCES;
		goto exit_locking;
	}


	if ( (! (fp->f_flag & FWRITE)) && (uap->flag != LOCKTEST)) {
		u.u_error = EACCES;
		goto exit_locking;
	}

	if ( ( ip->i_uid == 0 ) && ( u.u_uid != 0) ) {
		u.u_error = EACCES;
		goto exit_locking;
	}

	/*
	 * validate ranges
	 * kludge for zero and negative length
	 */
	LB = fp->f_offset;
	if( uap->size >= 0 ) {
		UB = LB + uap->size;
		if(UB <= LB) UB = MAXSIZE;
	}
		else UB = MAXSIZE;

	switch (uap->flag) {

	case	UNLOCK:

		/*
		 * starting at list head scan
		 * for locks in the range by
		 * this process
		 */
		cl = (struct locklist *)(int)&ip->i_locklist;
		while(nl = cl->ll_link) {
			/*
			 * if not by this process skip to next lock
			 */
			if(nl->ll_proc != u.u_procp) {
				cl = nl;
				continue;
			}
			/*
			 * check for locks in proper range
			 */
			if( UB <= nl->ll_start )
				break;
			if( nl->ll_end <= LB ) {
				cl = nl;
				continue;
			}
			/*
			 * for locks fully contained within
			 * requested range, just delete the item
			 */
			if( LB <= nl->ll_start && nl->ll_end <= UB) {
				cl->ll_link = nl->ll_link;
				lockfree(nl);
				continue;
			}
			/*
			 * if some one is sleeping on this lock
			 * do a wakeup, we may free the region
			 * being slept on
			 */
			spin_lock(&file_locking_sem);
			if(nl->ll_flags & IWANT) {
				nl->ll_flags &= ~IWANT;
				mfs_wakeup_all(nl);
			}
			spin_unlock(&file_locking_sem);
			/*
			 * middle section is being removed
			 * add new lock for last section
			 * modify existing lock for first section.
			 * if no locks, return in error
			 */
			if( nl->ll_start < LB && UB < nl->ll_end) {
				if( lockadd(nl,UB,nl->ll_end) )
					goto exit_locking;
				nl->ll_end = LB;
				break;
			}
			/*
			 * first section is being deleted
			 * just move starting point up
			 */
			if( LB <= nl->ll_start && UB < nl->ll_end) {
				nl->ll_start = UB;
				break;
			}
			/*
			 * must be deleting last part of this section
			 * move ending point down
			 * continue looking for locks covered by upper
			 * limit of unlock range
			 */
			nl->ll_end = LB;
			cl = nl;
		}

		goto exit_locking;

	case	LOCKTEST:
		
		/* test for other processes lock's */

		if(locked(uap->flag, fp, ip, LB, UB) == NULL)
			u.u_error = NULL;
		goto exit_locking;

	default:
		break;
	}

	/*
	 * request must be a lock of some kind
	 * check to see if the region is lockable by this
	 * process
	 */
	if(locked(uap->flag, fp, ip, LB, UB))
		goto exit_locking;
	cl = (struct locklist *)&ip->i_locklist;
	/*
	 * simple case, no existing locks, simply add new lock
	 */
	if( (nl=cl->ll_link) == NULL ) {
		lockadd(cl, LB, UB);
		goto exit_locking;
	}
	/*
	 * simple case, lock is before existing locks,
	 * simply insert at head of list
	 */
	if( UB < nl->ll_start ) {
		lockadd(cl,LB,UB);
		goto exit_locking;
	}
	/*
	 * ending range of lock is same as start of lock by
	 * another process, simply insert at head of list
	 */
	if( UB <= nl->ll_start && u.u_procp != nl->ll_proc ) {
		lockadd(cl, LB, UB);
		goto exit_locking;
	}
	/*
	 * request range overlaps with begining of first request
	 * modify starting point in lock to include requested region
	 */
	if( UB >= nl->ll_start && LB < nl->ll_start ) {
		nl->ll_start = LB;
	}
	/*
	 * scan thru remaining locklist
	 */
	cl = nl;
	do {
		/*
		 * actions for requests at end of list
		 */
		if( ( nl = cl->ll_link ) == NULL ) {
			/*
			 * request overlaps tail of last entry
			 * extend end point
			 */
			if( LB <= cl->ll_end && u.u_procp == cl->ll_proc ) {
				if( UB > cl->ll_end ) cl->ll_end = UB;
				goto exit_locking;
			}
			/*
			 * otherwise add new entry
			 */
			lockadd(cl, LB, UB);
			goto exit_locking;
		}
		/*
		 * if more locks in range skip to next
		 * otherwise stop scan
		 */
		if( nl->ll_start < LB ) {
			cl = nl;
		}
		else {
			break;
		}
	} while(foo=1);	/* compiler bug for do{}while(constant) */
	/*
	 * if upper bound is fully resolved were done
	 * otherwise fix end of last entry or add new entry
	 */
	if(UB <= cl->ll_end)
		goto exit_locking;
	if(LB <= cl->ll_end && u.u_procp == cl->ll_proc) cl->ll_end = UB;
	else {
		if( lockadd(cl, LB, UB) ) return;
		cl = cl->ll_link;
	}
	/*
	 * end point set above may overlap later entries
	 * if so delete or modify them to perform the compaction
	 */
	while( (nl=cl->ll_link) != NULL)  {
		/*
		 * if we found lock by another process we must
		 * be done since we validated the range above
		 */
		if(u.u_procp != nl->ll_proc)  {
			goto exit_locking;
		}
		/*
		 * if the new endpoint no longer overlaps were done
		 */
		if(cl->ll_end < nl->ll_start)  {
			goto exit_locking;
		}
		/*
		 * if the new range overlaps the first part of the
		 * next lock, take its end point
		 * and delete the next lock
		 * we should be done
		 */
		if(cl->ll_end <= nl->ll_end) {
			cl->ll_end = nl->ll_end;
			cl->ll_link = nl->ll_link;
			lockfree(nl);
			goto exit_locking;
		}
		/*
		 * the next lock is fully included in the new range
		 * so it may be deleted
		 */
		cl->ll_link = nl->ll_link;
		lockfree(nl);
	}
exit_locking:
	spin_lock(&inode_sem);
	if (inode_wanted(ip))  {
		inode_unwant(ip);
		mfs_wakeup_all(ip);
	}
	inode_unlock(ip);
	spin_unlock(&inode_sem);
}
/*
 * locked -- routine to scan locks and check for a locked condition
 */
locked(flag, fp, ip, LB, UB)
register struct inode *ip;
struct file *fp;
register off_t	LB, UB;
{
	register struct locklist *nl = ip->i_locklist;

	/*
	 * scan list while locks are in requested range
	 */
	while(nl != NULL && nl->ll_start < UB) {
		/*
		 * skip locks for this process
		 * and those out of range
		 */
		if( nl->ll_proc == u.u_procp || nl->ll_end <= LB) {
			nl = nl->ll_link;
			if(nl == NULL) return(NULL);
			continue;
		}
		/*
		 * must have found lock by another process
		 * if request is to test only, then exit with
		 * error code
		 */
		if(flag>1) {
			u.u_error = EACCES;
			return(1);
		}
		/*
		 * will need to sleep on lock, check for deadlock first
		 * abort on error
		 */
		spin_lock(&file_locking_sem);
		if(deadlock(nl) != NULL) {
			spin_unlock(&file_locking_sem);
			return(1);
		}
		spin_lock(&inode_sem);
		if (inode_wanted(ip))  {
			inode_unwant(ip);
			mfs_wakeup_all(ip);
		}
		inode_unlock(ip);
		spin_unlock(&inode_sem);
		/*
		 * post want flag to get awoken
		 * then sleep till lock is released
		 */
		nl->ll_flags |= IWANT;
		mfs_sleep_with_sig_check(nl, PSLEP, &file_locking_sem);
		spin_unlock(&file_locking_sem);

		spin_lock(&inode_sem);
		while (inode_locked(ip)) {
			inode_want(ip);
			mfs_sleep(ip, PINOD, &inode_sem);
		}
		inode_lock(ip);
		spin_unlock(&inode_sem);

		/*
		 * set scan back to begining to catch
		 * any new areas locked
		 * or a partial delete
		 */
		nl = ip->i_locklist;
		/*
		 * abort if any errors
		 */
		if(u.u_error) return(1);
	}
	return(NULL);
}

/*
 * deadlock -- routine to follow chain of locks and proc table entries
 *		to find deadlocks on file locks.
 */

deadlock(lp)
register struct locklist *lp;
{
	register struct locklist *nl;

	/*
	 * scan while the process owning the lock is sleeping
	 */
	while(lp->ll_proc->p_stat == SSLEEP) {
		/*
		 * if the object the process is sleeping on is
		 * NOT in the locktable every thing is ok
		 * fall out of loop and return NULL
		 */
		nl = (struct locklist *)lp->ll_proc->p_wchan;
		if( nl < &locklist[0] || nl >= &locklist[v.v_nflocks] )
			break;
		/*
		 * the object was a locklist entry
		 * if the owner of that entry is this
		 * process then a deadlock would occur
		 * set error exit and return
		 */
		if(nl->ll_proc == u.u_procp) {
			u.u_error = EDEADLOCK;
			return((int)nl);
		}
		/*
		 * the object was a locklist entry
		 * owned by some other process
		 * continue the scan with that process
		 */
		lp = nl;
	}
	return(NULL);
}

/*
 * unlock -- called by close to release all locks for this process
 */

unlock(ip)
register struct inode *ip;
{
	register struct locklist *nl;
	register struct locklist *cl;

	if(cl = (struct locklist *)&ip->i_locklist)
		while( (nl = cl->ll_link) != NULL) {
			if(nl->ll_proc == u.u_procp) {
				cl->ll_link = nl->ll_link;
				lockfree(nl);
			}
			else cl = nl;
		}
}

lockinit()  
{
	register struct locklist *fl = &locklist[0];
	register struct locklist *nl;

	/*
	 * link the locklist table into the freelist
	 */
	if(fl->ll_proc == NULL) {
		fl->ll_proc = &proc[0];
		for(nl= &locklist[1]; nl < &locklist[v.v_nflocks]; nl++) {
			lockfree(nl);
		}
	}
}


/*
 * lockalloc -- allocates free list, returns free lock items
 */
struct locklist *
lockalloc()
{
	register struct locklist *fl = &locklist[0];
	register struct locklist *nl;

	spin_lock(&file_locking_sem);
	/*
	 * if all the locks are used error exit
	 */
	if( (nl=fl->ll_link) == NULL) {
		spin_unlock(&file_locking_sem);
		u.u_error = EDEADLOCK;
		return(NULL);
	}
	/*
	 * return the next lock on the list
	 */
	fl->ll_link = nl->ll_link;
	nl->ll_link = NULL;
	spin_unlock(&file_locking_sem);
	return(nl);
}

/*
 * lockfree -- returns a lock item to the free list
 */

lockfree(lp)
register struct locklist *lp;
{
	register struct locklist *fl = &locklist[0];

	/*
	 * if some process is sleeping on this lock
	 * wake them up
	 */
	spin_lock(&file_locking_sem);
	if(lp->ll_flags & IWANT) {
		lp->ll_flags &= ~IWANT;
		mfs_wakeup_all(lp);
	}
	/*
	 * add the lock into the free list
	 */
	lp->ll_link = fl->ll_link;
	fl->ll_link = lp;
	spin_unlock(&file_locking_sem);
}

/*
 * lockadd -- routine to add item to list
 */
lockadd(cl,LB,UB)
register struct locklist *cl;
off_t LB,UB;
{
	register struct locklist *nl;

	/*
	 * get a lock, return if none available
	 */
	nl = lockalloc();
	if(nl == NULL) {
		return(1);
	}
	/*
	 * link the new entry into list at current spot
	 * fill in the data from the args
	 */
	nl->ll_link = cl->ll_link;
	cl->ll_link = nl;
	nl->ll_proc = u.u_procp;
	nl->ll_start = LB;
	nl->ll_end = UB;
	return(0);
}
