/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iget.c: version 25.1 created on 11/27/91 at 15:09:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iget.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:iget.c	23.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/mount.h"
#include "sys/errno.h"
#include "sys/user.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/ino.h"
#include "sys/stat.h"
#include "sys/var.h"
#include "sys/conf.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/open.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/nami.h"
#include "sys/mfs.h"
#include "sys/own.h"

extern struct mount	*pipemnt;

struct ifreelist ifreelist;

/*
 * initialize inodes
 */
inoinit()
{
	register struct inode *ip;
	register int i;

	ifreelist.av_forw = ifreelist.av_back =
		(struct inode *) &ifreelist;
	for (i = 0; i <= hinodemask; i++) {
		hinode[i].i_forw = hinode[i].i_back =
			(struct inode *) &hinode[i];
	}
	for (i = 0, ip = inode; i < v.v_inode; i++, ip++) {
		ip->i_forw = ip->i_back = ip;
		(ifreelist.av_forw)->av_back = ip;
		ip->av_forw = ifreelist.av_forw;
		ifreelist.av_forw = ip;
		ip->av_back = (struct inode *) &ifreelist;
	}

	/* allow user to configure off the synchronous inode writes */
	isyn = isyn_flag ? ISYN : 0;
}

/*
 * Look up an inode by mount point (device) and inumber.
 * If it is in core (in the inode structure), honor the locking
 * protocol.
 * If it is not in core, read it in from the specified device.
 * If the inode is mounted on, perform the indicated indirection.
 * In all cases, a pointer to a locked inode structure is returned.
 *
 * printf warning: inode table overflow -- if the inode structure is
 *					   full.
 * panic: no imt -- if the mounted filesystem is not in the mount table.
 *	"cannot happen"
 */

struct inode *
iget(mp, ino)
register struct mount *mp;
register ino;
{
	register struct inode *ip;
	register struct hinode *hip;
	register struct inode *tip;
	register short  fstyp;
	int 		flags;

	atom_inc(&sysinfo.iget);
	fstyp = mp->m_fstyp;
loop:
	hip = ihash(ino);
	spin_lock(&inode_sem);
	for (ip = hip->i_forw; ip != (struct inode *) hip; ip = ip->i_forw)
		if (ino == ip->i_number && mp == ip->i_mntdev)  {
			goto found;
		}

	ip = ifreelist.av_forw;
	while ((ip != (struct inode *)&ifreelist)) {
		/*
		 * If inode locked, assume it has been found in the cache
		 * by another process, so march on, march on...
		 */
		if (!inode_locked(ip))
			break;
		ip = ip->av_forw;
	}
	if (ip == (struct inode *)&ifreelist) {
		spin_unlock(&inode_sem);
		cmn_err(CE_WARN, "iget - inode table overflow");
		if (fsinfo[fstyp].fs_notify & NO_IGET) {
			struct argnotify noarg;

			noarg.cmd = NO_IGET;
			noarg.data1 = (long)mp;
			noarg.data2 = (long)ino;
			if (! fstypsw[fstyp].notify_flag)
				upkern_lock();
			(void)(*fstypsw[fstyp].fs_notify)((struct inode *)0,
							  &noarg);
		}
		atom_inc(&syserr.inodeovf);
		u.u_error = ENFILE;
		return(NULL);
	}

	ASSERT(ip == ip->av_back->av_forw);
	ASSERT(ip == ip->av_forw->av_back);
	ip->av_back->av_forw = ip->av_forw;	/* remove from free list */
	ip->av_forw->av_back = ip->av_back;

	/* Remove from old hash list. */

	ip->i_back->i_forw = ip->i_forw;
	ip->i_forw->i_back = ip->i_back;
	ip->i_inode_lock = INODE_LOCK_VAL;
 	ip->i_flag = 0;

	ASSERT(ip->i_count == 0);

	/*
	 * If a block number list was allocated for this file
	 * (because it is a 413), then free the space now since
	 * we are going to reuse this table slot for a different
	 * inode.  See the code in mmgt/region.c/mapreg.
	 * Also, dispose of the left-over data structures associated with
	 * an old inode whose slot we are about to re-use.  If FS_NOICACHE
	 * is set for this fstyp then old inodes don't remain in
	 * the cache and this disposal is taken care of at the time of
	 * last reference to the inode in iput().  We also assume that
	 * this disposal need not be done at all unless a new fstyp
	 * is being assigned to the inode.
	 */
	if (ip->i_fstyp) {
		spin_unlock(&inode_sem);
		FS_FREEMAP(ip);
		spin_lock(&inode_sem);
		flags = fsinfo[ip->i_fstyp].fs_flags;
		if ((flags & FS_NOICACHE) == 0 &&
		    ((ip->i_fstyp != fstyp) || (flags &FS_RECYCLE)))  {
			/* this could probably be done by just putting onto
			   the file system's respective freelists, which means
			   that it would not be necessary to exit and enter the
			   cr. unfortunately that means either putting file
			   system specific code here or adding another entry
			   to the file system switch structure.   mcm
			*/
			spin_unlock(&inode_sem);
			IPUT(ip);
			spin_lock(&inode_sem);
		}
	}

	hip->i_forw->i_back = ip;	/* insert into new hash list */
	ip->i_forw = hip->i_forw;
	hip->i_forw = ip;
	ip->i_back = (struct inode *) hip;

	ip->i_mntdev = mp;
	ip->i_mnton = NULL;
	ip->i_dev = mp->m_dev;
	ip->i_fstyp = fstyp;
	ip->i_rcvd = NULL;
	ip->i_vcode = ++rfs_vcode;
	ip->i_wcnt = 0;
	ip->i_number = ino;
	ip->i_count = 1;
	spin_unlock(&inode_sem);

#ifdef FSPTR
	ip->i_fstypp = &fstypsw[fstyp];
#endif
	tip = FS_IREAD(ip);
	/*
	 * fs_iread returns NULL to indicate an error.
	 * If NULL is returned, no fs dependent inode has been
	 * assigned to the fs independent inode.
	 * In this case the newly allocated fs independent
	 * inode should be deallocated, that is, returned to the
	 * free list and taken off the hash list. If it stayed
	 * on the hash list it could be "found" and its use would
	 * cause a panic because it has no fs specific portion.
	 */
	if (tip == NULL) {
		spin_lock(&inode_sem);
		ip->i_back->i_forw = ip->i_forw; /* remove from hash list */
		ip->i_forw->i_back = ip->i_back;
		ifreelist.av_back->av_forw = ip; /* put it back on free list */
		ip->av_forw = (struct inode *) &ifreelist;
		ip->av_back = ifreelist.av_back;
		ip->i_forw = ip->i_back = ip;
		ip->i_fsptr = NULL;
		ip->i_count = 0;
		ip->i_fstyp = 0;
		spin_unlock(&inode_sem);
		prele(ip);
	}
	return(tip);
found:
	if (inode_locked(ip)) {
		inode_want(ip);
		mfs_sleep(ip, PINOD, &inode_sem);
		spin_unlock(&inode_sem);
		goto loop;
	}

	if (ip->i_flag & (IMOUNT|IRMOUNT)) {
		mp = ip->i_mnton;
		ASSERT(mp != NULL);
		/*
		 * If MINTER is set it means that the file system
		 * is in the process of being unmounted. The
		 * fs-dependent umount routine flushed all of the
		 * inodes (via iflush()) and cleared m_mount.  The
		 * fs-independent umount has not yet done an iput()
		 * on the "mounted on" inode.
		 */
		if (mp->m_flags&MINTER) {
			spin_unlock(&inode_sem);
			u.u_error = EAGAIN;
			return(NULL);
		}
		/*
		 * Invoke the file system dependent iput
		 * routine to note that we are releasing
		 * a reference to an inode.  We have to
		 * simulate a real reference by incrementing
		 * and decrementing i_count.
		 */
		if (fsinfo[ip->i_fstyp].fs_flags & FS_NOICACHE) {
			ip->i_count++;
			spin_unlock(&inode_sem);
			IPUT(ip);
			spin_lock(&inode_sem);
			ip->i_count--;
		}
		if (mp->m_inodp == ip) {
			if (ip->i_flag & IMOUNT) {	/* local case */
				ip = mp->m_mount;
				if (ip == NULL) {
					spin_unlock(&inode_sem);
					cmn_err(CE_WARN,
					   "Null m_mount in iget mp: %x\n", mp);
					u.u_error = EAGAIN; 
					return(NULL);
				}
				ino = ip->i_number;
				fstyp = ip->i_fstyp;
				goto found;
			} else {
				struct inode *rip;
				spin_unlock(&inode_sem);
				rnamei1(mp->m_mount, &rip);
				return(rip);
			}
		}
		cmn_err(CE_PANIC,"iget - mounted on inode not in mount table.");
	}

	if (ip->i_count == 0) {
		/* remove from freelist */
		ASSERT(ip->av_back->av_forw == ip);
		ASSERT(ip->av_forw->av_back == ip);

		ip->av_back->av_forw = ip->av_forw;
		ip->av_forw->av_back = ip->av_back;
	}
	ip->i_count++;
	inode_lock(ip);
	spin_unlock(&inode_sem);
	return(ip);
}

/*
 * Decrement reference count of an inode structure.
 * On the last reference, write the inode out and if necessary,
 * truncate and deallocate the file.
 */
iput(ip)
register struct inode *ip;
{
	ASSERT(inode_locked(ip));

	/* Free the incore slot only if reference count is 1.	*/
	if (ip->i_count == 1) {

		ip->i_flag &= ~ITEXT;
		if (ip->i_ftype == IFCHR) ip->i_sptr = NULL;

		IPUT(ip);

		/*
		 * Don't take ip off its current hash list unless the
		 * fstyp does not wish to make use of the inode cache. 
		 * In that case FS_NOICACHE will be set. If the cache is
		 * used an inode stays on this hash list, 
		 * with its inumber filled in until:
		 * (1) iget needs that inumber and re-uses it, or
		 * (2) iget allocates it off the freelist. 
		 * In case (1) iget removes it off the freelist. 
		 * In case (2) iget removes it off the freelist, 
		 * and also moves it from its current hash list 
		 * to the new hash list.
		 */
		spin_lock(&inode_sem);
		if (fsinfo[ip->i_fstyp].fs_flags & FS_NOICACHE) {
			/* Remove this inode from its hash list. */
			ip->i_back->i_forw = ip->i_forw;
			ip->i_forw->i_back = ip->i_back;
			ip->i_forw = ip->i_back = ip;
			ip->i_fstyp = 0;
		}

		/* put inode on freelist */
		ASSERT(ip->av_back->av_forw != ip);
		ASSERT(ip->av_forw->av_back != ip);

		ifreelist.av_back->av_forw = ip;
		ip->av_forw = (struct inode *) &ifreelist;
		ip->av_back = ifreelist.av_back;
		ifreelist.av_back = ip;
		ip->i_count--;

		spin_unlock(&inode_sem);
		prele(ip);
		return;
	}

	ASSERT(ip->i_count > 1);

	if (fsinfo[ip->i_fstyp].fs_flags & FS_NOICACHE) {
		FS_IPUT(ip);
	}

	ip->i_count--;
	prele(ip);
}

/*
 * Search inodes for those on dev
 * Purge any cached inodes.
 * Returns -1 if an active inode (desides root) is
 * found, otherwise 0
 * Warning: This code assumes that it runs on a simplex machine.
 * That is, it assumes that the inode table will not change while
 * it is being scanned. Let's hope that no drivers are changing 
 * the inode table at interrupt level!!!!
 *
 * JPC	3/2/90	Changed to flush all possible inodes before returning, to
 *		give uadmin A_REMOUNT a better chance of working.
 */
iflush(mp)
register struct mount *mp;
{
	register inode_t	*ip;
	register inode_t	*rip;
	register dev_t 		dev;
	register uint		ret = 0;

	dev = mp->m_dev;
	rip = mp->m_mount;
	ASSERT(rip != NULL);
	spin_lock(&inode_sem);
	for (ip = &inode[0]; ip < (struct inode *)v.ve_inode; ip++) {
		if (ip->i_dev == dev) {
			if (ip == rip) {
				if (ip->i_count > 1)  {
					ret = -1;
				}
				continue;
			}
			if (ip->i_count == 0) {
				/*
				 * Remove from hash list.
				 * i_number is left filled in by iput,
				 * so it can be used to locate the hash
				 * chain ip is on.
				 */
				if (inode_locked(ip))  {
					ret = -1;
					continue;
				}
				ip->i_back->i_forw = ip->i_forw;
				ip->i_forw->i_back = ip->i_back;
				ip->i_forw = ip->i_back = ip;
			} else  {
				ret = -1;
			}
		}
	}
	spin_unlock(&inode_sem);
	return(ret);
}

/*
 * JPC 8/6/91	Code stolen from iflush to verify that only the root and
 *		text inodes are left for a clean shutdown of root.
 *
 * Search inodes for those on dev
 * Purge any cached inodes.
 * Returns count of active inodes (besides root and text inodes)
 */
iflush_clean(mp)
struct mount	*mp;
{
	register inode_t	*ip;
	register inode_t	*rip;
	register dev_t 		dev;
	register int		cnt;

	cnt = 0;
	dev = mp->m_dev;
	rip = mp->m_mount;
	ASSERT(rip);
	spin_lock(&inode_sem);
	for (ip = inode; ip < (struct inode *)v.ve_inode; ip++) {
		if (ip->i_dev != dev || ip == rip)
			continue;
		/*
		 * we don't like locked inodes with count==0, or any
		 * non-text and non-dir inodes.
		 */
		if (ip->i_count == 0) {
			if (inode_locked(ip))
				++cnt;
		}
		else if (!(ip->i_flag & ITEXT) && (ip->i_ftype != S_IFDIR ||
				(ip->i_flag & (IUPD | IACC | ICHG))))
			++cnt;
	}
	spin_unlock(&inode_sem);
	return(cnt);
}

/*
 * Remove an inode from its hash list
 */
iunhash(ip)
register struct inode *ip;
{
	spin_lock(&inode_sem);
	ip->i_back->i_forw = ip->i_forw;
	ip->i_forw->i_back = ip->i_back;
	ip->i_forw = ip->i_back = ip;
	spin_unlock(&inode_sem);
}

#ifdef RFS
/*
 * Check how many inodes are still active for the device.
 * Return 0 if only 1---assumed to be root inode.
 * Return -1 if more.
 */
icheck(mp)
register struct mount *mp;
{
	register int count;
	register struct inode *ip;

	count = 0;
	for (ip = inode; ip < (struct inode *)v.ve_inode; ip++)  {
		if ((ip->i_mntdev == mp) && ip->i_count)  {
			count += ip->i_count;
			if (count > 1)
				return(-1);
		}
	}

	return(0);
}
#endif /* RFS */

/*
 *	iinit is called once (from main) very early in initialization.
 *	It reads the root's super block and initializes the current date
 *	from the last modified date.
 *
 */
iinit()
{
	register dev_t	dev;

	u.u_error = 0;

	dev = notminored(rootdev);
	(*bdevsw[bmajor(dev)].d_open)(minor(dev), FREAD | FWRITE, OTYP_MNT);
	if ( u.u_error )
		cmn_err(CE_PANIC, "open of rootdev failed (dev=0x%x, err=%d)",
		  rootdev, u.u_error, 0);

	dev = notminored(pipedev);
	(*bdevsw[bmajor(dev)].d_open)(minor(dev), FREAD | FWRITE, OTYP_LYR);
	if ( u.u_error )
		cmn_err(CE_PANIC, "open of pipedev failed (dev=0x%x, err=%d)",
		  pipedev, u.u_error, 0);

	srmountfun(1);
}
