/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) getpages.c: version 25.1 created on 11/27/91 at 15:09:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)getpages.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * 001 JPC	2/2/88	Made dbd a register in ageregion, changed macros,
 *			removed extra dbd declaration in getpages, changed
 *			(rp->r_flags & RG_LOCK) to (rp->r_lock & REGION_LOCK)
 * 002 JPC	2/8/88	Added vhand_sleep, to be used until the TLB flush works.
 * 003 JPC	2/10/88	Made getpages return non-zero if enough pages have been
 *			scavenged, as per mcm's change to a1000 code.  Changed
 *			the test in getpages from using tune.t_gpgsmask to one
 *			testing both pg_isref(pt) and pg_isndref(dbd).
 *			Added vhand_procp so that vhand can be recognized in
 *			swap().
 * 004 JPC	2/16/88	Added mcm's changes to vhand, memfree, etc.  Added
 *			pglst_map.
 * 005 JPC	4/5/88	Vhand should work on multi-processor systems, changed
 *			some of the defines in sys/immu.h to use atom_and or
 *			atom_or, and added atom_ref_valid_clear in getpages.
 *			Changed getpages to clear the valid bit when adding
 *			the page to a list.  Changed addspg, addfpg, and
 *			freelist to restore the valid bit when releasing pages
 *			that were not freed or swapped.
 * 006 JPC	4/12/88	Removed vhand_sleep and its code.
 * 007 JPC	5/11/88	Protected vhand's region loop with rlstlock.
 */

#include "sys/types.h"
#include "sys/tuneable.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/inode.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/sysinfo.h"
#include "sys/pfdat.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/swap.h"
#include "sys/getpages.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/mfs.h"
#include "sys/spm_mem.h"
#include "sys/synch.h"


#define DEF_GPGSLO	40	/* default value for tune.t_gpgslo	*/


int		getpgslim;	/* Current limit for getpages.  It is	*/
				/* either tune.t_gpgslo or		*/
				/* tune.t_gpgshi.			*/
int		sclimit;	/* Swap chunk size limit.  Set to	*/
				/* tune.t_maxsc every cycle thru vhand.	*/
int		fclimit;	/* Free chunk size limit.  Set to	*/
				/* tune.t_maxfc every cycle thru vhand.	*/
suspend_lock_t	pglstlock = SUSPEND_INIT(PZERO);
				/* Lock for the page lists below.	*/
				/* Needed because sched and vhand can	*/
				/* try to use at the same time.		*/

/* The following tables are described in getpages.h */
pglst_t	spglst[MAXSPGLST];
pglst_t	fpglst[MAXFPGLST];
gprgl_t	gprglst[MAXSPGLST + MAXFPGLST];
int	spglndx;
int	fpglndx;
int	gprgndx;
extern	sptalloc();

pglstlk()
{
	suspend_lock(&pglstlock);
}

pglstunlk()
{	
	ASSERT(suspend_islocked(&pglstlock));
	suspend_unlock(&pglstlock);
}

pglstlocked()
{
	return (suspend_islocked(&pglstlock));
}


reg_t		vhandreg;


/*	This process is awakened periodically by clock to update the
 *	system's idea of the working sets of all processes and to
 *	steal pages from processes if freemem is too low.
 */

vhand()
{
	register reg_t	*rp;
	register reg_t	*nrp;
	register int	newractive;
	static char	sc_msg[] =
	  "vhand: tune.t_maxsc (MAXSC) changed from %d to %d.";
	static char	fc_msg[] =
	  "vhand: tune.t_maxfc (MAXFC) changed from %d to %d.";
	reg_t *next_rp();

	if (tune.t_gpgslo <= 0) {
		cmn_err(CE_NOTE,
		  "vhand: tune.t_gpgslo (GPGSLO) changed from %d to %d.",
		  tune.t_gpgslo, DEF_GPGSLO);
		tune.t_gpgslo = DEF_GPGSLO;
	}
	if (tune.t_maxsc <= 0 || tune.t_maxsc > MAXSPGLST) {
		cmn_err(CE_NOTE, sc_msg, tune.t_maxsc, MAXSPGLST);
		tune.t_maxsc = MAXSPGLST;
	}
	if (tune.t_maxfc <= 0 || tune.t_maxfc > MAXFPGLST) {
		cmn_err(CE_NOTE, fc_msg, tune.t_maxfc, MAXFPGLST);
		tune.t_maxfc = MAXFPGLST;
	}
	if (tune.t_gpgslo >= tune.t_gpgshi) {
		newractive = tune.t_gpgslo + tune.t_maxsc + tune.t_maxfc;
		cmn_err(CE_NOTE,
		  "vhand: tune.t_gpgshi (GPGSHI) changed from %d to %d.",
		  tune.t_gpgslo, newractive);
		tune.t_gpgslo = newractive;
	}
	getpgslim = tune.t_gpgslo;
	tune.t_vhandl = max(maxmem/v.v_vhndfrac, tune.t_gpgshi);

	for (;;) {

		/*	If tune.t_maxsc has been changed during the
		**	last pass through the regions or while we
		**	were sleeping, then use the new limit now.
		**	Be sure that an illegal value has not been
		**	specified.
		*/

		if (sclimit != tune.t_maxsc) {
			pglstlk();
			if (tune.t_maxsc <= 0 || tune.t_maxsc > MAXSPGLST) {
				cmn_err(CE_NOTE, sc_msg, tune.t_maxsc,
				  MAXSPGLST);
				tune.t_maxsc = MAXSPGLST;
			}
			if (spglndx >= tune.t_maxsc)
				if (!swapchunk((reg_t *)0, 1))
					goto vhand_slp;
			sclimit = tune.t_maxsc;
			pglstunlk();
		}

		/*	If tune.t_maxfc has been changed during the
		**	last pass through the regions or while we
		**	were sleeping, then use the new limit now.
		**	Be sure that an illegal value has not been
		**	specified.
		*/

		if (fclimit != tune.t_maxfc) {
			pglstlk();
			if (tune.t_maxfc <= 0 || tune.t_maxfc > MAXFPGLST) {
				cmn_err(CE_NOTE, fc_msg, tune.t_maxfc,
				  MAXFPGLST);
				tune.t_maxfc = MAXFPGLST;
			}
			if (fpglndx >= tune.t_maxfc)
				freechunk((reg_t *)0);
			fclimit = tune.t_maxfc;
			pglstunlk();
		}

		if (freemem > getpgslim) {
			getpgslim = tune.t_gpgslo;
			goto vhand_slp;
		}

		newractive = 0;
		pglstlk();
		/*
		 *	Scan all regions
		 */
		for (rp = next_rp(&ractive); rp; rp = nrp) {

			ageregion(rp);

			nrp = next_rp(rp);

			if (freemem <= getpgslim) {
				getpgslim = tune.t_gpgshi;
				(void) getpages(rp, 0);
				if (gprglst[gprgndx].gpr_count == 0  ||
					  gprglst[gprgndx].gpr_rgptr != rp)
					regrele(rp);
				continue;
			}

			if (!newractive)  {
				rlstlock();
				vhandreg.r_forw = rp;
				vhandreg.r_back = rp->r_back;
				vhandreg.r_back->r_forw = &vhandreg;
				rp->r_back = &vhandreg;
				newractive = 1;
				rlstunlock();
			}
			regrele(rp);
			getpgslim = tune.t_gpgslo;
		}

		if ( newractive ) {
			rlstlock();
			ractive.r_back->r_forw = ractive.r_forw;
			ractive.r_forw->r_back = ractive.r_back;
			ractive.r_forw = vhandreg.r_forw;
			ractive.r_back = vhandreg.r_back;
			ractive.r_back->r_forw = &ractive;
			ractive.r_forw->r_back = &ractive;
			rlstunlock();
		}

		/*	If we still do not have enough free
		**	memory and there are pages on the
		**	lists to steal, then steal them now 
		**	before we go to sleep.  Otherwise, 
		**	unlock all of the locked regions.
		*/

		if (fpglndx) { 
			if (freemem <= getpgslim)
				freechunk((reg_t *)0); 
			else {
				freelist(fpglst, fpglndx, (reg_t *)0);
				fpglndx = 0;
			}
		}

		if (spglndx) {
			if (freemem <= getpgslim)
				(void)swapchunk((reg_t *)0, 0);
			else {
				freelist(spglst, spglndx, (reg_t *)0);
				spglndx = 0;
			}
		}
		ASSERT(spglndx == 0);
		ASSERT(fpglndx == 0);
		ASSERT(gprglst[gprgndx].gpr_count == 0);
		flush_all_tlbs();
		pglstunlk();

		/*	Go to sleep until clock wakes us up again.
		*/

	vhand_slp:

		sleep(vhand, PSWP);
	}
}

/*
 * lock the next lockable region in the active list, and return it, or NULL
 * if we hit the end.  Caller must NOT have the region list locked.
 */
static reg_t *
next_rp(rp)
reg_t	*rp;
{
	register reg_t	*nrp;

	ASSERT(!rlst_mylock());

	rlstlock();

	for (nrp = rp->r_forw; nrp != &ractive; nrp = nrp->r_forw)
		if (reg_trylock(nrp))
			break;

	rlstunlock();

	return(nrp == &ractive ? NULL : nrp);
}


/*	Do page use bit ageing for the pte's in
 *	the passed region
 */
ageregion(rp)
register reg_t	*rp;
{
	register pde_t	*pt;
	register int	i;
	register int	j;
	register int	seglim;
	register int	pglim;
	register dbd_t	*dbd;		/* 001 */


	/*	Look at all of the segments of the region.
	 */
	
	seglim = ctos(rp->r_pgsz);

	for (i = 0  ;  i < seglim  ;  i++) {

		/*	Look at all of the pages of the segment.
		 */

		pt = rp->r_list[i];
		pglim = rp->r_pgsz - stoc(i);
		if (pglim > NPGPT)
			pglim = NPGPT;

		else { /* set up "pt" for stack region */
			if (rp->r_flags & RG_STACK)
				pt += NPGPT - pglim;
		}
			
		
		ASSERT(pglim >= 0  &&  pglim <= NPGPT);

		for (j = 0;  j < pglim;  j++, pt++) {

			/*	Check to see if this page is part of
			 *	the working set.  If not, it does
			 *	not have to be aged.
			 */
			if (!pg_isvalid(pt))
				continue;

			/*	We have an active page.  Age it
			 *	unless it is already as old as
			 *	it can get.
			 */

			dbd = (dbd_t *)pt + NPGPT;
			if (pg_isref(pt)) {
				pg_clrref(pt);
				pg_setndref(dbd);
			} else if (pg_isndref(dbd)) {		/* 001 */
				pg_clrndref(dbd);
			}
		}
	}
}



/*	Swap out pages from region rp which is locked by
 *	our caller.  If hard is set, take all valid pages,
 *	otherwise take only unreferenced pages
 *
 *	Returns non-zero if we have stolen enough pages, or if we were
 *	unable to steal all pages.
 */

getpages(rp, hard)
register reg_t	*rp;
register 	hard;
{
	register pde_t	*pt;
	register int	i;
	register int	j;
	register int	seglim;
	register int	pglim;
	register dbd_t	*dbd;
	register pfd_t	*pfd;
	register int	ret = 0;

	ASSERT(reg_mylock(rp));
	ASSERT(pglstlocked());

	
	/*	If the region is marked "don't swap", then don't
	 *	steal any pages from it.
	 */

	ASSERT(rp->r_noswapcnt >= 0);

	if (rp->r_noswapcnt) {
		return (ret);
	}

	/* Look through all of the segments of the region.  */
	seglim = ctos(rp->r_pgsz);

	for (i = 0;  i < seglim;  i++) {

		/* Look through segment's page table for valid
		 * pages to dump.
		 */

		pt = rp->r_list[i];

		pglim = rp->r_pgsz - stoc(i);
		if (pglim > NPGPT)
			pglim = NPGPT;
		else { /* set up "pt" for stack region */
			if (rp->r_flags & RG_STACK)
				pt += NPGPT - pglim;
		}
		ASSERT(pglim >= 0  &&  pglim <= NPGPT);

		for (j = 0  ;  j < pglim  ;  j++, pt++) {

			/* If we have gotten enough pages, then don't
			 * steal any more.
			 */
			if (!hard && (freemem >= getpgslim)) {
				getpgslim = tune.t_gpgslo;
				return (1);
			}

			/* Check to see if there is a page assigned
			 * and if it is eligible to be stolen.
			 */

			dbd = (dbd_t *)pt + NPGPT;
			if (!pg_isvalid(pt))
				continue;
			if (pg_islocked(dbd)) {
				ret = 1;
				continue;
			}

			/* We have a valid page assigned.
			 * See if we want to steal it.  
			 * Don't steal it, if the page has
			 * been referenced recently
			 */
			/* 005 reorganized for multi-proc vhand */
			if (hard) {
				pg_clrvalid(pt);		/* take page */
			}
			else if (pg_isref(pt) || pg_isndref(dbd) ||
			  atom_ref_clear_valid(pt))		/* 005 */
				continue;

			/* See if this page must be written to swap.
			 */

			switch (dbd->dbd_type) {
			case DBD_NONE: {
				
				/* Check to see if the page is already
				 * associated with swap.  If so, just
				 * use the same swap block unless the 
				 * swap use count overflows.
				 */
				
				pfd = pde_to_pfdat(*pt);
				memlock();
				if (pfd->pf_flags & P_HASH) {
					ASSERT(pg_iscw(pt));
					dbd->dbd_type = DBD_SWAP;
					dbd->dbd_swpi = pfd->pf_swpi;
					dbd->dbd_blkno = pfd->pf_blkno;
					if (swpinc(dbd, "getpages")) {
						memunlock();
						addfpg(rp, pt, hard);
						break;
					}
					ASSERT(pfd->pf_use > 0);
					dbd->dbd_type = DBD_NONE;
				}
				memunlock();
				addspg(rp, pt, hard);
				break;
			}

			case DBD_SWAP:
				
				/* See if this page has been modified
				 * since it was read in from swap.
				 * If not, then just use the copy
				 * on the swap file unless we are trying
				 * to delete the swap file.  If we are,
				 * then release the current swap copy
				 * and write the page out to another
				 * swap file.
				 */
				
				if (!pg_ismod(pt) &&
				   (swaptab[dbd->dbd_swpi].st_flags &
				    ST_INDEL) == 0) {
					minfo.unmodsw++;
					addfpg(rp, pt, hard);
					break;
				}

				/*	The page has been modified.
				 *	Release the current swap
				 *	block and add it to the list
				 *	of pages to be swapped out
				 *	later.
				 */

				if (swfree1(dbd) == 0) {
					memlock();
					if (!pbremove(rp, dbd))
						cmn_err(CE_PANIC,
						  "getpages - pbremove");
					memunlock();
				}

				dbd->dbd_type = DBD_NONE;
				addspg(rp, pt, hard);
				break;

			case DBD_FILE:
			case DBD_LSTFILE:

				/* This page cannot have been modified
				 * since if it had been, then it would
				 * be marked DBD_NONE, not DBD_FILE.
				 * Either the page is text and so the
				 * segment table entry is RO or it is
				 * data in which case it is copy-on-
				 * write and also RO.
				 */


				ASSERT(!pg_ismod(pt));
				addfpg(rp, pt, hard);
				minfo.unmodfl++;
				continue;
			}
		}

		/*	If we have gotten enough pages, then 
		 *	don't steal any more.  */

		if (!hard && (freemem >= getpgslim)) {
			getpgslim = tune.t_gpgslo;
			break;
		}
	}

	ASSERT(reg_mylock(rp));
	return (ret);
}


/*	Add an entry to the spglst table.  If the table is full,
**	then first call freechunk to get pages we can get without
**	doing I/O and then, if we still don't have enough call
**	swapchunk to empty the spglst table.
*/

addspg(rp, pt, hard)
register reg_t	*rp;
register pde_t	*pt;
{
	/*	If the swap table is full, then process it.
	*/

	ASSERT(spglndx <= sclimit);
	ASSERT(reg_mylock(rp));
	ASSERT(pglstlocked());

	if (spglndx == sclimit) {
		
		/*	If there are any pages on the other list
		**	which can be freed without doing any
		**	swapping, then free them first.  If that
		**	gives us enough space, then forget
		**	about adding this page to the swap list.
		*/

		if (!hard && (fpglndx > 0)) {
			freechunk(rp);
			if (freemem > getpgslim) {
validate:			pg_setvalid(pt);		/* 005 */
				return;
			}
		}

		/*	Swap out the pages on the swap list.
		**	If that gives us enough memory, then
		**	forget about adding the new page to
		**	the list.
		*/

		if (!swapchunk(rp, hard))
			goto validate;
		if (!hard && (freemem > getpgslim))
			goto validate;
	}

	/*	Increment the count of pages from this region
	**	which are on one of the lists.
	*/

	bumprcnt(rp);

	/*	Add the page to the swap list.
	*/

	ASSERT(spglndx >= 0  &&  spglndx < sclimit);
	spglst[spglndx].gp_ptptr = pt;
	spglst[spglndx++].gp_rlptr = &gprglst[gprgndx];

}


/*	Add an entry to the fpglst table.  If the table is full,
**	then first call freechunk to process it.
*/

addfpg(rp, pt, hard)
register reg_t	*rp;
register pde_t	*pt;
{

	/*	If the free table is full, then process it.
	**	If this gives us enough free memory, then
	**	forget about adding the new page to the list.
	*/

	ASSERT(pglstlocked());
	ASSERT(fpglndx <= fclimit);
	ASSERT(reg_mylock(rp));

	ASSERT(((dbd_t *)(pt + NPGPT))->dbd_type == DBD_SWAP  ||
	       ((dbd_t *)(pt + NPGPT))->dbd_type == DBD_FILE  ||
	       ((dbd_t *)(pt + NPGPT))->dbd_type == DBD_LSTFILE);

	if (fpglndx == fclimit) {
		freechunk(rp);
		if (!hard && freemem > getpgslim) {
			pg_setvalid(pt);			/* 005 */
			return;
		}
	}

	/*	Increment the count of pages from this region
	**	which are on one of the lists.
	*/

	bumprcnt(rp);

	/* Add the page to the free list.  */
	ASSERT(fpglndx >= 0  &&  fpglndx < fclimit);
	fpglst[fpglndx].gp_ptptr = pt;
	fpglst[fpglndx++].gp_rlptr = &gprglst[gprgndx];
}


/*	Swap out a chunk of user pages.
 */

swapchunk(rp, hard)
register reg_t	*rp;
{
	register int	i;
	register int	retval;
	static time_t	last_msg;
	extern time_t	time;

	ASSERT(pglstlocked());
	ASSERT(spglndx > 0  &&  spglndx <= sclimit);
	ASSERT(hard || fpglndx == 0);

	/*	If we are going to free more than is needed
	**	to get the required freemem, then just forget
	**	about the extra.
	*/
	if (!hard) {
		i = getpgslim - freemem + 1;
		if (i >= 0 && spglndx > i) {
			freelist(&spglst[i], spglndx - i, rp);
			if ((spglndx = i) == 0)
				return;
		}
	}

	retval = 1;

	if (swalloc(spglst, spglndx, 0) < 0) {

		/*	We could not get a contiguous chunk of
		**	swap space of the required size so do
		**	the swaps one page at a time.  Hope
		**	this doesn't happen very often.  Note
		**	that we get a "low on swap" printout
		**	on the console if this happens.
		*/
		if (time - last_msg > 60) {
			cmn_err(CE_WARN,
			  "!Swap space running out.  Needed %d pages.\n",
			  spglndx);
			last_msg = time;
		}

		for (i = 0;  i < spglndx;  i++) {

			/*	Allocate one page of swap and quit
			**	if none is available.  Don't wait.
			*/

			if (spglndx == 1 || swalloc(&spglst[i], 1, 0) < 0) {
				if (time - last_msg > 10) {
					cmn_err(CE_CONT,
					  "DANGER: Out of swap space.\n");
					last_msg = time;
				}
				freelist(&spglst[i], spglndx - i, rp);
				spglndx = i;
				retval = 0;
				break;
			}

			/*	Swap out one page.
			*/

			swap(&spglst[i], 1, B_WRITE);

		}

	} else {

		/* Write out all of the pages at once.  */
		swap(spglst, spglndx, B_WRITE);
	}

	/*	Free up the memory we just swapped out and
	**	reset the page list index.  Note that we
	**	never process the swap list if there is
	**	anything in the free list so after this
	**	memfree, both lists should be empty and
	**	therefore, the region count list should
	**	be empty also.
	*/
	if (spglndx)
		memfree(spglst, spglndx, rp, 0);

	spglndx = 0;
	return(retval);
}


/*	This routine is called to process the fpglist.  That is,
**	the list of pages which can be freed without doing any
**	swap I/O to create disk copies.
*/

freechunk(rp)
register reg_t	*rp;
{
	ASSERT(fpglndx > 0  &&  fpglndx <= fclimit);
	/* Now free up the actual pages.  */

	memfree(fpglst, fpglndx, rp, 1);

	/* Free pages list is empty now.  */
	fpglndx = 0;
}


/* 	Free memory.
 */

memfree(pglptr, size, lockedreg, skipmod)
register pglst_t	*pglptr;
register		size;
reg_t			*lockedreg;
register		skipmod;
{
	register pfd_t		*pfd;
	register dbd_t		*dbd;
	register gprgl_t	*rlptr;
	pde_t			*ptptr;
	reg_t			*rgptr;
	register int		j;

	ASSERT(size > 0  &&  size <= max(sclimit, fclimit));


	memlock();

	for (j = 0;  j < size;  j++, pglptr++) {

		/*	If we are supposed to skip modifed
		**	pages and this page has been modified,
		**	then skip it.  Don't forget to decrement
		**	the use count in the region list.
		*/
		ptptr = pglptr->gp_ptptr;
		rlptr = pglptr->gp_rlptr;
		rgptr = rlptr->gpr_rgptr;

		if (skipmod  &&  pg_ismod(ptptr)) {
			pg_setvalid(ptptr);
			if (--rlptr->gpr_count == 0 && rgptr != lockedreg) 
				regrele(rgptr);
			continue;
		}

		/*	Disassociate pte from physical page.
		*/

		dbd = (dbd_t *)(ptptr + NPGPT);

		ASSERT(dbd->dbd_type == DBD_SWAP  ||
		       dbd->dbd_type == DBD_FILE  ||
		       dbd->dbd_type == DBD_LSTFILE);

		pfd = pde_to_pfdat(*ptptr);

		ASSERT(reg_mylock(rgptr));

		/*	See if the page is in the hash list and
		 *	if not insert it there now.
		 */
		ASSERT(pfd->pf_use>0);		
		if (!(pfd->pf_flags & P_HASH)) {
			pfd->pf_flags |= P_DONE;
			pinsert(rgptr, dbd, pfd);
		}

		/*	free unused pages.
		*/

		ASSERT(pfd->pf_use>0);		
		if (--pfd->pf_use == 0) {

			/*	Put pages at end of queue since they
			**	represent disk blocks and we hope they
			**	will be used again soon.
			*/
			
			pfd->pf_prev = phead.pf_prev;
			pfd->pf_next = &phead;
			phead.pf_prev = pfd;
			pfd->pf_prev->pf_next = pfd;
			pfd->pf_flags |= P_QUEUE;
			freemem++;
			minfo.freedpgs++;
		}

		rgptr->r_nvalid--;

		if (--rlptr->gpr_count == 0  &&  rgptr != lockedreg) 
			regrele(rgptr);
	}

	memunlock();
}


/*	Increment the count of pages for a region.  Either
**	it is the current region or the region is not yet
**	in the list because we process each region only
**	once during each pass of vhand.
*/

bumprcnt(rp)
register reg_t	*rp;
{
	register int	i;

	/*	If this region is not in the region list,
	**	then add it now.  Otherwise, just increment
	**	the count of pages being stolen from this
	**	region.
	*/

	ASSERT(pglstlocked());

	if (gprglst[gprgndx].gpr_count == 0  ||
	   gprglst[gprgndx].gpr_rgptr != rp) {

		/*	The region count list can get fragmented
		**	because we can process the free page list
		**	many times before we process the swap page
		**	list.  Therefore, we must search for a
		**	free slot in the region count list.  Note
		**	that the list is cleaned up and starts
		**	fresh at the start of a new pass in vhand.
		**	In addition, there should always be a
		**	free slot because we make the region count
		**	list big enough to hold a separate region
		**	for each entry on both page lists.
		*/

		if (gprglst[gprgndx].gpr_count != 0) {
			i = gprgndx + 1;

			while (i != gprgndx) {
				if (i >= MAXSPGLST + MAXFPGLST)
					i = 0;
				if (gprglst[i].gpr_count == 0)
					break;
				i++;
			}

			if (i == gprgndx)
				cmn_err(CE_PANIC,
				  "bumprcnt - region count list overflow.");

			gprgndx = i;
		}
		gprglst[gprgndx].gpr_rgptr = rp;
		gprglst[gprgndx].gpr_count = 1;
	} else {
		gprglst[gprgndx].gpr_count++;
	}
}


/*	This routine is called to unlock the regions of a list
**	when the list does not really need to be processed.
*/

freelist(lp, count, lockedreg)
register pglst_t	*lp;
register int		count;
register reg_t		*lockedreg;
{
	register gprgl_t	*rl;
	register reg_t		*rp;
	register int		i;

	ASSERT(pglstlocked());
	ASSERT(count > 0);

	for (i = 0;  i < count;  i++, lp++) {
		pg_setvalid(lp->gp_ptptr);			/* 005 */
		rl = lp->gp_rlptr;
		rp = rl->gpr_rgptr;
		if (--rl->gpr_count == 0  &&  rp != lockedreg)
			regrele(rp);
	}
}

