/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fstyp.c: version 25.1 created on 11/27/91 at 15:09:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fstyp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:fstyp.c	25.1"

#include "sys/types.h"
#include "sys/immu.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/nami.h"
#include "sys/fs/s5macros.h"
#include "sys/errno.h"
#include "sys/user.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/debug.h"

/*
 * NOTE: Developers making use of the File System Switch mechanism to
 * build file system types in SVR3 should be aware that the architecture
 * is not frozen and may change in future releases of System V.  File
 * system types developed for SVR3 may require changes in order to work
 * with future releases of the system.
 */

int fsstray();
int fsnull();
int fsstray();
int fs2stray();
struct inode *fsinstray();
int *fsistray();



fsinit()
{
	register int i;

	/* fstyp 0 is invalid, so start with 1 */
	for (i = 1; i < nfstyp; i++)
		(*fstypsw[i].fs_init)();
}

fsnull()
{
	return(1);
}

fsstray()
{
	printf("stray fs call\n");
	u.u_error = EINVAL;
	return(NULL);
}

int *
fsistray()
{
	printf("stray fs (int *) call\n");
	u.u_error = EINVAL;
	return(NULL);
}

struct inode *
fsinstray()
{
	printf("stray fs (inode *) call\n");
	u.u_error = EINVAL;
	return(NULL);
}

sysfs()
{

	register struct uap {
		int	opcode;
	} *uap;

	uap = (struct uap *) u.u_ap;
	switch (uap->opcode) {
	case GETFSIND:   
	{

	/*
	 *	Translate fs identifier to an index
	 *	into the fsinfo structure.
	 */
		register struct	a {
			int	opcode;
			char	*fsname;
		} *uap;
		register int	index;
		register struct	fsinfo	*ap;
		char	fsbuf[FSTYPSZ];


		uap = (struct a *) u.u_ap;
		switch (upath(uap->fsname,fsbuf,FSTYPSZ)) {
		case -2:	/* too long  */
		case  0:	/* too short */
			u.u_error = EINVAL;
			return;
		case -1:	/* bad user address */
			u.u_error = EFAULT;
			return;
		}

	/*
	 *	Search fsinfo structure for the fs identifier
	 *	and return the index.
	 */

		for (ap=fsinfo, index=0; ap < &fsinfo[nfstyp]; ap++, index++)
			if (ap->fs_name != 0 && !strcmp(ap->fs_name,fsbuf)) {
				u.u_rval1 = index;
				return;
			}

		u.u_error = EINVAL;
		break;
	}

	case GETFSTYP:
	{

	/*
	 *	Translate fstype index into an fs identifier
	 */
		register struct a {
			int	opcode;
			int	fs_index;
			char	*cbuf;
		} *uap;
		register char	*src;
		register int	index;
		register struct	fsinfo	*ap;
		char	*osrc;


		uap = (struct a *) u.u_ap;
		index = uap->fs_index;
		if (index <= 0 || index >= nfstyp) {
			u.u_error = EINVAL;
			return;
		}
		ap = &fsinfo[index];
		src = ap->fs_name ? ap->fs_name : "";

		for (osrc = src; *src++;)
			;
	
		if (copyout(osrc, uap->cbuf, src - osrc))
			u.u_error = EFAULT;

		break;
	}

	case GETNFSTYP:

	/*
	 *	Return number of fstypes configured in the
	 *	system.
	 */

		u.u_rval1 = nfstyp - 1;
		break;

	default:
		u.u_error = EINVAL;
	}
}

FS_IPUT(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->iput_flag)
		return ((*(ip)->i_fstypp->fs_iput)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_iput)(ip);
		upkern_unlock();
	}
	return (retcode);
}

inode_t *
FS_IREAD(ip) 
inode_t	*ip;
{
	inode_t	*retcode;

	if (ip->i_fstypp->iread_flag)
		return ((*(ip)->i_fstypp->fs_iread)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_iread)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_IUPDAT(ip, tm1, tm2) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->iupdat_flag)
		return ((*(ip)->i_fstypp->fs_iupdat)(ip, tm1, tm2));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_iupdat)(ip, tm1, tm2);
		upkern_unlock();
	}
	return (retcode);
}

FS_READI(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->readi_flag)
		return ((*(ip)->i_fstypp->fs_readi)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_readi)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_WRITEI(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->writei_flag)
		return ((*(ip)->i_fstypp->fs_writei)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_writei)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_ITRUNC(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->itrunc_flag)
		return ((*(ip)->i_fstypp->fs_itrunc)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_itrunc)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_STATF(ip, arg) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->statf_flag)
		return ((*(ip)->i_fstypp->fs_statf)(ip, arg));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_statf)(ip, arg);
		upkern_unlock();
	}
	return (retcode);
}

FS_NAMEI(ip, p, arg) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->namei_flag)
		return ((*(ip)->i_fstypp->fs_namei)(p, arg));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_namei)(p, arg);
		upkern_unlock();
	}
	return (retcode);
}

FS_OPENI(ip, mode) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->openi_flag)
		return ((*(ip)->i_fstypp->fs_openi)(ip, mode));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_openi)(ip, mode);
		upkern_unlock();
	}
	return (retcode);
}

FS_CLOSEI(ip, f, c, o) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->closei_flag)
		return ((*(ip)->i_fstypp->fs_closei)(ip, f, c, o));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_closei)(ip, f, c, o);
		upkern_unlock();
	}
	return (retcode);
}

FS_ACCESS(ip, mode) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->access_flag)
		return ((*(ip)->i_fstypp->fs_access)(ip, mode));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_access)(ip, mode);
		upkern_unlock();
	}
	return (retcode);
}

FS_GETDENTS(ip, bp, bsz) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->getdents_flag)
		return ((*(ip)->i_fstypp->fs_getdents)(ip, bp, bsz));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_getdents)(ip, bp, bsz);
		upkern_unlock();
	}
	return (retcode);
}

FS_ALLOCMAP(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->allocmap_flag)
		return ((*(ip)->i_fstypp->fs_allocmap)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_allocmap)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_FREEMAP(ip) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->freemap_flag)
		return ((*(ip)->i_fstypp->fs_freemap)(ip));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_freemap)(ip);
		upkern_unlock();
	}
	return (retcode);
}

FS_READMAP(ip, off, sz, va, sf) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->readmap_flag)
		return ((*(ip)->i_fstypp->fs_readmap)(ip, off, sz, va, sf));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_readmap)(ip, off, sz, va, sf);
		upkern_unlock();
	}
	return (retcode);
}

FS_SETATTR(ip, mode) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->setattr_flag)
		return ((*(ip)->i_fstypp->fs_setattr)(ip, mode));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_setattr)(ip, mode);
		upkern_unlock();
	}
	return (retcode);
}

FS_NOTIFY(ip, arg) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->notify_flag)
		return ((*(ip)->i_fstypp->fs_notify)(ip, arg));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_notify)(ip, arg);
		upkern_unlock();
	}
	return (retcode);
}

FS_FCNTL(ip, cmd, arg, flag, offset) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->fcntl_flag)
		return ((*(ip)->i_fstypp->fs_fcntl)(ip,cmd,arg,flag,offset));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_fcntl)(ip,cmd,arg,flag,offset);
		upkern_unlock();
	}
	return (retcode);
}

FS_IOCTL(ip, cmd, arg, flag) 
inode_t	*ip;
{
	uint	retcode;

	if (ip->i_fstypp->ioctl_flag)
		return ((*(ip)->i_fstypp->fs_ioctl)(ip, cmd, arg, flag));
	else {
		upkern_lock();
		retcode = (*(ip)->i_fstypp->fs_ioctl)(ip, cmd, arg, flag);
		upkern_unlock();
	}
	return (retcode);
}
