/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fpp.c: version 25.1 created on 11/27/91 at 15:09:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fpp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)uts/os/M68020:fpp.c	22.1"

#include  "sys/types.h"
#include  "sys/systm.h"
#include  "sys/user.h"
#include  "sys/proc.h"
#include "sys/own.h"
#include "sys/fpu.h"
#include "sys/debug.h"

unchar	fpu_null_state[4] = {FPU_VERSION_NULL, 0x00, 0x00, 0x00};

fpu_get_type()
{
	ml_fpu_idle();	/* force fpu to idle state */
	ml_fpu_save();	/* this save will be of an idle state */
	own.o_fpu_type = u.u_fpu.fsave[FPU_VERSION];
}

fpu_save()
{
	ASSERT(own.o_fpu_loaded);

	ml_fpu_save();
	own.o_fpu_loaded = 0;
	u.u_procp->p_fpu_dests = own.o_fpu_same;
}

fpu_restore()
{
	ASSERT(!own.o_fpu_loaded);

	/*
	 * okay to switch masks if in idle state.
	 */
	if (u.u_fpu.fsave[FPU_FORMAT] == FPU_FORMAT_IDLE)
		u.u_fpu.fsave[FPU_VERSION] = own.o_fpu_type;

	/*
	 * the only way to check for null state is to test version == NULL
	 */
	ASSERT(u.u_fpu.fsave[FPU_VERSION] == FPU_VERSION_NULL ||
	       u.u_fpu.fsave[FPU_VERSION] == own.o_fpu_type);

	ml_fpu_restore();
	own.o_fpu_loaded++;
}

/*
 * Set things up so fpu will be cleared next time we go to use it.
 * This is done by forcing it back to the NULL state.
 */


fpu_clear()
{
	own.o_fpu_loaded = 0;
	u.u_fpu.fsave[FPU_VERSION] = 0;
	u.u_fpu.fsave[FPU_FORMAT] = 0;
}

/*
 * Check if fpu is waiting for an event that is never going to
 * happen.  If so, we have no choice but to clear the condition and lose
 * some information.
 *
 * The fpu is considered stuck if it is in the middle of an instruction
 * that cannot continue.
 * This condition is caused by the floating point instruction that generates
 * a bus error.
 *
 * If it is a page fault, the process will resume and continue the instruction.
 * If the bus error kills the process then there is no problem.
 * The problem is if the process catches the signal and then uses the fpu.
 *
 * The test for seeing if the fpu is stuck is wrong in a few cases.
 * Moral of story:
 *	 Do not expect an in progress fpu instruction to survive a bus error.
 */

fpu_stuck_check()
{
	if ( own.o_fpu_loaded )
		fpu_save();
	if (u.u_fpu.fsave[FPU_FORMAT] != FPU_FORMAT_BUSY)
		return;
	ml_fpu_unstick();
	own.o_fpu_loaded++;
}
