/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fork.c: version 25.3 created on 7/24/92 at 19:34:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fork.c	25.3	7/24/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/pfdat.h"
#include "sys/map.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/acct.h"
#include "sys/tuneable.h"
#include "sys/spm_mem.h"
#include "sys/own.h"
#include "sys/kmem.h"
#include "sys/synch.h"

#define NOFORCE	0

/*
 * fork system call.
 */

fork()
{
	/* protected by upkern */
	sysinfo.sysfork++;

	/*
	 * Disallow if
	 *  No processes at all; or
	 *  not su and too many procs owned; or
	 *  not su and would take last slot; or
	 * Check done in newproc().
	 */

	switch (newproc(1)) {
		case 1:  /* child -- successful newproc */
			u.u_rval1 = u.u_procp->p_ppid;
			u.u_rval2 = 1; /* child */
			u.u_start = time;
			u.u_ticks = spm_mem.lbolt;
			u.u_mem = u.u_procp->p_size;
			u.u_ior = u.u_iow = u.u_ioch = 0;
			u.u_cstime = 0;
			u.u_stime = 0;
			u.u_cutime = 0;
			u.u_utime = 0;
			u.u_acflag = AFORK;
			sat_fork();
			u.u_lock = 0;
			return;
		case 0: /* parent, rval1 setup by newproc */
			/* u.u_rval1 = pid_of_child; */
			break;
		default:	/* couldn't fork */
			u.u_error = EAGAIN;
			break;
	}

	u.u_rval2 = 0;	/* parent */
}


/*
 * Create a new process-- the internal version of
 * sys fork.
 *
 * This changes the new proc structure and
 * alters only u.u_procp kf the uarea.
 *
 * It returns 1 in the new process, 0 in the old.
 */

int	mpid;

newproc(failok)
{
	register struct proc *cp, *pp, *pend;
	register n, a;
	int temp_sig;

#ifdef Copyback_M68040
	cache_push_data();		/* push any dangling user writes */
#endif

	/*
	 * First, just locate a slot for a process
	 * and copy the useful info from this process into it.
	 * The panic "cannot happen" because fork has already
	 * checked for the existence of a slot.
	 */

	temp_sig = u.u_procp->p_sig; /* we have to store the parent's 
				pending signals to compare with later on
				because in POSIX we clear the child's
				pending signals but want to pass on 
				any signal that has come in during the fork*/
retry:
	mpid++;
	if (mpid >= MAXPID) {
		mpid = 0;
		goto retry;
	}
	pp = &proc[0];
	cp = NULL;
	n = (struct proc *)v.ve_proc - pp;
	a = 0;
	do {
		if (pp->p_stat == NULL) {
			if (cp == NULL)
				cp = pp;
			continue;
		}
		if (pp->p_pid == mpid)
			goto retry;
		if (pp->p_uid == u.u_ruid)
			a++;
		pend = pp;
	} while (pp++, --n);
	if (cp == NULL) {
		if ((struct proc *)v.ve_proc >= &proc[v.v_proc]) {
			if (failok) {
				atom_inc(&syserr.procovf);
				u.u_error = EAGAIN;
				return(-1);
			} else
				cmn_err(CE_PANIC, "newproc - no procs");
		}
		cp = (struct proc *)v.ve_proc;
	}
	if (cp > pend)
		pend = cp;
	pend++;
	v.ve_proc = (char *)pend;
	if (u.u_uid && u.u_ruid) {
		if (cp == &proc[v.v_proc-1] || a >= v.v_maxup) {
			u.u_error = EAGAIN;
			return(-1);
		}
	}
	/*
	 * make proc entry for new proc
	 */
	pp = u.u_procp;
	if(!(IS_POSIX_PROC(pp))) 
		cp->p_sig = pp->p_sig;
	else
		cp->p_sig = 0;
	cp->p_posix_flags = pp->p_posix_flags & POSIX_FLAGS_MASK;
	if (!(IS_JOBC_PROC(pp)))
		cp->p_cursig = pp->p_cursig;

	/* JTOF - setup the proper security stuff 
 	 */
	auth_fork( cp, pp );

	bcopy( pp->p_auth->a_groups, cp->p_auth->a_groups, 
		sizeof(ushort) * GROUPS );
	cp->p_uid = pp->p_uid;
	cp->p_suid = pp->p_suid;
	cp->p_sgid = pp->p_sgid;
	cp->p_pgrp = pp->p_pgrp;
	cp->p_auth->p_save_pgrp = pp->p_pgrp;

#ifdef	PERF
	cp->p_slice_clamp  = pp->p_slice_clamp;	 /* parent's time slice limit */
	cp->p_pri_clamp	   = pp->p_pri_clamp;	 /* parent's pri limit     */
	cp->p_usrpri_clamp = pp->p_usrpri_clamp; /* parent's usrpri limit  */
	cp->p_cpu_clamp	   = pp->p_cpu_clamp;	 /* parent's cpu limit     */
	cp->p_slice_cnt	   = 0;			 /* usage count statistics */
	cp->p_slice_ovfl   = 0;			 /* overflow cnt for above */
	cp->p_pri_cnt	   = 0;			 /* usage count statistics */
	cp->p_pri_ovfl	   = 0;			 /* overflow cnt for above */
	cp->p_usrpri_cnt   = 0;			 /* usage count statistics */
	cp->p_usrpri_ovfl  = 0;			 /* overflow cnt for above */
	cp->p_cpu_cnt	   = 0;			 /* usage count statistics */
	cp->p_cpu_ovfl	   = 0;			 /* overflow cnt for above */
#endif	/* PERF */
	cp->p_perf_flags   = pp->p_perf_flags;	 /* parent's performance flags*/
	cp->p_usrpri	   = 0;			 /* usrpri from p_cpu & p_nice*/
	cp->p_slptime	   = 0;			 /* slept time in seconds  */
	cp->p_pri_slp	   = 0;			 /* pri before sleeping	   */
	cp->p_pri_adj	   = pp->p_pri_adj;	 /* parent's pri adj value */
	cp->p_lticks	   = pp->p_quantum;	 /* parent's quantum size  */
	cp->p_quantum	   = pp->p_quantum;	 /* parent's quantum size  */
	cp->p_nswtch	   = 0;			 /* per proc cnt of swtch's*/
	cp->p_ovfswtch	   = 0;			 /* per proc ovf of swtch's*/

	/* start of setitimer() addition */
	cp->p_realtimer.it_value = 0;
	cp->p_realtimer.it_interval = 0;
	cp->p_realtimer_ticks = 0;
	cp->p_realtimer_id = 0;
	/* end of setitimer() addition */

	/* At this point, the child can receive any signals sent to its
	group so see if any signals have come in since starting the fork
	and update the child's pending signals, if necessary.
	*/

	if(pp->p_sig != temp_sig)
		cp->p_sig = pp->p_sig & (~temp_sig);

	cp->p_nice = pp->p_nice;
	cp->p_chold = pp->p_chold;
	cp->p_hold = pp->p_hold;
	cp->p_stat = SIDL;
	cp->p_clktim = 0;
	cp->p_flag = SLOAD;
	cp->p_pid = mpid;
	cp->p_epid = mpid;
	cp->p_ppid = pp->p_pid;
	cp->p_time = 0;
	cp->p_cpu = 0;
	cp->p_pri = PUSER + pp->p_nice - NZERO;
 	cp->p_dests = pp->p_dests;
 	cp->p_last_ran_on = pp->p_last_ran_on;

	/* link up to parent-child-sibling chain---
	 * no need to lock generally since only a free proc call
	 * (done by same parent as newproc) diddles with child chain.
	 */

	cp->p_sibling = pp->p_child;
	pp->p_child = cp;
	cp->p_parent = pp;
	cp->p_sysid = pp->p_sysid;	/* REMOTE */
	cp->p_saved_set_uid = pp->p_saved_set_uid;
	cp->p_saved_set_gid = pp->p_saved_set_gid;
	cp->p_my_tty = pp->p_my_tty;
	cp->p_posix_sig = pp->p_posix_sig;
	cp->p_session_id = pp->p_session_id;

	/*
	 * make duplicate entries
	 * where needed
	 */

	plock(u.u_cdir);
	u.u_cdir->i_count++;
	prele(u.u_cdir);
	if (u.u_rdir) {
		plock(u.u_rdir);	/*lock root directory*/
		u.u_rdir->i_count++;
		prele(u.u_rdir);
	}
	
	/*
	 * Copy process.
	 */
	switch (procdup(cp, pp)) {
	case 0:
		/* Successful copy */
		break;
	case -1:
		if (!failok)
			cmn_err(CE_PANIC, "newproc - fork failed\n");

		/* reset all incremented counts */

		pexit();

		/* clean up parent-child-sibling pointers--
		* No lock necessary since nobody else could
		* be diddling with them here.
		*/

		pp->p_child = cp->p_sibling;
		cp->p_parent = NULL;
		cp->p_sibling = NULL;
		cp->p_stat = NULL;
		cp->p_ppid = 0;
		/* Added for POSIX */
		cp->p_pgrp = 0;
		cp->p_auth->p_save_pgrp = 0;
		cp->p_session_id = 0;
		cp->p_posix_flags = 0;
		cp->p_posix_sig = 0;
		cp->p_saved_set_uid = 0;
		cp->p_saved_set_gid = 0;
		cp->p_my_tty = 0;

		u.u_error = EAGAIN;
		return(-1);
	case 1:
		/* Child resumes here */
		return(1);
	}

	u.u_rval1 = cp->p_pid;		/* parent returns pid of child */

	/* have parent give up processor after
	 * its priority is recalculated so that
	 * the child runs first (its already on
	 * the run queue at sufficiently good
	 * priority to accomplish this).  This
	 * allows the dominant path of the child
	 * immediately execing to break the multiple
	 * use of copy on write pages with no disk home.
	 * The parent will get to steal them back
	 * rather than uselessly copying them.
	 */
	own_runrun = 1;
	return(0);
}


/*
 * Create a duplicate copy of a process, everything but stack.
 */

procdup(cp, pp)
struct proc	*cp;
struct proc	*pp;
{
	register int		prot;
	register preg_t		*p_prp;
	register preg_t		*c_prp;
	register user_t		*uservad;
	register inode_t	*ip;
	reg_t			*rp, *oldrp;
	sde_t			*sde;
	user_t			*uballoc();

	/* 	Allocate SDT tables and ublock for the child
	*/

	if ((uservad = uballoc(cp)) == NULL)
		return(-1);

	if ( own.o_fpu_loaded )
		fpu_save();

	bcopy(ADDR_U, uservad, ctob(USIZE));
	uservad = (user_t *)((char *)uservad + U_OFFSET); /* point to u-struct*/

	uservad->u_procp = cp;

	/* 
	 * initialize page pointer table for child
	 */

#ifdef	THREE_LEVEL_MMU

	/* Clear out the Qsegment (qde_t) table for the child (3 level mmu) */
	/* sde's will be built beneath, by the region duplicating           */
	bset_long(rde_to_km(cp->p_urde), spm_mem.invalid_qde.qde_all, NEPQT);

#else	/* THREE_LEVEL_MMU */

	sde = (sde_t *) rde_to_km(cp->p_urde);
	bset_long(sde, spm_mem.invalid_sde.sg_sge, (ulong)UMEM_SIZE / NBPS);

#endif	/* THREE_LEVEL_MMU */

	/*	Duplicate all the regions of the process.
	 */

	p_prp = pp->p_region;
	c_prp = cp->p_region;

	for ( ; p_prp->p_reg; p_prp++, c_prp++) {
		prot = (p_prp->p_flags & PF_RDONLY) ? SEG_RO : SEG_RW;
		if (ip = p_prp->p_reg->r_iptr)
				plock(ip);
		reglock(p_prp->p_reg);
		/*
		 * don't dup any A1000 regions, except for data regions
		 */
		if (!(p_prp->p_flags & PF_A1000) || p_prp->p_type == PT_DATA) {
			if ((rp=dupreg(p_prp->p_reg,NOSLEEP,NOFORCE))==NULL) {
				regrele(p_prp->p_reg);
				if (c_prp > cp->p_region)
					do {
						c_prp--;
						if (ip = c_prp->p_reg->r_iptr) 
							plock(ip);
						reglock(c_prp->p_reg);
						detachreg(c_prp, uservad);
					} while (c_prp > cp->p_region);
				ubfree(cp);
				return(-1);
			}
			oldrp = rp;
		}
		else {
			/*
			 * Skip A1000 shared memory region
			 * it will be attached latter
			 */
			if (p_prp->p_type == PT_SHMEM) {
				rp->r_flags |= RG_WASSHM;
				regrele(p_prp->p_reg);
				continue;
			}
			rp = oldrp;
			reglock(rp);
		}
		if (attachreg(rp, uservad, (p_prp->p_type == PT_STACK) ?
		    (uint)(p_prp->p_regva) : (uint)(p_prp->p_regva) & ~SOFFMASK,
		    p_prp->p_type|(p_prp->p_flags&PF_A1000), prot) == NULL) {
			if (rp->r_refcnt)
			{
				if (ip = rp->r_iptr)
					prele(ip);
				regrele(rp);
			}
			else
				freereg(rp);
			if (rp != p_prp->p_reg) {
				regrele(p_prp->p_reg);

				/* Note that we don't want to
				** do a prele(ip) here since
				** rp will have had the same
				** ip value and the freereg
				** will have unlocked it.
				*/
			}
			if (c_prp > cp->p_region)
				do {
					c_prp--;
					if (ip = c_prp->p_reg->r_iptr) 
						plock(ip);
					reglock(c_prp->p_reg);
					detachreg(c_prp, uservad);
				} while (c_prp > cp->p_region);
			ubfree(cp);
			return(-1);
		}
		if (ip)
			prele(ip);
		regrele(p_prp->p_reg);
		if (rp != p_prp->p_reg) {
			regrele(rp);
		}
	}

	cp->p_userp = uservad;

	/*
	 * build page table for shared memory if code and data overlapped
  	 */
/*	shmfork1(cp, pp, uservad); */

	cp->p_upkern_cnt = pp->p_upkern_cnt;

	/*
	 * dup file chain and bump reference counts on open files.
	 */
	if (!dup_ofiles(uservad))
		return(-1);

	/*	Set up values for child to
	**	return to "newproc".
	*/

	if (save(uservad->u_rsav))
		return(1);		/* child returns from here */
	

	/*	Put the child on the run queue.
	*/

	cp->p_running = NO_PM_ID;
	setrq(cp);
	return(0);
}

/* 
 * hanna FIX: for now, allocate the top level segment table using the
 * hanna FIX: 68020 method.  However, our q segment table needs only
 * hanna FIX: to be 512 bytes long (you could fit 8 into a page).
 * hanna FIX: You will need something like the ptalloc routines to maintain
 * hanna FIX: them.
 */
#ifdef THREE_LEVEL_MMU
#define PPTSIZE 1
#else /* THREE_LEVEL_MMU */
#define PPTSIZE btoc(pttob(2))
#endif /* THREE_LEVEL_MMU */

struct user *
uballoc(p)
register proc_t *p;
{
	
	/* Allocate pages for ublock and two page pointer tables.  */

	atom_sub(&availrmem, USIZE + PPTSIZE);
	atom_sub(&availsmem, USIZE + PPTSIZE);
	if (availrmem < tune.t_minarmem || availsmem < tune.t_minasmem) {
		atom_add(&availrmem, USIZE + PPTSIZE);
		atom_add(&availsmem, USIZE + PPTSIZE);
		nomemmsg("uballoc", USIZE + PPTSIZE, 0, 0);
		return(NULL);
	}

	reglock(&sysreg);
	memlock();
	if (ptmemall(&sysreg, p->p_ubptbl, USIZE, 1, 0)) {
		cmn_err(CE_PANIC,
			"uballoc - ptmemall failed for u-block");
	}


	/* 
	 * WARNING:  ptmemall returns fills in PDEs not RDEs, RDEs
	 * We are taking advantage of the similarity of the PM20 MMU format 
	 * for pde's and rde's.
	 */
	if (ptmemall(&sysreg, &p->p_urde, PPTSIZE, 1, 0)) {
		cmn_err(CE_PANIC,
			"uballoc - ptmemall failed for u-rde");
	}

#ifdef	M68040
/* hanna FIX: That's right.  Go ahead.  Take a kluge and put an even bigger
 * hanna FIX: bandaid on it.
 * hanna FIX: ptmemall returns a pde.  But the format of a pde is different
 * hanna FIX: than a rde.  Sooo, for NOW, kluge it up to make the returned
 * hanna FIX: pde look like the rde it's supposed to.  This includes:
 * hanna FIX: zeroing out bits 0-11  (returned address is on page boundary)
 * hanna FIX: setting the Used bit, zeroing the write protect bit, and 
 * hanna FIX: setting the UDT field to say it is a valid pointer.
 * hanna FIX: On deallocation, you must make it look like a pde again.
 * hanna FIX: whatamess. Get the time to fix this.
 */
 /* hanna FIX: */ p->p_urde.rde_all &= 0xfffffe00;
#endif	/* M68040 hanna FIX */

	memunlock();
	regrele(&sysreg);
	
#ifdef	aSPARC
	{ /* local */
	    register unsigned int pgnum;
	    for (pgnum=0; pgnum<USIZE;pgnum++) 
		pg_setrw(&p->p_ubptbl[pgnum]);
	} /* local */
#else	/* aSPARC */
	ASSERT(USIZE == 1);
	pg_setrw(p->p_ubptbl);
#endif	/* aSPARC */
	/* 
	 * user_t * is not strictly correct. this is ptr to stack and uarea
	 * so it is correct to return the base address of entire area
	 */
	return ((struct user *) pde_to_km(p->p_ubptbl[0]));
}

/*
 *	ubfree(P) frees up proc p's SDT tables(M68020) or TOP
 *	tables(M68040) and ublock
 */

ubfree(p)
register struct proc *p;
{
	/* free up u_block */
	reglock(&sysreg);
	memlock();
	pfree(&sysreg, p->p_ubptbl, 0, USIZE);
	/*
	 * WARNING: pfree is designed to remove pde's, not rde's.
	 * We are taking advantage of the similarity of the PM20 MMU format 
	 * for pde's and rde's.
	 */
#ifdef	M68040 /* hanna FIX */
/* hanna FIX:  Yes. So it is.  For today's debugging and bringup of the
 * hanna FIX: M68040 I've left it so, but this means that I need to 
 * hanna FIX: make the rde look like a pde, before setting it free.
 * hanna FIX: whatashame.
 */
/* hanna FIX: couldn't get compiler to coerce right, 0x2 is "PRESENT" for pde */
/* hanna FIX: */p->p_urde.rde.rsvd = 0x1; 
#endif	/* M68040 hanna FIX */
	pfree(&sysreg, &p->p_urde, 0, PPTSIZE);	/* FIX THIS, MSS */
	memunlock();
	regrele(&sysreg);
	atom_add(&availrmem, USIZE + PPTSIZE);
	atom_add(&availsmem, USIZE + PPTSIZE);
}
