/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fio.c: version 25.1 created on 11/27/91 at 15:09:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:fio.c	25.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/conf.h"
#include "sys/nami.h"
#include "sys/inode.h"
#include "sys/fstyp.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/mount.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/sysinfo.h"
#include "sys/acct.h"
#include "sys/open.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/own.h"

/*
 * Convert a user supplied file descriptor into a pointer
 * to a file structure.
 * Only task is to check range of the descriptor.
 */
struct file *
getf(f)
register uint f;
{
	register struct file *fp;
	
	if ((int)f >= 0 && (fp = GET_OFILE(f)))
		return(fp);

	u.u_error = EBADF;
	return(NULL);
}

/*
 * Internal form of close.
 * Decrement reference count on file structure.
 * Also make sure the pipe protocol does not constipate.
 *
 * Decrement reference count on the inode following
 * removal to the referencing file structure.
 * On the last close switch out to the device handler for
 * special files.  Note that the handler is called
 * on every open but only the last close.
 */
closef(fp)
register struct file *fp;
{
	register struct inode *ip;

	if (fp == NULL)
		return;
	ip = fp->f_inode;
	plock(ip);

	CLOSEI(ip, fp->f_flag, fp->f_count, fp->f_offset);

	spin_lock(&file_freelist_lock);

	if ((unsigned)fp->f_count > 1) {
		fp->f_count--;
		spin_unlock(&file_freelist_lock);
		prele(ip);
		return;
	}
	fp->f_count = 0;
	fp->f_next = ffreelist;
	ffreelist = fp;
	spin_unlock(&file_freelist_lock);
	iput(ip);
}

/*
 *	suser   return privilege mode of the process 
 */

suser()
{
	auth_suser();
} 

/*
 * Allocate a user file descriptor.
 */
ufalloc(i)
register i;
{
	if ((i = allocate_ofile(i)) < 0)
		return(-1);

	/*
	 * u.u_nofiles is one larger than the largest file descriptor
	 * ever used by this process. 
	 */
	if (i >= u.u_nofiles)
		u.u_nofiles = i + 1;

	SET_OFLAG(i, 0);
	u.u_rval1 = i;
	return(i);
}

/*
 * Allocate a user file descriptor and a file structure.
 * Initialize the descriptor to point at the file structure.
 *
 * file table overflow -- if there are no available file structures.
 */
struct file *
falloc(ip, flag)
struct inode *ip;
{
	register struct file *fp;
	register i;

	if ((i = ufalloc(0)) < 0)
		return(NULL);

	spin_lock(&file_freelist_lock);

	if ((fp = ffreelist) == NULL) {
		spin_unlock(&file_freelist_lock);
		cmn_err(CE_NOTE, "File table overflow\n");
		atom_inc(&syserr.fileovf);
		u.u_error = ENFILE;
		return(NULL);
	}
	ffreelist = fp->f_next;
	SET_OFILE(i, fp);
	fp->f_count++;
	spin_unlock(&file_freelist_lock);
	fp->f_flag = flag;
	fp->f_inode = ip;
	fp->f_offset = 0;
	return(fp);
}

struct file *ffreelist;

finit()
{
	register struct file *fp;

	for (ffreelist = fp = &file[0]; fp < &file[v.v_file-1]; fp++)
		fp->f_next = fp+1;
}

unfalloc(fp)
register struct file	*fp;
{
	spin_lock(&file_freelist_lock);
	if (--fp->f_count <= 0) {
		fp->f_next = ffreelist;
		ffreelist = fp;
	}
	spin_unlock(&file_freelist_lock);
}
