/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) exit.c: version 25.1.1.1 created on 6/15/92 at 10:59:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)exit.c	25.1.1.1	6/15/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-port:os/exit.c	10.11"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/map.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/buf.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/acct.h"
#include "sys/sysinfo.h"
#include "sys/var.h"
#include "sys/tty.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/spl.h"
#include "sys/own.h"
#include "sys/wait.h"
#include "sys/schedcpu.h"
#include "sys/schedext.h"

/*
 * exit system call:
 * pass back caller's arg
 */

rexit()
{
	register struct a {
		int	rval;
	} *uap;

	uap = (struct a *)u.u_ap;
	exit((uap->rval & 0377) << 8);
}

/*
 * Release resources.
 * Enter zombie state.
 * Wake up parent and init processes,
 * and dispose of children.
 */

exit(rv)
{
	register struct proc *p, *q, *pq;
	register preg_t	*prp;
	register reg_t	*rp;
	register int i;
	struct inode	*ip;
	int		flag;

	ASSERT(own.o_upkern_proc);

	p = u.u_procp;
#ifdef DEBUG
	if (p<=&proc[2]) panic("exit on proc 0,1, or 2\n");
#endif
	atom_and(&p->p_flag, ~STRC);
	p->p_clktim = 0;
	for (i = 0; i < NSIG; i++)
		u.u_signal[i] = SIG_IGN;
	/* Only send a SIGHUP to a process group if this is a process group
	 * leader of a non job control process
	*/
	if((p->p_pid == p->p_pgrp) && (!(IS_JOBC_PROC(p)))
	 && (u.u_ttyp != NULL) && (*u.u_ttyp == p->p_pgrp)) {
		*u.u_ttyp = 0;
		signal(p->p_pgrp, SIGHUP);
	}

	close_ofiles(1);

	punlock();
	plock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir) {
		plock(u.u_rdir);
		iput(u.u_rdir);
	}

	semexit();
	/*** shmexit(); ***/

#ifdef SECON
	sat_exit( rv );
#endif	
	acct(rv);

	/* free data, text; free U block and stack switch */

	prp = p->p_region;
	while (rp = prp->p_reg) {
		if (ip = rp->r_iptr)
			plock(ip);
		reglock(rp);
		detachreg(prp, &u);
	}

	p->p_xstat = rv;
	p->p_utime = u.u_cutime + u.u_utime;
	p->p_stime = u.u_cstime + u.u_stime;

	/* posix;  this code find whether a group has become as a orphaned
	 * process group.  If so, in that orphaned process group if any process
	 * has stopped, we start it by giving a SIGCONT signal.
	 * NOTE: orphaned process groups is a process group, in which NO
	 * 	 process has a parent which is a member of some other group, 
	 *	 within the same session.
	 * If session leader exits, clear session id of all procs in that
	 * session.
	 */
	/* if session leader is exiting, then all processes in that session
	 * lose their controlling terminal.
	 */
	if( p->p_pid == p->p_session_id ) {
	 	if (u.u_ttyp != NULL)
			*u.u_ttyp = 0;
	   	for (pq = &proc[1]; pq < (struct proc *)v.ve_proc; pq++) {
			if( p->p_session_id == pq->p_session_id ){
				if ( p == pq )
					continue;
				psignal(pq,SIGHUP);
				if(pq->p_stat == SSTOP)
					psignal(pq,SIGCONT);
				pq->p_session_id = 0;
/* Ravi: on site fix.  removing this line so that orphaned processes
				pq->p_my_tty = 0;
can get EIO when they try to read or write to their controlling terminal */
				pq->p_pgrp = 0;
			}
		}
		p->p_session_id = 0;
	}
	else if (p->p_pgrp && IS_JOBC_PROC(p) && isorphaned(p,JUSTLOOKING))  { 
	   	    for (q = &proc[1]; q < (struct proc *)v.ve_proc; q++) {
			if( (p->p_pgrp == q->p_pgrp) && (q->p_stat == SSTOP))  {
				signal(q->p_pgrp, SIGHUP);
				signal(q->p_pgrp, SIGCONT);
				break;
			}
		    }
		}

	flag = 0;

	if ((q = p->p_child) != NULL)
	{
		while(1)  {
			/* loop termination condition tested in last if */
			/* q is child of exiting proc (p) */

			q->p_ppid = 1;
			q->p_parent = &proc[1];
			if (q->p_stat == SZOMB)
				flag = 1;
			else {
#ifdef notdef
				if (q->p_stat == SSTOP && 
				    (q->p_flag & STRC) &&
				    (q->p_whystop == SIGNALLED))
					setrun(q);
#endif /*notdef*/
				if((q->p_stat == SSTOP) && (q->p_flag & STRC))
					setrun(q);
				else if(p->p_session_id == q->p_session_id) {
				    if(isorphaned(q,JUSTLOOKING))  {
					 for (pq = &proc[1];
					    pq<(struct proc *)v.ve_proc;pq++) {
						if( q->p_pgrp == pq->p_pgrp )  {
						  if( pq->p_stat == SSTOP )  {
						     signal(pq->p_pgrp,SIGHUP);
						     signal(pq->p_pgrp,SIGCONT);
						     break;
						  }
						}
					 }
				    }
				}

			}

			if (q->p_sibling == NULL) {
				/* attach to proc 1 chain */
				/* lock in case proc 1 is forking now */

				fspl6();
				q->p_sibling = proc[1].p_child;
				proc[1].p_child = p->p_child;
				fspl0();
				p->p_child = NULL;
				break;
			}
			q = q->p_sibling;

		}

		/* only send 1 death of child sig to proc 1--also delay
		 * sending sig until reasonably sure not to sleep on
		 * proc 1 parent-child-sib lock.
		 */

		if (flag) {
			psignal(&proc[1], SIGCLD);
		}
	}	/* end if children */


	p->p_auth->p_save_pgrp = p->p_pgrp;	/* is needed by waitpid() */
	p->p_posix_flags = 0;
	p->p_pgrp = 0;
	p->p_session_id = 0;
	p->p_stat = SZOMB;
	p->p_cursig = 0;	/* make sure zombie is not set running */
	p->p_sig = 0;
	psignal(p->p_parent, SIGCLD);

	/* swtch() frees up stack and ublock */
	swtch();
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
	register struct proc *p;

loop:
	for (p = u.u_procp->p_child ; p ; p = p->p_sibling) {
		if (p->p_stat == SZOMB) {
			freeproc(p, 1);
			return;
		}
		if (p->p_stat == SSTOP) {
			if (((p->p_flag & (STRC|SWTED)) == STRC) &&
			     (p->p_whystop == SIGNALLED))  {
				atom_or(&p->p_flag, SWTED);
				u.u_rval1 = p->p_pid;
				u.u_rval2 = (p->p_cursig<<8) | 0177;
				return;
			}
			continue;
		}
	}
	if (u.u_procp->p_child) {
		sleep((caddr_t)u.u_procp, PWAIT);
		goto loop;
	}
	u.u_error = ECHILD;
}


/*
 * Waitpid system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced or really stopped) children,
 * and pass back status from them.
 */
waitpid()
{
	register struct a {
		int	pid;
		int	*stat_loc;
		int	options;
	}  *uap;
	register struct proc *p;
	register int	pid;
	register int	pgrp;
	int		any;
	int		given_child;
	int		my_group;
	int		given_group;
	int		have_child;

	uap = (struct a *)u.u_ap;
	if( (uap->options & (~(WNOHANG | WUNTRACED)) ) )  {
		u.u_error = EINVAL;
		return;
	}

	any = 0;
	given_child = 0;
	my_group = 0;
	given_group = 0;
	have_child = 0;    

	if( uap->pid == -1 ) 
		any = 1;		/* waiting for any child */
	else if( uap->pid > 0 )  
		given_child = 1;	/* waiting for uap->pid child */
	else if( uap->pid == 0 )
		my_group = 1;		/* waiting for any child in my group */
	else if( uap->pid < -1 )
		given_group = 1;	/* waiting for any child in 
					 * -uap->pid group 
					 */
loop:
	for (p = u.u_procp->p_child ; p ; p = p->p_sibling) {

		if (p->p_stat == SZOMB) {
			pid = p->p_pid;
			/* we saved this in exit just for waitpid */
			pgrp = p->p_auth->p_save_pgrp;
			freeproc(p, 1);
			if( any )
				return;
			else if( given_child )  {
				if( pid == uap->pid )
					return;
			     }
			else if( my_group )  {
				if( pgrp == u.u_procp->p_pgrp )
					return;
			     }
			else if( given_group )  {
				if( (int)(-uap->pid) == pgrp )
					return;
			     }
		}	
		/* well...if the any child is stopped, catch it */
	   else	if( p->p_stat == SSTOP ) {
			if( !(uap->options & WUNTRACED))
				goto update;
			if(p->p_posix_flags & TRACED) {
				if( given_child && (p->p_pid == uap->pid)){
					u.u_error = ECHILD;
					return;
				}
				continue;
			}
			u.u_rval1 = p->p_pid;
			u.u_rval2 = (p->p_cursig<<8) | 0177;
			if( any )  {
				p->p_posix_flags |= TRACED;
				return;
			     }
			else if( given_child )   {
				if( (int)p->p_pid == uap->pid )  {
					p->p_posix_flags |= TRACED;
					return;
			        }
			     }
			else if( my_group )  {
				if( u.u_procp->p_pgrp == p->p_pgrp )  {
					p->p_posix_flags |= TRACED;
					return;
			        }
			     }
			else if( given_group ) 
				if( (-uap->pid) == (int)p->p_pgrp )  {
					p->p_posix_flags |= TRACED;
					return;
			        }
		}
update:
		if( given_child && (p->p_pid == uap->pid) )
			have_child++;
		else if( my_group && (p->p_pgrp == u.u_procp->p_pgrp) )
			have_child++;
		else if( given_group && (p->p_pgrp == -uap->pid) )
			have_child++;
		else if(any)
			have_child++;
	}
	if(have_child && (!(uap->options & WNOHANG))) {
		sleep((caddr_t)u.u_procp, PWAIT);
		goto loop;
	}
	if( have_child && (uap->options & WNOHANG))
		return;
	u.u_error = ECHILD;
}

/*
 * Remove zombie children from the process table.
 */
freeproc(p, flag)
register struct proc *p;
{

	register proc_t	*q;

	/*	Free up remaining memory used by the
	 *	zombie process here.  This is just
	 *	the u-block and the sdt's.
	 */

	ubfree(p);

	if (flag) {
#ifdef	PERF
		EXITCPU(u.u_procp,p);	/* parent gets child's cpu usage */
#else	/* PERF */
		register n;

		n = u.u_procp->p_cpu + p->p_cpu;
		if (n > 80)
			n = 80;
		u.u_procp->p_cpu = n;
#endif	/* PERF */
		u.u_rval1 = p->p_pid;
		u.u_rval2 = p->p_xstat;
	}
	u.u_cutime += p->p_utime;
	u.u_cstime += p->p_stime;
	p->p_stat = NULL;
	p->p_pid = 0;
	p->p_pgrp = 0;
	p->p_ppid = 0;
	p->p_sig = 0L;
	p->p_flag = 0;
	p->p_wchan = 0;
	p->p_cursig = 0;
	p->p_posix_flags = 0;  /* posix signal flags like SA_NOCLDSTOP */
	p->p_posix_sig = 0;	/* signal set by posix sigaction	*/
	p->p_saved_set_uid = 0;
	p->p_saved_set_gid = 0;
	p->p_session_id = 0;
	p->p_my_tty = 0;
	p->p_auth->p_save_pgrp = 0;
#ifdef SECON
	bzero(p->p_auth, sizeof(auth_t));
#endif
#ifdef notdef
	p->p_whystop = 0;
	p->p_whatstop = 0;
#endif /*notdef*/

	q = p->p_parent;
	if (q->p_child == p)
		q->p_child = p->p_sibling;
	else {
		for (q = q->p_child ; q ; q = q->p_sibling)
			if (q->p_sibling == p)
				break;
	
		ASSERT(q  &&  q->p_sibling == p);
		q->p_sibling = p->p_sibling;
	}
}

/* clean up common process stuff -- called from newproc()
 * on error in fork() due to no swap space
 */
pexit()
{	register int	i;

	/* don't include punlock() since not needed for newproc() clean */

	plock(u.u_cdir);
	iput(u.u_cdir);
	if (u.u_rdir) {
		plock(u.u_rdir);
		iput(u.u_rdir);
	}

	semexit();
	/*** shmexit(); ***/
}

/*
 * orphaned process group check:
 * This routine checks two things.
 * With exiting flag set, it checks whether the calling process exiting
 * causes its proces group to become orphaned process group.
 * With exiting flag NOT set, it checks whehter a process belongs to 
 * orphaned process group(typically from tty drivers).
 * See the POSIX glossary for the official definition of an orphaned
 * process group.
 */
isorphaned(p,exiting)
register struct proc *p;
register int	exiting;
{
register struct proc *q;

	if( !p->p_session_id )
		return(1);
	for (q = &proc[1];  q < (struct proc *)v.ve_proc; q++) {
		if( p->p_pgrp == q->p_pgrp )  {
			if( (p == q) && exiting )
				continue;
			if((q->p_session_id == q->p_parent->p_session_id)
			&& (q->p_pgrp != q->p_parent->p_pgrp) ) 
				return(0);
		}
	}
	return(1);
}
